# -*- coding: utf-8 -*-
from django.urls import path
from django.views.i18n import JavaScriptCatalog

from . import views

app_name = 'djeym'
urlpatterns = [
    path('jsi18n/',
         JavaScriptCatalog.as_view(packages=['djeym']),
         name='javascript-catalog'),
    path('ajax-balloon-content/',
         views.AjaxBalloonContent.as_view(),
         name='ajax_balloon_content'),
    path('ajax-upload-placemarks/',
         views.AjaxUploadPlacemarks.as_view(),
         name='ajax_get_geo_objects_placemark'),
    path('ajax-upload-settings-front/',
         views.AjaxUploadSettingsFront.as_view(),
         name='ajax_upload_settings_front'),
    path('ajax-upload-heat-points/',
         views.AjaxUploadHeatPoints.as_view(),
         name='ajax_get_heat_points'),
    path('ajax-upload-polylines/',
         views.AjaxUploadPolylines.as_view(),
         name='ajax_get_geo_objects_polyline'),
    path('ajax-upload-polygons/',
         views.AjaxUploadPolygons.as_view(),
         name='ajax_get_geo_objects_polygon'),
    path('ajax-save-geo-object/',
         views.AjaxSaveGeoObjects.as_view(),
         name='ajax_save_geo_object'),
    path('ymeditor/<slug:slug>/',
         views.YMapEditor.as_view(),
         name='ymap_editor'),
    path('ajax-upload-settings-editor/',
         views.AjaxUploadSettingsEditor.as_view(),
         name='ajax_upload_settings_editor'),
    path('ajax-save-cusotm-marker/',
         views.AjaxSaveCusotmMarker.as_view(),
         name='ajax_save_cusotm_marker'),
    path('ajax-cluster-icon/',
         views.AjaxClusterIcon.as_view(),
         name='ajax_cluster_icon'),
    path('ajax-collection-example-icon/',
         views.AjaxCollectionExampleIcon.as_view(),
         name='ajax_collection_example_icon'),
    path('ajax-import-icon-collection/',
         views.AjaxImportIconCollection.as_view(),
         name='ajax_import_icon_collection'),
    path('export-icon-collection/<slug:slug>/',
         views.ExportIconCollection.as_view(),
         name='export_icon_collection'),
    path('ajax-import-tile-source/',
         views.AjaxImportTileSource.as_view(),
         name='ajax_import_tile_source'),
    path('export-tile-source/',
         views.ExportTileSource.as_view(),
         name='export_tile_source'),
    path('ajax-tile-screenshot/',
         views.AjaxTileScreenshot.as_view(),
         name='ajax_tile_screenshot'),
    path('ajax-update-tile-source/',
         views.AjaxUpdateTileSource.as_view(),
         name='ajax_update_tile_source'),
    path('ajax-update-map-controls/',
         views.AjaxUpdateMapControls.as_view(),
         name='ajax_update_map_controls'),
    path('ajax-update-heatmap-settings/',
         views.AjaxUpdateHeatmapSettings.as_view(),
         name='ajax_update-heatmap_settings'),
    path('ajax-activate-heatmap/',
         views.AjaxActivateHeatmap.as_view(),
         name='ajax_activate_heatmap'),
    path('ajax-heatmap-undo-settings/',
         views.AjaxHeatmapUndoSettings.as_view(),
         name='ajax_heatmap_undo_settings'),
    path('ajax-update-likes/',
         views.AjaxUpdateLikes.as_view(),
         name='ajax_update_likes'),
    path('ajax-update-preset-settings/',
         views.AjaxUpdatePresetSettings.as_view(),
         name='ajax_update_preset_settings'),
    path('ajax-update-general-settings/',
         views.AjaxUpdateGeneralSettings.as_view(),
         name='ajax_update_general_settings'),
    path('ajax-load-indicator-icon/',
         views.AjaxLoadIndicatorIcon.as_view(),
         name='ajax_load_indicator_icon'),
    path('ajax-update-load-indicator/',
         views.AjaxUpdateLoadIndicator.as_view(),
         name='ajax_update_load_indicator'),
    path('ajax-update-filters-categories/',
         views.AjaxUpdateFiltersCategories.as_view(),
         name='ajax_update_filters_categories'),
    path('ajax-del-img-bg-panel-front/',
         views.AjaxDeleteImgBgPanelFront.as_view(),
         name='ajax_del_img_bg_panel_front'),
    path('ajax-block-ip-address/',
         views.AjaxBlockIPAddress.as_view(),
         name='ajax_block_ip_address'),
    path('ajax-upload-icon-collection/',
         views.AjaxIconCollection.as_view(),
         name='ajax_upload_icon_collection')
]
