# AKTime

用于程序运行时统计各函数的运行时间，使用时只需要导入aktime中的TimeCalcu即可。给要统计运行时间的方法加上@time_cacu装饰器，程序结束时"调用read_resul()会以图表的形式展示各方法的运行时间。

**安装**

```python
pip install aktime
```



**示例**

```python
import time
from aktime.TimeCalcu import time_calcu, time_statistic


@time_calcu
def time1():

    for i in range(10):
        time.sleep(0.1)

@time_calcu
def time2():
    for i in range(25):
        time.sleep(0.1)

def main():
    time1()
    time2()
    time1()


if __name__ == '__main__':
    main()
    time_statistic()
```

**正常运行**

```
+--------------------------------+------------+------------+
|           Func name            |   Counts   |  Run time  |
+--------------------------------+------------+------------+
|            time2()             |     1      |  2.56514   |
| ------------------------------ | ---------- | ---------- |
|            time1()             |     2      |  2.05260   |
| ------------------------------ | ---------- | ---------- |
|              Sum               |     3      |  4.61774   |
+--------------------------------+------------+------------+
```

**出现错误时**
```
+--------------------------------+------------+------------+---------------------------+--------------------------------+
|           Func name            |   Counts   |  Run time  |           Error           |            Location            |
+--------------------------------+------------+------------+---------------------------+--------------------------------+
|            time1()             |     1      |  0.10216   |                           |       TimeCalcu.py: 153        |
| ------------------------------ | ---------- | ---------- | ------------------------- | ------------------------------ |
|            time2()             |     1      |  0.00003   |  name 'a' is not defi...  |       TimeCalcu.py: 158        |
| ------------------------------ | ---------- | ---------- | ------------------------- | ------------------------------ |
|              Sum               |     2      |  0.10219   |                           |                                |
+--------------------------------+------------+------------+---------------------------+--------------------------------+
```



