"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cluster2 = exports.Cluster2Property = void 0;
const ros = require("@alicloud/ros-cdk-core");
const emr_generated_1 = require("./emr.generated");
Object.defineProperty(exports, "Cluster2Property", { enumerable: true, get: function () { return emr_generated_1.RosCluster2; } });
/**
 * A ROS resource type:  `ALIYUN::EMR::Cluster2`
 */
class Cluster2 extends ros.Resource {
    /**
     * Create a new `ALIYUN::EMR::Cluster2`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosCluster2 = new emr_generated_1.RosCluster2(this, id, {
            applications: props.applications,
            resourceGroupId: props.resourceGroupId,
            applicationConfigs: props.applicationConfigs,
            clusterType: props.clusterType,
            nodeGroups: props.nodeGroups,
            releaseVersion: props.releaseVersion,
            bootstrapScripts: props.bootstrapScripts,
            subscriptionConfig: props.subscriptionConfig,
            deployMode: props.deployMode,
            securityMode: props.securityMode,
            nodeAttributes: props.nodeAttributes,
            clusterName: props.clusterName,
            paymentType: props.paymentType,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCluster2;
        this.attrClusterId = rosCluster2.attrClusterId;
    }
}
exports.Cluster2 = Cluster2;
//# sourceMappingURL=data:application/json;base64,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