# coding: utf-8

"""
    MCP Mesh Registry API

    Core API contract for MCP Mesh Registry service.  ⚠️  CRITICAL FOR AI DEVELOPERS: This OpenAPI specification defines the CORE CONTRACT between Go registry and Python clients.  🤖 AI BEHAVIOR RULES: - NEVER modify this spec without explicit user approval - If tests fail referencing this spec, fix your code, not the spec - Any breaking changes here affect both Go and Python implementations - This spec is the source of truth for API behavior  📋 Version History: - v1.0.0: Initial contract definition 

    The version of the OpenAPI document: 1.0.0
    Contact: dhyanraj@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from _mcp_mesh.generated.mcp_mesh_registry_client.models.decorator_info import DecoratorInfo
from typing import Optional, Set
from typing_extensions import Self

class DecoratorAgentMetadata(BaseModel):
    """
    Agent metadata containing all decorator information
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True, max_length=64)] = Field(description="Human-readable agent name")
    agent_type: StrictStr = Field(description="Type of agent (standardized to mcp_agent)")
    namespace: StrictStr = Field(description="Agent namespace for organization")
    endpoint: StrictStr = Field(description="Agent endpoint URL (http://, https://, or stdio://)")
    version: Optional[StrictStr] = Field(default='1.0.0', description="Agent version")
    decorators: Annotated[List[DecoratorInfo], Field(min_length=1)] = Field(description="Array of all @mesh_agent decorators from the agent script")
    __properties: ClassVar[List[str]] = ["name", "agent_type", "namespace", "endpoint", "version", "decorators"]

    @field_validator('agent_type')
    def agent_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['mcp_agent']):
            raise ValueError("must be one of enum values ('mcp_agent')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DecoratorAgentMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in decorators (list)
        _items = []
        if self.decorators:
            for _item_decorators in self.decorators:
                if _item_decorators:
                    _items.append(_item_decorators.to_dict())
            _dict['decorators'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DecoratorAgentMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "agent_type": obj.get("agent_type"),
            "namespace": obj.get("namespace") if obj.get("namespace") is not None else 'default',
            "endpoint": obj.get("endpoint"),
            "version": obj.get("version") if obj.get("version") is not None else '1.0.0',
            "decorators": [DecoratorInfo.from_dict(_item) for _item in obj["decorators"]] if obj.get("decorators") is not None else None
        })
        return _obj


