# coding: utf-8

"""
    MCP Mesh Registry API

    Core API contract for MCP Mesh Registry service.  ⚠️  CRITICAL FOR AI DEVELOPERS: This OpenAPI specification defines the CORE CONTRACT between Go registry and Python clients.  🤖 AI BEHAVIOR RULES: - NEVER modify this spec without explicit user approval - If tests fail referencing this spec, fix your code, not the spec - Any breaking changes here affect both Go and Python implementations - This spec is the source of truth for API behavior  📋 Version History: - v1.0.0: Initial contract definition 

    The version of the OpenAPI document: 1.0.0
    Contact: dhyanraj@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from _mcp_mesh.generated.mcp_mesh_registry_client.models.agent_metadata_dependencies_inner import AgentMetadataDependenciesInner
from typing import Optional, Set
from typing_extensions import Self

class AgentMetadata(BaseModel):
    """
    AgentMetadata
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True, max_length=64)] = Field(description="Human-readable agent name")
    agent_type: StrictStr = Field(description="Type of agent")
    namespace: StrictStr = Field(description="Agent namespace for organization")
    endpoint: StrictStr = Field(description="Agent endpoint URL (http://, https://, or stdio://)")
    capabilities: Optional[Annotated[List[StrictStr], Field(min_length=0)]] = Field(default=None, description="List of capabilities provided by agent (0 or more)")
    dependencies: Optional[Annotated[List[AgentMetadataDependenciesInner], Field(min_length=0)]] = Field(default=None, description="List of agent dependencies (0 or more) - supports both simple strings and rich objects")
    health_interval: Optional[Annotated[int, Field(le=3600, strict=True, ge=1)]] = Field(default=30, description="Health check interval in seconds")
    timeout_threshold: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(default=60, description="Timeout threshold in seconds")
    eviction_threshold: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(default=120, description="Eviction threshold in seconds")
    version: Optional[StrictStr] = Field(default='1.0.0', description="Agent version")
    description: Optional[StrictStr] = Field(default=None, description="Agent description")
    tags: Optional[List[StrictStr]] = Field(default=None, description="Agent tags for categorization")
    security_context: Optional[StrictStr] = Field(default=None, description="Security context for agent")
    __properties: ClassVar[List[str]] = ["name", "agent_type", "namespace", "endpoint", "capabilities", "dependencies", "health_interval", "timeout_threshold", "eviction_threshold", "version", "description", "tags", "security_context"]

    @field_validator('agent_type')
    def agent_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['mesh_agent', 'mcp_agent', 'system_agent']):
            raise ValueError("must be one of enum values ('mesh_agent', 'mcp_agent', 'system_agent')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AgentMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in dependencies (list)
        _items = []
        if self.dependencies:
            for _item_dependencies in self.dependencies:
                if _item_dependencies:
                    _items.append(_item_dependencies.to_dict())
            _dict['dependencies'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AgentMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "agent_type": obj.get("agent_type"),
            "namespace": obj.get("namespace") if obj.get("namespace") is not None else 'default',
            "endpoint": obj.get("endpoint"),
            "capabilities": obj.get("capabilities"),
            "dependencies": [AgentMetadataDependenciesInner.from_dict(_item) for _item in obj["dependencies"]] if obj.get("dependencies") is not None else None,
            "health_interval": obj.get("health_interval") if obj.get("health_interval") is not None else 30,
            "timeout_threshold": obj.get("timeout_threshold") if obj.get("timeout_threshold") is not None else 60,
            "eviction_threshold": obj.get("eviction_threshold") if obj.get("eviction_threshold") is not None else 120,
            "version": obj.get("version") if obj.get("version") is not None else '1.0.0',
            "description": obj.get("description"),
            "tags": obj.get("tags"),
            "security_context": obj.get("security_context")
        })
        return _obj


