# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.openapi.configuration import Configuration


class V1alpha1AssemblyDatasetDescriptors(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'datasets': 'list[V1alpha1AssemblyDatasetDescriptor]',
        'total_count': 'int'
    }

    attribute_map = {
        'datasets': 'datasets',
        'total_count': 'total_count'
    }

    def __init__(self, datasets=None, total_count=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1AssemblyDatasetDescriptors - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._datasets = None
        self._total_count = None
        self.discriminator = None

        if datasets is not None:
            self.datasets = datasets
        if total_count is not None:
            self.total_count = total_count

    @property
    def datasets(self):
        """Gets the datasets of this V1alpha1AssemblyDatasetDescriptors.  # noqa: E501

        List of all datasets that match the request, up to the provided limit.  # noqa: E501

        :return: The datasets of this V1alpha1AssemblyDatasetDescriptors.  # noqa: E501
        :rtype: list[V1alpha1AssemblyDatasetDescriptor]
        """
        return self._datasets

    @datasets.setter
    def datasets(self, datasets):
        """Sets the datasets of this V1alpha1AssemblyDatasetDescriptors.

        List of all datasets that match the request, up to the provided limit.  # noqa: E501

        :param datasets: The datasets of this V1alpha1AssemblyDatasetDescriptors.  # noqa: E501
        :type: list[V1alpha1AssemblyDatasetDescriptor]
        """

        self._datasets = datasets

    @property
    def total_count(self):
        """Gets the total_count of this V1alpha1AssemblyDatasetDescriptors.  # noqa: E501

        The total count of available datasets (ignoring the cutoff parameter).  # noqa: E501

        :return: The total_count of this V1alpha1AssemblyDatasetDescriptors.  # noqa: E501
        :rtype: int
        """
        return self._total_count

    @total_count.setter
    def total_count(self, total_count):
        """Sets the total_count of this V1alpha1AssemblyDatasetDescriptors.

        The total count of available datasets (ignoring the cutoff parameter).  # noqa: E501

        :param total_count: The total_count of this V1alpha1AssemblyDatasetDescriptors.  # noqa: E501
        :type: int
        """

        self._total_count = total_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1AssemblyDatasetDescriptors):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1AssemblyDatasetDescriptors):
            return True

        return self.to_dict() != other.to_dict()
