[![pipeline status](https://gitlab.com/computationalmaterials/clease-gui/badges/master/pipeline.svg)](https://gitlab.com/computationalmaterials/clease-gui/-/commits/master)
[![coverage report](https://gitlab.com/computationalmaterials/clease-gui/badges/master/coverage.svg)](https://gitlab.com/computationalmaterials/clease-gui/-/commits/master)
[![Documentation Status](https://readthedocs.org/projects/clease-gui/badge/?version=latest)](https://clease-gui.readthedocs.io/en/latest/?badge=latest)
[![PyPI](https://img.shields.io/pypi/v/clease-gui)](https://pypi.org/project/clease-gui/)
[![Anaconda](https://anaconda.org/conda-forge/clease-gui/badges/version.svg)](https://anaconda.org/conda-forge/clease-gui)

[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

# CLEASE GUI
This is a GUI based on Jupyter notebooks for [CLEASE](https://gitlab.com/computationalmaterials/clease).
For more information, head on over to the [documentation](https://clease-gui.readthedocs.io).

## Installation

The CLEASE GUI is available on [PyPI](https://pypi.org/project/clease-gui/):

    $ pip install clease-gui

The GUI is also available on [conda-forge](https://anaconda.org/conda-forge/clease-gui).
This is also the prefered method on Windows, in order to simply the compilation process of CLEASE.
To install into your conda environment, do:

    $ conda install -c conda-forge clease-gui

## Running the GUI
The GUI is based on Jupyter notebooks. The GUI works in both "classic" jupyter
notebooks, and in Jupyter lab. Launch jupyter lab with:

    $ jupyter-lab

*Alternatively* to use the classic jupyter notebook, do:

    $ jupyter notebook

Create a new notebook that you want to work in, and a new cell, add the following lines:

```python
%matplotlib tk
from clease_gui import display_ui
display_ui(dev_mode=True);
```

A line `%matplotlib notebook` can be added at the start of the cell for nicer plots
(this only works in classic jupyter notebooks).
However, this may come at a significant performance cost, so do your own testing.

## Plot font sizes

All plots generated in this package are generated by the ``matplotlib`` package. However, the default font size in ``matplotlib`` can be rather small,
so it can be adjusted globally, e.g. by running the following in a cell:
```python
import matplotlib
matplotlib.rcParams.update({'font.size': 16})
```
This will also affect the font sizes on the figures generated in the GUI.
