# Generated by Django 3.1.7 on 2021-10-21 18:38

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.OAUTH2_PROVIDER_APPLICATION_MODEL),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Event',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('event_object', models.CharField(blank=True, max_length=500, null=True)),
                ('action', models.CharField(blank=True, help_text='create/update/partial-update/delete etc', max_length=50, null=True)),
                ('event_data', models.JSONField(blank=True, help_text='Payload to be sent to webhook endpoint', null=True, verbose_name='Event Data')),
                ('is_processed', models.BooleanField(default=False, help_text='Whether the event has been posted to webhook endpoints or not')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('application', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.OAUTH2_PROVIDER_APPLICATION_MODEL, verbose_name='Application')),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='WebhookEventPostAttempt',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('endpoint_url', models.CharField(max_length=255, verbose_name='Webhook Endpoint')),
                ('status', models.CharField(blank=True, max_length=10, null=True, verbose_name='HTTP Status')),
                ('response_data', models.TextField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('application', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.OAUTH2_PROVIDER_APPLICATION_MODEL, verbose_name='Application')),
                ('event', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='mad_webhooks.event', verbose_name='Event')),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='Webhook',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('endpoint_url', models.CharField(help_text='Webhook URI - URI where the system will send the payload.', max_length=500, verbose_name='Webhook Endpoint')),
                ('query_params', models.JSONField(blank=True, help_text='These parameters will be sent back to the webhook endpoint via query string.', null=True, verbose_name='Query Parameters')),
                ('header_params', models.JSONField(blank=True, help_text='These parameters will be sent back to the webhook endpoint via request header.', null=True, verbose_name='Header Parameters')),
                ('description', models.TextField(blank=True, null=True)),
                ('is_active', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('application', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.OAUTH2_PROVIDER_APPLICATION_MODEL, verbose_name='Application')),
            ],
            options={
                'verbose_name': 'Webhook Endpoint',
                'verbose_name_plural': 'Webhook Endpoints',
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='Log',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('request_data', models.JSONField(blank=True, null=True, verbose_name='Request Data')),
                ('response_data', models.JSONField(blank=True, null=True, verbose_name='Response Data')),
                ('path', models.CharField(max_length=500, verbose_name='Path')),
                ('status', models.CharField(max_length=255, verbose_name='HTTP Status')),
                ('method', models.CharField(max_length=255, verbose_name='HTTP Method')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('application', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.OAUTH2_PROVIDER_APPLICATION_MODEL, verbose_name='Created By Application')),
                ('user', models.ForeignKey(help_text='Activity was preformed by this user', null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, verbose_name='Users')),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
    ]
