![OS](https://img.shields.io/badge/OS-GNU%2FLinux-red?style=for-the-badge&logo=Linux)
![OS](https://img.shields.io/badge/OS-Windows-blue?style=for-the-badge&logo=Windows)
![OS](https://img.shields.io/badge/OS-Mac-white?style=for-the-badge&logo=apple)
![GitHub](https://img.shields.io/github/license/rly0nheart/octosuite?style=for-the-badge&logo=github)
![GitHub tag (latest by date)](https://img.shields.io/github/v/tag/rly0nheart/octosuite?style=for-the-badge&logo=github)
![GitHub commits since latest release (by date)](https://img.shields.io/github/commits-since/rly0nheart/octosuite/1.7.0-dev?style=for-the-badge&logo=github)
![GitHub last commit](https://img.shields.io/github/last-commit/rly0nheart/octosuite?style=for-the-badge&logo=github)
![GitHub repo size](https://img.shields.io/github/repo-size/rly0nheart/octosuite?style=for-the-badge&logo=github)

> *Simply gather OSINT on Github users & organizations like a God🔥*

# FEATURES
- [x] Fetches organization info
- [x] Fetches user info
- [x] Fetches repository info
- [x] Returns contents of a path from a repository
- [x] Returns a list of repos owned by an organization
- [x] Returns a list of repos owned by a user
- [x] Returns a list of gists owned by a user
- [x] Returns a list of a user's followers
- [x] Checks whether user A follows user B
- [x] Searches users
- [x] Searches repositories
- [x] Searches topics
- [x] Searches issues
- [x] Searches commits
- [x] Easily updates with the 'update' command
- [x] Automatically logs network activity (.logs folder)
- [x] User can view, read and delete log files

# INSTALLATION
## Clone from Github

```
git clone https://github.com/rly0nheart/octosuite.git
```
![Screenshot_20220414-002508](https://user-images.githubusercontent.com/74001397/163280996-ed0f8817-c3e3-49d8-9e15-93452cb08a3e.jpg)


```
cd octosuite
```
![Screenshot_20220414-002214](https://user-images.githubusercontent.com/74001397/163281317-158bbf7b-073f-457e-8a8a-730d4c0ed413.jpg)


```
pip install -r requirements.txt
```
![Screenshot_20220414-004420](https://user-images.githubusercontent.com/74001397/163282481-6cb5efe8-6e5a-4c2b-a8b5-7ff99f7ca293.jpg)



## Install from PyPI
```
pip install octosuite
```
![Screenshot_20220414-005400](https://user-images.githubusercontent.com/74001397/163283184-e9458439-8074-4338-938b-4588390bb6b7.jpg)


# GITHUB FORK USAGE 
## Linux
```
sudo chmod +x octosuite
```
![Screenshot_20220414-004443](https://user-images.githubusercontent.com/74001397/163282620-a5307969-bcce-49d1-ad3c-c3ea0f78fb44.jpg)


```
sudo ./octosuite
```
![Screenshot_20220414-004507](https://user-images.githubusercontent.com/74001397/163282716-41ace7fc-ee04-4c95-985e-68dd3286682c.jpg)




## Windows
```
python3 octosuite
```

## Mac
```
python3 octosuite
```

# PYPI PACKAGE USAGE
## Linux
```
octosuite
```

## Windows
```
octosuite
```

## Mac 
```
octosuite
```

# AVAILABLE COMMANDS
| COMMAND         | DESCRIPTION|
| ------------- |:---------:|
| ``info:org`` | *get organization info*  |
| ``info:user`` | *get user profile info*  |
| ``info:repo`` | *get repository info*  |
| ``info:dev`` | *show developer's info* |
| ``path:contents``  | *get contents of a path from a specified repository* |
| ``repos:org``      | *get a list of repositories owned by a specified organization* |
| ``repos:user``  | *get a list of repositories owned by a specified user* |
| ``user:gists``  |  *get a list of gists owned by a specified user* |
| ``user:followers``  |  *get a list of a user's followers* |
| ``user:following`` | *check whether user A follows user B* |
| ``search:users`` | *search user(s)* |
| ``search:repos`` | *search repositor(y)(ies)* |
| ``search:topics`` | *search topics(s)* |
| ``search:issues`` | *search issue(s)* |
| ``search:commits`` | *search commit(s)* |
| ``logs:view`` | *view octosuite log files* |
| ``logs:read`` | *read a specified log file* |
| ``logs:delete`` | *delete a specified log file* |
| ``update`` | *update octosuite* |
| ``changelog`` | *show changelog* |
| ``help`` | *show usage/help* |
| ``exit`` | *exit session* |


# NOTE
* *octosuite automatically logs network and minor user activity. The logs are saved by date and time in .logs folder*
* *Although octosuite was developed to work on **Mac**, **Windows**, or any **Linux** *Distribution*, it has only been tested on **Termux** *and* **Kali Linux***
* *If you believe octosuite can be better, feel free to open a pull request on GitHub with your improvements* ✌🏾🙂

# GITHUB
[GitHub](https://github.com/rly0nheart/octosuite)

# LICENSE
![license](https://user-images.githubusercontent.com/74001397/137917929-2f2cdb0c-4d1d-4e4b-9f0d-e01589e027b5.png)

# ABOUT DEVELOPER
[About.me](https://about.me/rly0nheart)