"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsTPSTokenBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const dynamodb = require("aws-cdk-lib/aws-dynamodb");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_lambda_event_sources_1 = require("aws-cdk-lib/aws-lambda-event-sources");
const sqs = require("aws-cdk-lib/aws-sqs");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
class StepFunctionsTPSTokenBucket extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        var dynamoDBTableName;
        var dynamoDBTableID;
        var sqsQueue;
        if (!props.tokenBucketDDBTableID || !props.tokenBucketDDBTableName) {
            const dynamoDBTableClass = new dynamodb.Table(this, 'TextractConcurrencyTable', {
                partitionKey: {
                    name: 'ID',
                    type: dynamodb.AttributeType.NUMBER,
                },
                billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
            });
            dynamoDBTableName = dynamoDBTableClass.tableName;
            dynamoDBTableID = 'tpsTokenBucketDefault';
        }
        else {
            dynamoDBTableName = props.tokenBucketDDBTableName;
            dynamoDBTableID = props.tokenBucketDDBTableID;
        }
        if (!props.sqsQueue || !props.sqsQueue) {
            // should avoid using a different SQS queue for the same token bucket
            sqsQueue = new sqs.Queue(this, 'TokenBucketQueue', { visibilityTimeout: aws_cdk_lib_1.Duration.seconds(30) });
        }
        else {
            sqsQueue = props.sqsQueue;
        }
        const tpsTokenBucketFunction = new lambda.DockerImageFunction(this, 'TokenBucketFunction', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/tokenbucket/')),
            memorySize: 128,
            timeout: aws_cdk_lib_1.Duration.seconds(30),
            environment: {
                TOKEN_LIMIT: props.tokenLimit.toString(),
                DDB_TOKEN_ID: dynamoDBTableID,
                DDB_TOKEN_TABLE: dynamoDBTableName,
            },
        });
        tpsTokenBucketFunction.addToRolePolicy(new iam.PolicyStatement({ actions: ['dynamodb:*'], resources: ['*'] }));
        tpsTokenBucketFunction.addToRolePolicy(new iam.PolicyStatement({ actions: ['states:*'], resources: ['*'] }));
        const tpsTokenBucketFunctionInvoke = new tasks.LambdaInvoke(this, 'TPSTokenBucketFunction', {
            lambdaFunction: tpsTokenBucketFunction,
            outputPath: '$.Payload',
        });
        tpsTokenBucketFunctionInvoke.addRetry({
            interval: aws_cdk_lib_1.Duration.seconds(1),
            maxAttempts: 6,
            backoffRate: 2,
            errors: [sfn.Errors.ALL],
        });
        const sqsTokenBucketTask = new tasks.SqsSendMessage(this, 'SqsTokenBucketTask', {
            queue: sqsQueue,
            messageBody: sfn.TaskInput.fromObject({ field1: 'somedata', TaskToken: sfn.JsonPath.taskToken }),
            integrationPattern: sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
        });
        tpsTokenBucketFunction.addEventSource(new aws_lambda_event_sources_1.SqsEventSource(sqsQueue, { batchSize: 10 }));
        // const workflow_chain = sfn.Chain.start(sqsTokenBucketTask);
        // // detectText.next(releaseLockClass);
        // // textractAsyncLambdaInvoke.next(releaseLockClass);
        // const stateMachine = new sfn.StateMachine(this, 'StateMachine', {
        //   definition: workflow_chain,
        //   timeout: Duration.hours(4),
        // });
        this.endStates = [sqsTokenBucketTask];
        this.startState = sqsTokenBucketTask;
    }
}
exports.StepFunctionsTPSTokenBucket = StepFunctionsTPSTokenBucket;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionsTPSTokenBucket[_a] = { fqn: "schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket", version: "0.0.11" };
//# sourceMappingURL=data:application/json;base64,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