import os
import logging
import json
import boto3
from token_bucket import Limiter
from dynamodbtokenbucketstorage import DynamoDBStorage

logger = logging.getLogger(__name__)

sqs_client = boto3.client('sqs')
dynamo_db_client = boto3.client("dynamodb")
step_functions_client = boto3.client(service_name='stepfunctions')


def lambda_handler(event, _):
    log_level = os.environ.get('LOG_LEVEL', 'INFO')
    logger.setLevel(log_level)
    logger.info(f"LOG_LEVEL: {log_level} ")
    logger.info(json.dumps(event))
    token_bucket_table_name = os.environ.get('DDB_TOKEN_BUCKET_TABLE_NAME')
    token_bucket_key_name = os.environ.get('DDB_TOKEN_BUCKET_KEY_NAME')
    token_bucket_rate = os.environ.get('DDB_TOKEN_BUCKET_RATE', 10)
    token_bucket_capacity = os.environ.get('DDB_TOKEN_BUCKET_CAPACITY', 10)
    if not token_bucket_key_name:
        raise ValueError(f"no DDB_TOKEN_BUCKET_KEY_NAME provided")
    if not token_bucket_table_name:
        raise ValueError(f"no DDB_TOKEN_BUCKET_TABLE_NAME provided")

    limiter = Limiter(rate=token_bucket_rate,
                      capacity=token_bucket_capacity,
                      storage=DynamoDBStorage(token_bucket_table_name))
    if 'Records' in event:
        for record in event['Records']:
            if record["eventSource"] == "aws:sqs":
                body = json.loads(record["body"])
                token = body['TaskToken']
                if limiter.consume(key=token_bucket_key_name):
                    step_functions_client.send_task_success(
                        taskToken=token,
                        output=json.dumps({'message': f'this works'}))
