"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbController = exports.AlbScheme = exports.AlbControllerVersion = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const iam = require("@aws-cdk/aws-iam");
const helm_chart_1 = require("./helm-chart");
const service_account_1 = require("./service-account");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_1 = require("@aws-cdk/core");
/**
 * Controller version.
 *
 * Corresponds to the image tag of 'amazon/aws-load-balancer-controller' image.
 *
 * @stability stable
 */
class AlbControllerVersion {
    constructor(
    /**
     * The version string.
     */
    version, 
    /**
     * Whether or not its a custom version.
     */
    custom) {
        this.version = version;
        this.custom = custom;
    }
    /**
     * Specify a custom version.
     *
     * Use this if the version you need is not available in one of the predefined versions.
     * Note that in this case, you will also need to provide an IAM policy in the controller options.
     *
     * @param version The version number.
     * @stability stable
     */
    static of(version) {
        return new AlbControllerVersion(version, true);
    }
}
exports.AlbControllerVersion = AlbControllerVersion;
_a = JSII_RTTI_SYMBOL_1;
AlbControllerVersion[_a] = { fqn: "@aws-cdk/aws-eks.AlbControllerVersion", version: "1.143.0" };
/**
 * v2.0.0.
 *
 * @stability stable
 */
AlbControllerVersion.V2_0_0 = new AlbControllerVersion('v2.0.0', false);
/**
 * v2.0.1.
 *
 * @stability stable
 */
AlbControllerVersion.V2_0_1 = new AlbControllerVersion('v2.0.1', false);
/**
 * v2.1.0.
 *
 * @stability stable
 */
AlbControllerVersion.V2_1_0 = new AlbControllerVersion('v2.1.0', false);
/**
 * v2.1.1.
 *
 * @stability stable
 */
AlbControllerVersion.V2_1_1 = new AlbControllerVersion('v2.1.1', false);
/**
 * v2.1.2.
 *
 * @stability stable
 */
AlbControllerVersion.V2_1_2 = new AlbControllerVersion('v2.1.2', false);
/**
 * v2.1.3.
 *
 * @stability stable
 */
AlbControllerVersion.V2_1_3 = new AlbControllerVersion('v2.1.3', false);
/**
 * v2.0.0.
 *
 * @stability stable
 */
AlbControllerVersion.V2_2_0 = new AlbControllerVersion('v2.2.0', false);
/**
 * v2.2.1.
 *
 * @stability stable
 */
AlbControllerVersion.V2_2_1 = new AlbControllerVersion('v2.2.1', false);
/**
 * v2.2.2.
 *
 * @stability stable
 */
AlbControllerVersion.V2_2_2 = new AlbControllerVersion('v2.2.2', false);
/**
 * v2.2.3.
 *
 * @stability stable
 */
AlbControllerVersion.V2_2_3 = new AlbControllerVersion('v2.2.3', false);
/**
 * v2.2.4.
 *
 * @stability stable
 */
AlbControllerVersion.V2_2_4 = new AlbControllerVersion('v2.2.4', false);
/**
 * v2.3.0.
 *
 * @stability stable
 */
AlbControllerVersion.V2_3_0 = new AlbControllerVersion('v2.3.0', false);
/**
 * v2.3.1.
 *
 * @stability stable
 */
AlbControllerVersion.V2_3_1 = new AlbControllerVersion('v2.3.1', false);
/**
 * ALB Scheme.
 *
 * @see https://kubernetes-sigs.github.io/aws-load-balancer-controller/v2.3/guide/ingress/annotations/#scheme
 * @stability stable
 */
var AlbScheme;
(function (AlbScheme) {
    AlbScheme["INTERNAL"] = "internal";
    AlbScheme["INTERNET_FACING"] = "internet-facing";
})(AlbScheme = exports.AlbScheme || (exports.AlbScheme = {}));
/**
 * Construct for installing the AWS ALB Contoller on EKS clusters.
 *
 * Use the factory functions `get` and `getOrCreate` to obtain/create instances of this controller.
 *
 * @see https://kubernetes-sigs.github.io/aws-load-balancer-controller
 * @stability stable
 */
class AlbController extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _c, _d;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_eks_AlbControllerProps(props);
        const namespace = 'kube-system';
        const serviceAccount = new service_account_1.ServiceAccount(this, 'alb-sa', { namespace, name: 'aws-load-balancer-controller', cluster: props.cluster });
        if (props.version.custom && !props.policy) {
            throw new Error("'albControllerOptions.policy' is required when using a custom controller version");
        }
        // https://kubernetes-sigs.github.io/aws-load-balancer-controller/v2.2/deploy/installation/#iam-permissions
        const policy = (_c = props.policy) !== null && _c !== void 0 ? _c : JSON.parse(fs.readFileSync(path.join(__dirname, 'addons', `alb-iam_policy-${props.version.version}.json`), 'utf8'));
        for (const statement of policy.Statement) {
            serviceAccount.addToPrincipalPolicy(iam.PolicyStatement.fromJson(statement));
        }
        // https://kubernetes-sigs.github.io/aws-load-balancer-controller/v2.2/deploy/installation/#add-controller-to-cluster
        const chart = new helm_chart_1.HelmChart(this, 'Resource', {
            cluster: props.cluster,
            chart: 'aws-load-balancer-controller',
            repository: 'https://aws.github.io/eks-charts',
            namespace,
            release: 'aws-load-balancer-controller',
            // latest at the time of writing. We intentionally don't
            // want to expose this since helm here is just an implementation detail
            // for installing a specific version of the controller itself.
            // https://github.com/aws/eks-charts/blob/v0.0.65/stable/aws-load-balancer-controller/Chart.yaml
            version: '1.2.7',
            wait: true,
            timeout: core_1.Duration.minutes(15),
            values: {
                clusterName: props.cluster.clusterName,
                serviceAccount: {
                    create: false,
                    name: serviceAccount.serviceAccountName,
                },
                region: core_1.Stack.of(this).region,
                vpcId: props.cluster.vpc.vpcId,
                image: {
                    repository: (_d = props.repository) !== null && _d !== void 0 ? _d : '602401143452.dkr.ecr.us-west-2.amazonaws.com/amazon/aws-load-balancer-controller',
                    tag: props.version.version,
                },
            },
        });
        // the controller relies on permissions deployed using these resources.
        chart.node.addDependency(serviceAccount);
        chart.node.addDependency(props.cluster.openIdConnectProvider);
        chart.node.addDependency(props.cluster.awsAuth);
    }
    /**
     * Create the controller construct associated with this cluster and scope.
     *
     * Singleton per stack/cluster.
     *
     * @stability stable
     */
    static create(scope, props) {
        jsiiDeprecationWarnings._aws_cdk_aws_eks_AlbControllerProps(props);
        const stack = core_1.Stack.of(scope);
        const uid = AlbController.uid(props.cluster);
        return new AlbController(stack, uid, props);
    }
    static uid(cluster) {
        return `${core_1.Names.nodeUniqueId(cluster.node)}-AlbController`;
    }
}
exports.AlbController = AlbController;
_b = JSII_RTTI_SYMBOL_1;
AlbController[_b] = { fqn: "@aws-cdk/aws-eks.AlbController", version: "1.143.0" };
//# sourceMappingURL=data:application/json;base64,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