"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable dot-notation */
const handler_1 = require("../handler");
describe('VersionProviderResource', () => {
    let versionProviderResource;
    beforeEach(() => {
        versionProviderResource = new handler_1.VersionProviderResource();
        jest.spyOn(console, 'log').mockReturnValue(undefined);
    });
    afterEach(() => {
        jest.clearAllMocks();
    });
    describe('implementsIVersionProviderResourceProperties', () => {
        test('correct input', async () => {
            expect(versionProviderResource['implementsIVersionProviderResourceProperties']({
                versionString: '10.1.9.2',
                forceRun: 'testValue',
            })).toBeTruthy();
        });
        test('correct input no forceRun', async () => {
            expect(versionProviderResource['implementsIVersionProviderResourceProperties']({
                versionString: '10.1.9.2',
            })).toBeTruthy();
        });
        test('correct input with no versionString', async () => {
            expect(versionProviderResource['implementsIVersionProviderResourceProperties']({})).toBeTruthy();
        });
        test('non-object input', async () => {
            expect(versionProviderResource['implementsIVersionProviderResourceProperties']('test')).toBeFalsy();
        });
        test('input with invalid versionString', async () => {
            expect(versionProviderResource['implementsIVersionProviderResourceProperties']({
                versionString: 'version',
            })).toBeFalsy();
        });
        test('input with invalid forceRun', async () => {
            expect(versionProviderResource['implementsIVersionProviderResourceProperties']({
                versionString: '10.1.9.2',
                forceRun: {},
            })).toBeFalsy();
        });
    });
    describe('parseS3BucketName', () => {
        test('correct input', () => {
            expect(versionProviderResource['parseS3BucketName']('s3://bucketName/objectKey')).toEqual('bucketName');
        });
        test.each([
            ':/bucketName/objectKey',
            's3:/bucketName/objectKey',
            's3://bucketName',
            'bucketName',
        ])('malformed input: %p', (s3Uri) => {
            expect(() => versionProviderResource['parseS3BucketName'](s3Uri)).toThrowError(/Could not parse S3 bucket name/);
        });
    });
    describe('parseS3ObjectKey', () => {
        test.each([
            ['s3://bucketName/objectKey', 'objectKey'],
            ['s3://bucketName/objectDirectory/objectName', 'objectDirectory/objectName'],
            ['s3://bucketName/objectDirectory/objectName.run', 'objectDirectory/objectName.run'],
            ['s3://bucketName/objectDirectory/10.1.9.2/objectName.run', 'objectDirectory/10.1.9.2/objectName.run'],
        ])('correct input: %p', (s3Uri, objectKey) => {
            expect(versionProviderResource['parseS3ObjectKey'](s3Uri)).toEqual(objectKey);
        });
        test.each([
            ':/bucketName/objectKey',
            's3:/bucketName/objectKey',
            's3://bucketName',
            'bucketName',
        ])('malformed input: %p', (s3Uri) => {
            expect(() => versionProviderResource['parseS3ObjectKey'](s3Uri)).toThrowError(/Could not parse S3 object key/);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGFuZGxlci50ZXN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaGFuZGxlci50ZXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7O0dBR0c7O0FBRUgsaUNBQWlDO0FBRWpDLHdDQUFxRDtBQUVyRCxRQUFRLENBQUMseUJBQXlCLEVBQUUsR0FBRyxFQUFFO0lBQ3ZDLElBQUksdUJBQWdELENBQUM7SUFFckQsVUFBVSxDQUFDLEdBQUcsRUFBRTtRQUNkLHVCQUF1QixHQUFHLElBQUksaUNBQXVCLEVBQUUsQ0FBQztRQUN4RCxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sRUFBRSxLQUFLLENBQUMsQ0FBQyxlQUFlLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDeEQsQ0FBQyxDQUFDLENBQUM7SUFFSCxTQUFTLENBQUMsR0FBRyxFQUFFO1FBQ2IsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3ZCLENBQUMsQ0FBQyxDQUFDO0lBRUgsUUFBUSxDQUFDLDhDQUE4QyxFQUFFLEdBQUcsRUFBRTtRQUM1RCxJQUFJLENBQUMsZUFBZSxFQUFFLEtBQUssSUFBSSxFQUFFO1lBQy9CLE1BQU0sQ0FBQyx1QkFBdUIsQ0FBQyw4Q0FBOEMsQ0FBQyxDQUFDO2dCQUM3RSxhQUFhLEVBQUUsVUFBVTtnQkFDekIsUUFBUSxFQUFFLFdBQVc7YUFDdEIsQ0FBQyxDQUFDLENBQUMsVUFBVSxFQUFFLENBQUM7UUFDbkIsQ0FBQyxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsMkJBQTJCLEVBQUUsS0FBSyxJQUFJLEVBQUU7WUFDM0MsTUFBTSxDQUFDLHVCQUF1QixDQUFDLDhDQUE4QyxDQUFDLENBQUM7Z0JBQzdFLGFBQWEsRUFBRSxVQUFVO2FBQzFCLENBQUMsQ0FBQyxDQUFDLFVBQVUsRUFBRSxDQUFDO1FBQ25CLENBQUMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLHFDQUFxQyxFQUFFLEtBQUssSUFBSSxFQUFFO1lBQ3JELE1BQU0sQ0FBQyx1QkFBdUIsQ0FBQyw4Q0FBOEMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxFQUFFLENBQUM7UUFDbkcsQ0FBQyxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsa0JBQWtCLEVBQUUsS0FBSyxJQUFJLEVBQUU7WUFDbEMsTUFBTSxDQUFDLHVCQUF1QixDQUFDLDhDQUE4QyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxTQUFTLEVBQUUsQ0FBQztRQUN0RyxDQUFDLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxrQ0FBa0MsRUFBRSxLQUFLLElBQUksRUFBRTtZQUNsRCxNQUFNLENBQUMsdUJBQXVCLENBQUMsOENBQThDLENBQUMsQ0FBQztnQkFDN0UsYUFBYSxFQUFFLFNBQVM7YUFDekIsQ0FBQyxDQUFDLENBQUMsU0FBUyxFQUFFLENBQUM7UUFDbEIsQ0FBQyxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsNkJBQTZCLEVBQUUsS0FBSyxJQUFJLEVBQUU7WUFDN0MsTUFBTSxDQUFDLHVCQUF1QixDQUFDLDhDQUE4QyxDQUFDLENBQUM7Z0JBQzdFLGFBQWEsRUFBRSxVQUFVO2dCQUN6QixRQUFRLEVBQUUsRUFBRTthQUNiLENBQUMsQ0FBQyxDQUFDLFNBQVMsRUFBRSxDQUFDO1FBQ2xCLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQyxDQUFDLENBQUM7SUFFSCxRQUFRLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxFQUFFO1FBQ2pDLElBQUksQ0FBQyxlQUFlLEVBQUUsR0FBRyxFQUFFO1lBQ3pCLE1BQU0sQ0FBQyx1QkFBdUIsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLDJCQUEyQixDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDMUcsQ0FBQyxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsSUFBSSxDQUFDO1lBQ1Isd0JBQXdCO1lBQ3hCLDBCQUEwQjtZQUMxQixpQkFBaUI7WUFDakIsWUFBWTtTQUNiLENBQUMsQ0FBQyxxQkFBcUIsRUFBRSxDQUFDLEtBQWEsRUFBRSxFQUFFO1lBQzFDLE1BQU0sQ0FBQyxHQUFHLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsWUFBWSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7UUFDbkgsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDLENBQUMsQ0FBQztJQUVILFFBQVEsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLEVBQUU7UUFDaEMsSUFBSSxDQUFDLElBQUksQ0FBQztZQUNSLENBQUMsMkJBQTJCLEVBQUUsV0FBVyxDQUFDO1lBQzFDLENBQUMsNENBQTRDLEVBQUUsNEJBQTRCLENBQUM7WUFDNUUsQ0FBQyxnREFBZ0QsRUFBRSxnQ0FBZ0MsQ0FBQztZQUNwRixDQUFDLHlEQUF5RCxFQUFFLHlDQUF5QyxDQUFDO1NBQ3ZHLENBQUMsQ0FBQyxtQkFBbUIsRUFBRSxDQUFDLEtBQWEsRUFBRSxTQUFpQixFQUFFLEVBQUU7WUFDM0QsTUFBTSxDQUFDLHVCQUF1QixDQUFDLGtCQUFrQixDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLENBQUM7UUFDaEYsQ0FBQyxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsSUFBSSxDQUFDO1lBQ1Isd0JBQXdCO1lBQ3hCLDBCQUEwQjtZQUMxQixpQkFBaUI7WUFDakIsWUFBWTtTQUNiLENBQUMsQ0FBQyxxQkFBcUIsRUFBRSxDQUFDLEtBQWEsRUFBRSxFQUFFO1lBQzFDLE1BQU0sQ0FBQyxHQUFHLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsWUFBWSxDQUFDLCtCQUErQixDQUFDLENBQUM7UUFDakgsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDLENBQUMsQ0FBQztBQUNMLENBQUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBDb3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuLyogZXNsaW50LWRpc2FibGUgZG90LW5vdGF0aW9uICovXG5cbmltcG9ydCB7IFZlcnNpb25Qcm92aWRlclJlc291cmNlIH0gZnJvbSAnLi4vaGFuZGxlcic7XG5cbmRlc2NyaWJlKCdWZXJzaW9uUHJvdmlkZXJSZXNvdXJjZScsICgpID0+IHtcbiAgbGV0IHZlcnNpb25Qcm92aWRlclJlc291cmNlOiBWZXJzaW9uUHJvdmlkZXJSZXNvdXJjZTtcblxuICBiZWZvcmVFYWNoKCgpID0+IHtcbiAgICB2ZXJzaW9uUHJvdmlkZXJSZXNvdXJjZSA9IG5ldyBWZXJzaW9uUHJvdmlkZXJSZXNvdXJjZSgpO1xuICAgIGplc3Quc3B5T24oY29uc29sZSwgJ2xvZycpLm1vY2tSZXR1cm5WYWx1ZSh1bmRlZmluZWQpO1xuICB9KTtcblxuICBhZnRlckVhY2goKCkgPT4ge1xuICAgIGplc3QuY2xlYXJBbGxNb2NrcygpO1xuICB9KTtcblxuICBkZXNjcmliZSgnaW1wbGVtZW50c0lWZXJzaW9uUHJvdmlkZXJSZXNvdXJjZVByb3BlcnRpZXMnLCAoKSA9PiB7XG4gICAgdGVzdCgnY29ycmVjdCBpbnB1dCcsIGFzeW5jICgpID0+IHtcbiAgICAgIGV4cGVjdCh2ZXJzaW9uUHJvdmlkZXJSZXNvdXJjZVsnaW1wbGVtZW50c0lWZXJzaW9uUHJvdmlkZXJSZXNvdXJjZVByb3BlcnRpZXMnXSh7XG4gICAgICAgIHZlcnNpb25TdHJpbmc6ICcxMC4xLjkuMicsXG4gICAgICAgIGZvcmNlUnVuOiAndGVzdFZhbHVlJyxcbiAgICAgIH0pKS50b0JlVHJ1dGh5KCk7XG4gICAgfSk7XG5cbiAgICB0ZXN0KCdjb3JyZWN0IGlucHV0IG5vIGZvcmNlUnVuJywgYXN5bmMgKCkgPT4ge1xuICAgICAgZXhwZWN0KHZlcnNpb25Qcm92aWRlclJlc291cmNlWydpbXBsZW1lbnRzSVZlcnNpb25Qcm92aWRlclJlc291cmNlUHJvcGVydGllcyddKHtcbiAgICAgICAgdmVyc2lvblN0cmluZzogJzEwLjEuOS4yJyxcbiAgICAgIH0pKS50b0JlVHJ1dGh5KCk7XG4gICAgfSk7XG5cbiAgICB0ZXN0KCdjb3JyZWN0IGlucHV0IHdpdGggbm8gdmVyc2lvblN0cmluZycsIGFzeW5jICgpID0+IHtcbiAgICAgIGV4cGVjdCh2ZXJzaW9uUHJvdmlkZXJSZXNvdXJjZVsnaW1wbGVtZW50c0lWZXJzaW9uUHJvdmlkZXJSZXNvdXJjZVByb3BlcnRpZXMnXSh7fSkpLnRvQmVUcnV0aHkoKTtcbiAgICB9KTtcblxuICAgIHRlc3QoJ25vbi1vYmplY3QgaW5wdXQnLCBhc3luYyAoKSA9PiB7XG4gICAgICBleHBlY3QodmVyc2lvblByb3ZpZGVyUmVzb3VyY2VbJ2ltcGxlbWVudHNJVmVyc2lvblByb3ZpZGVyUmVzb3VyY2VQcm9wZXJ0aWVzJ10oJ3Rlc3QnKSkudG9CZUZhbHN5KCk7XG4gICAgfSk7XG5cbiAgICB0ZXN0KCdpbnB1dCB3aXRoIGludmFsaWQgdmVyc2lvblN0cmluZycsIGFzeW5jICgpID0+IHtcbiAgICAgIGV4cGVjdCh2ZXJzaW9uUHJvdmlkZXJSZXNvdXJjZVsnaW1wbGVtZW50c0lWZXJzaW9uUHJvdmlkZXJSZXNvdXJjZVByb3BlcnRpZXMnXSh7XG4gICAgICAgIHZlcnNpb25TdHJpbmc6ICd2ZXJzaW9uJyxcbiAgICAgIH0pKS50b0JlRmFsc3koKTtcbiAgICB9KTtcblxuICAgIHRlc3QoJ2lucHV0IHdpdGggaW52YWxpZCBmb3JjZVJ1bicsIGFzeW5jICgpID0+IHtcbiAgICAgIGV4cGVjdCh2ZXJzaW9uUHJvdmlkZXJSZXNvdXJjZVsnaW1wbGVtZW50c0lWZXJzaW9uUHJvdmlkZXJSZXNvdXJjZVByb3BlcnRpZXMnXSh7XG4gICAgICAgIHZlcnNpb25TdHJpbmc6ICcxMC4xLjkuMicsXG4gICAgICAgIGZvcmNlUnVuOiB7fSxcbiAgICAgIH0pKS50b0JlRmFsc3koKTtcbiAgICB9KTtcbiAgfSk7XG5cbiAgZGVzY3JpYmUoJ3BhcnNlUzNCdWNrZXROYW1lJywgKCkgPT4ge1xuICAgIHRlc3QoJ2NvcnJlY3QgaW5wdXQnLCAoKSA9PiB7XG4gICAgICBleHBlY3QodmVyc2lvblByb3ZpZGVyUmVzb3VyY2VbJ3BhcnNlUzNCdWNrZXROYW1lJ10oJ3MzOi8vYnVja2V0TmFtZS9vYmplY3RLZXknKSkudG9FcXVhbCgnYnVja2V0TmFtZScpO1xuICAgIH0pO1xuXG4gICAgdGVzdC5lYWNoKFtcbiAgICAgICc6L2J1Y2tldE5hbWUvb2JqZWN0S2V5JyxcbiAgICAgICdzMzovYnVja2V0TmFtZS9vYmplY3RLZXknLFxuICAgICAgJ3MzOi8vYnVja2V0TmFtZScsXG4gICAgICAnYnVja2V0TmFtZScsXG4gICAgXSkoJ21hbGZvcm1lZCBpbnB1dDogJXAnLCAoczNVcmk6IHN0cmluZykgPT4ge1xuICAgICAgZXhwZWN0KCgpID0+IHZlcnNpb25Qcm92aWRlclJlc291cmNlWydwYXJzZVMzQnVja2V0TmFtZSddKHMzVXJpKSkudG9UaHJvd0Vycm9yKC9Db3VsZCBub3QgcGFyc2UgUzMgYnVja2V0IG5hbWUvKTtcbiAgICB9KTtcbiAgfSk7XG5cbiAgZGVzY3JpYmUoJ3BhcnNlUzNPYmplY3RLZXknLCAoKSA9PiB7XG4gICAgdGVzdC5lYWNoKFtcbiAgICAgIFsnczM6Ly9idWNrZXROYW1lL29iamVjdEtleScsICdvYmplY3RLZXknXSxcbiAgICAgIFsnczM6Ly9idWNrZXROYW1lL29iamVjdERpcmVjdG9yeS9vYmplY3ROYW1lJywgJ29iamVjdERpcmVjdG9yeS9vYmplY3ROYW1lJ10sXG4gICAgICBbJ3MzOi8vYnVja2V0TmFtZS9vYmplY3REaXJlY3Rvcnkvb2JqZWN0TmFtZS5ydW4nLCAnb2JqZWN0RGlyZWN0b3J5L29iamVjdE5hbWUucnVuJ10sXG4gICAgICBbJ3MzOi8vYnVja2V0TmFtZS9vYmplY3REaXJlY3RvcnkvMTAuMS45LjIvb2JqZWN0TmFtZS5ydW4nLCAnb2JqZWN0RGlyZWN0b3J5LzEwLjEuOS4yL29iamVjdE5hbWUucnVuJ10sXG4gICAgXSkoJ2NvcnJlY3QgaW5wdXQ6ICVwJywgKHMzVXJpOiBzdHJpbmcsIG9iamVjdEtleTogc3RyaW5nKSA9PiB7XG4gICAgICBleHBlY3QodmVyc2lvblByb3ZpZGVyUmVzb3VyY2VbJ3BhcnNlUzNPYmplY3RLZXknXShzM1VyaSkpLnRvRXF1YWwob2JqZWN0S2V5KTtcbiAgICB9KTtcblxuICAgIHRlc3QuZWFjaChbXG4gICAgICAnOi9idWNrZXROYW1lL29iamVjdEtleScsXG4gICAgICAnczM6L2J1Y2tldE5hbWUvb2JqZWN0S2V5JyxcbiAgICAgICdzMzovL2J1Y2tldE5hbWUnLFxuICAgICAgJ2J1Y2tldE5hbWUnLFxuICAgIF0pKCdtYWxmb3JtZWQgaW5wdXQ6ICVwJywgKHMzVXJpOiBzdHJpbmcpID0+IHtcbiAgICAgIGV4cGVjdCgoKSA9PiB2ZXJzaW9uUHJvdmlkZXJSZXNvdXJjZVsncGFyc2VTM09iamVjdEtleSddKHMzVXJpKSkudG9UaHJvd0Vycm9yKC9Db3VsZCBub3QgcGFyc2UgUzMgb2JqZWN0IGtleS8pO1xuICAgIH0pO1xuICB9KTtcbn0pO1xuIl19