/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * Values required for establishing a connection to a TLS-enabled MongoDB server.
 */
export interface IConnectionOptions {
    /**
     * FQDN of the host to connect to.
     */
    readonly Hostname: string;
    /**
     * Port on the host that is serving MongoDB.
     */
    readonly Port: string;
    /**
     * ARN of a Secret containing login credentials. The contents must be a SecretString containing a JSON
     * document of the form:
     *     {
     *         "username": <login user>,
     *         "password": <login password>
     *     }
     */
    readonly Credentials: string;
    /**
     * ARN of a Secret containing the CA to validate the identity of the MongoDB server. The contents
     * must be a PEM-encoded certificate in the SecretString of the secret.
     */
    readonly CaCertificate: string;
}
/**
 * Information regarding a user to add to the DB that can authenticate via X.509 certificate.
 */
export interface IX509AuthenticatedUser {
    /**
     * Certificate providing subject/identity for the user.
     */
    readonly Certificate: string;
    /**
     * JSON encoded MongoDB roles array for the user.
     */
    readonly Roles: string;
}
/**
 * Resource arguments for the MongoDbConfigure Custom Resource handler.
 */
export interface IMongoDbConfigureResource {
    /**
     * Connection info for logging into the MongoDB application server.
     */
    readonly Connection: IConnectionOptions;
    /**
     * List of ARNs to Secrets containing password-authenticated credentials & roles for users to be created.
     *
     * @default No such users are created.
     */
    readonly PasswordAuthUsers?: string[];
    readonly X509AuthUsers?: IX509AuthenticatedUser[];
}
export declare function implementsIConnectionOptions(value: any): boolean;
export declare function implementsIX509AuthenticatedUser(value: any): boolean;
export declare function implementsIMongoDbConfigureResource(value: any): boolean;
