"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.calculateSha256Hash = void 0;
const crypto_1 = require("crypto");
function calculateSha256Hash(value) {
    // eslint-disable-next-line no-shadow
    function _updateHashWithValue(hash, val) {
        if (Array.isArray(val)) {
            for (const item of val) {
                _updateHashWithValue(hash, item);
            }
        }
        else if (typeof val === 'object') {
            for (const [key, item] of Object.entries(val).sort()) {
                hash.update(key);
                _updateHashWithValue(hash, item);
            }
        }
        else if (typeof val === 'number') {
            hash.update(val.toString());
        }
        else if (typeof val === 'string') {
            hash.update(val);
        }
        else {
            throw new Error(`Unexpected value type: ${typeof (val)}`);
        }
    }
    const hash = crypto_1.createHash('sha256');
    _updateHashWithValue(hash, value);
    return hash.digest().toString('hex');
}
exports.calculateSha256Hash = calculateSha256Hash;
//# sourceMappingURL=data:application/json;base64,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