"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.windowsConfigureWorkerScriptBoilerplate = exports.windowsCloudWatchScriptBoilerplate = exports.linuxConfigureWorkerScriptBoilerplate = exports.linuxCloudWatchScriptBoilerplate = exports.RQ_CONNECTION_ASSET = exports.REPO_DC_ASSET = exports.TEST_ASSET = exports.INSTALL_REPOSITORY_ASSET_LINUX = exports.CONFIG_WORKER_PORT_ASSET_WINDOWS = exports.CONFIG_WORKER_ASSET_WINDOWS = exports.CONFIG_WORKER_ASSET_LINUX = exports.CWA_ASSET_WINDOWS = exports.CWA_ASSET_LINUX = void 0;
// TODO: Properly import from aws-rfdk. Not ideal
// to use a relative path here.
const assert_1 = require("@aws-cdk/assert");
const asset_constants_1 = require("../../core/test/asset-constants");
Object.defineProperty(exports, "CWA_ASSET_LINUX", { enumerable: true, get: function () { return asset_constants_1.CWA_ASSET_LINUX; } });
Object.defineProperty(exports, "CWA_ASSET_WINDOWS", { enumerable: true, get: function () { return asset_constants_1.CWA_ASSET_WINDOWS; } });
// configureWorker.sh
exports.CONFIG_WORKER_ASSET_LINUX = {
    Bucket: 'AssetParameters1cfdffe73bb016717ba1f43d64fe528af27b3784f524a97bb36533a6e6d057ffS3Bucket9FBDD688',
    Key: 'AssetParameters1cfdffe73bb016717ba1f43d64fe528af27b3784f524a97bb36533a6e6d057ffS3VersionKey02A3157B',
};
// configureWorker.ps1
exports.CONFIG_WORKER_ASSET_WINDOWS = {
    Bucket: 'AssetParametersa10d67420c8758e35d8dae5fa406c7acb92b1bd40924167d5564aa0037b4a980S3Bucket953E30DC',
    Key: 'AssetParametersa10d67420c8758e35d8dae5fa406c7acb92b1bd40924167d5564aa0037b4a980S3VersionKeyAFB97BD6',
};
exports.CONFIG_WORKER_PORT_ASSET_WINDOWS = {
    Bucket: 'AssetParameters3227efc256da3ae31791b7c80e1532cac975116846f179f118a20843e0c2ee80S3Bucket6583BE37',
    Key: 'AssetParameters3227efc256da3ae31791b7c80e1532cac975116846f179f118a20843e0c2ee80S3VersionKey6C80977B',
};
// installDeadlineRepository.sh
exports.INSTALL_REPOSITORY_ASSET_LINUX = {
    Bucket: assert_1.stringLike('AssetParameters*S3Bucket8EB24E17'),
};
// test.file
exports.TEST_ASSET = {
    Bucket: assert_1.stringLike('AssetParameters*S3Bucket5D5509D9'),
    Key: assert_1.stringLike('AssetParameters*S3VersionKeyF19FF080'),
};
// installRepostitoryDirectConnection
exports.REPO_DC_ASSET = {
    Bucket: assert_1.stringLike('AssetParameters*S3Bucket87338EBD'),
    Key: assert_1.stringLike('AssetParameters*S3VersionKeyB7FF7B3C'),
};
exports.RQ_CONNECTION_ASSET = {
    Bucket: 'AssetParametersb61797635329f0b0ec0b710b31d49f0e41c1936849266d8a9aed82e1616c9077S3Bucket4D5EEE4A',
    Key: 'AssetParametersb61797635329f0b0ec0b710b31d49f0e41c1936849266d8a9aed82e1616c9077S3VersionKey9B7B46A0',
};
function linuxCloudWatchScriptBoilerplate(scriptParams) {
    return [
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        "')\naws s3 cp 's3://",
        {
            Ref: asset_constants_1.CWA_ASSET_LINUX.Bucket,
        },
        '/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        "' '/tmp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        "'\nset -e\nchmod +x '/tmp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        "'\n'/tmp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        "' -i ",
        {
            Ref: 'AWS::Region',
        },
        ' ',
        {
            Ref: 'ConfigStringParameterC2BE550F',
        },
        "\nmkdir -p $(dirname '/tmp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "')\naws s3 cp 's3://",
        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Bucket },
        '/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "' '/tmp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "'\nmkdir -p $(dirname '/tmp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        '\')\naws s3 cp \'s3://',
        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Bucket },
        '/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        '\' \'/tmp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        '\'\n' +
            'set -e\n' +
            'chmod +x \'/tmp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        '\'\n\'/tmp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        scriptParams,
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
    ];
}
exports.linuxCloudWatchScriptBoilerplate = linuxCloudWatchScriptBoilerplate;
function linuxConfigureWorkerScriptBoilerplate(scriptParams) {
    return [
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "')\naws s3 cp 's3://",
        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Bucket },
        '/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "' '/tmp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "'\nmkdir -p $(dirname '/tmp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        '\')\naws s3 cp \'s3://',
        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Bucket },
        '/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        '\' \'/tmp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        '\'\n' +
            'set -e\n' +
            'chmod +x \'/tmp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        '\'\n\'/tmp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_LINUX.Key },
                    ],
                },
            ],
        },
        scriptParams,
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
    ];
}
exports.linuxConfigureWorkerScriptBoilerplate = linuxConfigureWorkerScriptBoilerplate;
function windowsCloudWatchScriptBoilerplate(scriptParams) {
    return [
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "' ) -ea 0\nRead-S3Object -BucketName '",
        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Bucket },
        "' -key '",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "' -file 'C:/temp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "' -ErrorAction Stop\n&'C:/temp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "' -i ",
        { Ref: 'AWS::Region' },
        ' ',
        { Ref: 'ConfigStringParameterC2BE550F' },
        "\nif (!$?) { Write-Error 'Failed to execute the file \"C:/temp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: asset_constants_1.CWA_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "\"' -ErrorAction Stop }\nmkdir (Split-Path -Path 'C:/temp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        '\' ) -ea 0\nRead-S3Object -BucketName \'',
        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Bucket },
        '\' -key \'',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        '\' -file \'C:/temp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "' -ErrorAction Stop\nmkdir (Split-Path -Path 'C:/temp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "' ) -ea 0\nRead-S3Object -BucketName '",
        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Bucket },
        "' -key '",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "' -file 'C:/temp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        '\' -ErrorAction Stop\n&\'C:/temp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        scriptParams,
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        {
                            Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key,
                        },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        {
                            Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key,
                        },
                    ],
                },
            ],
        },
        '\nif (!$?) { Write-Error \'Failed to execute the file \"C:/temp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
    ];
}
exports.windowsCloudWatchScriptBoilerplate = windowsCloudWatchScriptBoilerplate;
function windowsConfigureWorkerScriptBoilerplate(scriptParams) {
    return [
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        '\' ) -ea 0\nRead-S3Object -BucketName \'',
        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Bucket },
        '\' -key \'',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        '\' -file \'C:/temp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "' -ErrorAction Stop\nmkdir (Split-Path -Path 'C:/temp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "' ) -ea 0\nRead-S3Object -BucketName '",
        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Bucket },
        "' -key '",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        "' -file 'C:/temp/",
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        '\' -ErrorAction Stop\n&\'C:/temp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        scriptParams,
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        {
                            Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key,
                        },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        {
                            Ref: exports.CONFIG_WORKER_ASSET_WINDOWS.Key,
                        },
                    ],
                },
            ],
        },
        '\nif (!$?) { Write-Error \'Failed to execute the file \"C:/temp/',
        {
            'Fn::Select': [
                0,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
        {
            'Fn::Select': [
                1,
                {
                    'Fn::Split': [
                        '||',
                        { Ref: exports.CONFIG_WORKER_PORT_ASSET_WINDOWS.Key },
                    ],
                },
            ],
        },
    ];
}
exports.windowsConfigureWorkerScriptBoilerplate = windowsConfigureWorkerScriptBoilerplate;
//# sourceMappingURL=data:application/json;base64,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