/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
import { Ec2Service } from '@aws-cdk/aws-ecs';
import { Construct } from '@aws-cdk/core';
/**
 * Input properties for WaitForStableService.
 */
export interface WaitForStableServiceProps {
    /**
     * A service to wait for.
     */
    readonly service: Ec2Service;
}
/**
 * Depend on this construct to wait until the ECS Service becomes stable.
 * See https://docs.aws.amazon.com/cli/latest/reference/ecs/wait/services-stable.html.
 */
export declare class WaitForStableService extends Construct {
    constructor(scope: Construct, id: string, props: WaitForStableServiceProps);
    private forceRun;
}
