/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
import { MountPermissions } from './mountable-filesystem';
/**
 * This is an internal-only class that can be used to convert enum values from
 * {@link MountPermissions} into strings, or whatever, that are needed by OS-specific
 * mount utilities.
 */
export declare class MountPermissionsHelper {
    /**
     * Convert the given permission into the appropriate mount option for Linux's mount command.
     *
     * @param permission The permission to convert. Defaults to {@link MountPermissions.READWRITE} if not defined.
     */
    static toLinuxMountOption(permission?: MountPermissions): string;
    /**
     * Convert the given permission into the appropriate list of IAM actions allowed on the EFS FileSystem required for
     * the mount.
     *
     * @param permission The permission to convert. Defaults to {@link MountPermissions.READWRITE} if not defined.
     */
    static toEfsIAMActions(permission?: MountPermissions): string[];
}
