"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogGroupFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
const aws_logs_1 = require("@aws-cdk/aws-logs");
const exporting_log_group_1 = require("./exporting-log-group");
/**
 * This factory will return an ILogGroup based on the configuration provided to it.
 *
 * The LogGroup will either be
 * wrapped in a LogRetention from the aws-lambda package that has the ability to look up and reuse an existing LogGroup
 * or an ExportingLogGroup that uses a LogRetention and adds additional functionality to export the logs to S3.
 *
 * @stability stable
 */
class LogGroupFactory {
    /**
     * Either create a new LogGroup given the LogGroup name, or return the existing LogGroup.
     *
     * @stability stable
     */
    static createOrFetch(scope, logWrapperId, logGroupName, props) {
        const fullLogGroupName = (props === null || props === void 0 ? void 0 : props.logGroupPrefix) ? `${props.logGroupPrefix}${logGroupName}` : logGroupName;
        const retention = (props === null || props === void 0 ? void 0 : props.retention) ? props.retention : LogGroupFactory.DEFAULT_LOG_RETENTION;
        return (props === null || props === void 0 ? void 0 : props.bucketName) ? new exporting_log_group_1.ExportingLogGroup(scope, logWrapperId, {
            bucketName: props.bucketName,
            logGroupName: fullLogGroupName,
            retention: props.retention,
        }).logGroup
            : aws_logs_1.LogGroup.fromLogGroupArn(scope, `${logGroupName}LogGroup`, new aws_logs_1.LogRetention(scope, logWrapperId, {
                logGroupName: fullLogGroupName,
                retention,
            }).logGroupArn);
    }
}
exports.LogGroupFactory = LogGroupFactory;
_a = JSII_RTTI_SYMBOL_1;
LogGroupFactory[_a] = { fqn: "aws-rfdk.LogGroupFactory", version: "0.41.0" };
/**
 * Default retention period to hold logs in CloudWatch for.
 */
LogGroupFactory.DEFAULT_LOG_RETENTION = aws_logs_1.RetentionDays.THREE_DAYS;
//# sourceMappingURL=data:application/json;base64,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