"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchConfigBuilder = exports.TimeZone = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
const core_1 = require("@aws-cdk/core");
/**
 * Enum to describe the time zone property.
 *
 * @stability stable
 */
var TimeZone;
(function (TimeZone) {
    TimeZone["LOCAL"] = "Local";
    TimeZone["UTC"] = "UTC";
})(TimeZone = exports.TimeZone || (exports.TimeZone = {}));
/**
 * Class that can build a CloudWatch Agent configuration.
 *
 * @stability stable
 */
class CloudWatchConfigBuilder {
    /**
     * Constructs.
     *
     * @stability stable
     */
    constructor(logFlushInterval = CloudWatchConfigBuilder.DEFAULT_FLUSH_INTERVAL) {
        this.cloudWatchFileList = [];
        this.logFlushInterval = logFlushInterval;
    }
    /**
     * This method adds the log file path and its associated log group and log stream properties to the list of files which needs to be streamed to cloud watch logs.
     *
     * @param logGroupName - string for the log group name.
     * @param logStreamPrefix - string for the log stream prefix.
     * @param logFilePath - local file path which needs to be streamed.
     * @param timeZone -  the time zone to use when putting timestamps on log events.
     * @stability stable
     */
    addLogsCollectList(logGroupName, logStreamPrefix, logFilePath, timeZone = CloudWatchConfigBuilder.DEFAULT_LOG_TIMEZONE) {
        this.cloudWatchFileList.push({
            log_group_name: logGroupName,
            log_stream_name: logStreamPrefix + '-' + CloudWatchConfigBuilder.CLOUDWATCH_CONFIG_INSTANCE_ID_VARIABLE,
            file_path: logFilePath,
            timezone: timeZone,
        });
    }
    /**
     * The method generates the configuration for log file streaming to be added to CloudWatch Agent Configuration File.
     *
     * @stability stable
     */
    generateCloudWatchConfiguration() {
        const cloudWatchConfig = {
            logs: {
                logs_collected: {
                    files: {
                        collect_list: this.cloudWatchFileList,
                    },
                },
                log_stream_name: CloudWatchConfigBuilder.DEFAULT_STREAM_NAME
                    + '-'
                    + CloudWatchConfigBuilder.CLOUDWATCH_CONFIG_INSTANCE_ID_VARIABLE,
                force_flush_interval: this.logFlushInterval.toSeconds(),
            },
        };
        return JSON.stringify(cloudWatchConfig);
    }
}
exports.CloudWatchConfigBuilder = CloudWatchConfigBuilder;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchConfigBuilder[_a] = { fqn: "aws-rfdk.CloudWatchConfigBuilder", version: "0.41.0" };
CloudWatchConfigBuilder.DEFAULT_STREAM_NAME = 'DefaultLogStream';
CloudWatchConfigBuilder.DEFAULT_FLUSH_INTERVAL = core_1.Duration.seconds(60);
CloudWatchConfigBuilder.DEFAULT_LOG_TIMEZONE = TimeZone.LOCAL;
CloudWatchConfigBuilder.CLOUDWATCH_CONFIG_INSTANCE_ID_VARIABLE = '{instance_id}';
//# sourceMappingURL=data:application/json;base64,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