/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import oracle.pgx.api.ClientContext;
import oracle.pgx.api.GmCompilerOptimization;
import oracle.pgx.api.GraphMetaData;
import oracle.pgx.api.Namespace;
import oracle.pgx.api.Operation;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxVect;
import oracle.pgx.api.PoolType;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.executionenvironment.ExecutionEnvironmentField;
import oracle.pgx.api.expansion.internal.GraphExpansionConfig;
import oracle.pgx.api.filter.GraphFilter;
import oracle.pgx.api.frames.internal.GraphFrameDeclaration;
import oracle.pgx.api.internal.AllPathsProxy;
import oracle.pgx.api.internal.AnalysisResult;
import oracle.pgx.api.internal.Argument;
import oracle.pgx.api.internal.Changes;
import oracle.pgx.api.internal.ClientSessionContext;
import oracle.pgx.api.internal.CollectionProxy;
import oracle.pgx.api.internal.CompilationResult;
import oracle.pgx.api.internal.CompiledProgramMetaData;
import oracle.pgx.api.internal.ComponentsProxy;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.CoreGraphPersistenceApi;
import oracle.pgx.api.internal.Edge;
import oracle.pgx.api.internal.EdgeChanges;
import oracle.pgx.api.internal.EdgeLabel;
import oracle.pgx.api.internal.Entity;
import oracle.pgx.api.internal.FrameMetaData;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.api.internal.MapProxy;
import oracle.pgx.api.internal.PathProxy;
import oracle.pgx.api.internal.PgqlRedactionArgument;
import oracle.pgx.api.internal.PgqlResultSetProxy;
import oracle.pgx.api.internal.PreparedStatementProxy;
import oracle.pgx.api.internal.Property;
import oracle.pgx.api.internal.PropertyProxy;
import oracle.pgx.api.internal.PropertyValue;
import oracle.pgx.api.internal.RedactionRulesTriggers;
import oracle.pgx.api.internal.ScalarValue;
import oracle.pgx.api.internal.Vertex;
import oracle.pgx.api.internal.VertexChanges;
import oracle.pgx.api.internal.VertexLabels;
import oracle.pgx.api.internal.characteristic.WorkloadCharacteristicSet;
import oracle.pgx.api.internal.mllib.DeepWalkModelMetadata;
import oracle.pgx.api.internal.mllib.GnnExplanationMetaData;
import oracle.pgx.api.internal.mllib.ModelMetadata;
import oracle.pgx.api.internal.mllib.Pg2vecModelMetadata;
import oracle.pgx.api.internal.mllib.SupervisedEdgeWiseModelMetadata;
import oracle.pgx.api.internal.mllib.SupervisedGnnExplainerConfig;
import oracle.pgx.api.internal.mllib.SupervisedGnnExplanationMetaData;
import oracle.pgx.api.internal.mllib.SupervisedGraphWiseModelMetadata;
import oracle.pgx.api.internal.mllib.UnsupervisedEdgeWiseModelMetadata;
import oracle.pgx.api.internal.mllib.UnsupervisedGnnExplainerConfig;
import oracle.pgx.api.internal.mllib.UnsupervisedGraphWiseModelMetadata;
import oracle.pgx.api.mllib.SupervisedEdgeWiseModel;
import oracle.pgx.api.mllib.SupervisedGraphWiseModel;
import oracle.pgx.api.mllib.UnsupervisedEdgeWiseModel;
import oracle.pgx.api.mllib.UnsupervisedGraphWiseModel;
import oracle.pgx.api.mllib.VertexAnomalyDetectionModel;
import oracle.pgx.client.AbstractAsyncRequest;
import oracle.pgx.client.BatchedUploader;
import oracle.pgx.client.HeaderBuilder;
import oracle.pgx.client.HttpRequestExecutor;
import oracle.pgx.client.PgxRemoteRequest;
import oracle.pgx.client.PgxUrlEncoder;
import oracle.pgx.client.RemoteAllPathsProxyFactoryImpl;
import oracle.pgx.client.RemoteCollectionProxyFactoryImpl;
import oracle.pgx.client.RemoteComponentsProxyFactoryImpl;
import oracle.pgx.client.RemoteMapProxyFactoryImpl;
import oracle.pgx.client.RemotePgqlResultSetProxyFactoryImpl;
import oracle.pgx.client.RemotePreparedStatementProxyFactoryImpl;
import oracle.pgx.client.RemotePropertyProxyFactoryImpl;
import oracle.pgx.client.RemoteResponse;
import oracle.pgx.client.RemoteUtils;
import oracle.pgx.common.BindValue;
import oracle.pgx.common.Either;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.NotImplementedException;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.Self;
import oracle.pgx.common.auth.PgxResourcePermission;
import oracle.pgx.common.auth.PgxRole;
import oracle.pgx.common.auth.PgxUser;
import oracle.pgx.common.marshalers.AllPathsProxyMarshaler;
import oracle.pgx.common.marshalers.CollectionProxyMarshaler;
import oracle.pgx.common.marshalers.ComponentsProxyMarshaler;
import oracle.pgx.common.marshalers.ExecutionEnvironmentValueMarshaler;
import oracle.pgx.common.marshalers.GenericCollectionMarshaler;
import oracle.pgx.common.marshalers.GenericMarshaler;
import oracle.pgx.common.marshalers.InvocationResultMarshaler;
import oracle.pgx.common.marshalers.LongMarshaler;
import oracle.pgx.common.marshalers.MapProxyMarshaler;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.marshalers.Marshalers;
import oracle.pgx.common.marshalers.PgqlExplainMarshaler;
import oracle.pgx.common.marshalers.PgqlResultSetMarshaler;
import oracle.pgx.common.marshalers.PreparedStatementMarshaler;
import oracle.pgx.common.marshalers.PropertyProxyMarshaler;
import oracle.pgx.common.marshalers.PropertyTypedObjectMarshaler;
import oracle.pgx.common.marshalers.ValueMarshaler;
import oracle.pgx.common.mutations.MutationStrategy;
import oracle.pgx.common.mutations.PartitionizingStrategy;
import oracle.pgx.common.pojo.AddChangesRequest;
import oracle.pgx.common.pojo.AddRedactionRuleRequest;
import oracle.pgx.common.pojo.AddRowsToFrameBuilderRequest;
import oracle.pgx.common.pojo.AllPathsProxyRequest;
import oracle.pgx.common.pojo.AlterGraphRequest;
import oracle.pgx.common.pojo.BindValueImpl;
import oracle.pgx.common.pojo.BuildFrameRequest;
import oracle.pgx.common.pojo.BuildGraphRequest;
import oracle.pgx.common.pojo.CloneCollectionRequest;
import oracle.pgx.common.pojo.CollectionInfo;
import oracle.pgx.common.pojo.CombinePropertyRequest;
import oracle.pgx.common.pojo.ComputeMlModelRequest;
import oracle.pgx.common.pojo.ComputeSimilarsBatchedMlModelRequest;
import oracle.pgx.common.pojo.ComputeSimilarsMlModelRequest;
import oracle.pgx.common.pojo.ContainsElementRequest;
import oracle.pgx.common.pojo.CreateAnalysisRequest;
import oracle.pgx.common.pojo.CreateBipartiteSubgraphRequest;
import oracle.pgx.common.pojo.CreateCollectionProxyRequest;
import oracle.pgx.common.pojo.CreateCollectionRequest;
import oracle.pgx.common.pojo.CreateComponentsProxyRequest;
import oracle.pgx.common.pojo.CreateDeepWalkModelRequest;
import oracle.pgx.common.pojo.CreateFrameBuilderRequest;
import oracle.pgx.common.pojo.CreateGraphRequest;
import oracle.pgx.common.pojo.CreateMapProxyRequest;
import oracle.pgx.common.pojo.CreateMapRequest;
import oracle.pgx.common.pojo.CreatePg2vecModelRequest;
import oracle.pgx.common.pojo.CreatePgqlResultProxyRequest;
import oracle.pgx.common.pojo.CreatePropertyProxyRequest;
import oracle.pgx.common.pojo.CreatePropertyRequest;
import oracle.pgx.common.pojo.CreateScalarRequest;
import oracle.pgx.common.pojo.CreateSessionRequest;
import oracle.pgx.common.pojo.CreateSparsifiedSubgraphRequest;
import oracle.pgx.common.pojo.CreateSubgraphFromFilterRequest;
import oracle.pgx.common.pojo.CreateSupervisedEdgeWiseModelRequest;
import oracle.pgx.common.pojo.CreateSupervisedGraphWiseModelRequest;
import oracle.pgx.common.pojo.CreateUnsupervisedEdgeWiseModelRequest;
import oracle.pgx.common.pojo.CreateUnsupervisedGraphWiseModelRequest;
import oracle.pgx.common.pojo.DescribeFrameRequest;
import oracle.pgx.common.pojo.DescribeGraphRequest;
import oracle.pgx.common.pojo.EntityProviderConfigContainer;
import oracle.pgx.common.pojo.ExecutePreparedStatementRequest;
import oracle.pgx.common.pojo.ExecutionEnvironmentUpdateRequest;
import oracle.pgx.common.pojo.ExpandPropertyRequest;
import oracle.pgx.common.pojo.ExtractTopKRequest;
import oracle.pgx.common.pojo.FillPropertyRequest;
import oracle.pgx.common.pojo.FlattenFrameRequest;
import oracle.pgx.common.pojo.FrameExtractionRequest;
import oracle.pgx.common.pojo.FramePrintingRequest;
import oracle.pgx.common.pojo.GetGraphByNameRequest;
import oracle.pgx.common.pojo.GraphConfigContainer;
import oracle.pgx.common.pojo.GraphConfigRequest;
import oracle.pgx.common.pojo.GraphExpansionRequest;
import oracle.pgx.common.pojo.GraphFromFramesRequest;
import oracle.pgx.common.pojo.GraphPermissionRequest;
import oracle.pgx.common.pojo.GraphWiseExplanationMlModelRequest;
import oracle.pgx.common.pojo.IdTypedObject;
import oracle.pgx.common.pojo.JoinFramesRequest;
import oracle.pgx.common.pojo.LoadFrameRequest;
import oracle.pgx.common.pojo.LoadMlModelRequestWithConfigRequest;
import oracle.pgx.common.pojo.MapInfo;
import oracle.pgx.common.pojo.ModelRepositoryRequestWithConfig;
import oracle.pgx.common.pojo.ModifyCollectionRequest;
import oracle.pgx.common.pojo.MovePropertyRequest;
import oracle.pgx.common.pojo.MutateGraphRequest;
import oracle.pgx.common.pojo.MutateRequest;
import oracle.pgx.common.pojo.PathProxyRequest;
import oracle.pgx.common.pojo.PgqlCloneAndExecuteRequest;
import oracle.pgx.common.pojo.PgqlExplainRequest;
import oracle.pgx.common.pojo.PgqlQueryRequest;
import oracle.pgx.common.pojo.PinGraphRequest;
import oracle.pgx.common.pojo.PrepareStatementRequest;
import oracle.pgx.common.pojo.PropertyValuesPatchRequest;
import oracle.pgx.common.pojo.PublishGraphRequest;
import oracle.pgx.common.pojo.RefreshGraphRequest;
import oracle.pgx.common.pojo.RemoveRedactionRuleRequest;
import oracle.pgx.common.pojo.RenameGraphRequest;
import oracle.pgx.common.pojo.RunAnalysisRequest;
import oracle.pgx.common.pojo.SelectFrameRequest;
import oracle.pgx.common.pojo.SetScalarValueRequest;
import oracle.pgx.common.pojo.SortByDegreeRequest;
import oracle.pgx.common.pojo.StoreFrameRequest;
import oracle.pgx.common.pojo.StoreGraphRequest;
import oracle.pgx.common.pojo.StoreMlModelRequestWithConfig;
import oracle.pgx.common.pojo.SupervisedEdgeWiseInferenceMlModelRequest;
import oracle.pgx.common.pojo.SupervisedGraphWiseInferenceMlModelRequest;
import oracle.pgx.common.pojo.TypedMapEntry;
import oracle.pgx.common.pojo.TypedObject;
import oracle.pgx.common.pojo.UnionFramesRequest;
import oracle.pgx.common.pojo.UnsafeHttpMethodRequest;
import oracle.pgx.common.pojo.UnsupervisedAnomalyDetectionGraphWiseInferenceMlModelRequest;
import oracle.pgx.common.pojo.UnsupervisedEdgeWiseInferenceMlModelRequest;
import oracle.pgx.common.pojo.UnsupervisedGraphWiseInferenceMlModelRequest;
import oracle.pgx.common.types.AuthorizationType;
import oracle.pgx.common.types.CollectionType;
import oracle.pgx.common.types.Direction;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.types.ReturnType;
import oracle.pgx.common.types.internal.IdTypeUtils;
import oracle.pgx.common.types.internal.PropertyTypeUtils;
import oracle.pgx.common.util.ChangeTrackingMap;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.RemoteAllPathsProxyFactory;
import oracle.pgx.common.util.RemoteCollectionProxyFactory;
import oracle.pgx.common.util.RemoteComponentsProxyFactory;
import oracle.pgx.common.util.RemoteMapProxyFactory;
import oracle.pgx.common.util.RemotePgqlResultSetProxyFactory;
import oracle.pgx.common.util.RemotePreparedStatementProxyFactory;
import oracle.pgx.common.util.RemotePropertyProxyFactory;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.GraphBuilderConfig;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.IdGenerationStrategy;
import oracle.pgx.config.LinkTemplate;
import oracle.pgx.config.OnAddExistingElement;
import oracle.pgx.config.OnInvalidChange;
import oracle.pgx.config.OnRequiredConversion;
import oracle.pgx.config.PgxRedactionRuleConfig;
import oracle.pgx.config.internal.PgqlOption;
import oracle.pgx.config.mllib.ModelLoadingConfiguration;
import oracle.pgx.config.mllib.ModelRepositoryConfiguration;
import oracle.pgx.config.mllib.ModelStoringConfiguration;
import oracle.pgx.loaders.location.EntityProviderLocation;
import oracle.pgx.loaders.location.GraphLocation;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteCoreImpl
implements Core {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteCoreImpl.class);
    private final ClientContext context;
    private final HttpClient httpClient;
    private final String csrfToken;
    private final String baseUrl;
    private final String coreUrl;
    private final String executionEnvironmentUrl;
    private final RemotePropertyProxyFactory centralityResultFactory;
    private final RemoteAllPathsProxyFactory allPathsProxyFactory;
    private final RemoteCollectionProxyFactory collectionProxyFactory;
    private final RemoteComponentsProxyFactory componentsProxyFactory;
    private final RemoteMapProxyFactory mapProxyFactory;
    private final RemotePgqlResultSetProxyFactory pgqlResultSetFactory;
    private final RemotePreparedStatementProxyFactory preparedStatementProxyFactory;
    private final URI baseUri;

    private <T> PgxFuture<T> request(CoreRequest<T> request) {
        return request.execute();
    }

    private <T> PgxFuture<T> asyncRequest(PgxRemoteRequest<T> request) {
        return RemoteUtils.asyncRequest(this.context.getExecutorService(), request);
    }

    public PgxFuture<Pg2vecModelMetadata> createPg2vecModel(SessionContext sessionContext, final Pg2vecModelMetadata unregisteredModelMetadata) {
        return this.request(new CoreRequest<Pg2vecModelMetadata>(sessionContext, (Marshaler)Marshalers.PG2VEC_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreatePg2vecModelRequest createPg2vecModelRequest = new CreatePg2vecModelRequest();
                createPg2vecModelRequest.modelMetadata = unregisteredModelMetadata;
                return executor.post((UnsafeHttpMethodRequest)createPg2vecModelRequest, LinkTemplate.PG2VEC_MODELS.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Double> fitPg2vecModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final String graphletIdPropertyType) {
        return this.request(new CoreRequest<Double>(sessionContext, (Marshaler)Marshalers.DOUBLE_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ComputeMlModelRequest request = new ComputeMlModelRequest();
                request.graphId = graphId;
                request.graphletIdPropertyType = graphletIdPropertyType;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.FIT_PG2VEC_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> computeSimilarsPg2vecModel(SessionContext sessionContext, final String modelName, final String graphletId, final int k) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ComputeSimilarsMlModelRequest request = new ComputeSimilarsMlModelRequest();
                request.id = graphletId;
                request.k = k;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.COMPUTE_SIMILARS_PG2VEC_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> computeSimilarsBatchedPg2vecModel(SessionContext sessionContext, final String modelName, final List<String> graphletIds, final int k) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ComputeSimilarsBatchedMlModelRequest request = new ComputeSimilarsBatchedMlModelRequest();
                request.idList = graphletIds;
                request.k = k;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.COMPUTE_SIMILARS_BATCHED_PG2VEC_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> inferGraphletVectorPg2vecModel(SessionContext sessionContext, final String modelName, final PgxId graphletId, final String graphletIdPropertyType) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ComputeMlModelRequest request = new ComputeMlModelRequest();
                request.graphId = graphletId;
                request.graphletIdPropertyType = graphletIdPropertyType;
                request.isBatch = false;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_GRAPHLET_PG2VEC_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> inferGraphletVectorBatchedPg2vecModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final String graphletIdPropertyType) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ComputeMlModelRequest request = new ComputeMlModelRequest();
                request.graphId = graphId;
                request.graphletIdPropertyType = graphletIdPropertyType;
                request.isBatch = true;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_GRAPHLET_PG2VEC_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> getTrainedGraphletVectorsPg2vecModel(SessionContext sessionContext, final String modelName) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.get(headers, LinkTemplate.GET_MODEL_DATA_PG2VEC_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<ModelMetadata> loadModel(SessionContext sessionContext, final ModelLoadingConfiguration config) {
        return this.request(new CoreRequest<ModelMetadata>(sessionContext, (Marshaler)Marshalers.MODEL_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                LoadMlModelRequestWithConfigRequest loadMlModelRequest = new LoadMlModelRequestWithConfigRequest();
                loadMlModelRequest.config = config;
                return executor.post((UnsafeHttpMethodRequest)loadMlModelRequest, LinkTemplate.LOAD_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> storeModel(SessionContext sessionContext, final String modelName, final ModelStoringConfiguration modelStoringConfiguration) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                StoreMlModelRequestWithConfig request = new StoreMlModelRequestWithConfig();
                request.config = modelStoringConfiguration;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.STORE_MODEL_DATA_WITH_CONFIG.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> destroyMlModel(SessionContext sessionContext, final String modelName) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.delete(headers, LinkTemplate.MLMODEL_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> createModelStore(SessionContext sessionContext, final String modelStoreName, final ModelRepositoryConfiguration config) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ModelRepositoryRequestWithConfig request = new ModelRepositoryRequestWithConfig();
                request.config = config;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-store-name", modelStoreName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.CREATE_MODEL_STORE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> deleteModelStore(SessionContext sessionContext, final String modelStoreName, final ModelRepositoryConfiguration config) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ModelRepositoryRequestWithConfig request = new ModelRepositoryRequestWithConfig();
                request.config = config;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-store-name", modelStoreName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.DELETE_MODEL_STORE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<List<String>> listModelStoresNames(SessionContext sessionContext, final ModelRepositoryConfiguration config) {
        return this.request(new CoreRequest<List<String>>(sessionContext, (Marshaler)Marshalers.STRING_LIST_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ModelRepositoryRequestWithConfig request = new ModelRepositoryRequestWithConfig();
                request.config = config;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.LIST_MODEL_STORES.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<List<String>> listModelsInModelStore(SessionContext sessionContext, final String modelStoreName, final ModelRepositoryConfiguration config) {
        return this.request(new CoreRequest<List<String>>(sessionContext, (Marshaler)Marshalers.STRING_LIST_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ModelRepositoryRequestWithConfig request = new ModelRepositoryRequestWithConfig();
                request.config = config;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-store-name", modelStoreName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.LIST_MODELS_IN_MODEL_STORE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<String> getModelDescription(SessionContext sessionContext, final String modelStoreName, final String modelName, final ModelRepositoryConfiguration config) {
        return this.request(new CoreRequest<String>(sessionContext, (Marshaler)Marshalers.STRING_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ModelRepositoryRequestWithConfig request = new ModelRepositoryRequestWithConfig();
                request.config = config;
                HeaderBuilder hb = new HeaderBuilder();
                hb.addHeader("x-model-store-name", modelStoreName);
                hb.addHeader("x-model-name", modelName);
                return executor.post(hb.build(), (UnsafeHttpMethodRequest)request, LinkTemplate.GET_MODEL_DESCRIPTION.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> deleteModel(SessionContext sessionContext, final String modelStoreName, final String modelName, final ModelRepositoryConfiguration config) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ModelRepositoryRequestWithConfig request = new ModelRepositoryRequestWithConfig();
                request.config = config;
                HeaderBuilder hb = new HeaderBuilder();
                hb.addHeader("x-model-store-name", modelStoreName);
                hb.addHeader("x-model-name", modelName);
                return executor.post(hb.build(), (UnsafeHttpMethodRequest)request, LinkTemplate.DELETE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<DeepWalkModelMetadata> createDeepWalkModel(SessionContext sessionContext, final DeepWalkModelMetadata unregisteredModelMetadata) {
        return this.request(new CoreRequest<DeepWalkModelMetadata>(sessionContext, (Marshaler)Marshalers.DEEPWALK_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateDeepWalkModelRequest createDeepWalkModelRequest = new CreateDeepWalkModelRequest();
                createDeepWalkModelRequest.modelMetadata = unregisteredModelMetadata;
                return executor.post((UnsafeHttpMethodRequest)createDeepWalkModelRequest, LinkTemplate.DEEPWALK_MODELS.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Double> fitDeepWalkModel(SessionContext sessionContext, final String modelName, final PgxId graphId) {
        return this.request(new CoreRequest<Double>(sessionContext, (Marshaler)Marshalers.DOUBLE_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ComputeMlModelRequest request = new ComputeMlModelRequest();
                request.graphId = graphId;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.FIT_DEEPWALK_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> computeSimilarsDeepWalkModel(SessionContext sessionContext, final String modelName, final String vertexId, final int k) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ComputeSimilarsMlModelRequest request = new ComputeSimilarsMlModelRequest();
                request.id = vertexId;
                request.k = k;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.COMPUTE_SIMILARS_DEEPWALK_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> computeSimilarsBatchedDeepWalkModel(SessionContext sessionContext, final String modelName, final List<String> vertexIds, final int k) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ComputeSimilarsBatchedMlModelRequest request = new ComputeSimilarsBatchedMlModelRequest();
                request.idList = vertexIds;
                request.k = k;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.COMPUTE_SIMILARS_BATCHED_DEEPWALK_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> getTrainedVertexVectorsDeepWalkModel(SessionContext sessionContext, final String modelName) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.get(headers, LinkTemplate.GET_MODEL_DATA_DEEPWALK_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<SupervisedGraphWiseModelMetadata> createSupervisedGraphWiseModel(SessionContext sessionContext, final SupervisedGraphWiseModelMetadata unregisteredModelMetadata) {
        return this.request(new CoreRequest<SupervisedGraphWiseModelMetadata>(sessionContext, (Marshaler)Marshalers.GRAPHWISE_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateSupervisedGraphWiseModelRequest createSupervisedGraphWiseModelRequest = new CreateSupervisedGraphWiseModelRequest();
                createSupervisedGraphWiseModelRequest.modelMetadata = unregisteredModelMetadata;
                return executor.post((UnsafeHttpMethodRequest)createSupervisedGraphWiseModelRequest, LinkTemplate.GRAPHWISE_MODELS.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<SupervisedGraphWiseModelMetadata> fitSupervisedGraphWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId) {
        return this.request(new CoreRequest<SupervisedGraphWiseModelMetadata>(sessionContext, (Marshaler)Marshalers.GRAPHWISE_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ComputeMlModelRequest request = new ComputeMlModelRequest();
                request.graphId = graphId;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.FIT_GRAPHWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> inferEmbeddingsSupervisedGraphWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> vertices) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                SupervisedGraphWiseInferenceMlModelRequest request = new SupervisedGraphWiseInferenceMlModelRequest();
                ArrayList idTypedVertices = new ArrayList();
                boolean verticesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(vertices, idTypedVertices, true);
                request.graphId = graphId;
                request.vertices = idTypedVertices;
                request.verticesWrapped = verticesWrapped;
                request.inferenceType = SupervisedGraphWiseModel.SupervisedGraphWiseInferenceType.INFER_EMBEDDINGS;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_GRAPHWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> inferLogitsSupervisedGraphWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> vertices) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                SupervisedGraphWiseInferenceMlModelRequest request = new SupervisedGraphWiseInferenceMlModelRequest();
                ArrayList idTypedVertices = new ArrayList();
                boolean verticesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(vertices, idTypedVertices, true);
                request.graphId = graphId;
                request.vertices = idTypedVertices;
                request.verticesWrapped = verticesWrapped;
                request.inferenceType = SupervisedGraphWiseModel.SupervisedGraphWiseInferenceType.INFER_LOGITS;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_GRAPHWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> inferLabelsSupervisedGraphWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> vertices, final float threshold) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                SupervisedGraphWiseInferenceMlModelRequest request = new SupervisedGraphWiseInferenceMlModelRequest();
                ArrayList idTypedVertices = new ArrayList();
                boolean verticesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(vertices, idTypedVertices, true);
                request.graphId = graphId;
                request.vertices = idTypedVertices;
                request.verticesWrapped = verticesWrapped;
                request.inferenceType = SupervisedGraphWiseModel.SupervisedGraphWiseInferenceType.INFER_LABELS;
                request.threshold = threshold;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_GRAPHWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> inferSupervisedGraphWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> vertices, final float threshold) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                SupervisedGraphWiseInferenceMlModelRequest request = new SupervisedGraphWiseInferenceMlModelRequest();
                ArrayList idTypedVertices = new ArrayList();
                boolean verticesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(vertices, idTypedVertices, true);
                request.graphId = graphId;
                request.vertices = idTypedVertices;
                request.verticesWrapped = verticesWrapped;
                request.inferenceType = SupervisedGraphWiseModel.SupervisedGraphWiseInferenceType.INFER;
                request.threshold = threshold;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_GRAPHWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> evaluateLabelsSupervisedGraphWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> vertices, final float threshold) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                SupervisedGraphWiseInferenceMlModelRequest request = new SupervisedGraphWiseInferenceMlModelRequest();
                ArrayList idTypedVertices = new ArrayList();
                boolean verticesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(vertices, idTypedVertices, true);
                request.graphId = graphId;
                request.vertices = idTypedVertices;
                request.verticesWrapped = verticesWrapped;
                request.threshold = threshold;
                request.inferenceType = SupervisedGraphWiseModel.SupervisedGraphWiseInferenceType.EVALUATE_LABELS;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_GRAPHWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> evaluateSupervisedGraphWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> vertices, final float threshold) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                SupervisedGraphWiseInferenceMlModelRequest request = new SupervisedGraphWiseInferenceMlModelRequest();
                ArrayList idTypedVertices = new ArrayList();
                boolean verticesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(vertices, idTypedVertices, true);
                request.graphId = graphId;
                request.vertices = idTypedVertices;
                request.verticesWrapped = verticesWrapped;
                request.threshold = threshold;
                request.inferenceType = SupervisedGraphWiseModel.SupervisedGraphWiseInferenceType.EVALUATE;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_GRAPHWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<SupervisedGnnExplanationMetaData> inferAndGetExplanationSupervisedGraphWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final Object vertex, final float threshold) {
        return this.request(new CoreRequest<SupervisedGnnExplanationMetaData>(sessionContext, (Marshaler)Marshalers.SUPERVISED_GNN_EXPLANATION_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                GraphWiseExplanationMlModelRequest request = new GraphWiseExplanationMlModelRequest();
                boolean verticesWrapped = vertex instanceof Vertex;
                request.graphId = graphId;
                request.vertex = new IdTypedObject(vertex);
                request.verticesWrapped = verticesWrapped;
                request.modelType = GraphWiseExplanationMlModelRequest.ModelType.SUPERVISED;
                request.threshold = Float.valueOf(threshold);
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.EXPLAIN_GRAPHWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<SupervisedGnnExplanationMetaData> inferAndGetExplanationSupervisedGraphWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final Object vertex, final float threshold, final SupervisedGnnExplainerConfig explainerConfig) {
        return this.request(new CoreRequest<SupervisedGnnExplanationMetaData>(sessionContext, (Marshaler)Marshalers.SUPERVISED_GNN_EXPLANATION_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                GraphWiseExplanationMlModelRequest request = new GraphWiseExplanationMlModelRequest();
                boolean verticesWrapped = vertex instanceof Vertex;
                request.graphId = graphId;
                request.vertex = new IdTypedObject(vertex);
                request.verticesWrapped = verticesWrapped;
                request.modelType = GraphWiseExplanationMlModelRequest.ModelType.SUPERVISED;
                request.threshold = Float.valueOf(threshold);
                request.numOptimizationSteps = explainerConfig.getNumOptimizationSteps();
                request.learningRate = explainerConfig.getLearningRate();
                request.marginalize = explainerConfig.getMarginalize();
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.EXPLAIN_GRAPHWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<UnsupervisedGraphWiseModelMetadata> createUnsupervisedGraphWiseModel(SessionContext sessionContext, final UnsupervisedGraphWiseModelMetadata unregisteredModelMetadata) {
        return this.request(new CoreRequest<UnsupervisedGraphWiseModelMetadata>(sessionContext, (Marshaler)Marshalers.UNSUPERVISED_GRAPHWISE_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateUnsupervisedGraphWiseModelRequest createUnsupervisedGraphWiseModelRequest = new CreateUnsupervisedGraphWiseModelRequest();
                createUnsupervisedGraphWiseModelRequest.modelMetadata = unregisteredModelMetadata;
                return executor.post((UnsafeHttpMethodRequest)createUnsupervisedGraphWiseModelRequest, LinkTemplate.UNSUPERVISED_GRAPHWISE_MODELS.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<UnsupervisedGraphWiseModelMetadata> fitUnsupervisedGraphWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId) {
        return this.request(new CoreRequest<UnsupervisedGraphWiseModelMetadata>(sessionContext, (Marshaler)Marshalers.UNSUPERVISED_GRAPHWISE_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ComputeMlModelRequest request = new ComputeMlModelRequest();
                request.graphId = graphId;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.FIT_UNSUPERVISED_GRAPHWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> inferEmbeddingsUnsupervisedGraphWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> vertices) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                UnsupervisedGraphWiseInferenceMlModelRequest request = new UnsupervisedGraphWiseInferenceMlModelRequest();
                ArrayList idTypedVertices = new ArrayList();
                boolean verticesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(vertices, idTypedVertices, true);
                request.graphId = graphId;
                request.vertices = idTypedVertices;
                request.verticesWrapped = verticesWrapped;
                request.inferenceType = UnsupervisedGraphWiseModel.UnsupervisedGraphWiseInferenceType.INFER_EMBEDDINGS;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_UNSUPERVISED_GRAPHWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> inferAnomalyScoresUnsupervisedGraphWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> vertices) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                UnsupervisedAnomalyDetectionGraphWiseInferenceMlModelRequest request = new UnsupervisedAnomalyDetectionGraphWiseInferenceMlModelRequest();
                ArrayList idTypedVertices = new ArrayList();
                boolean verticesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(vertices, idTypedVertices, true);
                request.graphId = graphId;
                request.vertices = idTypedVertices;
                request.verticesWrapped = verticesWrapped;
                request.inferenceType = VertexAnomalyDetectionModel.AnomalyDetectionInferenceType.INFER_ANOMALY_SCORES;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_ANOMALY_UNSUPERVISED_GRAPHWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> inferAnomalyLabelsUnsupervisedGraphWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> vertices, final float threshold) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                UnsupervisedAnomalyDetectionGraphWiseInferenceMlModelRequest request = new UnsupervisedAnomalyDetectionGraphWiseInferenceMlModelRequest();
                ArrayList idTypedVertices = new ArrayList();
                boolean verticesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(vertices, idTypedVertices, true);
                request.graphId = graphId;
                request.vertices = idTypedVertices;
                request.verticesWrapped = verticesWrapped;
                request.inferenceType = VertexAnomalyDetectionModel.AnomalyDetectionInferenceType.INFER_ANOMALY_LABELS;
                request.threshold = threshold;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_ANOMALY_UNSUPERVISED_GRAPHWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Double> findAnomalyThresholdUnsupervisedGraphWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> vertices, final float contaminationFactor) {
        return this.request(new CoreRequest<Double>(sessionContext, (Marshaler)Marshalers.DOUBLE_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                UnsupervisedAnomalyDetectionGraphWiseInferenceMlModelRequest request = new UnsupervisedAnomalyDetectionGraphWiseInferenceMlModelRequest();
                ArrayList idTypedVertices = new ArrayList();
                boolean verticesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(vertices, idTypedVertices, true);
                request.graphId = graphId;
                request.vertices = idTypedVertices;
                request.verticesWrapped = verticesWrapped;
                request.inferenceType = VertexAnomalyDetectionModel.AnomalyDetectionInferenceType.FIND_ANOMALY_THRESHOLD;
                request.threshold = contaminationFactor;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.FIND_ANOMALY_THRESHOLD_UNSUPERVISED_GRAPHWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> evaluateAnomalyLabelsUnsupervisedGraphWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> vertices, final String vertexAnomalyPropertyName, final Object anomalyPropertyValue, final float threshold) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                UnsupervisedAnomalyDetectionGraphWiseInferenceMlModelRequest request = new UnsupervisedAnomalyDetectionGraphWiseInferenceMlModelRequest();
                ArrayList idTypedVertices = new ArrayList();
                boolean verticesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(vertices, idTypedVertices, true);
                request.graphId = graphId;
                request.vertices = idTypedVertices;
                request.verticesWrapped = verticesWrapped;
                request.inferenceType = VertexAnomalyDetectionModel.AnomalyDetectionInferenceType.EVALUATE_ANOMALY_LABELS;
                request.threshold = threshold;
                request.vertexAnomalyPropertyName = vertexAnomalyPropertyName;
                request.anomalyPropertyValue = anomalyPropertyValue;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_ANOMALY_UNSUPERVISED_GRAPHWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<GnnExplanationMetaData> inferAndGetExplanationUnsupervisedGraphWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final Object vertex, final int numClusters, final int numSamples) {
        return this.request(new CoreRequest<GnnExplanationMetaData>(sessionContext, (Marshaler)Marshalers.GNN_EXPLANATION_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                GraphWiseExplanationMlModelRequest request = new GraphWiseExplanationMlModelRequest();
                boolean verticesWrapped = vertex instanceof Vertex;
                request.graphId = graphId;
                request.vertex = new IdTypedObject(vertex);
                request.verticesWrapped = verticesWrapped;
                request.modelType = GraphWiseExplanationMlModelRequest.ModelType.UNSUPERVISED;
                request.numClusters = numClusters;
                request.numSamples = numSamples;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.EXPLAIN_GRAPHWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<GnnExplanationMetaData> inferAndGetExplanationUnsupervisedGraphWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final Object vertex, final UnsupervisedGnnExplainerConfig explainerConfig) {
        return this.request(new CoreRequest<GnnExplanationMetaData>(sessionContext, (Marshaler)Marshalers.GNN_EXPLANATION_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                GraphWiseExplanationMlModelRequest request = new GraphWiseExplanationMlModelRequest();
                boolean verticesWrapped = vertex instanceof Vertex;
                request.graphId = graphId;
                request.vertex = new IdTypedObject(vertex);
                request.verticesWrapped = verticesWrapped;
                request.modelType = GraphWiseExplanationMlModelRequest.ModelType.UNSUPERVISED;
                request.numOptimizationSteps = explainerConfig.getNumOptimizationSteps();
                request.learningRate = explainerConfig.getLearningRate();
                request.marginalize = explainerConfig.getMarginalize();
                request.numClusters = explainerConfig.getNumClusters();
                request.numSamples = explainerConfig.getNumSamples();
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.EXPLAIN_GRAPHWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    private static boolean wrappedEntitiesAsIdTyped(List<Object> entities, List<IdTypedObject> idTypedVertices, boolean wrapVertices) throws IOException {
        if (entities.isEmpty()) {
            return false;
        }
        Set wrapped = wrapVertices ? entities.stream().map(v -> v instanceof Vertex).collect(Collectors.toSet()) : entities.stream().map(v -> v instanceof Edge).collect(Collectors.toSet());
        if (wrapped.size() != 1) {
            throw new IllegalStateException("not all provided vertices were wrapped");
        }
        boolean areVerticesWrapped = (Boolean)wrapped.iterator().next();
        for (Object v2 : entities) {
            idTypedVertices.add(new IdTypedObject(v2));
        }
        return areVerticesWrapped;
    }

    public PgxFuture<SupervisedEdgeWiseModelMetadata> createSupervisedEdgeWiseModel(SessionContext sessionContext, final SupervisedEdgeWiseModelMetadata unregisteredModelMetadata) {
        return this.request(new CoreRequest<SupervisedEdgeWiseModelMetadata>(sessionContext, (Marshaler)Marshalers.EDGEWISE_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateSupervisedEdgeWiseModelRequest createSupervisedEdgeWiseModelRequest = new CreateSupervisedEdgeWiseModelRequest();
                createSupervisedEdgeWiseModelRequest.modelMetadata = unregisteredModelMetadata;
                return executor.post((UnsafeHttpMethodRequest)createSupervisedEdgeWiseModelRequest, LinkTemplate.EDGEWISE_MODELS.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<SupervisedEdgeWiseModelMetadata> fitSupervisedEdgeWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId) {
        return this.request(new CoreRequest<SupervisedEdgeWiseModelMetadata>(sessionContext, (Marshaler)Marshalers.EDGEWISE_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ComputeMlModelRequest request = new ComputeMlModelRequest();
                request.graphId = graphId;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.FIT_EDGEWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> inferEmbeddingsSupervisedEdgeWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> edges) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                SupervisedEdgeWiseInferenceMlModelRequest request = new SupervisedEdgeWiseInferenceMlModelRequest();
                ArrayList idTypedEdges = new ArrayList();
                boolean edgesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(edges, idTypedEdges, false);
                request.graphId = graphId;
                request.edges = idTypedEdges;
                request.edgesWrapped = edgesWrapped;
                request.inferenceType = SupervisedEdgeWiseModel.SupervisedEdgeWiseInferenceType.INFER_EMBEDDINGS;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_EDGEWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> inferLogitsSupervisedEdgeWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> edges) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                SupervisedEdgeWiseInferenceMlModelRequest request = new SupervisedEdgeWiseInferenceMlModelRequest();
                ArrayList idTypedEdges = new ArrayList();
                boolean edgesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(edges, idTypedEdges, false);
                request.graphId = graphId;
                request.edges = idTypedEdges;
                request.edgesWrapped = edgesWrapped;
                request.inferenceType = SupervisedEdgeWiseModel.SupervisedEdgeWiseInferenceType.INFER_LOGITS;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_EDGEWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> inferLabelsSupervisedEdgeWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> edges, final float threshold) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                SupervisedEdgeWiseInferenceMlModelRequest request = new SupervisedEdgeWiseInferenceMlModelRequest();
                ArrayList idTypedEdges = new ArrayList();
                boolean edgesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(edges, idTypedEdges, false);
                request.graphId = graphId;
                request.edges = idTypedEdges;
                request.edgesWrapped = edgesWrapped;
                request.inferenceType = SupervisedEdgeWiseModel.SupervisedEdgeWiseInferenceType.INFER_LABELS;
                request.threshold = threshold;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_EDGEWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> evaluateLabelsSupervisedEdgeWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> edges, final float threshold) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                SupervisedEdgeWiseInferenceMlModelRequest request = new SupervisedEdgeWiseInferenceMlModelRequest();
                ArrayList idTypedEdges = new ArrayList();
                boolean edgesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(edges, idTypedEdges, false);
                request.graphId = graphId;
                request.edges = idTypedEdges;
                request.edgesWrapped = edgesWrapped;
                request.threshold = threshold;
                request.inferenceType = SupervisedEdgeWiseModel.SupervisedEdgeWiseInferenceType.EVALUATE_LABELS;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_EDGEWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> inferSupervisedEdgeWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> edges, final float threshold) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                SupervisedEdgeWiseInferenceMlModelRequest request = new SupervisedEdgeWiseInferenceMlModelRequest();
                ArrayList idTypedEdges = new ArrayList();
                boolean edgesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(edges, idTypedEdges, false);
                request.graphId = graphId;
                request.edges = idTypedEdges;
                request.edgesWrapped = edgesWrapped;
                request.inferenceType = SupervisedEdgeWiseModel.SupervisedEdgeWiseInferenceType.INFER;
                request.threshold = threshold;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_EDGEWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> evaluateSupervisedEdgeWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> edges, final float threshold) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                SupervisedEdgeWiseInferenceMlModelRequest request = new SupervisedEdgeWiseInferenceMlModelRequest();
                ArrayList idTypedEdges = new ArrayList();
                boolean edgesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(edges, idTypedEdges, false);
                request.graphId = graphId;
                request.edges = idTypedEdges;
                request.edgesWrapped = edgesWrapped;
                request.threshold = threshold;
                request.inferenceType = SupervisedEdgeWiseModel.SupervisedEdgeWiseInferenceType.EVALUATE;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_EDGEWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<UnsupervisedEdgeWiseModelMetadata> createUnsupervisedEdgeWiseModel(SessionContext sessionContext, final UnsupervisedEdgeWiseModelMetadata unregisteredModelMetadata) {
        return this.request(new CoreRequest<UnsupervisedEdgeWiseModelMetadata>(sessionContext, (Marshaler)Marshalers.UNSUPERVISED_EDGEWISE_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateUnsupervisedEdgeWiseModelRequest createUnsupervisedEdgeWiseModelRequest = new CreateUnsupervisedEdgeWiseModelRequest();
                createUnsupervisedEdgeWiseModelRequest.modelMetadata = unregisteredModelMetadata;
                return executor.post((UnsafeHttpMethodRequest)createUnsupervisedEdgeWiseModelRequest, LinkTemplate.UNSUPERVISED_EDGEWISE_MODELS.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<UnsupervisedEdgeWiseModelMetadata> fitUnsupervisedEdgeWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId) {
        return this.request(new CoreRequest<UnsupervisedEdgeWiseModelMetadata>(sessionContext, (Marshaler)Marshalers.UNSUPERVISED_EDGEWISE_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ComputeMlModelRequest request = new ComputeMlModelRequest();
                request.graphId = graphId;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.FIT_UNSUPERVISED_EDGEWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> inferEmbeddingsUnsupervisedEdgeWiseModel(SessionContext sessionContext, final String modelName, final PgxId graphId, final List<Object> edges) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                UnsupervisedEdgeWiseInferenceMlModelRequest request = new UnsupervisedEdgeWiseInferenceMlModelRequest();
                ArrayList idTypedEdges = new ArrayList();
                boolean edgesWrapped = RemoteCoreImpl.wrappedEntitiesAsIdTyped(edges, idTypedEdges, false);
                request.graphId = graphId;
                request.edges = idTypedEdges;
                request.edgesWrapped = edgesWrapped;
                request.inferenceType = UnsupervisedEdgeWiseModel.UnsupervisedEdgeWiseInferenceType.INFER_EMBEDDINGS;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-model-name", modelName);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.INFER_UNSUPERVISED_EDGEWISE_MODEL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public RemoteCoreImpl(ClientContext context) {
        this.context = context;
        this.httpClient = context.getHttpClient();
        this.csrfToken = context.getCsrfToken();
        String baseUrl = context.getConfig().getCleanedBaseUrl();
        LOG.info("initializing PGX client with base URL {}", (Object)baseUrl);
        this.baseUri = URI.create(baseUrl);
        this.baseUrl = baseUrl;
        this.coreUrl = baseUrl + "/core/v1";
        this.executionEnvironmentUrl = this.coreUrl + "/executionEnvironment";
        this.centralityResultFactory = new RemotePropertyProxyFactoryImpl(context, this.baseUri);
        this.allPathsProxyFactory = new RemoteAllPathsProxyFactoryImpl(context, this.baseUri);
        this.collectionProxyFactory = new RemoteCollectionProxyFactoryImpl(context, this.baseUri);
        this.componentsProxyFactory = new RemoteComponentsProxyFactoryImpl(context, this.baseUri);
        this.mapProxyFactory = new RemoteMapProxyFactoryImpl(context, this.baseUri);
        this.pgqlResultSetFactory = new RemotePgqlResultSetProxyFactoryImpl(context, this.baseUri);
        this.preparedStatementProxyFactory = new RemotePreparedStatementProxyFactoryImpl();
    }

    public ClientContext getContext() {
        return this.context;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public PgxFuture<SessionContext> createSession(String source, Long idleTimeout, Long taskTimeout, TimeUnit timeunit) {
        return this.asyncRequest(() -> {
            CookieStore cookieStore = RemoteUtils.createCookieStore(this.baseUrl, null, this.csrfToken, this.context.getClientStickyCookie());
            Optional<SessionContext> sessionContext = this.submitCreateSessionRequest(source, idleTimeout, taskTimeout, timeunit, cookieStore);
            if (sessionContext.isPresent()) {
                return sessionContext.get();
            }
            Optional<Cookie> stickyCookie = RemoteUtils.findCookie("PGX_SESSION_STICKY_COOKIE", cookieStore);
            assert (stickyCookie.isPresent());
            String stickyCookieValue = stickyCookie.get().getValue();
            CookieStore cookieStoreWithSticky = RemoteUtils.createCookieStore(this.baseUrl, null, this.csrfToken, this.context.getClientStickyCookie());
            cookieStoreWithSticky.addCookie(RemoteUtils.createCookie(this.baseUrl, "PGX_SESSION_STICKY_COOKIE", stickyCookieValue));
            sessionContext = this.submitCreateSessionRequest(source, idleTimeout, taskTimeout, timeunit, cookieStoreWithSticky);
            if (!sessionContext.isPresent()) {
                throw new IllegalStateException("server did not set a SID cookie");
            }
            return sessionContext.get();
        });
    }

    private Optional<SessionContext> submitCreateSessionRequest(String source, Long idleTimeout, Long taskTimeout, TimeUnit timeunit, CookieStore cookieStore) throws IOException, RemoteUtils.RequestPendingException, ExecutionException {
        CreateSessionRequest createSessionRequest = new CreateSessionRequest();
        createSessionRequest.csrfToken = this.csrfToken;
        createSessionRequest.source = source;
        createSessionRequest.taskTimeout = taskTimeout;
        createSessionRequest.idleTimeout = idleTimeout;
        if (timeunit != null) {
            createSessionRequest.timeUnitName = timeunit.name();
        }
        String jsonPayload = JsonUtil.toJson((Object)createSessionRequest);
        Request r = Request.Post((URI)LinkTemplate.SESSIONS.generateLink(this.baseUri, new Object[0])).bodyString(jsonPayload, ContentType.APPLICATION_JSON);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requesting {} with payload {}", (Object)r, (Object)jsonPayload);
        }
        Executor httpExecutor = Executor.newInstance((HttpClient)this.httpClient).use(cookieStore);
        RemoteUtils.parse(httpExecutor.execute(r), Marshalers.VOID_MARSHALER);
        return this.createSessionContext(cookieStore);
    }

    private Optional<SessionContext> createSessionContext(CookieStore cookieStore) {
        Optional<Cookie> stickyCookie = RemoteUtils.findCookie("PGX_SESSION_STICKY_COOKIE", cookieStore);
        if (stickyCookie.isPresent()) {
            LOG.debug("the server sent a sticky cookie");
        } else {
            LOG.debug("the server did not send a sticky cookie");
        }
        Optional<Cookie> sessionIdCookie = RemoteUtils.findCookie("SID", cookieStore);
        if (sessionIdCookie.isPresent()) {
            String sessionId = sessionIdCookie.get().getValue();
            LOG.debug("server created session ID = {}", (Object)sessionId);
            LOG.debug("domain = {}", (Object)sessionIdCookie.get().getDomain());
            LOG.debug("expiry = {}", (Object)sessionIdCookie.get().getExpiryDate());
            String stickyCookieValue = stickyCookie.map(Cookie::getValue).orElse(null);
            ClientSessionContext sessionContext = new ClientSessionContext(sessionId, stickyCookieValue);
            return Optional.of(sessionContext);
        }
        LOG.debug("server did not create a session");
        if (stickyCookie.isPresent()) {
            LOG.debug("will resubmit request with sticky cookie");
            return Optional.empty();
        }
        throw new IllegalStateException("expected to receive either session id or sticky cookie but received neither");
    }

    public PgxFuture<Void> destroySession(SessionContext sessionContext) {
        return this.asyncRequest(() -> {
            try {
                URIBuilder builder = new URIBuilder(LinkTemplate.DESTROY_SESSION.generateUrl(this.baseUri, new Object[0]));
                builder.addParameter("_csrf_token", this.csrfToken);
                Request r = Request.Delete((String)PgxUrlEncoder.encodeUrl(builder.build().toString(), new Object[0]));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Requesting {}", (Object)r);
                }
                Response response = RemoteUtils.newHttpExecutor(this.httpClient, this.baseUrl, sessionContext, this.csrfToken, this.context.getClientStickyCookie()).execute(r);
                return (Void)RemoteUtils.parse(response, Marshalers.VOID_MARSHALER);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public PgxFuture<Object> getExecutionEnvironment(SessionContext sessionContext, final PoolType poolType, final ExecutionEnvironmentField field) {
        return this.request(new CoreRequest<Object>(sessionContext, (Marshaler)new ExecutionEnvironmentValueMarshaler(field)){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                String url = PgxUrlEncoder.encodeUrl(RemoteCoreImpl.this.executionEnvironmentUrl, new Object[0]);
                ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
                String poolName = poolType == null ? null : poolType.name();
                parameters.add((NameValuePair)new BasicNameValuePair("poolType", poolName));
                parameters.add((NameValuePair)new BasicNameValuePair("field", field.name()));
                return executor.get(url, parameters);
            }
        });
    }

    public PgxFuture<Void> updateExecutionEnvironment(SessionContext sessionContext, final PoolType poolType, final ExecutionEnvironmentField field, final Object value) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                String url = PgxUrlEncoder.encodeUrl(RemoteCoreImpl.this.executionEnvironmentUrl + "/update", new Object[0]);
                ExecutionEnvironmentUpdateRequest request = new ExecutionEnvironmentUpdateRequest();
                request.poolType = poolType;
                request.field = field;
                request.value = value;
                return executor.post((UnsafeHttpMethodRequest)request, url);
            }
        });
    }

    public PgxFuture<PgxId> createFrameBuilder(final SessionContext sessionContext, final EntityProviderConfig config) {
        return this.request(new CoreRequest<PgxId>(sessionContext, (Marshaler)Marshalers.PGX_ID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateFrameBuilderRequest request = new CreateFrameBuilderRequest();
                request.schema = EntityProviderConfigContainer.createObfuscated((EntityProviderConfig)config, (String)sessionContext.getSessionId());
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.CREATE_FRAME_BUILDER.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> addRowsToFrameBuilder(SessionContext sessionContext, PgxId builderId, Map<String, Iterable<?>> data) {
        if (data == null || !data.values().iterator().hasNext()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"FRAME_BUILDER_INVALID_COLUMNS", (Object[])new Object[0]));
        }
        int uploadBatchSize = this.context.getConfig().getUploadBatchSize();
        Map<String, Iterator<?>> unmaterializedData = data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Iterable)e.getValue()).iterator()));
        HashMap materializedData = Maps.newHashMapWithExpectedSize((int)unmaterializedData.size());
        for (String columnName : data.keySet()) {
            materializedData.put(columnName, new ArrayList(uploadBatchSize));
        }
        return this.addRowsToFrameBuilderBatched(sessionContext, builderId, unmaterializedData, materializedData, uploadBatchSize);
    }

    private PgxFuture<Void> addRowsToFrameBuilderBatched(SessionContext sessionContext, PgxId builderId, Map<String, Iterator<?>> unmaterializedData, Map<String, List<?>> materializedData, int batchSize) {
        PgxFuture promise = PgxFuture.completedFuture(null);
        if (materializedData.values().iterator().next().isEmpty()) {
            for (Map.Entry<String, List<?>> entry : materializedData.entrySet()) {
                String s = entry.getKey();
                List<?> l = entry.getValue();
                Iterator<?> it = unmaterializedData.get(s);
                for (int i = 0; i < batchSize && it.hasNext(); ++i) {
                    l.add(it.next());
                }
            }
        }
        if (materializedData.values().iterator().next().isEmpty()) {
            return promise;
        }
        return promise.thenCompose(v -> this.addRowsToFrameBuilderBatch(sessionContext, builderId, materializedData, batchSize)).handle((v, error) -> RemoteCoreImpl.handleAddRowsToFrameBuilderBatchErrors(error, batchSize)).thenCompose(b -> {
            if (b == batchSize) {
                materializedData.forEach((s, l) -> {
                    int startIndex = Math.min(l.size(), batchSize);
                    materializedData.put((String)s, l.subList(startIndex, l.size()));
                });
            }
            return this.addRowsToFrameBuilderBatched(sessionContext, builderId, unmaterializedData, materializedData, (int)b);
        });
    }

    private static int handleAddRowsToFrameBuilderBatchErrors(Throwable error, int batchSize) {
        if (error != null && error.getCause() != null && error.getCause().getClass() == IllegalArgumentException.class) {
            boolean correctMessage = RemoteCoreImpl.isRequestSizeTooLargeExceptionMessage(error.getCause());
            if (correctMessage) {
                if (batchSize > 1) {
                    return batchSize >> 1;
                }
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"FRAME_BUILDER_SINGLE_ROW_TOO_LARGE", (Object[])new Object[0]));
            }
            throw (CompletionException)error;
        }
        return batchSize;
    }

    private static boolean isRequestSizeTooLargeExceptionMessage(Throwable error) {
        return Sets.newHashSet((Object[])error.getMessage().split(" ")).containsAll(Arrays.asList(ErrorMessages.getMessage((String)"REQUEST_TOO_LARGE", (Object[])new Object[0]).split(" ")));
    }

    private PgxFuture<Void> addRowsToFrameBuilderBatch(SessionContext sessionContext, final PgxId builderId, Map<String, List<?>> data, int batchSize) {
        int numRows = data.values().iterator().next().size();
        int endIndex = Math.min(batchSize, numRows);
        final Map<String, Iterable> batch = data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).subList(0, endIndex)));
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                AddRowsToFrameBuilderRequest request = new AddRowsToFrameBuilderRequest();
                request.data = batch;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-frame-builder-id", builderId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.ADD_ROWS_TO_FRAME_BUILDER.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> buildFrame(SessionContext sessionContext, final PgxId builderId, final String frameName) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                BuildFrameRequest request = new BuildFrameRequest();
                request.frameName = frameName;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-frame-builder-id", builderId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.BUILD_FRAME.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> destroyFrameBuilder(SessionContext sessionContext, final PgxId builderId) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-frame-builder-id", builderId.toString());
                return executor.delete(headers, LinkTemplate.DESTROY_FRAME_BUILDER.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<EntityProviderConfig> describeFrame(SessionContext sessionContext, final EntityProviderLocation location) {
        return this.request(new CoreRequest<EntityProviderConfig>(sessionContext, (Marshaler)Marshalers.PROVIDER_CONFIG_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                DescribeFrameRequest request = new DescribeFrameRequest();
                request.location = location;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.DESCRIBE_FRAME.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> loadRowFrame(final SessionContext sessionContext, final EntityProviderConfig config) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                LoadFrameRequest request = new LoadFrameRequest();
                request.configContainer = EntityProviderConfigContainer.createObfuscated((EntityProviderConfig)config, (String)sessionContext.getSessionId());
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.LOAD_FRAME.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> storeFrame(final SessionContext sessionContext, final PgxId frameId, final EntityProviderConfig config, final boolean overwrite) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                StoreFrameRequest storeGraphRequest = new StoreFrameRequest();
                storeGraphRequest.configContainer = EntityProviderConfigContainer.createObfuscated((EntityProviderConfig)config, (String)sessionContext.getSessionId());
                storeGraphRequest.overwrite = overwrite;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-frame-id", frameId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)storeGraphRequest, LinkTemplate.STORE_FRAME.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> selectFrame(SessionContext sessionContext, final PgxId frameId, final LinkedHashMap<String, String> columnMapping, final boolean inPlace) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                SelectFrameRequest selectRequest = new SelectFrameRequest();
                selectRequest.columnMappings = columnMapping;
                selectRequest.inPlace = inPlace;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-frame-id", frameId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)selectRequest, LinkTemplate.SELECT_FRAME.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> flattenFrame(SessionContext sessionContext, final PgxId frameId, final boolean inPlace, final String[] columns) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                FlattenFrameRequest flattenRequest = new FlattenFrameRequest();
                flattenRequest.inPlace = inPlace;
                flattenRequest.columns = columns;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-frame-id", frameId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)flattenRequest, LinkTemplate.FLATTEN_FRAME.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> frameHead(SessionContext sessionContext, final PgxId frameId, final long numRows, final boolean inPlace) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                FrameExtractionRequest request = new FrameExtractionRequest();
                request.numRows = numRows;
                request.inPlace = inPlace;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-frame-id", frameId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.FRAME_HEAD.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> frameTail(SessionContext sessionContext, final PgxId frameId, final long numRows, final boolean inPlace) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                FrameExtractionRequest request = new FrameExtractionRequest();
                request.numRows = numRows;
                request.inPlace = inPlace;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-frame-id", frameId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.FRAME_TAIL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Long> frameCount(SessionContext sessionContext, final PgxId frameId) {
        return this.request(new CoreRequest<Long>(sessionContext, (Marshaler)Marshalers.LONG_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-frame-id", frameId.toString());
                return executor.get(headers, LinkTemplate.FRAME_COUNT.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<String> printFrame(SessionContext sessionContext, final PgxId frameId, final long numResults, final long from, final boolean truncate, final String lineSeparator) {
        return this.request(new CoreRequest<String>(sessionContext, (Marshaler)Marshalers.WRAPPED_STRING_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                FramePrintingRequest request = new FramePrintingRequest();
                request.numResults = numResults;
                request.from = from;
                request.truncate = truncate;
                request.lineSeparator = lineSeparator;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-frame-id", frameId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.FRAME_PRINT.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> joinFrame(SessionContext sessionContext, final PgxId frameLeftId, final PgxId frameRightId, final String leftJoinKeyColumn, final String rightJoinKeyColumn, final String leftPrefix, final String rightPrefix) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                JoinFramesRequest request = new JoinFramesRequest();
                request.leftFrame = frameLeftId;
                request.rightFrame = frameRightId;
                request.leftOn = leftJoinKeyColumn;
                request.rightOn = rightJoinKeyColumn;
                request.leftPrefix = leftPrefix;
                request.rightPrefix = rightPrefix;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.FRAME_JOIN.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> frameUnion(SessionContext sessionContext, final PgxId frameAId, final PgxId frameBId, final PgxId ... otherFramesIds) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                UnionFramesRequest request = new UnionFramesRequest();
                request.frameA = frameAId;
                request.frameB = frameBId;
                request.otherFrames = otherFramesIds;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.FRAME_UNION.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<PgqlResultSetProxy> frameToPgqlResultSet(SessionContext sessionContext, final PgxId frameId) {
        PgqlResultSetMarshaler marshaler = new PgqlResultSetMarshaler(sessionContext, this.pgqlResultSetFactory);
        return this.request(new CoreRequest<PgqlResultSetProxy>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-frame-id", frameId.toString());
                return executor.get(headers, LinkTemplate.FRAME_TO_PGQL_RESULTSET.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> destroyFrame(SessionContext sessionContext, final PgxId frameId) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-frame-id", frameId.toString());
                return executor.delete(headers, LinkTemplate.FRAME_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> createGraphFromFrames(SessionContext sessionContext, final GraphFrameDeclaration declaration) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                GraphFromFramesRequest request = new GraphFromFramesRequest();
                request.declaration = declaration;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.CREATE_GRAPH_FROM_FRAMES.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> loadGraphWithProperties(final SessionContext sessionContext, final GraphConfig config, final String name) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateGraphRequest createGraphRequest = new CreateGraphRequest();
                createGraphRequest.graphConfig = GraphConfigContainer.createObfuscated((GraphConfig)config, (String)sessionContext.getSessionId());
                createGraphRequest.graphName = name;
                return executor.post((UnsafeHttpMethodRequest)createGraphRequest, LinkTemplate.LOAD_GRAPH.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<GraphConfig> describeGraph(SessionContext sessionContext, final GraphLocation location) {
        return this.request(new CoreRequest<GraphConfig>(sessionContext, (Marshaler)Marshalers.GRAPH_CONFIG_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                DescribeGraphRequest request = new DescribeGraphRequest();
                request.graphLocation = location;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.DESCRIBE_GRAPH.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> refresh(SessionContext sessionContext, final PgxId graphId, final boolean blockIfFull) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                RefreshGraphRequest request = new RefreshGraphRequest();
                request.blockIfFull = blockIfFull;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.REFRESH_GRAPH.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Collection<Graph>> getGraphs(SessionContext sessionContext) {
        GenericCollectionMarshaler graphSetMarshaler = new GenericCollectionMarshaler(Set.class, Graph.class);
        return this.request(new CoreRequest<Collection<Graph>>(sessionContext, (Marshaler)graphSetMarshaler){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                return executor.get(LinkTemplate.GRAPHS_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Collection<String>> getGraphs(SessionContext sessionContext, final Namespace namespace) {
        GenericCollectionMarshaler marshaler = new GenericCollectionMarshaler(List.class, String.class);
        return this.request(new CoreRequest<Collection<String>>(sessionContext, (Marshaler)marshaler){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-namespace-id", namespace.getNamespaceId().toString());
                return executor.get(headers, LinkTemplate.GRAPH_NAMES_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Boolean> isFresh(SessionContext sessionContext, final PgxId graphId) {
        return this.request(new CoreRequest<Boolean>(sessionContext, (Marshaler)Marshalers.BOOLEAN_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.get(headers, LinkTemplate.IS_FRESH_GRAPH.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Deque<GraphMetaData>> getAvailableSnapshots(final SessionContext sessionContext, final GraphConfig config) {
        return this.request(new CoreRequest<Deque<GraphMetaData>>(sessionContext, (Marshaler)Marshalers.GRAPH_META_DATA_LIST_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                GraphConfigRequest request = new GraphConfigRequest();
                request.graphConfig = GraphConfigContainer.createObfuscated((GraphConfig)config, (String)sessionContext.getSessionId());
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.LOOK_UP_SNAPSHOTS.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Deque<GraphMetaData>> getAvailableSnapshots(SessionContext sessionContext, final PgxId graphId) {
        return this.request(new CoreRequest<Deque<GraphMetaData>>(sessionContext, (Marshaler)Marshalers.GRAPH_META_DATA_LIST_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.get(headers, LinkTemplate.LOOK_UP_SNAPSHOTS_BY_ID.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> checkout(SessionContext sessionContext, final PgxId graphId, final long creationTs) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).addHeader("x-creation-ts", String.valueOf(creationTs)).build();
                return executor.post(headers, LinkTemplate.SNAPSHOT_CHECKOUT.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<GraphMetaData> getSnapshot(SessionContext sessionContext, final PgxId graphId, final long creationTs) {
        GenericMarshaler marshaler = new GenericMarshaler(GraphMetaData.class);
        return this.request(new CoreRequest<GraphMetaData>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).addHeader("x-creation-ts", String.valueOf(creationTs)).build();
                return executor.get(headers, LinkTemplate.SNAPSHOT_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> getGraphResult(SessionContext sessionContext, final PgxId graphId) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.get(headers, LinkTemplate.GRAPH_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), params);
            }
        });
    }

    public PgxFuture<Graph> getGraphResultByName(SessionContext sessionContext, final Namespace namespace, final String graphName) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                GetGraphByNameRequest request = new GetGraphByNameRequest();
                request.name = graphName;
                request.namespaceId = namespace == null ? null : namespace.getNamespaceId();
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.GRAPH_BY_NAME.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Property> createProperty(SessionContext sessionContext, final PgxId graphId, final EntityType entityType, final PropertyType type, final int dimension, final String propertyName, final boolean hardName) {
        return this.request(new CoreRequest<Property>(sessionContext, (Marshaler)Marshalers.PROPERTY_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreatePropertyRequest createPropertyRequest = new CreatePropertyRequest();
                createPropertyRequest.entityType = entityType;
                createPropertyRequest.type = type;
                createPropertyRequest.dimension = dimension;
                createPropertyRequest.name = propertyName;
                createPropertyRequest.hardName = hardName;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)createPropertyRequest, LinkTemplate.PROPERTIES_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Self> createScalar(SessionContext sessionContext, final PgxId graphId, final PropertyType type, final int dimension, final String name) {
        return this.request(new CoreRequest<Self>(sessionContext, (Marshaler)Marshalers.SELF_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateScalarRequest createScalarRequest = new CreateScalarRequest();
                createScalarRequest.type = type;
                createScalarRequest.scalarName = name;
                createScalarRequest.dimension = dimension;
                createScalarRequest.graphId = graphId;
                return executor.post((UnsafeHttpMethodRequest)createScalarRequest, LinkTemplate.SCALARS_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Self> createScalar(SessionContext sessionContext, PgxId graphId, PropertyType type, String name) {
        return this.createScalar(sessionContext, graphId, type, 0, name);
    }

    public <V> PgxFuture<ScalarValue<V>> getScalarValue(SessionContext sessionContext, final String scalarName) {
        ValueMarshaler marshaler = new ValueMarshaler();
        return this.request(new CoreRequest<ScalarValue<V>>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-scalar-name", scalarName);
                return executor.get(headers, LinkTemplate.SCALAR_VALUE_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public <V> PgxFuture<Void> setScalarValue(SessionContext sessionContext, final String scalarName, final V value) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                SetScalarValueRequest setScalarRequest = new SetScalarValueRequest();
                ScalarValue scalarValue = value instanceof PgxVect ? new ScalarValue(value, null) : new ScalarValue(value, PropertyType.getTypeFor(value.getClass()));
                setScalarRequest.value = scalarValue;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-scalar-name", scalarName);
                return executor.put(headers, LinkTemplate.SCALAR_VALUE_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), (UnsafeHttpMethodRequest)setScalarRequest);
            }
        });
    }

    public PgxFuture<Void> destroyScalar(SessionContext sessionContext, final String scalarName) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-scalar-name", scalarName);
                return executor.delete(headers, LinkTemplate.SCALAR_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    @Deprecated
    public PgxFuture<Void> destroyScalar(SessionContext sessionContext, final String scalarName, final boolean ignoreNotFound) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-scalar-name", scalarName);
                return executor.delete(headers, LinkTemplate.SCALAR_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), Collections.singletonList(new BasicNameValuePair("ignoreNotFound", String.valueOf(ignoreNotFound))));
            }
        });
    }

    public PgxFuture<CollectionInfo> createCollection(SessionContext sessionContext, final PgxId graphId, final CollectionType type, final EntityType elementType, final String name) {
        return this.request(new CoreRequest<CollectionInfo>(sessionContext, (Marshaler)Marshalers.COLLECTION_INFO_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateCollectionRequest createCollectionRequest = new CreateCollectionRequest();
                createCollectionRequest.type = type;
                createCollectionRequest.elementType = elementType;
                createCollectionRequest.collectionName = name;
                createCollectionRequest.graphId = graphId;
                return executor.post((UnsafeHttpMethodRequest)createCollectionRequest, LinkTemplate.COLLECTIONS_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<CollectionInfo> createCollection(SessionContext sessionContext, final CollectionType type, final PropertyType contentType, final String name) {
        return this.request(new CoreRequest<CollectionInfo>(sessionContext, (Marshaler)Marshalers.COLLECTION_INFO_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateCollectionRequest createCollectionRequest = new CreateCollectionRequest();
                createCollectionRequest.type = type;
                createCollectionRequest.contentType = contentType;
                createCollectionRequest.elementType = contentType.toEntityType().orElse(null);
                createCollectionRequest.collectionName = name;
                createCollectionRequest.isScalarCollection = true;
                return executor.post((UnsafeHttpMethodRequest)createCollectionRequest, LinkTemplate.COLLECTIONS_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<CollectionInfo> createCollectionFromFilter(SessionContext sessionContext, final PgxId graphId, final CollectionType type, final GraphFilter filter, final String name) {
        return this.request(new CoreRequest<CollectionInfo>(sessionContext, (Marshaler)Marshalers.COLLECTION_INFO_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateCollectionRequest createCollectionRequest = new CreateCollectionRequest();
                createCollectionRequest.type = type;
                createCollectionRequest.filter = filter;
                createCollectionRequest.collectionName = name;
                createCollectionRequest.graphId = graphId;
                createCollectionRequest.fromFilter = true;
                return executor.post((UnsafeHttpMethodRequest)createCollectionRequest, LinkTemplate.COLLECTIONS_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Self> createMap(SessionContext sessionContext, final PgxId graphId, final PropertyType keyType, final PropertyType valType, final String mapName) {
        return this.request(new CoreRequest<Self>(sessionContext, (Marshaler)new GenericMarshaler(Self.class)){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateMapRequest createMapRequest = new CreateMapRequest();
                createMapRequest.keyType = keyType;
                createMapRequest.valType = valType;
                createMapRequest.mapName = mapName;
                createMapRequest.graphId = graphId;
                return executor.post((UnsafeHttpMethodRequest)createMapRequest, LinkTemplate.MAPS_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<MapInfo> createMap(SessionContext sessionContext, final PropertyType keyType, final PropertyType valType, final String mapName) {
        return this.request(new CoreRequest<MapInfo>(sessionContext, (Marshaler)Marshalers.MAP_INFO_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateMapRequest createMapRequest = new CreateMapRequest();
                createMapRequest.keyType = keyType;
                createMapRequest.valType = valType;
                createMapRequest.mapName = mapName;
                createMapRequest.isSessionMap = true;
                return executor.post((UnsafeHttpMethodRequest)createMapRequest, LinkTemplate.MAPS_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> extractTopKFromMap(SessionContext sessionContext, final String mapName, final PgxId colName, final int k) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ExtractTopKRequest extractTopKRequest = new ExtractTopKRequest();
                extractTopKRequest.collectionName = colName;
                extractTopKRequest.k = k;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-map-name", mapName);
                return executor.post(headers, (UnsafeHttpMethodRequest)extractTopKRequest, LinkTemplate.MAP_EXTRACT_TOPK.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<ComponentsProxy> getComponentsProxy(SessionContext sessionContext, final PgxId graphId, final PgxId propId, final long numComponents) {
        ComponentsProxyMarshaler marshaler = new ComponentsProxyMarshaler(sessionContext, this.componentsProxyFactory);
        return this.request(new CoreRequest<ComponentsProxy>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateComponentsProxyRequest request = new CreateComponentsProxyRequest();
                request.propId = propId;
                request.graphId = graphId;
                request.numComponents = numComponents;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.COMPONENTS_PROXIES_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public <T> PgxFuture<PropertyProxy<T>> getPropertyProxy(SessionContext sessionContext, final PgxId graphId, final PgxId propertyId, final EntityType entityType, final boolean labelFlag) {
        PropertyProxyMarshaler marshaler = new PropertyProxyMarshaler(sessionContext, this.centralityResultFactory, entityType != null ? entityType.toPropertyType() : null);
        return this.request(new CoreRequest<PropertyProxy<T>>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreatePropertyProxyRequest request = new CreatePropertyProxyRequest();
                if (entityType != null) {
                    request.entityType = entityType;
                }
                request.labelFlag = labelFlag;
                request.graphId = graphId;
                request.propertyId = propertyId;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.PROPERTY_PROXIES_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<PathProxy> getPathProxy(SessionContext sessionContext, final PgxId graphId, final Object src, final Object dst, final PgxId costId, final PgxId parentId, final PgxId parentEdgeId) {
        return this.request(new CoreRequest<PathProxy>(sessionContext, (Marshaler)Marshalers.PATH_PROXY_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                PathProxyRequest pathProxyRequest = new PathProxyRequest();
                pathProxyRequest.src = new IdTypedObject(src);
                pathProxyRequest.srcValWrapped = src instanceof Vertex;
                pathProxyRequest.dst = new IdTypedObject(dst);
                pathProxyRequest.dstValWrapped = dst instanceof Vertex;
                pathProxyRequest.costId = costId;
                pathProxyRequest.parentId = parentId;
                pathProxyRequest.parentEdgeId = parentEdgeId;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)pathProxyRequest, LinkTemplate.COMPUTE_PATH.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<PathProxy> getPathProxy(SessionContext sessionContext, final PgxId graphId, final PgxId nodeSeqName, final PgxId edgeSeqName) {
        return this.request(new CoreRequest<PathProxy>(sessionContext, (Marshaler)Marshalers.PATH_PROXY_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                PathProxyRequest pathProxyRequest = new PathProxyRequest();
                pathProxyRequest.nodeSeqName = nodeSeqName;
                pathProxyRequest.edgeSeqName = edgeSeqName;
                pathProxyRequest.fromSequence = true;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)pathProxyRequest, LinkTemplate.COMPUTE_PATH.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<AllPathsProxy> getAllPathsProxy(SessionContext sessionContext, final PgxId graphId, final Object src, final PgxId costId, final PgxId distId, final PgxId parentId, final PgxId parentEdgeId) {
        AllPathsProxyMarshaler marshaler = new AllPathsProxyMarshaler(sessionContext, this.allPathsProxyFactory);
        return this.request(new CoreRequest<AllPathsProxy>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                AllPathsProxyRequest pathProxyRequest = new AllPathsProxyRequest();
                pathProxyRequest.src = new IdTypedObject(src);
                pathProxyRequest.srcValWrapped = src instanceof Vertex;
                pathProxyRequest.costId = costId;
                pathProxyRequest.distId = distId;
                pathProxyRequest.parentId = parentId;
                pathProxyRequest.parentEdgeId = parentEdgeId;
                pathProxyRequest.graphId = graphId;
                return executor.post((UnsafeHttpMethodRequest)pathProxyRequest, LinkTemplate.ALLPATH_PROXIES_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<CollectionProxy> getCollectionProxy(SessionContext sessionContext, final PgxId collectionId) {
        CollectionProxyMarshaler marshaler = new CollectionProxyMarshaler(sessionContext, this.collectionProxyFactory);
        return this.request(new CoreRequest<CollectionProxy>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateCollectionProxyRequest request = new CreateCollectionProxyRequest();
                request.collectionName = collectionId;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.COLLECTION_PROXIES_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<CollectionProxy> getComponentCollectionProxy(SessionContext sessionContext, final PgxId collectionNamespace, final long id) {
        CollectionProxyMarshaler marshaler = new CollectionProxyMarshaler(sessionContext, this.collectionProxyFactory);
        return this.request(new CoreRequest<CollectionProxy>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateCollectionProxyRequest request = new CreateCollectionProxyRequest();
                request.isComponentCollection = true;
                request.collectionNamespace = collectionNamespace;
                request.id = id;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.COLLECTION_PROXIES_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<CollectionInfo> createCollectionFromComponent(SessionContext sessionContext, final PgxId namespace, final long id, final String newName) {
        return this.request(new CoreRequest<CollectionInfo>(sessionContext, (Marshaler)Marshalers.COLLECTION_INFO_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateCollectionRequest createCollectionRequest = new CreateCollectionRequest();
                createCollectionRequest.collectionName = newName;
                createCollectionRequest.fromComponent = true;
                createCollectionRequest.componentId = id;
                createCollectionRequest.componentStorageName = namespace;
                return executor.post((UnsafeHttpMethodRequest)createCollectionRequest, LinkTemplate.COLLECTIONS_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public <E> PgxFuture<Boolean> containsElement(SessionContext sessionContext, final PgxId collectionId, final E element) {
        return this.request(new CoreRequest<Boolean>(sessionContext, (Marshaler)Marshalers.BOOLEAN_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ContainsElementRequest containsElementRequest = new ContainsElementRequest();
                containsElementRequest.element = element;
                containsElementRequest.wrapped = element instanceof Entity;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-collection-name", collectionId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)containsElementRequest, LinkTemplate.COLLECTION_CONTAINS.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public <E> PgxFuture<Boolean> containsElementWrappedCollection(SessionContext sessionContext, final PgxId collectionNamespace, final long id, final E element) {
        return this.request(new CoreRequest<Boolean>(sessionContext, (Marshaler)Marshalers.BOOLEAN_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ContainsElementRequest containsElementRequest = new ContainsElementRequest();
                containsElementRequest.element = element;
                containsElementRequest.wrapped = element instanceof Entity;
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-component-storage-name", collectionNamespace.toString()).addHeader("x-id", String.valueOf(id)).build();
                return executor.post(headers, (UnsafeHttpMethodRequest)containsElementRequest, LinkTemplate.COMPONENT_CONTAINS.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Collection<CollectionInfo>> getCollections(SessionContext sessionContext, final PgxId graphId) {
        GenericCollectionMarshaler collectionInfoMarshaler = new GenericCollectionMarshaler(List.class, CollectionInfo.class);
        return this.request(new CoreRequest<Collection<CollectionInfo>>(sessionContext, (Marshaler)collectionInfoMarshaler){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                return executor.get(LinkTemplate.COLLECTIONS_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), "graphId", graphId.toString());
            }
        });
    }

    public PgxFuture<CollectionInfo> getCollection(SessionContext sessionContext, final PgxId collectionId) {
        return this.request(new CoreRequest<CollectionInfo>(sessionContext, (Marshaler)Marshalers.COLLECTION_INFO_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-collection-name", collectionId.toString());
                return executor.get(headers, LinkTemplate.COLLECTION_INFO_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> sortByDegree(SessionContext sessionContext, final PgxId graphId, final Collection<PgxId> nodePropIds, final Collection<PgxId> edgePropIds, final boolean ascending, final boolean useOutDegree, final boolean inPlace, final String newGraphName) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                SortByDegreeRequest sortByDegreeRequest = new SortByDegreeRequest();
                sortByDegreeRequest.nodePropIds = nodePropIds;
                sortByDegreeRequest.edgePropIds = edgePropIds;
                sortByDegreeRequest.ascending = ascending;
                sortByDegreeRequest.useOutDegree = useOutDegree;
                sortByDegreeRequest.inPlace = inPlace;
                sortByDegreeRequest.newGraphName = newGraphName;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)sortByDegreeRequest, LinkTemplate.SORT_BY_DEGREE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> createUndirectedGraph(SessionContext sessionContext, final PgxId graphId, final MutationStrategy mutationStrategy) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                MutateGraphRequest undirectGraphRequest = new MutateGraphRequest();
                undirectGraphRequest.initMutationStrategy(mutationStrategy);
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)undirectGraphRequest, LinkTemplate.UNDIRECT.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> createPartitionedGraph(SessionContext sessionContext, PgxId graphId, PartitionizingStrategy partitionizingStrategy) {
        String message = "Heterogeneizing graphs remotely is not currently supported";
        NotImplementedException exception = new NotImplementedException(message);
        PgxFuture breach = PgxFuture.exceptionallyCompletedFuture((Throwable)exception);
        return breach;
    }

    public PgxFuture<Graph> createTransposedGraph(SessionContext sessionContext, final PgxId graphId, final MutationStrategy mutationStrategy) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                MutateGraphRequest transposeGraphRequest = new MutateGraphRequest();
                transposeGraphRequest.initMutationStrategy(mutationStrategy);
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)transposeGraphRequest, LinkTemplate.TRANSPOSE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> simplifyGraph(SessionContext sessionContext, final PgxId graphId, final MutationStrategy mutationStrategy) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                MutateGraphRequest simplifyRequest = new MutateGraphRequest();
                simplifyRequest.initMutationStrategy(mutationStrategy);
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)simplifyRequest, LinkTemplate.SIMPLIFY.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> createBipartiteSubgraphFromLeftSet(SessionContext sessionContext, final PgxId graphId, final Collection<PgxId> nodePropIds, final Collection<PgxId> edgePropIds, final PgxId nodeSetName, final String newGraphName, final String isLeftPropName) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateBipartiteSubgraphRequest bipartiteGraphRequest = new CreateBipartiteSubgraphRequest();
                bipartiteGraphRequest.nodePropIds = nodePropIds;
                bipartiteGraphRequest.edgePropIds = edgePropIds;
                bipartiteGraphRequest.nodeSetName = nodeSetName;
                bipartiteGraphRequest.isLeftPropName = isLeftPropName;
                bipartiteGraphRequest.newGraphName = newGraphName;
                bipartiteGraphRequest.fromLeftSet = true;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)bipartiteGraphRequest, LinkTemplate.BIPARTITE_SUBGRAPHS.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> createBipartiteSubgraphFromInDegree(SessionContext sessionContext, final PgxId graphId, final Collection<PgxId> nodePropIds, final Collection<PgxId> edgePropIds, final String newGraphName, final String isLeftPropName, final boolean inPlace) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateBipartiteSubgraphRequest bipartiteGraphRequest = new CreateBipartiteSubgraphRequest();
                bipartiteGraphRequest.nodePropIds = nodePropIds;
                bipartiteGraphRequest.edgePropIds = edgePropIds;
                bipartiteGraphRequest.isLeftPropName = isLeftPropName;
                bipartiteGraphRequest.newGraphName = newGraphName;
                bipartiteGraphRequest.inPlace = inPlace;
                bipartiteGraphRequest.fromInDegree = true;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)bipartiteGraphRequest, LinkTemplate.BIPARTITE_SUBGRAPHS.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> createSubgraphFromFilter(SessionContext sessionContext, final PgxId graphId, final Collection<PgxId> nodePropIds, final Collection<PgxId> edgePropIds, final GraphFilter graphFilter, final String newGraphName) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateSubgraphFromFilterRequest subgraphRequest = new CreateSubgraphFromFilterRequest();
                subgraphRequest.nodePropIds = nodePropIds;
                subgraphRequest.edgePropIds = edgePropIds;
                subgraphRequest.graphFilter = graphFilter;
                subgraphRequest.newGraphName = newGraphName;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)subgraphRequest, LinkTemplate.FROM_FILTER_SUBGRAPHS.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> cloneGraph(SessionContext sessionContext, final PgxId graphId, final Collection<PgxId> nodePropIds, final Collection<PgxId> edgePropIds, final String newGraphName) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                MutateRequest cloneRequest = new MutateRequest();
                cloneRequest.nodePropIds = nodePropIds;
                cloneRequest.edgePropIds = edgePropIds;
                cloneRequest.newGraphName = newGraphName;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)cloneRequest, LinkTemplate.CLONE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Object> getRandomEntity(SessionContext sessionContext, final PgxId graphId, final EntityType entityType) {
        GenericMarshaler marshaler = entityType == EntityType.EDGE ? new GenericMarshaler(Edge.class) : new GenericMarshaler(Vertex.class);
        return this.request(new CoreRequest<Object>(sessionContext, (Marshaler)marshaler){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>();
                queryParams.add((NameValuePair)new BasicNameValuePair("entityType", entityType.name()));
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.get(headers, LinkTemplate.RANDOM_ENTITY.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), queryParams);
            }
        });
    }

    private PgxFuture<Long> getEdgeCount(SessionContext sessionContext, PgxId graphId, final Object node, final Direction direction, final List<NameValuePair> headers, final String url, final IdType vertexIdType) {
        LongMarshaler marshaler = new LongMarshaler();
        return this.request(new CoreRequest<Long>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>();
                queryParams.add((NameValuePair)new BasicNameValuePair("direction", direction.toString()));
                queryParams.add((NameValuePair)new BasicNameValuePair("idType", vertexIdType.name()));
                queryParams.add((NameValuePair)new BasicNameValuePair("wrapped", Boolean.toString(node instanceof Vertex)));
                return executor.get(headers, url, queryParams);
            }
        });
    }

    public PgxFuture<Either<Collection<Vertex>, Iterable<Object>>> getNeighbors(SessionContext sessionContext, final PgxId graphId, final Object node, final Direction direction, final IdType vertexIdType) {
        GenericCollectionMarshaler genericMarshaler = new GenericCollectionMarshaler(List.class, Vertex.class);
        return this.request(new CoreRequest<Collection<Vertex>>(sessionContext, (Marshaler)genericMarshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>();
                queryParams.add((NameValuePair)new BasicNameValuePair("direction", direction.toString()));
                queryParams.add((NameValuePair)new BasicNameValuePair("idType", vertexIdType.name()));
                queryParams.add((NameValuePair)new BasicNameValuePair("wrapped", Boolean.toString(node instanceof Vertex)));
                String entityOrIdString = node instanceof Vertex ? JsonUtil.toJson((Object)node) : String.valueOf(node);
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).addHeader("x-vertex-id", entityOrIdString).build();
                return executor.get(headers, LinkTemplate.VERTEX_NEIGHBORS.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), queryParams);
            }
        }).thenApply(Either::left);
    }

    public PgxFuture<Either<Collection<Edge>, PrimitiveIterator.OfLong>> getEdges(SessionContext sessionContext, final PgxId graphId, final Object node, final Direction direction) {
        GenericCollectionMarshaler genericMarshaler = new GenericCollectionMarshaler(List.class, Edge.class);
        return this.request(new CoreRequest<Collection<Edge>>(sessionContext, (Marshaler)genericMarshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>();
                queryParams.add((NameValuePair)new BasicNameValuePair("direction", direction.toString()));
                queryParams.add((NameValuePair)new BasicNameValuePair("idType", IdType.LONG.name()));
                queryParams.add((NameValuePair)new BasicNameValuePair("wrapped", Boolean.toString(node instanceof Vertex)));
                String entityOrIdString = node instanceof Vertex ? JsonUtil.toJson((Object)node) : String.valueOf(node);
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).addHeader("x-vertex-id", entityOrIdString).build();
                return executor.get(headers, LinkTemplate.CONNECTED_EDGES.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), queryParams);
            }
        }).thenApply(Either::left);
    }

    public PgxFuture<Long> getEdgeCount(SessionContext sessionContext, PgxId graphId, Object node, Direction direction) {
        List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).addHeader("x-vertex-id", node.toString()).build();
        return this.getEdgeCount(sessionContext, graphId, node, direction, headers, LinkTemplate.EDGE_COUNT.generateUrl(this.baseUri, new Object[0]), IdType.LONG);
    }

    public <V> PgxFuture<V> getEntityFromTable(SessionContext sessionContext, PgxId graphId, String tableName, EntityType entityType, IdType idType, Object key) {
        HeaderBuilder headerBuilder = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).addHeader("x-table-name", tableName);
        switch (entityType) {
            case VERTEX: {
                String url = LinkTemplate.VERTEX_IN_TABLE_SELF.generateUrl(this.baseUri, new Object[0]);
                headerBuilder.addHeader((NameValuePair)new BasicNameValuePair("x-vertex-id", String.valueOf(key)));
                return this.getVertex(sessionContext, headerBuilder.build(), url, idType);
            }
            case EDGE: {
                String edgeUrl = LinkTemplate.EDGE_IN_TABLE_SELF.generateUrl(this.baseUri, new Object[0]);
                headerBuilder.addHeader((NameValuePair)new BasicNameValuePair("x-edge-id", String.valueOf(key)));
                return this.getEdge(sessionContext, headerBuilder.build(), edgeUrl, idType);
            }
        }
        throw new IllegalEnumConstantException((Enum)entityType);
    }

    public <V> PgxFuture<V> getEntity(SessionContext sessionContext, PgxId graphId, EntityType entityType, IdType idType, Object id) {
        HeaderBuilder headerBuilder = new HeaderBuilder().addHeader("x-graph-id", graphId.toString());
        switch (entityType) {
            case VERTEX: {
                String vertexUrl = LinkTemplate.VERTEX_SELF.generateUrl(this.baseUri, new Object[0]);
                headerBuilder.addHeader("x-vertex-id", String.valueOf(id));
                return this.getVertex(sessionContext, headerBuilder.build(), vertexUrl, idType);
            }
            case EDGE: {
                String edgeUrl = LinkTemplate.EDGE_SELF.generateUrl(this.baseUri, new Object[0]);
                headerBuilder.addHeader("x-edge-id", String.valueOf(id));
                return this.getEdge(sessionContext, headerBuilder.build(), edgeUrl, idType);
            }
        }
        throw new IllegalEnumConstantException((Enum)entityType);
    }

    private PgxFuture<Vertex> getVertex(SessionContext sessionContext, final List<NameValuePair> headers, final String url, final IdType idType) {
        return this.request(new CoreRequest<Vertex>(sessionContext, (Marshaler)Marshalers.VERTEX_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                if (idType == null) {
                    throw new IllegalStateException(ErrorMessages.getMessage((String)"GRAPH_MISSING_VERTEX_IDS", (Object[])new Object[0]));
                }
                return executor.get(headers, url, "idType", idType.toKey().toUpperCase());
            }
        });
    }

    private PgxFuture<Edge> getEdge(SessionContext sessionContext, final List<NameValuePair> headers, final String url, final IdType idType) {
        return this.request(new CoreRequest<Edge>(sessionContext, (Marshaler)Marshalers.EDGE_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                return executor.get(headers, url, "idType", idType.toKey().toUpperCase());
            }
        });
    }

    public PgxFuture<Boolean> exists(SessionContext sessionContext, final PgxId graphId, final EntityType entityType, final IdType idType, final Object id) {
        return this.request(new CoreRequest<Boolean>(sessionContext, (Marshaler)Marshalers.BOOLEAN_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>();
                queryParams.add((NameValuePair)new BasicNameValuePair("entityType", entityType.name()));
                queryParams.add((NameValuePair)new BasicNameValuePair("idType", idType.name()));
                queryParams.add((NameValuePair)new BasicNameValuePair("key", id.toString()));
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).build();
                return executor.get(headers, LinkTemplate.EXISTS.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), queryParams);
            }
        });
    }

    public PgxFuture<PropertyValue> getPropertyValue(SessionContext sessionContext, final PgxId graphId, final PgxId propertyId, final EntityType entityType, final Object key) {
        ValueMarshaler marshaler = new ValueMarshaler();
        return this.request(new CoreRequest<PropertyValue>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>();
                queryParams.add((NameValuePair)new BasicNameValuePair("entityType", entityType.name()));
                boolean isKeyWrapped = key instanceof Entity;
                queryParams.add((NameValuePair)new BasicNameValuePair("keyWrapped", Boolean.toString(isKeyWrapped)));
                queryParams.add((NameValuePair)new BasicNameValuePair("idType", IdTypeUtils.getElementIdType((Object)key).name()));
                String entityOrIdString = isKeyWrapped ? JsonUtil.toJson((Object)key) : String.valueOf(key);
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).addHeader("x-property-name", propertyId.toString()).addHeader("x-property-key", entityOrIdString).build();
                return executor.get(headers, LinkTemplate.PROPERTY_VALUE_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), queryParams);
            }
        });
    }

    public PgxFuture<CompilationResult> createAnalysis(SessionContext sessionContext, final String code, final boolean parallel, final List<GmCompilerOptimization> disabledOptimizations, final boolean verbose, final boolean overwrite) {
        return this.request(new CoreRequest<CompilationResult>(sessionContext, (Marshaler)Marshalers.COMPILATION_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateAnalysisRequest analysisRequest = new CreateAnalysisRequest();
                analysisRequest.code = code;
                analysisRequest.parallel = parallel;
                analysisRequest.disabledOptimizations = disabledOptimizations;
                analysisRequest.verbose = verbose;
                analysisRequest.overwrite = overwrite;
                return executor.post((UnsafeHttpMethodRequest)analysisRequest, LinkTemplate.COMPILE_PROGRAM.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Set<String>> getAvailableAnalysisIds(SessionContext sessionContext) {
        return this.request(new CoreRequest<Set<String>>(sessionContext, (Marshaler)Marshalers.STRING_SET_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                return executor.get(LinkTemplate.ANALYSES_IDS_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Collection<CompiledProgramMetaData>> getAvailableAnalyses(SessionContext sessionContext) {
        GenericCollectionMarshaler marshaler = new GenericCollectionMarshaler(List.class, CompiledProgramMetaData.class);
        return this.request(new CoreRequest<Collection<CompiledProgramMetaData>>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                return executor.get(LinkTemplate.ANALYSES_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<CompiledProgramMetaData> getAnalysisMetaData(SessionContext sessionContext, final String analysisId) {
        return this.request(new CoreRequest<CompiledProgramMetaData>(sessionContext, (Marshaler)Marshalers.COMPILED_PROGRAM_META_DATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-aid", analysisId);
                return executor.get(headers, LinkTemplate.ANALYSIS_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> destroyAnalysis(SessionContext sessionContext, final String analysisName) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-aid", analysisName);
                return executor.delete(headers, LinkTemplate.ANALYSIS_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    @Deprecated
    public PgxFuture<Void> destroyAnalysis(SessionContext sessionContext, final String analysisName, final boolean ignoreNotFound) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-aid", analysisName);
                return executor.delete(headers, LinkTemplate.ANALYSIS_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), "ignoreNotFound", String.valueOf(ignoreNotFound));
            }
        });
    }

    public <T> PgxFuture<AnalysisResult<T>> runAnalysis(SessionContext sessionContext, final String analysisId, final Argument[] args, final Class<T> expectedReturnType, final WorkloadCharacteristicSet additionalWorkloadCharacteristics) {
        InvocationResultMarshaler marshaler = new InvocationResultMarshaler(expectedReturnType);
        return this.request(new CoreRequest<AnalysisResult<T>>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                RunAnalysisRequest analysisRequest = new RunAnalysisRequest();
                analysisRequest.args = args;
                analysisRequest.workloadCharacteristics = additionalWorkloadCharacteristics;
                analysisRequest.expectedReturnType = ReturnType.getTypeFor((Class)expectedReturnType);
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-aid", analysisId);
                return executor.post(headers, (UnsafeHttpMethodRequest)analysisRequest, LinkTemplate.ANALYSIS_RUN.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> destroyGraphWithProperties(SessionContext sessionContext, final PgxId graphId) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.delete(headers, LinkTemplate.GRAPH_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    @Deprecated
    public PgxFuture<Void> destroyGraphWithProperties(SessionContext sessionContext, final PgxId graphId, final boolean ignoreNotFound, final PgxGraph.Retention retention) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add((NameValuePair)new BasicNameValuePair("ignoreNotFound", String.valueOf(ignoreNotFound)));
                params.add((NameValuePair)new BasicNameValuePair("retention", String.valueOf(retention)));
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.delete(headers, LinkTemplate.GRAPH_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), params);
            }
        });
    }

    public PgxFuture<Void> destroyProperty(SessionContext sessionContext, final PgxId graphId, final PgxId propertyId, final EntityType entityType) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
                if (entityType != null) {
                    params.add((NameValuePair)new BasicNameValuePair("entityType", entityType.name()));
                }
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).addHeader("x-property-name", propertyId.toString()).build();
                return executor.delete(headers, LinkTemplate.PROPERTY_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), params);
            }
        });
    }

    @Deprecated
    public PgxFuture<Void> destroyProperty(SessionContext sessionContext, final PgxId graphId, final PgxId propertyId, final EntityType entityType, final boolean ignoreNotFound) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
                if (entityType != null) {
                    params.add((NameValuePair)new BasicNameValuePair("entityType", entityType.name()));
                }
                params.add((NameValuePair)new BasicNameValuePair("ignoreNotFound", String.valueOf(ignoreNotFound)));
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).addHeader("x-property-name", propertyId.toString()).build();
                return executor.delete(headers, LinkTemplate.PROPERTY_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), params);
            }
        });
    }

    public PgxFuture<Void> destroyCollection(SessionContext sessionContext, final PgxId collectionId) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-collection-name", collectionId.toString());
                return executor.delete(headers, LinkTemplate.COLLECTION_INFO_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    @Deprecated
    public PgxFuture<Void> destroyCollection(SessionContext sessionContext, final PgxId collectionId, final boolean ignoreNotFound) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-collection-name", collectionId.toString());
                return executor.delete(headers, LinkTemplate.COLLECTION_INFO_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), "ignoreNotFound", String.valueOf(ignoreNotFound));
            }
        });
    }

    public PgxFuture<Void> destroyWrappedCollection(SessionContext sessionContext, final PgxId collectionNamespace) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-component-storage-name", collectionNamespace.toString());
                return executor.delete(headers, LinkTemplate.COMPONENT_STORAGE_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    @Deprecated
    public PgxFuture<Void> destroyWrappedCollection(SessionContext sessionContext, final PgxId collectionNamespace, final boolean ignoreNotFound) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-component-storage-name", collectionNamespace.toString());
                return executor.delete(headers, LinkTemplate.COMPONENT_STORAGE_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), "ignoreNotFound", String.valueOf(ignoreNotFound));
            }
        });
    }

    public PgxFuture<Void> destroyMap(SessionContext sessionContext, final String mapName) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-map-name", mapName);
                return executor.delete(headers, LinkTemplate.MAP_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    @Deprecated
    public PgxFuture<Void> destroyMap(SessionContext sessionContext, final String mapName, final boolean ignoreNotFound) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-map-name", mapName);
                return executor.delete(headers, LinkTemplate.MAP_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), "ignoreNotFound", String.valueOf(ignoreNotFound));
            }
        });
    }

    public synchronized PgxFuture<Void> storeGraphWithProperties(final SessionContext sessionContext, final PgxId graphId, final GraphConfig targetConfig, final Set<String> vertexProvidersToStore, final Set<String> edgeProvidersToStore, final boolean overwrite) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                String sessionId = sessionContext.getSessionId();
                StoreGraphRequest storeGraphRequest = new StoreGraphRequest();
                storeGraphRequest.graphConfig = GraphConfigContainer.createObfuscated((GraphConfig)targetConfig, (String)sessionId);
                storeGraphRequest.vertexProvidersToStore = vertexProvidersToStore;
                storeGraphRequest.edgeProvidersToStore = edgeProvidersToStore;
                storeGraphRequest.overwrite = overwrite;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)storeGraphRequest, LinkTemplate.STORE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Property> cloneProperty(SessionContext sessionContext, final PgxId graphId, final PgxId propertyId, final EntityType entityType, final String name) {
        return this.request(new CoreRequest<Property>(sessionContext, (Marshaler)Marshalers.PROPERTY_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                MovePropertyRequest movePropertyRequest = new MovePropertyRequest();
                movePropertyRequest.entityType = entityType;
                movePropertyRequest.newName = name;
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).addHeader("x-property-name", propertyId.toString()).build();
                return executor.post(headers, (UnsafeHttpMethodRequest)movePropertyRequest, LinkTemplate.PROPERTY_CLONE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> renameProperty(SessionContext sessionContext, final PgxId graphId, final PgxId propertyId, final EntityType entityType, final String newName) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                MovePropertyRequest movePropertyRequest = new MovePropertyRequest();
                movePropertyRequest.entityType = entityType;
                movePropertyRequest.newName = newName;
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).addHeader("x-property-name", propertyId.toString()).build();
                return executor.put(headers, LinkTemplate.PROPERTY_NAME.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), (UnsafeHttpMethodRequest)movePropertyRequest);
            }
        });
    }

    public <V> PgxFuture<Void> fillProperty(SessionContext sessionContext, final PgxId graphId, final PgxId propertyId, final V value, final EntityType entityType) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                FillPropertyRequest fillPropertyRequest = new FillPropertyRequest();
                fillPropertyRequest.entityType = entityType;
                fillPropertyRequest.value = PropertyValue.wrap(null, (Object)value);
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).addHeader("x-property-name", propertyId.toString()).build();
                return executor.put(headers, LinkTemplate.PROPERTY_FILL.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), (UnsafeHttpMethodRequest)fillPropertyRequest);
            }
        });
    }

    public PgxFuture<List<Property>> expand(SessionContext sessionContext, final PgxId graphId, final PgxId propertyId, final EntityType entityType, final String namePrefix) {
        return this.request(new CoreRequest<List<Property>>(sessionContext, (Marshaler)Marshalers.PROPERTY_LIST_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ExpandPropertyRequest expandRequest = new ExpandPropertyRequest();
                expandRequest.entityType = entityType;
                expandRequest.namePrefix = namePrefix;
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).addHeader("x-property-name", propertyId.toString()).build();
                return executor.post(headers, (UnsafeHttpMethodRequest)expandRequest, LinkTemplate.PROPERTY_EXPAND.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Property> combine(SessionContext sessionContext, final PgxId graphId, final EntityType type, final List<PgxId> propertyIds, final String name) {
        return this.request(new CoreRequest<Property>(sessionContext, (Marshaler)Marshalers.PROPERTY_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CombinePropertyRequest combineRequest = new CombinePropertyRequest();
                combineRequest.entityType = type;
                combineRequest.name = name;
                combineRequest.propertyIds = propertyIds;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)combineRequest, LinkTemplate.COMBINE_PROPERTIES.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public <V> PgxFuture<Void> setProperty(SessionContext sessionContext, PgxId graphId, PgxId propertyId, EntityType entityType, Map<Object, V> givenValues, V defaultVal) {
        Map values = givenValues == null ? Collections.emptyMap() : givenValues;
        int uploadBatchSize = this.context.getConfig().getUploadBatchSize();
        if (values.size() <= uploadBatchSize) {
            return this.uploadPropertyBatch(sessionContext, graphId, propertyId, values, entityType, defaultVal);
        }
        return this.asyncRequest(() -> {
            if (defaultVal != null) {
                this.fillProperty(sessionContext, graphId, propertyId, defaultVal, entityType).get();
            }
            Iterator it = values.entrySet().iterator();
            HashMap chunk = new HashMap(uploadBatchSize);
            while (it.hasNext()) {
                while (it.hasNext() && chunk.size() <= uploadBatchSize) {
                    Map.Entry entry = it.next();
                    chunk.put(entry.getKey(), entry.getValue());
                }
                this.uploadPropertyBatch(sessionContext, graphId, propertyId, chunk, entityType, null).get();
                chunk.clear();
            }
            return null;
        });
    }

    private <V> PgxFuture<Void> uploadPropertyBatch(SessionContext sessionContext, final PgxId graphId, final PgxId propertyId, final Map<Object, V> values, final EntityType entityType, final V defaultVal) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                PropertyValuesPatchRequest request = new PropertyValuesPatchRequest();
                request.entityType = entityType;
                ArrayList items = new ArrayList();
                values.forEach((key, value) -> items.add(PropertyValue.wrap((Object)key, (Object)value)));
                request.defaultValue = PropertyValue.wrap(null, (Object)defaultVal);
                request.items = items;
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).addHeader("x-property-name", propertyId.toString()).build();
                return executor.patch(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.PROPERTY_VALUES.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public <E> PgxFuture<PgxId> addAllToCollection(SessionContext sessionContext, PgxId collectionId, Collection<E> source) {
        return this.modifyCollection(sessionContext, collectionId, source, false);
    }

    public <E> PgxFuture<PgxId> removeAllFromCollection(SessionContext sessionContext, PgxId collectionId, Collection<E> source) {
        return this.modifyCollection(sessionContext, collectionId, source, true);
    }

    private PgxFuture<PgxId> modifyCollection(SessionContext sessionContext, PgxId colName, Collection<?> givenSource, boolean remove) {
        String url = LinkTemplate.COLLECTION_ELEMENTS.generateUrl(this.baseUri, new Object[0]);
        Collection<Object> source = givenSource == null ? Collections.emptyList() : givenSource;
        int uploadBatchSize = this.context.getConfig().getUploadBatchSize();
        if (source.size() <= uploadBatchSize) {
            return this.uploadModifyCollectionBatch(url, sessionContext, colName, source, remove);
        }
        return this.asyncRequest(() -> {
            Iterator sourceIterator = source.iterator();
            ArrayList sourceList = new ArrayList(uploadBatchSize);
            PgxId lastResult = null;
            while (sourceIterator.hasNext()) {
                while (sourceList.size() <= uploadBatchSize && sourceIterator.hasNext()) {
                    Object item = sourceIterator.next();
                    sourceList.add(item);
                }
                lastResult = (PgxId)this.uploadModifyCollectionBatch(url, sessionContext, colName, sourceList, remove).get();
                sourceList.clear();
            }
            return lastResult;
        });
    }

    private PgxFuture<PgxId> uploadModifyCollectionBatch(String url, SessionContext sessionContext, final PgxId colName, final Collection<?> items, final boolean remove) {
        return this.request(new CoreRequest<PgxId>(sessionContext, (Marshaler)Marshalers.PGX_ID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ModifyCollectionRequest request = new ModifyCollectionRequest();
                request.values = JsonUtil.toJson((Object)items);
                PropertyType valueType = null;
                if (items.size() > 0) {
                    Object firstElement = items.iterator().next();
                    valueType = PropertyTypeUtils.getElementPropertyType(firstElement);
                }
                request.valueType = valueType;
                request.remove = remove;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-collection-name", colName.toString());
                String fullUrl = LinkTemplate.COLLECTION_ELEMENTS.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]);
                return executor.patch(headers, (UnsafeHttpMethodRequest)request, fullUrl);
            }
        });
    }

    public PgxFuture<PgxId> clearCollection(SessionContext sessionContext, final PgxId collectionId) {
        return this.request(new CoreRequest<PgxId>(sessionContext, (Marshaler)Marshalers.PGX_ID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-collection-name", collectionId.toString());
                return executor.delete(headers, LinkTemplate.COLLECTION_ELEMENTS.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<CollectionInfo> cloneCollection(SessionContext sessionContext, final PgxId collectionId, final String newName) {
        return this.request(new CoreRequest<CollectionInfo>(sessionContext, (Marshaler)Marshalers.COLLECTION_INFO_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CloneCollectionRequest collectionRequest = new CloneCollectionRequest();
                collectionRequest.newCollectionName = newName;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-collection-name", collectionId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)collectionRequest, LinkTemplate.COLLECTION_CLONE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<CollectionInfo> toMutableCollection(SessionContext sessionContext, final PgxId collectionId, final String newName) {
        return this.request(new CoreRequest<CollectionInfo>(sessionContext, (Marshaler)Marshalers.COLLECTION_INFO_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CloneCollectionRequest collectionRequest = new CloneCollectionRequest();
                collectionRequest.newCollectionName = newName;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-collection-name", collectionId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)collectionRequest, LinkTemplate.COLLECTION_TO_MUTABLE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Boolean> isCollectionMutable(SessionContext sessionContext, final PgxId collectionId) {
        return this.request(new CoreRequest<Boolean>(sessionContext, (Marshaler)Marshalers.BOOLEAN_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-collection-name", collectionId.toString());
                return executor.get(headers, LinkTemplate.COLLECTION_IS_MUTABLE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public <K, V> PgxFuture<MapProxy<K, V>> getMapProxy(SessionContext sessionContext, final String mapName) {
        MapProxyMarshaler marshaler = new MapProxyMarshaler(sessionContext, this.mapProxyFactory);
        return this.request(new CoreRequest<MapProxy<K, V>>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateMapProxyRequest request = new CreateMapProxyRequest();
                request.mapName = mapName;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.MAP_PROXIES_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> createSparsifiedSubgraph(SessionContext sessionContext, final PgxId graphId, final Collection<PgxId> nodePropIds, final Collection<PgxId> edgePropIds, final double e, final String newGraphName) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreateSparsifiedSubgraphRequest subgraphRequest = new CreateSparsifiedSubgraphRequest();
                subgraphRequest.nodePropIds = nodePropIds;
                subgraphRequest.edgePropIds = edgePropIds;
                subgraphRequest.newGraphName = newGraphName;
                subgraphRequest.e = e;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)subgraphRequest, LinkTemplate.SPARSIFIED_SUBGRAPHS.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Boolean> removeMapEntry(SessionContext sessionContext, final String mapName, final Object key) {
        return this.request(new CoreRequest<Boolean>(sessionContext, (Marshaler)Marshalers.BOOLEAN_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                PropertyType keyType = PropertyTypeUtils.getElementPropertyType((Object)key);
                TypedObject mapEntryKey = new TypedObject((Object)keyType, JsonUtil.toJson((Object)key));
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-map-name", mapName);
                return executor.patch(headers, (UnsafeHttpMethodRequest)mapEntryKey, LinkTemplate.MAP_ENTRIES.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Object> setMapEntry(SessionContext sessionContext, final String mapName, final Object key, final Object value) {
        PropertyTypedObjectMarshaler marshaler = new PropertyTypedObjectMarshaler();
        return this.request(new CoreRequest(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-map-name", mapName).addHeader("x-map-key", String.valueOf(key)).build();
                PropertyType keyType = PropertyTypeUtils.getElementPropertyType((Object)key);
                PropertyType valueType = PropertyTypeUtils.getElementPropertyType((Object)value);
                TypedMapEntry typedMapEntry = new TypedMapEntry(key, value, keyType, valueType);
                return executor.put(headers, LinkTemplate.MAP_ENTRY_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), (UnsafeHttpMethodRequest)typedMapEntry);
            }
        });
    }

    public PgxFuture<PgqlResultSetProxy> queryPgql(SessionContext sessionContext, PgxId graphId, String pgqlString) {
        return this.queryPgql(sessionContext, graphId, pgqlString, Collections.emptyList());
    }

    public PgxFuture<PgqlResultSetProxy> queryPgql(SessionContext sessionContext, final PgxId graphId, final String pgqlString, List<PgqlOption> pgqlOptions) {
        final List finalPgqlOptions = PgqlOption.getClientPgqlOptionsWithDefaults(pgqlOptions);
        PgqlResultSetMarshaler marshaler = new PgqlResultSetMarshaler(sessionContext, this.pgqlResultSetFactory);
        return this.request(new CoreRequest<PgqlResultSetProxy>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                PgqlQueryRequest req = new PgqlQueryRequest();
                req.pgqlQuery = pgqlString;
                req.graphId = graphId;
                RemoteCoreImpl.setPgqlRequestAccordingToQueryOptions(req, finalPgqlOptions);
                return executor.post((UnsafeHttpMethodRequest)req, LinkTemplate.PGQL_RUN.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<PgqlResultSetProxy> queryPgql(SessionContext sessionContext, String pgqlString) {
        return this.queryPgql(sessionContext, pgqlString, null);
    }

    public PgxFuture<PgqlResultSetProxy> queryPgql(SessionContext sessionContext, final String pgqlString, List<PgqlOption> pgqlOptions) {
        final List finalPgqlOptions = PgqlOption.getClientPgqlOptionsWithDefaults(pgqlOptions);
        PgqlResultSetMarshaler marshaler = new PgqlResultSetMarshaler(sessionContext, this.pgqlResultSetFactory);
        return this.request(new CoreRequest<PgqlResultSetProxy>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                PgqlQueryRequest req = new PgqlQueryRequest();
                req.pgqlQuery = pgqlString;
                RemoteCoreImpl.setPgqlRequestAccordingToQueryOptions(req, finalPgqlOptions);
                return executor.post((UnsafeHttpMethodRequest)req, LinkTemplate.PGQL_RUN.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<PgqlResultSetProxy> executePgql(SessionContext sessionContext, final PgxId graphId, final String pgqlString, List<PgqlOption> pgqlOptions) {
        final List finalPgqlOptions = PgqlOption.getClientPgqlOptionsWithDefaults(pgqlOptions);
        PgqlResultSetMarshaler marshaler = new PgqlResultSetMarshaler(sessionContext, this.pgqlResultSetFactory);
        return this.request(new CoreRequest<PgqlResultSetProxy>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                PgqlQueryRequest req = new PgqlQueryRequest();
                req.pgqlQuery = pgqlString;
                req.graphId = graphId;
                RemoteCoreImpl.setPgqlRequestAccordingToQueryOptions(req, finalPgqlOptions);
                return executor.post((UnsafeHttpMethodRequest)req, LinkTemplate.PGQL_EXECUTE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> cloneAndExecutePgql(SessionContext sessionContext, final PgxId graphId, final String pgqlString, final String newGraphName, List<PgqlOption> pgqlOptions) {
        final List finalPgqlOptions = PgqlOption.getClientPgqlOptionsWithDefaults(pgqlOptions);
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                PgqlCloneAndExecuteRequest req = new PgqlCloneAndExecuteRequest();
                req.pgqlQuery = pgqlString;
                req.newGraphName = newGraphName;
                req.graphId = graphId;
                RemoteCoreImpl.setPgqlRequestAccordingToQueryOptions((PgqlQueryRequest)req, finalPgqlOptions);
                return executor.post((UnsafeHttpMethodRequest)req, LinkTemplate.PGQL_CLONE_AND_EXECUTE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> cloneAndExecutePgql(SessionContext sessionContext, PgxId graphId, String pgqlString, List<PgqlOption> pgqlOptions) {
        return this.cloneAndExecutePgql(sessionContext, graphId, pgqlString, null, pgqlOptions);
    }

    private static void setPgqlRequestAccordingToQueryOptions(PgqlQueryRequest req, List<PgqlOption> finalPgqlOptions) {
        for (PgqlOption pgqlOption : finalPgqlOptions) {
            if (pgqlOption instanceof PgqlOption.PgqlSchemaStrictnessOption) {
                PgqlOption.PgqlSchemaStrictnessOption schemaStrictnessOption = (PgqlOption.PgqlSchemaStrictnessOption)pgqlOption;
                req.schemaStrictnessMode = schemaStrictnessOption.isStrictSchemaMode();
                continue;
            }
            if (pgqlOption instanceof PgqlOption.PgqlLazyResultSetEvaluationOption) {
                PgqlOption.PgqlLazyResultSetEvaluationOption lazyResultSetEvaluationOption = (PgqlOption.PgqlLazyResultSetEvaluationOption)pgqlOption;
                req.lazyEvaluationMode = lazyResultSetEvaluationOption.isLazyEvaluationMode();
                continue;
            }
            throw new IllegalStateException("Unknown PGQL option passed: " + pgqlOption);
        }
        if (req.schemaStrictnessMode == null) {
            req.schemaStrictnessMode = true;
        }
        if (req.lazyEvaluationMode == null) {
            req.lazyEvaluationMode = false;
        }
    }

    public PgxFuture<PreparedStatementProxy> preparePgql(SessionContext sessionContext, final PgxId graphId, final String pgqlString) {
        PreparedStatementMarshaler marshaler = new PreparedStatementMarshaler(sessionContext, this.preparedStatementProxyFactory);
        return this.request(new CoreRequest<PreparedStatementProxy>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                PrepareStatementRequest request = new PrepareStatementRequest();
                request.queryWithBindVariables = pgqlString;
                request.graphId = graphId;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.PGQL_PREPARE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<PreparedStatementProxy> preparePgql(SessionContext sessionContext, final String pgqlString) {
        PreparedStatementMarshaler marshaler = new PreparedStatementMarshaler(sessionContext, this.preparedStatementProxyFactory);
        return this.request(new CoreRequest<PreparedStatementProxy>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                PrepareStatementRequest request = new PrepareStatementRequest();
                request.queryWithBindVariables = pgqlString;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.PGQL_PREPARE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<PgqlResultSetProxy> executePreparedStatement(SessionContext sessionContext, final PgxId graphId, final String preparedStatementId, final BindValue[] bindValues) {
        PgqlResultSetMarshaler marshaler = new PgqlResultSetMarshaler(sessionContext, this.pgqlResultSetFactory);
        return this.request(new CoreRequest<PgqlResultSetProxy>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ExecutePreparedStatementRequest req = new ExecutePreparedStatementRequest();
                req.bindValues = (BindValueImpl[])bindValues;
                req.graphId = graphId;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-ps-id", preparedStatementId);
                return executor.post(headers, (UnsafeHttpMethodRequest)req, LinkTemplate.PGQL_PREPARED_STATEMENT_EXECUTE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<PgqlResultSetProxy> executeAnyPreparedStatement(SessionContext sessionContext, final PgxId graphId, final String preparedStatementId, final BindValue[] bindValues) {
        PgqlResultSetMarshaler marshaler = new PgqlResultSetMarshaler(sessionContext, this.pgqlResultSetFactory);
        return this.request(new CoreRequest<PgqlResultSetProxy>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ExecutePreparedStatementRequest req = new ExecutePreparedStatementRequest();
                req.bindValues = (BindValueImpl[])bindValues;
                req.graphId = graphId;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-ps-id", preparedStatementId);
                return executor.post(headers, (UnsafeHttpMethodRequest)req, LinkTemplate.PGQL_PREPARED_STATEMENT_EXECUTE_ANY.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Operation> explainPgql(SessionContext sessionContext, final PgxId graphId, final String pgqlString) {
        PgqlExplainMarshaler marshaler = new PgqlExplainMarshaler();
        return this.request(new CoreRequest<Operation>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                PgqlExplainRequest req = new PgqlExplainRequest();
                req.pgqlQuery = pgqlString;
                req.graphId = graphId;
                return executor.post((UnsafeHttpMethodRequest)req, LinkTemplate.PGQL_EXPLAIN.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Operation> explainPgql(SessionContext sessionContext, final String pgqlString) {
        PgqlExplainMarshaler marshaler = new PgqlExplainMarshaler();
        return this.request(new CoreRequest<Operation>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                PgqlExplainRequest req = new PgqlExplainRequest();
                req.pgqlQuery = pgqlString;
                return executor.post((UnsafeHttpMethodRequest)req, LinkTemplate.PGQL_EXPLAIN.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<PgxId[]> extractGraphIds(SessionContext sessionContext, PgxId graphId, String pgqlString) {
        throw new IllegalStateException("extractGraphIds(..) should not be called from clients");
    }

    public PgxFuture<PgqlResultSetProxy> queryPgqlForRedaction(SessionContext sessionContext, PgqlRedactionArgument redactionArgument) {
        throw new IllegalStateException("queryPgqlForRedaction(..) should not be called from clients");
    }

    public PgxFuture<PgqlResultSetProxy> getPgqlResultSet(SessionContext sessionContext, final String resultSetId) {
        PgqlResultSetMarshaler marshaler = new PgqlResultSetMarshaler(sessionContext, this.pgqlResultSetFactory);
        return this.request(new CoreRequest<PgqlResultSetProxy>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                CreatePgqlResultProxyRequest request = new CreatePgqlResultProxyRequest();
                request.resultSetId = resultSetId;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.PGQL_RESULT_PROXIES.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<FrameMetaData> createFrameFromPgqlResult(SessionContext sessionContext, final String resultSetId) {
        return this.request(new CoreRequest<FrameMetaData>(sessionContext, (Marshaler)Marshalers.FRAME_METADATA_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-proxy-id", resultSetId);
                return executor.post(headers, LinkTemplate.PGQL_RESULT_PROXY_TO_FRAME.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> destroyPgqlResultSet(SessionContext sessionContext, final String resultSetId) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-result-set-id", resultSetId);
                return executor.delete(headers, LinkTemplate.PGQL_QUERY_RESULT_SELF.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> destroyPreparedStatement(SessionContext sessionContext, final String preparedStatementId) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-ps-id", preparedStatementId);
                return executor.delete(headers, LinkTemplate.PGQL_PREPARED_STATEMENT.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<VertexLabels> getVertexLabels(SessionContext sessionContext, PgxId graphId, Object keyOrEntity) {
        GenericMarshaler genericMarshaler = new GenericMarshaler(VertexLabels.class);
        return this.getLabels(sessionContext, graphId, keyOrEntity, true, (Marshaler)genericMarshaler);
    }

    public PgxFuture<EdgeLabel> getEdgeLabel(SessionContext sessionContext, PgxId graphId, Object keyOrEntity) {
        GenericMarshaler genericMarshaler = new GenericMarshaler(EdgeLabel.class);
        return this.getLabels(sessionContext, graphId, keyOrEntity, false, (Marshaler)genericMarshaler);
    }

    private <T> PgxFuture<T> getLabels(SessionContext sessionContext, final PgxId graphId, final Object key, final boolean vertexLabels, Marshaler<T> marshaler) {
        return this.request(new CoreRequest<T>(sessionContext, marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                boolean isKeyWrapped = key instanceof Entity;
                Object id = isKeyWrapped ? JsonUtil.toJson((Object)key) : key;
                String keyType = IdTypeUtils.getElementIdType((Object)key).name();
                ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>();
                queryParams.add((NameValuePair)new BasicNameValuePair("idType", keyType));
                queryParams.add((NameValuePair)new BasicNameValuePair("keyWrapped", Boolean.toString(isKeyWrapped)));
                LinkTemplate template = vertexLabels ? LinkTemplate.VERTEX_LABEL_SELF : LinkTemplate.EDGE_LABEL_SELF;
                HeaderBuilder headerBuilder = new HeaderBuilder();
                if (vertexLabels) {
                    headerBuilder.addHeader((NameValuePair)new BasicNameValuePair("x-vertex-id", String.valueOf(id)));
                } else {
                    headerBuilder.addHeader((NameValuePair)new BasicNameValuePair("x-edge-id", String.valueOf(id)));
                }
                headerBuilder.addHeader((NameValuePair)new BasicNameValuePair("x-graph-id", graphId.toString()));
                return executor.get(headerBuilder.build(), template.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), queryParams);
            }
        });
    }

    public PgxFuture<Vertex> getVertexFromEdge(SessionContext sessionContext, final PgxId graphId, final Object id, final Direction direction) {
        return this.request(new CoreRequest<Vertex>(sessionContext, (Marshaler)Marshalers.VERTEX_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>();
                queryParams.add((NameValuePair)new BasicNameValuePair("direction", direction.toString()));
                queryParams.add((NameValuePair)new BasicNameValuePair("wrapped", Boolean.toString(id instanceof Edge)));
                String entityOrIdString = id instanceof Edge ? JsonUtil.toJson((Object)id) : String.valueOf(id);
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).addHeader("x-edge-id", entityOrIdString).build();
                return executor.get(headers, LinkTemplate.VERTEX_FROM_EDGE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), queryParams);
            }
        });
    }

    public <VID> PgxFuture<Void> addChanges(SessionContext sessionContext, String changeSetName, List<ChangeTrackingMap.ChangeSetEntry<VID, VertexChanges>> vertexChanges, List<ChangeTrackingMap.ChangeSetEntry<Object, EdgeChanges>> edgeChanges, PgxId oldGraphId, OnAddExistingElement addExistingVertexPolicy, OnAddExistingElement addExistingEdgePolicy, OnInvalidChange invalidChangePolicy, OnRequiredConversion requiredConversionPolicy, IdGenerationStrategy vertexIdGenerationStrategy, IdGenerationStrategy edgeIdGenerationStrategy) {
        int uploadBatchSize = this.context.getConfig().getUploadBatchSize();
        String url = LinkTemplate.CHANGES.generateUrl(this.baseUri, new Object[0]);
        int numVertexChanges = vertexChanges.size();
        int numEdgeChanges = edgeChanges.size();
        IdType idType = Changes.extractVertexIdType(vertexChanges, edgeChanges);
        Map vertexPropertyTypes = Changes.extractPropertyType(vertexChanges);
        Map edgePropertyTypes = Changes.extractPropertyType(edgeChanges);
        if (numVertexChanges + numEdgeChanges < uploadBatchSize) {
            return this.uploadChangesBatch(url, sessionContext, changeSetName, vertexChanges, edgeChanges, oldGraphId, addExistingVertexPolicy, addExistingEdgePolicy, invalidChangePolicy, requiredConversionPolicy, vertexPropertyTypes, edgePropertyTypes, idType, vertexIdGenerationStrategy, edgeIdGenerationStrategy);
        }
        return this.asyncRequest(() -> {
            PgxFuture<Void> vertexBatches = BatchedUploader.uploadBatched(uploadBatchSize, vertexChanges, RemoteCoreImpl::isRequestSizeTooLargeExceptionMessage, changeSetEntries -> this.uploadChangesBatch(url, sessionContext, changeSetName, (List)changeSetEntries, Collections.emptyList(), oldGraphId, addExistingVertexPolicy, addExistingEdgePolicy, invalidChangePolicy, requiredConversionPolicy, vertexPropertyTypes, edgePropertyTypes, idType, vertexIdGenerationStrategy, edgeIdGenerationStrategy));
            PgxFuture<Void> edgeBatches = BatchedUploader.uploadBatched(uploadBatchSize, edgeChanges, RemoteCoreImpl::isRequestSizeTooLargeExceptionMessage, changeSetEntries -> this.uploadChangesBatch(url, sessionContext, changeSetName, Collections.emptyList(), (List<ChangeTrackingMap.ChangeSetEntry<Object, EdgeChanges>>)changeSetEntries, oldGraphId, addExistingVertexPolicy, addExistingEdgePolicy, invalidChangePolicy, requiredConversionPolicy, vertexPropertyTypes, edgePropertyTypes, idType, vertexIdGenerationStrategy, edgeIdGenerationStrategy));
            return PgxFuture.allOf(Arrays.asList(vertexBatches, edgeBatches));
        }).thenCompose(Function.identity());
    }

    private <VID> PgxFuture<Void> uploadChangesBatch(final String url, SessionContext sessionContext, final String changeSetName, final List<ChangeTrackingMap.ChangeSetEntry<VID, VertexChanges>> vertexChanges, final List<ChangeTrackingMap.ChangeSetEntry<Object, EdgeChanges>> edgeChanges, final PgxId graphId, final OnAddExistingElement addExistingVertexPolicy, final OnAddExistingElement addExistingEdgePolicy, final OnInvalidChange invalidChangePolicy, final OnRequiredConversion conversionPolicy, final Map<String, PropertyType> vertexPropertyTypes, final Map<String, PropertyType> edgePropertyTypes, final IdType vertexIdType, final IdGenerationStrategy vertexIdGenerationStrategy, final IdGenerationStrategy edgeIdGenerationStrategy) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                AddChangesRequest addChangesRequest = new AddChangesRequest();
                addChangesRequest.changeSetName = changeSetName;
                addChangesRequest.vertexChanges = vertexChanges;
                addChangesRequest.edgeChanges = edgeChanges;
                addChangesRequest.vertexPropTypes = vertexPropertyTypes;
                addChangesRequest.edgePropTypes = edgePropertyTypes;
                addChangesRequest.vertexIdType = vertexIdType;
                addChangesRequest.graphId = graphId;
                addChangesRequest.addExistingVertexPolicy = addExistingVertexPolicy;
                addChangesRequest.addExistingEdgePolicy = addExistingEdgePolicy;
                addChangesRequest.invalidChangePolicy = invalidChangePolicy;
                addChangesRequest.conversionPolicy = conversionPolicy;
                addChangesRequest.vertexIdGenerationStrategy = vertexIdGenerationStrategy;
                addChangesRequest.edgeIdGenerationStrategy = edgeIdGenerationStrategy;
                return executor.patch((UnsafeHttpMethodRequest)addChangesRequest, url);
            }
        });
    }

    public PgxFuture<Graph> buildGraph(SessionContext sessionContext, final PgxId graphId, final String changeSetName, final IdType vertexIdType, final Map<String, PropertyType> vertexPropertyTypes, final Map<String, PropertyType> edgePropertyTypes, final String newGraphName, final GraphBuilderConfig config, final String dataSourceVersion) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                BuildGraphRequest buildGraphRequest = new BuildGraphRequest();
                buildGraphRequest.changeSetName = changeSetName;
                buildGraphRequest.oldGraphId = graphId;
                buildGraphRequest.vertexIdType = vertexIdType;
                buildGraphRequest.vertexPropTypes = vertexPropertyTypes;
                buildGraphRequest.edgePropTypes = edgePropertyTypes;
                buildGraphRequest.newGraphName = newGraphName;
                buildGraphRequest.config = config;
                buildGraphRequest.dataSourceVersion = dataSourceVersion;
                return executor.post((UnsafeHttpMethodRequest)buildGraphRequest, LinkTemplate.BUILD_GRAPH.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> buildNewGraphSnapshot(SessionContext sessionContext, final PgxId graphId, final String changeSetName, final IdType vertexIdType, final Map<String, PropertyType> vertexPropertyTypes, final Map<String, PropertyType> edgePropertyTypes, final GraphBuilderConfig config, final String dataSourceVersion) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                BuildGraphRequest buildGraphRequest = new BuildGraphRequest();
                buildGraphRequest.changeSetName = changeSetName;
                buildGraphRequest.oldGraphId = graphId;
                buildGraphRequest.vertexIdType = vertexIdType;
                buildGraphRequest.vertexPropTypes = vertexPropertyTypes;
                buildGraphRequest.edgePropTypes = edgePropertyTypes;
                buildGraphRequest.newGraphName = null;
                buildGraphRequest.config = config;
                buildGraphRequest.dataSourceVersion = dataSourceVersion;
                return executor.post((UnsafeHttpMethodRequest)buildGraphRequest, LinkTemplate.BUILD_GRAPH_SNAPSHOT.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> alterGraph(final SessionContext sessionContext, final PgxId graphId, final String newGraphName, final boolean cascadeEdgeProviderRemovals, final LinkedHashMap<String, EntityProviderConfig> addedVertexProviders, final LinkedHashMap<String, EntityProviderConfig> addedEdgeProviders, final LinkedHashMap<String, EntityProviderConfig> addedEmptyVertexProviders, final LinkedHashMap<String, EntityProviderConfig> addedEmptyEdgeProviders, final Set<String> removedVertexProviders, final Set<String> removedEdgeProviders, final String dataSourceVersion) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                AlterGraphRequest alterGraphRequest = new AlterGraphRequest();
                alterGraphRequest.oldGraphId = graphId;
                alterGraphRequest.newGraphName = newGraphName;
                alterGraphRequest.cascadeEdgeProviderRemovals = cascadeEdgeProviderRemovals;
                alterGraphRequest.addedVertexProviders = RemoteCoreImpl.toEntityProviderConfigContainer(sessionContext, addedVertexProviders);
                alterGraphRequest.addedEdgeProviders = RemoteCoreImpl.toEntityProviderConfigContainer(sessionContext, addedEdgeProviders);
                alterGraphRequest.addedEmptyVertexProviders = RemoteCoreImpl.toEntityProviderConfigContainer(sessionContext, addedEmptyVertexProviders);
                alterGraphRequest.addedEmptyEdgeProviders = RemoteCoreImpl.toEntityProviderConfigContainer(sessionContext, addedEmptyEdgeProviders);
                alterGraphRequest.removedVertexProviders = removedVertexProviders;
                alterGraphRequest.removedEdgeProviders = removedEdgeProviders;
                alterGraphRequest.dataSourceVersion = dataSourceVersion;
                return executor.post((UnsafeHttpMethodRequest)alterGraphRequest, LinkTemplate.ALTER_GRAPH.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Graph> alterGraphNewSnapshot(final SessionContext sessionContext, final PgxId graphId, final boolean cascadeEdgeProviderRemovals, final LinkedHashMap<String, EntityProviderConfig> addedVertexProviders, final LinkedHashMap<String, EntityProviderConfig> addedEdgeProviders, final LinkedHashMap<String, EntityProviderConfig> addedEmptyVertexProviders, final LinkedHashMap<String, EntityProviderConfig> addedEmptyEdgeProviders, final Set<String> removedVertexProviders, final Set<String> removedEdgeProviders, final String dataSourceVersion) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                AlterGraphRequest alterGraphRequest = new AlterGraphRequest();
                alterGraphRequest.oldGraphId = graphId;
                alterGraphRequest.newGraphName = null;
                alterGraphRequest.cascadeEdgeProviderRemovals = cascadeEdgeProviderRemovals;
                alterGraphRequest.addedVertexProviders = RemoteCoreImpl.toEntityProviderConfigContainer(sessionContext, addedVertexProviders);
                alterGraphRequest.addedEdgeProviders = RemoteCoreImpl.toEntityProviderConfigContainer(sessionContext, addedEdgeProviders);
                alterGraphRequest.addedEmptyVertexProviders = RemoteCoreImpl.toEntityProviderConfigContainer(sessionContext, addedEmptyVertexProviders);
                alterGraphRequest.addedEmptyEdgeProviders = RemoteCoreImpl.toEntityProviderConfigContainer(sessionContext, addedEmptyEdgeProviders);
                alterGraphRequest.removedVertexProviders = removedVertexProviders;
                alterGraphRequest.removedEdgeProviders = removedEdgeProviders;
                alterGraphRequest.dataSourceVersion = dataSourceVersion;
                return executor.post((UnsafeHttpMethodRequest)alterGraphRequest, LinkTemplate.ALTER_GRAPH_SNAPSHOT.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    private static LinkedHashMap<String, EntityProviderConfigContainer> toEntityProviderConfigContainer(SessionContext sessionContext, LinkedHashMap<String, EntityProviderConfig> providers) {
        LinkedHashMap<String, EntityProviderConfigContainer> providerContainers = new LinkedHashMap<String, EntityProviderConfigContainer>();
        providers.forEach((name, config) -> {
            EntityProviderConfigContainer obfuscated = EntityProviderConfigContainer.createObfuscated((EntityProviderConfig)config, (String)sessionContext.getSessionId());
            providerContainers.put((String)name, obfuscated);
        });
        return providerContainers;
    }

    public PgxFuture<Graph> expandGraph(SessionContext sessionContext, final PgxId graphId, final GraphExpansionConfig expansionConfig) {
        return this.request(new CoreRequest<Graph>(sessionContext, (Marshaler)Marshalers.GRAPH_RESULT_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                GraphExpansionRequest expansionRequest = new GraphExpansionRequest();
                expansionRequest.expansionConfig = expansionConfig;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)expansionRequest, LinkTemplate.EXPAND_GRAPH.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public synchronized PgxFuture<Void> renameGraph(SessionContext sessionContext, final PgxId graphId, final String newGraphName) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                RenameGraphRequest request = new RenameGraphRequest();
                request.newGraphName = newGraphName;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.put(headers, LinkTemplate.RENAME_GRAPH.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), (UnsafeHttpMethodRequest)request);
            }
        });
    }

    public PgxFuture<Void> addRedactionRule(SessionContext sessionContext, final PgxId graphId, final PgxRedactionRuleConfig ruleConfig, final AuthorizationType type, final String ... names) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                AddRedactionRuleRequest request = new AddRedactionRuleRequest();
                request.ruleConfig = ruleConfig;
                request.type = type;
                request.names = names;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.REDACTION.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> removeRedactionRule(SessionContext sessionContext, final PgxId graphId, final PgxRedactionRuleConfig ruleConfig, final AuthorizationType type, final String ... names) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                RemoveRedactionRuleRequest request = new RemoveRedactionRuleRequest();
                request.ruleConfig = ruleConfig;
                request.type = type;
                request.names = names;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.REDACTION_DELETE.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<List<PgxRedactionRuleConfig>> getRedactionRules(SessionContext sessionContext, final PgxId graphId, final AuthorizationType type, final String name) {
        return this.request(new CoreRequest<List<PgxRedactionRuleConfig>>(sessionContext, (Marshaler)Marshalers.PGX_REDACTION_RULE_CONFIG_LIST_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                String url = PgxUrlEncoder.encodeUrl(LinkTemplate.REDACTION.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), new Object[0]);
                ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
                parameters.add((NameValuePair)new BasicNameValuePair("type", type.name()));
                parameters.add((NameValuePair)new BasicNameValuePair("name", name));
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.get(headers, url, parameters);
            }
        });
    }

    public synchronized PgxFuture<Void> publish(SessionContext sessionContext, final PgxId graphId, final Collection<PgxId> vertexPropIds, final Collection<PgxId> edgePropIds) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                PublishGraphRequest publishRequest = new PublishGraphRequest();
                publishRequest.vertexPropIds = vertexPropIds;
                publishRequest.edgePropIds = edgePropIds;
                publishRequest.withSnapshots = false;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)publishRequest, LinkTemplate.PUBLISH_GRAPH.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> publishWithSnapshots(SessionContext sessionContext, final PgxId graphId, final Collection<PgxId> vertexPropIds, final Collection<PgxId> edgePropIds) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                PublishGraphRequest publishRequest = new PublishGraphRequest();
                publishRequest.vertexPropIds = vertexPropIds;
                publishRequest.edgePropIds = edgePropIds;
                publishRequest.withSnapshots = true;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.post(headers, (UnsafeHttpMethodRequest)publishRequest, LinkTemplate.PUBLISH_GRAPH.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Boolean> isPublished(SessionContext sessionContext, final PgxId graphId) {
        return this.request(new CoreRequest<Boolean>(sessionContext, (Marshaler)Marshalers.BOOLEAN_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<BasicNameValuePair> param = Collections.singletonList(new BasicNameValuePair("withSnapshots", String.valueOf(false)));
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.get(headers, LinkTemplate.GRAPH_IS_PUBLISHED.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), param);
            }
        });
    }

    public PgxFuture<Boolean> isPublishedWithSnapshots(SessionContext sessionContext, final PgxId graphId) {
        return this.request(new CoreRequest<Boolean>(sessionContext, (Marshaler)Marshalers.BOOLEAN_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<BasicNameValuePair> param = Collections.singletonList(new BasicNameValuePair("withSnapshots", String.valueOf(true)));
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.get(headers, LinkTemplate.GRAPH_IS_PUBLISHED.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), param);
            }
        });
    }

    public PgxFuture<Void> setPinned(SessionContext sessionContext, final PgxId graphId, final CoreGraphPersistenceApi.PinTarget target, final boolean pinned) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor httpExecutor) throws IOException, ExecutionException {
                PinGraphRequest pinGraphRequest = new PinGraphRequest();
                pinGraphRequest.target = target;
                pinGraphRequest.value = pinned;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return httpExecutor.post(headers, (UnsafeHttpMethodRequest)pinGraphRequest, LinkTemplate.CORE_PIN_GRAPH.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Boolean> isPinned(SessionContext sessionContext, final PgxId graphId, final CoreGraphPersistenceApi.PinTarget target) {
        return this.request(new CoreRequest<Boolean>(sessionContext, (Marshaler)Marshalers.BOOLEAN_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor httpExecutor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return httpExecutor.get(headers, LinkTemplate.GRAPH_IS_PINNED.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), "pinTarget", target.toString());
            }
        });
    }

    public synchronized PgxFuture<Void> publishProperty(SessionContext sessionContext, final PgxId graphId, final PgxId propertyId, final EntityType entityType) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).addHeader("x-property-name", propertyId.toString()).build();
                String url = LinkTemplate.PUBLISH_PROPERTY.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]) + "?entityType=%s";
                return executor.post(headers, PgxUrlEncoder.encodeUrl(url, entityType.name()));
            }
        });
    }

    public PgxFuture<Boolean> isPropertyPublished(SessionContext sessionContext, final PgxId graphId, final PgxId propertyId, final EntityType entityType) {
        return this.request(new CoreRequest<Boolean>(sessionContext, (Marshaler)Marshalers.BOOLEAN_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>();
                queryParams.add((NameValuePair)new BasicNameValuePair("entityType", entityType.name()));
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-id", graphId.toString()).addHeader("x-property-name", propertyId.toString()).build();
                return executor.get(headers, LinkTemplate.PROPERTY_IS_PUBLISHED.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), queryParams);
            }
        });
    }

    public PgxFuture<PgxResourcePermission> getPermission(SessionContext sessionContext, final PgxId graphId) {
        GenericMarshaler marshaler = new GenericMarshaler(PgxResourcePermission.class);
        return this.request(new CoreRequest<PgxResourcePermission>(sessionContext, (Marshaler)marshaler){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.get(headers, LinkTemplate.USER_GRAPH_PERMISSION.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> grantPermission(SessionContext sessionContext, final PgxId graphId, final PgxUser user, final PgxResourcePermission permission) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                GraphPermissionRequest request = new GraphPermissionRequest();
                request.userName = user.getName();
                request.permission = permission;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.put(headers, LinkTemplate.GRANT_GRAPH_PERMISSION.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), (UnsafeHttpMethodRequest)request);
            }
        });
    }

    public PgxFuture<Void> grantPermission(SessionContext sessionContext, final PgxId graphId, final PgxRole role, final PgxResourcePermission permission) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                GraphPermissionRequest request = new GraphPermissionRequest();
                request.roleName = role.getName();
                request.permission = permission;
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.put(headers, LinkTemplate.GRANT_GRAPH_PERMISSION.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), (UnsafeHttpMethodRequest)request);
            }
        });
    }

    public PgxFuture<Void> revokePermission(SessionContext sessionContext, final PgxId graphId, final PgxUser user) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                GraphPermissionRequest request = new GraphPermissionRequest();
                request.userName = user.getName();
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.put(headers, LinkTemplate.REVOKE_GRAPH_PERMISSION.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), (UnsafeHttpMethodRequest)request);
            }
        });
    }

    public PgxFuture<Void> revokePermission(SessionContext sessionContext, final PgxId graphId, final PgxRole role) {
        return this.request(new CoreRequest<Void>(sessionContext, (Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                GraphPermissionRequest request = new GraphPermissionRequest();
                request.roleName = role.getName();
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-id", graphId.toString());
                return executor.put(headers, LinkTemplate.REVOKE_GRAPH_PERMISSION.generateUrl(RemoteCoreImpl.this.baseUri, new Object[0]), (UnsafeHttpMethodRequest)request);
            }
        });
    }

    public PgxFuture<Void> checkDataAccessPermission(SessionContext sessionContext, PgxId graphId) {
        throw new IllegalStateException("checkDataAccessPermission(..) should not be called from clients");
    }

    public PgxFuture<RedactionRulesTriggers> getRedactionRulesTriggers(SessionContext sessionContext, PgxId graphId) {
        throw new IllegalStateException("getRedactionRulesTriggers(..) should not be called from clients");
    }

    private abstract class CoreRequest<T>
    extends AbstractAsyncRequest<T> {
        CoreRequest(SessionContext sessionContext, Marshaler<T> marshaler) {
            super(RemoteCoreImpl.this.context, marshaler, RemoteCoreImpl.this.baseUrl, sessionContext, false);
        }

        @Override
        public final RemoteResponse request() throws IOException, ExecutionException, InterruptedException, RemoteUtils.RequestPendingException {
            return this.request(this.getHttpRequestExecutor());
        }

        abstract RemoteResponse request(HttpRequestExecutor var1) throws IOException, ExecutionException, InterruptedException, RemoteUtils.RequestPendingException;
    }
}

