/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class Order<T>
extends LinkedList<T> {
    private final Set<T> set = new HashSet<T>();

    public boolean pushBack(T elem) {
        if (!this.set.contains(elem)) {
            super.addLast(elem);
            this.set.add(elem);
            return true;
        }
        return false;
    }

    public boolean pushFront(T elem) {
        if (!this.set.contains(elem)) {
            super.addFirst(elem);
            this.set.add(elem);
            return true;
        }
        return false;
    }

    @Override
    public T pollFirst() {
        Object e = super.pollFirst();
        if (e != null) {
            this.set.remove(e);
        }
        return (T)e;
    }

    @Override
    public T pollLast() {
        Object e = super.pollLast();
        if (e != null) {
            this.set.remove(e);
        }
        return (T)e;
    }

    @Override
    public boolean add(T e) {
        return this.pushBack(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (T e : c) {
            changed |= this.add(e);
        }
        return changed;
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addFirst(T e) {
        this.pushFront(e);
    }

    @Override
    public void addLast(T e) {
        this.pushBack(e);
    }

    @Override
    public T removeFirst() {
        Object e = super.removeFirst();
        this.set.remove(e);
        return (T)e;
    }

    @Override
    public T removeLast() {
        Object e = super.removeLast();
        this.set.remove(e);
        return (T)e;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = super.remove(o);
        if (removed) {
            this.set.remove(o);
        }
        return removed;
    }
}

