/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.filter;

import java.util.Objects;
import oracle.pgx.api.filter.FilterType;
import oracle.pgx.api.filter.GraphFilter;
import oracle.pgx.common.util.ErrorMessages;

public abstract class BinaryGraphFilterOperation
extends GraphFilter {
    private final GraphFilter leftFilter;
    private final GraphFilter rightFilter;

    protected BinaryGraphFilterOperation(FilterType type, GraphFilter leftFilter, GraphFilter rightFilter) {
        super(type);
        this.leftFilter = leftFilter;
        this.rightFilter = rightFilter;
    }

    public final GraphFilter getLeftFilter() {
        return this.leftFilter;
    }

    public final GraphFilter getRightFilter() {
        return this.rightFilter;
    }

    public String toString() {
        return this.getType().toString().toLowerCase() + "( " + this.leftFilter + ", " + this.rightFilter + " )";
    }

    @Override
    public final BinaryGraphFilterOperation asBinaryGraphFilterOperation() {
        return this;
    }

    @Override
    public final boolean isBinaryOperation() {
        return true;
    }

    public static GraphFilter fromTypeAndFilters(FilterType type, GraphFilter leftFilter, GraphFilter rightFilter) {
        switch (type) {
            case UNION: {
                return leftFilter.union(rightFilter);
            }
            case INTERSECTION: {
                return leftFilter.intersect(rightFilter);
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage("NOT_A_BINARY_FILTER_OP", type.toString().toLowerCase()));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BinaryGraphFilterOperation that = (BinaryGraphFilterOperation)o;
        return Objects.equals(this.leftFilter, that.leftFilter) && Objects.equals(this.rightFilter, that.rightFilter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.leftFilter, this.rightFilter);
    }
}

