/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.index;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileObject;
import org.spoofax.interpreter.library.index.IIndex;
import org.spoofax.interpreter.library.index.Index;
import org.spoofax.interpreter.library.index.IndexEntryFactory;
import org.spoofax.interpreter.library.index.IndexFactory;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.io.binary.SAFWriter;
import org.spoofax.terms.io.binary.TermReader;

public class IndexManager {
    public static IIndex create(ITermFactory termFactory) {
        return new Index(termFactory);
    }

    public static IIndex read(FileObject indexFile, ITermFactory termFactory) throws ParseError, IOException, Exception {
        IStrategoTerm term = IndexManager.readTerm(indexFile, termFactory);
        IndexFactory factory = IndexManager.factory(termFactory);
        IIndex index = IndexManager.create(termFactory);
        return factory.indexFromTerm(index, term);
    }

    public static void write(IIndex index, FileObject indexFile, ITermFactory termFactory) throws IOException {
        indexFile.createFile();
        IndexFactory factory = IndexManager.factory(termFactory);
        IStrategoTerm term = factory.indexToTerm(index);
        IndexManager.writeTerm(indexFile, term);
    }

    private static IndexFactory factory(ITermFactory termFactory) {
        return new IndexFactory(termFactory, new IndexEntryFactory(termFactory));
    }

    private static IStrategoTerm readTerm(FileObject file, ITermFactory termFactory) throws ParseError, IOException {
        TermReader termReader = new TermReader(termFactory);
        return termReader.parseFromStream(file.getContent().getInputStream());
    }

    private static void writeTerm(FileObject file, IStrategoTerm term) throws IOException {
        file.createFile();
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream output = file.getContent().getOutputStream();){
            new SAFWriter().write(term, output);
            output.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

