/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api.stamp.resource;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import mb.pie.api.stamp.ResourceStamp;
import mb.pie.api.stamp.ResourceStamper;
import mb.resource.Resource;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ByteArrayResourceStamp<R extends Resource>
implements ResourceStamp<R> {
    private final byte[] value;
    private final ResourceStamper<R> stamper;
    private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);

    public ByteArrayResourceStamp(byte[] value, ResourceStamper<R> stamper) {
        this.value = value;
        this.stamper = stamper;
    }

    @Override
    public ResourceStamper<R> getStamper() {
        return this.stamper;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArrayResourceStamp that = (ByteArrayResourceStamp)o;
        if (!Arrays.equals(this.value, that.value)) {
            return false;
        }
        return this.stamper.equals(that.stamper);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.value);
        result = 31 * result + this.stamper.hashCode();
        return result;
    }

    public String toString() {
        return "ByteArrayResourceStamp(value=" + ByteArrayResourceStamp.bytesToHex(this.value) + ", stamper=" + this.stamper + ')';
    }

    public static String bytesToHex(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }
}

