/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.internal.adb;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import lombok.Generated;
import oracle.pg.rdbms.AdbGraphClientConfiguration;
import oracle.pg.rdbms.EnvironmentStatus;
import oracle.pg.rdbms.Job;
import oracle.pg.rdbms.exception.GraphClientException;
import oracle.pg.rdbms.internal.AbstractHttpClient;
import oracle.pg.rdbms.internal.UriUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphStudioClient
extends AbstractHttpClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphStudioClient.class);
    private static final String X_AUTH_TOKEN_HEADER = "x-auth-token";
    private final AdbGraphClientConfiguration config;
    private final ExecutorService executorService;
    private final URI graphStudioUrl;
    private final URI environmentUrl;
    private final URI userUrl;
    private final Supplier<String> tokenSupplier;

    public GraphStudioClient(AdbGraphClientConfiguration config, ExecutorService executorService, URI graphStudioUrl, Supplier<String> tokenSupplier) {
        super(config.getHttpClient());
        this.config = config;
        this.executorService = executorService;
        this.graphStudioUrl = graphStudioUrl;
        this.environmentUrl = UriUtils.appendPath(graphStudioUrl, config.getGraphStudioApiVersion() + "/modeler/environment");
        this.userUrl = UriUtils.appendPath(graphStudioUrl, config.getDataStudioApiVersion() + "/sessions/user");
        this.tokenSupplier = tokenSupplier;
    }

    private Map<String, String> createTokenHeader() {
        return Collections.singletonMap(X_AUTH_TOKEN_HEADER, this.tokenSupplier.get());
    }

    public void getUser() {
        AbstractHttpClient.JsonResponse response = this.getJson(this.userUrl, null, this.createTokenHeader());
        if (response.getStatusCode() != 200) {
            throw new GraphClientException("failed to get user (HTTP " + response.getStatusCode() + "): " + response.getBody(), response.getRequestId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnvironmentStatus getEnvironmentStatus() {
        EnvironmentStatus environmentStatus;
        URI url = UriUtils.appendPath(this.environmentUrl, "status");
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader(X_AUTH_TOKEN_HEADER, this.tokenSupplier.get());
        log.info("GET {}", (Object)url);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String requestId = GraphStudioClient.getRequestIdFromResponse(response);
                throw new GraphClientException("failed to get status (HTTP " + statusCode + "): " + EntityUtils.toString((HttpEntity)response.getEntity()), requestId);
            }
            String value = (String)this.objectMapper.readValue(response.getEntity().getContent(), String.class);
            environmentStatus = EnvironmentStatus.valueOf(value);
        }
        catch (Throwable throwable) {
            try {
                GraphStudioClient.close(response);
                throw throwable;
            }
            catch (IOException e) {
                throw new GraphClientException("could not execute request GET " + url, null, e);
            }
        }
        GraphStudioClient.close(response);
        return environmentStatus;
    }

    public Job getJob(long jobId) {
        URI url = UriUtils.appendPath(this.graphStudioUrl, this.config.getGraphStudioApiVersion() + "/modeler/jobs/" + jobId);
        AbstractHttpClient.JsonResponse response = this.getJson(url, null, this.createTokenHeader());
        if (response.getStatusCode() != 200) {
            throw new GraphClientException("failed to job status (HTTP " + response.getStatusCode() + "): " + response.getBody(), response.getRequestId());
        }
        return this.parseJobResponse(response.getBody());
    }

    public Job attachEnvironment(int memory) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("memory", memory);
        request.put("pgxInterpreterMemory", 1);
        request.put("pgqlInterpreterMemory", 1);
        request.put("markdownInterpreterMemory", 1);
        request.put("pythonInterpreterMemory", 1);
        request.put("rdfInterpreterMemory", 1);
        request.put("jdbcInterpreterMemory", 1);
        AbstractHttpClient.JsonResponse response = this.postJson(this.environmentUrl, request, null, this.createTokenHeader());
        if (response.getStatusCode() != 200) {
            throw new GraphClientException("failed to attach (HTTP " + response.getStatusCode() + "): " + response.getBody(), response.getRequestId());
        }
        return this.parseJobResponse(response.getBody());
    }

    public Job detachEnvironment() {
        AbstractHttpClient.JsonResponse response = this.deleteJson(this.environmentUrl, null, this.createTokenHeader());
        if (response.getStatusCode() != 200) {
            throw new GraphClientException("failed to detach (HTTP " + response.getStatusCode() + "): " + response.getBody(), response.getRequestId());
        }
        return this.parseJobResponse(response.getBody());
    }

    public Job reattachEnvironment() {
        AbstractHttpClient.JsonResponse response = this.putJson(this.environmentUrl, null, null, this.createTokenHeader());
        if (response.getStatusCode() != 200) {
            throw new GraphClientException("failed to restart (HTTP " + response.getStatusCode() + "): " + response.getBody(), response.getRequestId());
        }
        return this.parseJobResponse(response.getBody());
    }

    private Job parseJobResponse(Map<String, Object> json) {
        long id = new Long(String.valueOf(json.get("id")));
        String name = String.valueOf(json.get("name"));
        String description = String.valueOf(json.get("description"));
        Job.Type type = Job.Type.valueOf(String.valueOf(json.get("type")));
        Job.Status status = Job.Status.valueOf(String.valueOf(json.get("status")));
        String createdBy = String.valueOf(json.get("createdBy"));
        String error = String.valueOf(json.get("error"));
        List logs = (List)json.get("log");
        ArrayList<Job.LogEntry> logEntries = new ArrayList<Job.LogEntry>();
        if (logs != null) {
            logs.forEach(row -> {
                Date timestamp = new Date(new Long(String.valueOf(row.get("timestamp"))));
                logEntries.add(new Job.LogEntry(timestamp, (String)row.get("log")));
            });
        }
        return new Job(this, id, name, description, type, status, createdBy, error, logEntries);
    }

    @Generated
    public AdbGraphClientConfiguration getConfig() {
        return this.config;
    }

    @Generated
    public ExecutorService getExecutorService() {
        return this.executorService;
    }
}

