/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.internal;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import oracle.pgx.realm.client.RealmClient;

public abstract class AbstractRealmClient
implements RealmClient {
    private String token;
    private long refreshTimeBeforeTokenExpiry;
    private Date tokenExpirationDate;
    private static final String REFRESH_TIME_BEFORE_EXPIRY_CLAIM = "refresh_time_before_token_expiry_seconds";

    public AbstractRealmClient(String token, long refreshTimeBeforeTokenExpiry) {
        this.parseToken(token, refreshTimeBeforeTokenExpiry);
    }

    private void parseToken(String token, long refreshTimeBeforeTokenExpiry) {
        try {
            JWT jwt = JWTParser.parse((String)token);
            this.tokenExpirationDate = jwt.getJWTClaimsSet().getExpirationTime();
            this.refreshTimeBeforeTokenExpiry = refreshTimeBeforeTokenExpiry;
            if (refreshTimeBeforeTokenExpiry == -1L) {
                Integer refreshTimeFromJwt = jwt.getJWTClaimsSet().getIntegerClaim(REFRESH_TIME_BEFORE_EXPIRY_CLAIM);
                this.refreshTimeBeforeTokenExpiry = refreshTimeFromJwt != null ? (long)refreshTimeFromJwt.intValue() : 1800L;
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse token: " + e.getMessage(), e);
        }
        this.token = token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        try {
            Date actualDatePlusMargin = new Date(new Date().getTime() + this.refreshTimeBeforeTokenExpiry * 1000L);
            if (actualDatePlusMargin.after(this.tokenExpirationDate)) {
                this.setToken(this.refreshToken(this.token));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.token;
    }

    protected abstract String refreshToken(String var1) throws IOException;
}

