/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.GraphType;
import oracle.pg.rdbms.pgql.ModifyContext;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlTranslator;
import oracle.pg.rdbms.pgql.QueryContext;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgqlUtils {
    private static Logger ms_log = LoggerFactory.getLogger(PgqlUtils.class);
    public static final String VT_SUFFIX = "VT$";

    public static String unescapePgqlString(String str) throws PgqlToSqlException {
        char[] chars = str.toCharArray();
        StringBuffer unescStr = new StringBuffer("");
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\\') {
                if (i + 1 >= chars.length) {
                    throw new PgqlToSqlException("Invalid String literal: \"" + str + "\"");
                }
                if (chars[i + 1] == '\\') {
                    unescStr.append('\\');
                } else if (chars[i + 1] == 'n') {
                    unescStr.append('\n');
                } else if (chars[i + 1] == 't') {
                    unescStr.append('\t');
                } else if (chars[i + 1] == 'r') {
                    unescStr.append('\r');
                } else {
                    throw new PgqlToSqlException("Invalid String literal: \"" + str + "\"");
                }
                ++i;
                continue;
            }
            unescStr.append(chars[i]);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("unescapePgqlString input=[" + str + "] output=[" + unescStr + "]");
        }
        return unescStr.toString();
    }

    public static String getEdgeTabName(Connection conn, String graphOwner, String graphName) throws SQLException {
        return DbmsUtils.sanitizeGraphOwner(conn, graphOwner) + "." + DbmsUtils.sanitizeGraphName(conn, graphName) + "GE$";
    }

    public static String getSkeletonTabName(Connection conn, String graphOwner, String graphName) throws SQLException {
        return DbmsUtils.sanitizeGraphOwner(conn, graphOwner) + "." + DbmsUtils.sanitizeGraphName(conn, graphName) + "GT$";
    }

    public static String getVertexTabName(Connection conn, String graphOwner, String graphName) throws SQLException {
        return DbmsUtils.sanitizeGraphOwner(conn, graphOwner) + "." + DbmsUtils.sanitizeGraphName(conn, graphName) + VT_SUFFIX;
    }

    public static String getDistinctVertexTabName(Connection conn, String graphOwner, String graphName) throws SQLException {
        return DbmsUtils.sanitizeGraphOwner(conn, graphOwner) + "." + DbmsUtils.sanitizeGraphName(conn, graphName) + "VD$";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GraphType getGraphType(Connection conn, String graphOwner, String graphName) throws PgqlToSqlException {
        boolean isPgSqlGraph;
        if (PgqlTranslator.containsGraphMetadata(conn, graphOwner, graphName)) {
            return GraphType.PG_VIEWS;
        }
        String query = "DECLARE\n  cnt  NUMBER := 0;\n  idx  NUMBER := -1;\n  graph_name  VARCHAR2(4000) := ?;\n  owner       VARCHAR2(4000) := ?;\nBEGIN\n  BEGIN\n    execute immediate 'SELECT count(*) FROM SYS.ALL_PROPERTY_GRAPHS\n    WHERE graph_name = :graph_name AND owner = :owner'\n    into cnt\n    using graph_name, owner;\n   EXCEPTION when others then\n    if SQLCODE != -942 then\n      raise;\n    end if;\n  END;\n  ? := cnt;\n  BEGIN\n    select decode(table_name, ?, " + GraphType.PG_SCHEMA.ordinal() + ", ?, " + GraphType.PG_VIEWS.ordinal() + ")\n    into idx\n    from sys.all_tables\n    where owner = ?\n      and table_name IN(?, ?);\n   EXCEPTION when NO_DATA_FOUND then null;\n  END;\n  ? := idx;\nEND;";
        try (CallableStatement ps = conn.prepareCall(query);){
            String pgSchemaTable = graphName + VT_SUFFIX;
            String pgViewTable = graphName + "_ELEM_TABLE$";
            ps.setString(1, graphName);
            ps.setString(2, graphOwner);
            ps.registerOutParameter(3, 4);
            ps.setString(4, pgSchemaTable);
            ps.setString(5, pgViewTable);
            ps.setString(6, graphOwner);
            ps.setString(7, pgSchemaTable);
            ps.setString(8, pgViewTable);
            ps.registerOutParameter(9, 4);
            ps.execute();
            isPgSqlGraph = ps.getInt(3) > 0;
            int idx = ps.getInt(9);
            if (idx >= 0) {
                if (isPgSqlGraph) {
                    throw new PgqlToSqlException("There exist a SQL property graph and a property graph view/schema with the same name");
                }
                GraphType graphType = GraphType.values()[idx];
                return graphType;
            }
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
        if (!isPgSqlGraph) return null;
        return GraphType.PG_SQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static int countPgSchemaTables(Connection conn, String graphOwner, String graphName) {
        int n;
        Throwable throwable;
        PreparedStatement ps;
        ResultSet rs;
        block17: {
            block18: {
                String query = "SELECT COUNT(*) FROM SYS.ALL_TABLES WHERE owner = ? AND table_name IN(?, ?, ?, ?)";
                rs = null;
                ps = conn.prepareStatement(query);
                throwable = null;
                String clnGraphName = graphName.toUpperCase();
                ps.setString(1, graphOwner);
                ps.setString(2, clnGraphName + VT_SUFFIX);
                ps.setString(3, clnGraphName + "GE$");
                ps.setString(4, clnGraphName + "VD$");
                ps.setString(5, clnGraphName + "GT$");
                rs = ps.executeQuery();
                rs.next();
                n = rs.getInt(1);
                if (ps == null) break block17;
                if (throwable == null) break block18;
                try {
                    ps.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block17;
            }
            ps.close();
        }
        DbmsUtils.quietlyCloseResultSetAndStmt(rs, null);
        return n;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (ps != null) {
                                if (throwable != null) {
                                    try {
                                        ps.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    ps.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (SQLException ex) {
                        int n2 = 0;
                        return n2;
                    }
                }
                catch (Throwable throwable6) {
                    throw throwable6;
                }
                finally {
                    DbmsUtils.quietlyCloseResultSetAndStmt(rs, null);
                }
            }
        }
    }

    public static String getTemporaryTabName(Connection conn, String graphName, String suffix) throws SQLException {
        return DbmsUtils.enquoteTableName(conn, PgqlUtils.getTemporaryTabName(graphName, suffix).toUpperCase());
    }

    public static String getTemporaryTabName(String graphName, String suffix) {
        return "ora$ptt_" + graphName + "$" + suffix;
    }

    public static void setQueryOptions(QueryContext ctx, String options) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting query options ...");
        }
        ctx.useIso = false;
        switch (ctx.graphType) {
            case PG_SCHEMA: {
                ctx.checkDbVersion();
                ctx.checkOpgVersion();
                ctx.projNullProps = DbFeature.PROJECT_NULL_PROPERTIES.isSupported(ctx.dbVersion, ctx.opgVersion);
                ctx.useVLCol = DbFeature.VERTEX_LABELS.isSupported(ctx.dbVersion, ctx.opgVersion);
                ctx.useGtTab = DbFeature.POPULATE_DISTINCT_PG_TABLES.isSupported(ctx.dbVersion, ctx.opgVersion);
                ctx.useVdTab = DbFeature.POPULATE_DISTINCT_PG_TABLES.isSupported(ctx.dbVersion, ctx.opgVersion);
                ctx.useExtdSize = DbmsUtils.isMaxStringSizeExtended(ctx.pgqlConn.getJdbcConnection());
                ctx.useRW = true;
                ctx.useDistRW = false;
                ctx.allEdgeHash = false;
                ctx.allVertexHash = false;
                ctx.allEdgeNL = false;
                ctx.allVertexNL = false;
                ctx.maxPathLen = 0;
                ctx.addDefaultNull = true;
                break;
            }
            case PG_VIEWS: {
                ctx.reversePath = true;
                ctx.pushSrcHops = true;
                ctx.pushDstHops = false;
                ctx.spCreateView = false;
                ctx.spCreateTable = true;
                ctx.spStartVC = true;
                ctx.spEndVC = true;
                ctx.spPathVC = true;
            }
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Checking system parameters ...");
        }
        ctx.useIso = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.useIso", ctx.useIso);
        switch (ctx.graphType) {
            case PG_SCHEMA: {
                ctx.projNullProps = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.projNullProps", ctx.projNullProps);
                ctx.useVLCol = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.useVLCol", ctx.useVLCol);
                ctx.useGtTab = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.useGtTab", ctx.useGtTab);
                ctx.useVdTab = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.useVdTab", ctx.useVdTab);
                ctx.useRW = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.useRW", ctx.useRW);
                ctx.useDistRW = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.useDistRW", ctx.useDistRW);
                ctx.allEdgeHash = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.allEdgeHash", ctx.allEdgeHash);
                ctx.allVertexHash = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.allVertexHash", ctx.allVertexHash);
                ctx.allEdgeNL = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.allEdgeNL", ctx.allEdgeNL);
                ctx.allVertexNL = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.allVertexNL", ctx.allVertexNL);
                ctx.maxPathLen = PgqlUtils.extractIntProperty("oracle.pg.rdbms.pgql.maxPathLen", ctx.maxPathLen);
                ctx.addDefaultNull = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.addDefaultNull", ctx.addDefaultNull);
                break;
            }
            case PG_VIEWS: {
                ctx.reversePath = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.reversePath", ctx.reversePath);
                ctx.pushSrcHops = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.pushSrcHops", ctx.pushSrcHops);
                ctx.pushDstHops = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.pushDstHops", ctx.pushDstHops);
                ctx.spCreateView = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.spCreateView", ctx.spCreateView);
                ctx.spCreateTable = PgqlUtils.extractBooleanProperty("oracle.pg.rdbms.pgql.spCreateTable", ctx.spCreateTable);
            }
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... Done checking system parameters");
            ms_log.debug("Checking options string ...");
            ms_log.debug("options=[" + options + "]");
        }
        if (options != null) {
            String uOptions = options.toUpperCase();
            ctx.useIso = PgqlUtils.extractBooleanOptionValue(options, "USE_ISO", ctx.useIso);
            switch (ctx.graphType) {
                case PG_SCHEMA: {
                    ctx.projNullProps = PgqlUtils.extractBooleanOptionValue(options, "PROJ_NULL_PROPS", ctx.projNullProps);
                    ctx.useVLCol = PgqlUtils.extractBooleanOptionValue(options, "USE_VL_COL", ctx.useVLCol);
                    ctx.useGtTab = PgqlUtils.extractBooleanOptionValue(options, "USE_GT_TAB", ctx.useGtTab);
                    ctx.useVdTab = PgqlUtils.extractBooleanOptionValue(options, "USE_VD_TAB", ctx.useVdTab);
                    ctx.useRW = PgqlUtils.extractBooleanOptionValue(options, "USE_RW", ctx.useRW);
                    ctx.useDistRW = PgqlUtils.extractBooleanOptionValue(options, "USE_DIST_RW", ctx.useDistRW);
                    if (uOptions.contains("ALL_EDGE_HASH")) {
                        ctx.allEdgeHash = true;
                    }
                    if (uOptions.contains("ALL_VERTEX_HASH")) {
                        ctx.allVertexHash = true;
                    }
                    if (uOptions.contains("ALL_EDGE_NL")) {
                        ctx.allEdgeNL = true;
                    }
                    if (uOptions.contains("ALL_VERTEX_NL")) {
                        ctx.allVertexNL = true;
                    }
                    if (uOptions.contains("MAX_PATH_LEN")) {
                        ctx.maxPathLen = PgqlUtils.extractIntOptionValue(uOptions, "MAX_PATH_LEN=", ctx.maxPathLen);
                    }
                    ctx.addDefaultNull = PgqlUtils.extractBooleanOptionValue(options, "ADD_DEFAULT_NULL", ctx.addDefaultNull);
                    break;
                }
                case PG_VIEWS: {
                    ctx.reversePath = PgqlUtils.extractBooleanOptionValue(options, "REVERSE_PATH", ctx.reversePath);
                    ctx.pushSrcHops = PgqlUtils.extractBooleanOptionValue(options, "PUSH_SRC_HOPS", ctx.pushSrcHops);
                    ctx.pushDstHops = PgqlUtils.extractBooleanOptionValue(options, "PUSH_DST_HOPS", ctx.pushDstHops);
                    ctx.spCreateView = PgqlUtils.extractBooleanOptionValue(options, "SP_CREATE_VIEW", ctx.spCreateView);
                    ctx.spCreateTable = PgqlUtils.extractBooleanOptionValue(options, "SP_CREATE_TABLE", ctx.spCreateTable);
                }
            }
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... Done checking options string");
            ms_log.debug("... Done setting options ... QueryContext:\n" + ctx.toString());
        }
    }

    public static void setModifyOptions(ModifyContext modifyCtx, String options) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting modify options ...");
        }
        modifyCtx.resetOptions();
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Checking system parameters ...");
        }
        modifyCtx.setOptionsFromSystemProperties();
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... Done checking system parameters");
            ms_log.debug("Checking options string ...");
            ms_log.debug("options=[" + options + "]");
        }
        if (options != null) {
            String uOptions = options.toUpperCase();
            modifyCtx.setOptionsFromString(uOptions);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("... Done checking options string");
            ms_log.debug("... Done setting options ... ModifyContext:\n" + modifyCtx.toString());
        }
    }

    public static boolean extractBooleanProperty(String propName, boolean defaultValue) {
        String val;
        boolean boolVal;
        block3: {
            boolVal = defaultValue;
            val = null;
            try {
                val = System.getProperty(propName);
            }
            catch (Exception ex) {
                if (!ms_log.isDebugEnabled()) break block3;
                ms_log.debug("Error extracting system property [" + propName + "] " + ex.getMessage());
            }
        }
        if (val != null) {
            boolVal = Boolean.parseBoolean(val);
        }
        return boolVal;
    }

    public static int extractIntProperty(String propName, int defaultValue) {
        int intVal;
        block6: {
            String val;
            block5: {
                intVal = defaultValue;
                val = null;
                try {
                    val = System.getProperty(propName);
                }
                catch (Exception ex) {
                    if (!ms_log.isDebugEnabled()) break block5;
                    ms_log.debug("Error extracting system property [" + propName + "] " + ex.getMessage());
                }
            }
            if (val != null) {
                try {
                    intVal = Integer.parseInt(val);
                }
                catch (NumberFormatException ex) {
                    if (!ms_log.isDebugEnabled()) break block6;
                    ms_log.debug("Error extracting system property [" + propName + "] invalid integer [" + val + "]");
                }
            }
        }
        return intVal;
    }

    public static boolean extractBooleanOptionValue(String options, String optionName, boolean defaultValue) {
        boolean boolVal = defaultValue;
        if (options.contains(optionName + "=T")) {
            boolVal = true;
        }
        if (options.contains(optionName + "=F")) {
            boolVal = false;
        }
        return boolVal;
    }

    public static int extractIntOptionValue(String options, String optionName, int defaultValue) {
        int numVal = defaultValue;
        int idx = options.indexOf(optionName);
        if (idx >= 0) {
            int startIdx = idx + optionName.length();
            int endIdx = options.length();
            String[] chars = new String[]{"\n", "\t", " ", ","};
            for (int i = 0; i < chars.length; ++i) {
                int charIdx = options.indexOf(chars[i], startIdx);
                if (charIdx < 0 || charIdx >= endIdx) continue;
                endIdx = charIdx;
            }
            if (endIdx > startIdx) {
                try {
                    numVal = Integer.parseInt(options.substring(startIdx, endIdx));
                }
                catch (NumberFormatException ex) {
                    ms_log.debug("Error setting option " + optionName);
                }
            }
        }
        return numVal;
    }

    public static String escapeAndEnquoteIdentifier(String columnName) {
        return PgqlUtils.escapeAndEnquoteIdentifier(columnName, true);
    }

    public static String escapeAndEnquoteIdentifier(String columnName, boolean alwaysQuote) {
        String identifier = oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)columnName, (boolean)alwaysQuote);
        if (identifier.startsWith("\"")) {
            identifier = "\"" + identifier.replaceAll("\"", "") + "\"";
        }
        return identifier;
    }

    public static boolean containsSubquery(QueryExpression exp) {
        final MutableBoolean result = new MutableBoolean(false);
        exp.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(QueryExpression.Function.Exists exists) {
                result.setTrue();
            }

            public void visit(QueryExpression.ScalarSubquery subquery) {
                result.setTrue();
            }
        });
        return result.getValue();
    }

    static enum DbFeature {
        CREATE_PG_WITH_TBS_SET(18, 20.1),
        INSERT_UPDATE_DELETE(18, Double.MAX_VALUE),
        VERTEX_LABELS(19, 20.1),
        DROP_GRAPH_DIFFERENT_OWNER(20, 20.1),
        POPULATE_DISTINCT_PG_TABLES(20, 20.1),
        PROJECT_NULL_PROPERTIES(20, 20.1),
        ANALYZE_PG_DIFFERENT_OWNER(20, 20.3),
        SUBQUERY_PATH_EDGE_JOIN(23, Double.MAX_VALUE),
        SHORTEST_PATH_CURSOR(19, Double.MAX_VALUE);

        private final int requiredVersion;
        private final double requiredOpgVersion;

        private DbFeature(int requiredVersion, double requiredOpgVersion) {
            this.requiredVersion = requiredVersion;
            this.requiredOpgVersion = requiredOpgVersion;
        }

        public boolean isSupported(int dbVersion, double opgVersion) {
            return dbVersion >= this.requiredVersion || opgVersion >= this.requiredOpgVersion;
        }
    }
}

