/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLParseException;

public class XMLValidator {
    public static void process(String string, String string2) throws Exception {
        XSDBuilder xSDBuilder = new XSDBuilder();
        URL uRL = XMLValidator.createURL(string2);
        try {
            XMLSchema xMLSchema = xSDBuilder.build(uRL);
            XMLValidator.processValidateXML(string, xMLSchema);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public static void processValidateXML(String string, Object object) throws Exception {
        DOMParser dOMParser = new DOMParser();
        URL uRL = XMLValidator.createURL(string);
        dOMParser.setXMLSchema(object);
        dOMParser.setValidationMode(3);
        dOMParser.setPreserveWhitespace(true);
        dOMParser.setErrorStream((OutputStream)System.out);
        try {
            dOMParser.parse(uRL);
        }
        catch (XMLParseException xMLParseException) {
            xMLParseException.printStackTrace();
            System.out.println("ParserException: " + xMLParseException.getMessage());
            throw xMLParseException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("");
            System.out.println("NonParserException: " + exception.getMessage());
            throw exception;
        }
    }

    static URL createURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                String string2 = file.getAbsolutePath();
                String string3 = System.getProperty("file.separator");
                if (string3.length() == 1) {
                    char c = string3.charAt(0);
                    if (c != '/') {
                        string2 = string2.replace(c, '/');
                    }
                    if (string2.charAt(0) != '/') {
                        string2 = '/' + string2;
                    }
                }
                string2 = "file://" + string2;
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                System.out.println("Cannot create url for: " + string);
                System.exit(0);
            }
        }
        return uRL;
    }

    public static void main(String[] stringArray) throws Exception {
    }
}

