/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.pgql.lang.CommonTranslationUtil;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.TranslateCreateExternalSchema;
import oracle.pgql.lang.TranslateCreatePropertyGraph;
import oracle.pgql.lang.TranslateDropExternalSchema;
import oracle.pgql.lang.TranslateDropPropertyGraph;
import oracle.pgql.lang.TranslationContext;
import oracle.pgql.lang.ir.CommonPathExpression;
import oracle.pgql.lang.ir.DerivedTable;
import oracle.pgql.lang.ir.Direction;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.GroupBy;
import oracle.pgql.lang.ir.OrderBy;
import oracle.pgql.lang.ir.OrderByElem;
import oracle.pgql.lang.ir.PathFindingGoal;
import oracle.pgql.lang.ir.PathMode;
import oracle.pgql.lang.ir.PgqlStatement;
import oracle.pgql.lang.ir.Projection;
import oracle.pgql.lang.ir.QueryEdge;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.ir.SelectQuery;
import oracle.pgql.lang.ir.VertexPairConnection;
import oracle.pgql.lang.ir.modify.DeleteClause;
import oracle.pgql.lang.ir.modify.EdgeInsertion;
import oracle.pgql.lang.ir.modify.InsertClause;
import oracle.pgql.lang.ir.modify.Insertion;
import oracle.pgql.lang.ir.modify.Modification;
import oracle.pgql.lang.ir.modify.ModifyQuery;
import oracle.pgql.lang.ir.modify.SetPropertyExpression;
import oracle.pgql.lang.ir.modify.Update;
import oracle.pgql.lang.ir.modify.UpdateClause;
import oracle.pgql.lang.ir.modify.VertexInsertion;
import oracle.pgql.lang.ir.unnest.OneRowPerEdge;
import oracle.pgql.lang.ir.unnest.OneRowPerMatch;
import oracle.pgql.lang.ir.unnest.OneRowPerStep;
import oracle.pgql.lang.ir.unnest.OneRowPerVertex;
import oracle.pgql.lang.ir.unnest.RowsPerMatch;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.TermType;

public class SpoofaxAstToGraphQuery {
    private static final String GENERATED_VAR_SUBSTR = "<<anonymous>>";
    private static final String ALL_PROPERTIES_CONSTRUCTOR = "AllProperties";
    private static final int POS_COMMON_PATH_EXPRESSIONS = 0;
    private static final int POS_SELECT_OR_MODIFY = 1;
    private static final int POS_GRAPH_NAME = 2;
    private static final int POS_TABLE_EXPRESSIONS = 3;
    private static final int POS_NON_PUSHED_DOWN_PREDICATES = 4;
    private static final int POS_GROUPBY = 5;
    private static final int POS_HAVING = 6;
    private static final int POS_ORDERBY = 7;
    private static final int POS_LIMITOFFSET = 8;
    private static final int POT_GRAPH_NAME_NAME = 0;
    private static final int POS_COMMON_PATH_EXPRESSION_NAME = 0;
    private static final int POS_COMMON_PATH_EXPRESSION_VERTICES = 1;
    private static final int POS_COMMON_PATH_EXPRESSION_CONNECTIONS = 2;
    private static final int POS_COMMON_PATH_EXPRESSION_CONSTRAINTS = 3;
    private static final int POS_COMMON_PATH_EXPRESSION_COST = 4;
    private static final int POS_COST_EXP = 0;
    private static final int POS_PROJECTION_DISTINCT = 0;
    private static final int POS_PROJECTION_ELEMS = 1;
    private static final int POS_MODIFY_MODIFICATIONS = 0;
    private static final int POS_INSERT_CLAUSE_INTO_CLAUSE = 0;
    private static final int POS_INSERT_CLAUSE_INSERTIONS = 1;
    private static final int POS_INSERT_CLAUSE_INTO_CLAUSE_GRAPH_NAME = 0;
    private static final int POS_VERTEX_INSERTION_NAME = 0;
    private static final int POS_VERTEX_INSERTION_ORIGIN_OFFSET = 1;
    private static final int POS_VERTEX_INSERTION_LABELS = 2;
    private static final int POS_VERTEX_INSERTION_PROPERTIES = 3;
    private static final int POS_EDGE_INSERTION_NAME = 0;
    private static final int POS_EDGE_INSERTION_ORIGIN_OFFSET = 1;
    private static final int POS_EDGE_INSERTION_SRC = 2;
    private static final int POS_EDGE_INSERTION_DST = 3;
    private static final int POS_EDGE_INSERTION_LABELS = 4;
    private static final int POS_EDGE_INSERTION_PROPERTIES = 5;
    private static final int POS_LABELS_LIST = 0;
    private static final int POS_UPDATE_CLAUSE_ELEMENTS = 0;
    private static final int POS_UPDATE_NAME = 0;
    private static final int POS_UPDATE_SET_PROPERTIES = 1;
    private static final int POS_SET_PROPERTIES_EXPRESSIONS = 0;
    private static final int POS_SET_PROPERTY_EXPRESSION_PROPERTY_ACCESS = 0;
    private static final int POS_SET_PROPERTY_EXPRESSION_VALUE_EXPRESSION = 1;
    private static final int POS_DELETION_ELEMENTS = 0;
    private static final int POS_VERTICES = 0;
    private static final int POS_CONNECTIONS = 1;
    private static final int POS_CONSTRAINTS = 2;
    private static final int POS_VERTEX_NAME = 0;
    private static final int POS_VERTEX_ORIGIN_OFFSET = 1;
    private static final int POS_EDGE_SRC = 0;
    private static final int POS_EDGE_NAME = 1;
    private static final int POS_EDGE_DST = 2;
    private static final int POS_EDGE_DIRECTION = 3;
    private static final int POS_EDGE_ORIGIN_OFFSET = 4;
    private static final int POS_PATH_SRC = 0;
    private static final int POS_PATH_DST = 1;
    private static final int POS_PATH_EXPRESSION = 2;
    private static final int POS_PATH_LABEL_EXPRESSION = 2;
    private static final int POS_PATH_LABEL_EXPRESSION_LABEL = 1;
    private static final int POS_PATH_QUANTIFIERS = 3;
    private static final int POS_PATH_QUANTIFIERS_MIN_HOPS = 0;
    private static final int POS_PATH_QUANTIFIERS_MAX_HOPS = 1;
    private static final int POS_PATH_NAME = 4;
    private static final int POS_PATH_DIRECTION = 5;
    private static final int POS_PATH_FINDING_GOAL = 6;
    private static final int POS_PATH_TOP_K_ANY_ALL = 7;
    private static final int POS_PATH_PATH_MODE = 8;
    private static final int POS_PATH_ROWS_PER_MATCH = 9;
    private static final int POS_ONE_ROW_PER_VERTEX_VERTEX = 0;
    private static final int POS_ONE_ROW_PER_EDGE_EDGE = 0;
    private static final int POS_ONE_ROW_PER_STEP_VERTEX_1 = 0;
    private static final int POS_ONE_ROW_PER_STEP_EDGE = 1;
    private static final int POS_ONE_ROW_PER_STEP_VERTEX_2 = 2;
    private static final int POS_ROWS_PER_MATCH_VARIABLE_NAME = 0;
    private static final int POS_ROWS_PER_MATCH_VARIABLE_ORIGIN_OFFSET = 1;
    private static final int POS_ORDERBY_EXP = 0;
    private static final int POS_ORDERBY_ORDERING = 1;
    private static final int POS_LIMIT = 0;
    private static final int POS_OFFSET = 1;
    private static final int POS_EXPASVAR_EXP = 0;
    private static final int POS_EXPASVAR_VAR = 1;
    private static final int POS_EXPASVAR_ANONYMOUS = 2;
    private static final int POS_EXPASVAR_ORIGIN_OFFSET = 3;
    private static final int IDENTIFIER_NAME = 0;
    private static final int IDENTIFIER_ORIGINNAME = 1;
    private static final int POS_EXP_PLUS_TYPE_EXP = 0;
    private static final int POS_ALLPROPERTIES_VARREF = 0;
    private static final int POS_ALLPROPERTIES_PREFIX = 1;
    private static final int POS_DERIVED_TABLE_LATERAL = 0;
    private static final int POS_DERIVED_TABLE_SUBQUERY = 1;
    private static final int POS_SUBQUERY_QUERY = 0;

    public static PgqlStatement translate(IStrategoTerm ast) throws PgqlException {
        String constructorName;
        switch (constructorName = ((IStrategoAppl)ast).getConstructor().getName()) {
            case "NormalizedQuery": {
                return SpoofaxAstToGraphQuery.translate(ast, new TranslationContext(new HashMap<IStrategoTerm, QueryVariable>(), new HashSet<String>(), new HashMap<String, CommonPathExpression>()));
            }
            case "CreatePropertyGraph": {
                return TranslateCreatePropertyGraph.translateCreatePropertyGraph(ast);
            }
            case "DropPropertyGraph": {
                return TranslateDropPropertyGraph.translateDropPropertyGraph(ast);
            }
            case "CreateExternalSchema": {
                return TranslateCreateExternalSchema.translateCreateExternalSchema(ast);
            }
            case "DropExternalSchema": {
                return TranslateDropExternalSchema.translateDropExternalSchema(ast);
            }
        }
        return null;
    }

    protected static GraphQuery translate(IStrategoTerm ast, TranslationContext ctx) throws PgqlException {
        IStrategoTerm commonPathExpressionsT = CommonTranslationUtil.getList(ast.getSubterm(0));
        List<CommonPathExpression> commonPathExpressions = SpoofaxAstToGraphQuery.getCommonPathExpressions(commonPathExpressionsT, ctx);
        IStrategoList tableExpressionsT = (IStrategoList)ast.getSubterm(3);
        ArrayList<Object> tableExpressions = new ArrayList<Object>();
        block24: for (IStrategoAppl tableExpressionT : tableExpressionsT) {
            String constructorName;
            switch (constructorName = tableExpressionT.getConstructor().getName()) {
                case "GraphPattern": {
                    GraphPattern graphPattern = SpoofaxAstToGraphQuery.translateGraphPattern(ctx, (IStrategoTerm)tableExpressionT);
                    tableExpressions.add(graphPattern);
                    continue block24;
                }
                case "DerivedTable": {
                    boolean lateral = CommonTranslationUtil.isSome(tableExpressionT.getSubterm(0));
                    String query = (SelectQuery)SpoofaxAstToGraphQuery.translate(tableExpressionT.getSubterm(1).getSubterm(0), ctx);
                    DerivedTable derivedTable = new DerivedTable((SelectQuery)query, lateral);
                    tableExpressions.add(derivedTable);
                    continue block24;
                }
            }
            throw new IllegalStateException(constructorName + " not supported");
        }
        IStrategoTerm groupByT = ast.getSubterm(5);
        GroupBy groupBy = SpoofaxAstToGraphQuery.getGroupBy(ctx, groupByT);
        Projection projection = null;
        IStrategoTerm selectOrModifyT = ast.getSubterm(1);
        String selectOrUpdate = ((IStrategoAppl)selectOrModifyT).getConstructor().getName();
        List<Modification> modifications = null;
        switch (selectOrUpdate) {
            case "SelectClause": {
                projection = SpoofaxAstToGraphQuery.translateSelectClause(ctx, selectOrModifyT);
                break;
            }
            case "ModifyClause": {
                IStrategoTerm modificationsT = selectOrModifyT.getSubterm(0);
                modifications = SpoofaxAstToGraphQuery.translateModifications(ctx, modificationsT);
                break;
            }
            default: {
                throw new IllegalStateException(selectOrUpdate);
            }
        }
        IStrategoTerm fromT = ast.getSubterm(2);
        SchemaQualifiedName graphName = null;
        if (CommonTranslationUtil.isSome(fromT)) {
            IStrategoTerm graphNameT = CommonTranslationUtil.getSomeValue(fromT).getSubterm(0);
            graphName = CommonTranslationUtil.getSchemaQualifiedName(graphNameT);
        }
        QueryExpression having = SpoofaxAstToGraphQuery.tryGetExpression(ast.getSubterm(6), ctx);
        IStrategoTerm orderByT = ast.getSubterm(7);
        List<OrderByElem> orderByElems = SpoofaxAstToGraphQuery.getOrderByElems(ctx, orderByT);
        OrderBy orderBy = new OrderBy(orderByElems);
        IStrategoTerm limitOffsetT = ast.getSubterm(8);
        QueryExpression limit = SpoofaxAstToGraphQuery.tryGetExpression(limitOffsetT.getSubterm(0), ctx);
        QueryExpression offset = SpoofaxAstToGraphQuery.tryGetExpression(limitOffsetT.getSubterm(1), ctx);
        switch (selectOrUpdate) {
            case "SelectClause": {
                return new SelectQuery(commonPathExpressions, projection, graphName, tableExpressions, groupBy, having, orderBy, limit, offset);
            }
            case "ModifyClause": {
                return new ModifyQuery(commonPathExpressions, modifications, graphName, tableExpressions, groupBy, having, orderBy, limit, offset);
            }
        }
        throw new IllegalStateException(selectOrUpdate);
    }

    private static GraphPattern translateGraphPattern(TranslationContext ctx, IStrategoTerm graphPatternT) throws PgqlException {
        IStrategoTerm verticesT = CommonTranslationUtil.getList(graphPatternT.getSubterm(0));
        HashSet<QueryVertex> vertices = new HashSet<QueryVertex>(SpoofaxAstToGraphQuery.getQueryVertices(verticesT, ctx));
        HashMap<String, QueryVertex> vertexMap = new HashMap<String, QueryVertex>();
        vertices.stream().forEach(vertex -> vertexMap.put(vertex.getName(), (QueryVertex)vertex));
        IStrategoTerm connectionsT = CommonTranslationUtil.getList(graphPatternT.getSubterm(1));
        LinkedHashSet<VertexPairConnection> connections = SpoofaxAstToGraphQuery.getConnections(connectionsT, ctx, vertexMap);
        SpoofaxAstToGraphQuery.giveAnonymousVariablesUniqueHiddenName(vertices, ctx);
        SpoofaxAstToGraphQuery.giveAnonymousVariablesUniqueHiddenName(connections, ctx);
        IStrategoTerm constraintsT = CommonTranslationUtil.getList(graphPatternT.getSubterm(2));
        LinkedHashSet<QueryExpression> constraints = SpoofaxAstToGraphQuery.getQueryExpressions(constraintsT, ctx);
        GraphPattern graphPattern = new GraphPattern(vertices, connections, constraints);
        return graphPattern;
    }

    private static Projection translateSelectClause(TranslationContext ctx, IStrategoTerm selectOrUpdateT) throws PgqlException {
        List<ExpAsVar> selectElems;
        IStrategoTerm distinctT = selectOrUpdateT.getSubterm(0);
        boolean distinct = CommonTranslationUtil.isSome(distinctT);
        IStrategoTerm projectionElemsT = selectOrUpdateT.getSubterm(1);
        if (projectionElemsT.getType() == TermType.APPL && ((IStrategoAppl)projectionElemsT).getConstructor().getName().equals("Star")) {
            selectElems = new ArrayList<ExpAsVar>();
        } else {
            projectionElemsT = projectionElemsT.getSubterm(0);
            selectElems = SpoofaxAstToGraphQuery.getExpAsVars(ctx, projectionElemsT);
        }
        Projection projection = new Projection(distinct, selectElems);
        return projection;
    }

    private static List<Modification> translateModifications(TranslationContext ctx, IStrategoTerm modificationsT) throws PgqlException {
        ArrayList<Modification> result = new ArrayList<Modification>();
        block10: for (IStrategoTerm modificationT : modificationsT) {
            String constructorName;
            switch (constructorName = ((IStrategoAppl)modificationT).getConstructor().getName()) {
                case "InsertClause": {
                    IStrategoTerm optionalIntoClauseT = modificationT.getSubterm(0);
                    SchemaQualifiedName graphName = null;
                    if (CommonTranslationUtil.isSome(optionalIntoClauseT)) {
                        IStrategoTerm intoClauseT = CommonTranslationUtil.getSomeValue(optionalIntoClauseT);
                        graphName = CommonTranslationUtil.getSchemaQualifiedName(intoClauseT.getSubterm(0));
                    }
                    IStrategoTerm insertionsT = modificationT.getSubterm(1);
                    ArrayList<Insertion> insertions = new ArrayList<Insertion>();
                    for (IStrategoTerm insertionT : insertionsT) {
                        Insertion insertion = SpoofaxAstToGraphQuery.translateInsertion(ctx, insertionT);
                        insertions.add(insertion);
                    }
                    result.add((Modification)new InsertClause(graphName, insertions));
                    continue block10;
                }
                case "UpdateClause": {
                    IStrategoTerm updatesT = modificationT.getSubterm(0);
                    ArrayList<Update> updates = new ArrayList<Update>();
                    for (IStrategoTerm updateT : updatesT) {
                        IStrategoTerm elementT = updateT.getSubterm(0);
                        QueryExpression.VarRef element = (QueryExpression.VarRef)CommonTranslationUtil.translateExp(elementT, ctx);
                        IStrategoTerm setPropertiesT = updateT.getSubterm(1);
                        List<SetPropertyExpression> setPropertyExpressions = SpoofaxAstToGraphQuery.getSetPropertyExpressions(ctx, setPropertiesT);
                        updates.add(new Update(element, setPropertyExpressions));
                    }
                    result.add((Modification)new UpdateClause(updates));
                    continue block10;
                }
                case "DeleteClause": {
                    IStrategoTerm elementsT = modificationT.getSubterm(0);
                    ArrayList<QueryExpression.VarRef> deletions = new ArrayList<QueryExpression.VarRef>();
                    for (IStrategoTerm elementT : elementsT) {
                        deletions.add((QueryExpression.VarRef)CommonTranslationUtil.translateExp(elementT, ctx));
                    }
                    result.add((Modification)new DeleteClause(deletions));
                    continue block10;
                }
            }
            throw new IllegalArgumentException(constructorName);
        }
        return result;
    }

    private static Insertion translateInsertion(TranslationContext ctx, IStrategoTerm insertionT) throws PgqlException {
        String constructorName;
        switch (constructorName = ((IStrategoAppl)insertionT).getConstructor().getName()) {
            case "VertexInsertion": {
                String vertexName = CommonTranslationUtil.getString(insertionT.getSubterm(0));
                QueryVertex vertex = new QueryVertex(vertexName, false);
                IStrategoTerm originOffset = insertionT.getSubterm(1);
                ctx.addVar((QueryVariable)vertex, vertexName, originOffset);
                IStrategoTerm labelsT = insertionT.getSubterm(2);
                List<QueryExpression> labels = SpoofaxAstToGraphQuery.getLabels(ctx, labelsT);
                IStrategoTerm propertiesT = insertionT.getSubterm(3);
                List<SetPropertyExpression> properties = SpoofaxAstToGraphQuery.getProperties(ctx, propertiesT);
                return new VertexInsertion(vertex, labels, properties);
            }
            case "DirectedEdgeInsertion": {
                String edgeName = CommonTranslationUtil.getString(insertionT.getSubterm(0));
                IStrategoTerm srcVarRefT = insertionT.getSubterm(2).getSubterm(0);
                QueryVertex src = SpoofaxAstToGraphQuery.dereferenceQueryVertex(CommonTranslationUtil.getVariable(ctx, srcVarRefT));
                IStrategoTerm dstVarRefT = insertionT.getSubterm(3).getSubterm(0);
                QueryVertex dst = SpoofaxAstToGraphQuery.dereferenceQueryVertex(CommonTranslationUtil.getVariable(ctx, dstVarRefT));
                QueryEdge edge = new QueryEdge(src, dst, edgeName, false, Direction.OUTGOING);
                IStrategoTerm originOffset = insertionT.getSubterm(1);
                ctx.addVar((QueryVariable)edge, edgeName, originOffset);
                IStrategoTerm labelsT = insertionT.getSubterm(4);
                List<QueryExpression> labels = SpoofaxAstToGraphQuery.getLabels(ctx, labelsT);
                IStrategoTerm propertiesT = insertionT.getSubterm(5);
                List<SetPropertyExpression> properties = SpoofaxAstToGraphQuery.getProperties(ctx, propertiesT);
                return new EdgeInsertion(edge, labels, properties);
            }
        }
        throw new IllegalArgumentException(constructorName);
    }

    private static QueryVertex dereferenceQueryVertex(QueryVariable var) throws PgqlException {
        switch (var.getVariableType()) {
            case VERTEX: {
                return (QueryVertex)var;
            }
            case EXP_AS_VAR: {
                QueryExpression exp = ((ExpAsVar)var).getExp();
                if (exp.getExpType() != QueryExpression.ExpressionType.VARREF) {
                    throw new PgqlException("Not a vertex reference: " + exp);
                }
                QueryVariable nestedVar = ((QueryExpression.VarRef)exp).getVariable();
                return SpoofaxAstToGraphQuery.dereferenceQueryVertex(nestedVar);
            }
        }
        throw new PgqlException("Not a vertex reference: " + var);
    }

    private static List<QueryExpression> getLabels(TranslationContext ctx, IStrategoTerm labelsT) throws PgqlException {
        ArrayList<QueryExpression> result = new ArrayList<QueryExpression>();
        if (CommonTranslationUtil.isSome(labelsT)) {
            IStrategoTerm labelsListT = CommonTranslationUtil.getSomeValue(labelsT).getSubterm(0);
            for (IStrategoTerm labelT : labelsListT) {
                String label = CommonTranslationUtil.getString(labelT.getSubterm(0));
                result.add((QueryExpression)new QueryExpression.Constant.ConstString(label));
            }
        }
        return result;
    }

    private static List<SetPropertyExpression> getProperties(TranslationContext ctx, IStrategoTerm propertiesT) throws PgqlException {
        if (CommonTranslationUtil.isSome(propertiesT)) {
            return SpoofaxAstToGraphQuery.getSetPropertyExpressions(ctx, CommonTranslationUtil.getSomeValue(propertiesT));
        }
        return new ArrayList<SetPropertyExpression>();
    }

    private static List<SetPropertyExpression> getSetPropertyExpressions(TranslationContext ctx, IStrategoTerm setPropertiesT) throws PgqlException {
        ArrayList<SetPropertyExpression> result = new ArrayList<SetPropertyExpression>();
        IStrategoTerm expressionsT = setPropertiesT.getSubterm(0);
        for (IStrategoTerm expressionT : expressionsT) {
            IStrategoTerm propertyAccessT = expressionT.getSubterm(0);
            QueryExpression propertyAccess = CommonTranslationUtil.translateExp(propertyAccessT, ctx);
            IStrategoTerm valueExpressionT = expressionT.getSubterm(1);
            QueryExpression valueExpression = CommonTranslationUtil.translateExp(valueExpressionT, ctx);
            if (propertyAccess.getExpType() != QueryExpression.ExpressionType.PROP_ACCESS) continue;
            result.add(new SetPropertyExpression((QueryExpression.PropertyAccess)propertyAccess, valueExpression));
        }
        return result;
    }

    private static QueryExpression tryGetExpression(IStrategoTerm term, TranslationContext ctx) throws PgqlException {
        if (CommonTranslationUtil.isNone(term)) {
            return null;
        }
        IStrategoAppl expT = (IStrategoAppl)term.getSubterm(0).getSubterm(0);
        return CommonTranslationUtil.translateExp((IStrategoTerm)expT, ctx);
    }

    private static List<CommonPathExpression> getCommonPathExpressions(IStrategoTerm pathPatternsT, TranslationContext ctx) throws PgqlException {
        ArrayList<CommonPathExpression> result = new ArrayList<CommonPathExpression>();
        for (IStrategoTerm pathPatternT : pathPatternsT) {
            CommonPathExpression commonPathExpression = SpoofaxAstToGraphQuery.getPathExpression(pathPatternT, ctx);
            ctx.getCommonPathExpressions().put(commonPathExpression.getName(), commonPathExpression);
            result.add(commonPathExpression);
        }
        return result;
    }

    private static CommonPathExpression getPathExpression(IStrategoTerm pathPatternT, TranslationContext ctx) throws PgqlException {
        String name = CommonTranslationUtil.getString(pathPatternT.getSubterm(0));
        IStrategoTerm verticesT = CommonTranslationUtil.getList(pathPatternT.getSubterm(1));
        List<QueryVertex> vertices = SpoofaxAstToGraphQuery.getQueryVertices(verticesT, ctx);
        HashMap<String, QueryVertex> vertexMap = new HashMap<String, QueryVertex>();
        vertices.stream().forEach(vertex -> vertexMap.put(vertex.getName(), (QueryVertex)vertex));
        IStrategoTerm connectionsT = CommonTranslationUtil.getList(pathPatternT.getSubterm(2));
        ArrayList<Object> connections = new ArrayList<Object>();
        for (IStrategoTerm connectionT : connectionsT) {
            if (((IStrategoAppl)connectionT).getConstructor().getName().equals("Edge")) {
                connections.add(SpoofaxAstToGraphQuery.getQueryEdge(connectionT, ctx, vertexMap));
                continue;
            }
            connections.add(SpoofaxAstToGraphQuery.getPath(connectionT, ctx, vertexMap));
        }
        IStrategoTerm constraintsT = CommonTranslationUtil.getList(pathPatternT.getSubterm(3));
        LinkedHashSet<QueryExpression> constraints = SpoofaxAstToGraphQuery.getQueryExpressions(constraintsT, ctx);
        IStrategoTerm costT = pathPatternT.getSubterm(4);
        QueryExpression cost = CommonTranslationUtil.isNone(costT) ? null : CommonTranslationUtil.translateExp(CommonTranslationUtil.getSomeValue(costT).getSubterm(0), ctx);
        return new CommonPathExpression(name, vertices, connections, constraints, cost);
    }

    private static List<QueryVertex> getQueryVertices(IStrategoTerm verticesT, TranslationContext ctx) {
        ArrayList<QueryVertex> vertices = new ArrayList<QueryVertex>(verticesT.getSubtermCount());
        for (IStrategoTerm vertexT : verticesT) {
            String vertexName = CommonTranslationUtil.getString(vertexT.getSubterm(0));
            IStrategoTerm originOffset = vertexT.getSubterm(1);
            boolean anonymous = vertexName.contains(GENERATED_VAR_SUBSTR);
            QueryVertex vertex = new QueryVertex(vertexName, anonymous);
            ctx.addVar((QueryVariable)vertex, vertexName, originOffset);
            vertices.add(vertex);
        }
        return vertices;
    }

    private static LinkedHashSet<QueryExpression> getQueryExpressions(IStrategoTerm constraintsT, TranslationContext ctx) throws PgqlException {
        LinkedHashSet<QueryExpression> constraints = new LinkedHashSet<QueryExpression>(constraintsT.getSubtermCount());
        for (IStrategoTerm constraintT : constraintsT) {
            QueryExpression exp = CommonTranslationUtil.translateExp(constraintT, ctx);
            SpoofaxAstToGraphQuery.addQueryExpressions(exp, constraints);
        }
        return constraints;
    }

    private static void addQueryExpressions(QueryExpression exp, Set<QueryExpression> constraints) {
        if (exp.getExpType() == QueryExpression.ExpressionType.AND) {
            QueryExpression.LogicalExpression.And and = (QueryExpression.LogicalExpression.And)exp;
            SpoofaxAstToGraphQuery.addQueryExpressions(and.getExp1(), constraints);
            SpoofaxAstToGraphQuery.addQueryExpressions(and.getExp2(), constraints);
        } else {
            constraints.add(exp);
        }
    }

    private static LinkedHashSet<VertexPairConnection> getConnections(IStrategoTerm connectionsT, TranslationContext ctx, Map<String, QueryVertex> vertexMap) throws PgqlException {
        LinkedHashSet<VertexPairConnection> result = new LinkedHashSet<VertexPairConnection>();
        block11: for (IStrategoTerm connectionT : connectionsT) {
            String consName;
            switch (consName = ((IStrategoAppl)connectionT).getConstructor().getName()) {
                case "Edge": {
                    result.add((VertexPairConnection)SpoofaxAstToGraphQuery.getQueryEdge(connectionT, ctx, vertexMap));
                    continue block11;
                }
                case "Path": {
                    result.add((VertexPairConnection)SpoofaxAstToGraphQuery.getPath(connectionT, ctx, vertexMap));
                    continue block11;
                }
                case "ComplexRegularExpressionNotSupported": 
                case "ComplexParenthesizedRegularExpressionNotSupported": {
                    continue block11;
                }
            }
            throw new IllegalArgumentException(consName);
        }
        return result;
    }

    private static QueryEdge getQueryEdge(IStrategoTerm edgeT, TranslationContext ctx, Map<String, QueryVertex> vertexMap) {
        String name = CommonTranslationUtil.getString(edgeT.getSubterm(1));
        String srcName = CommonTranslationUtil.getString(edgeT.getSubterm(0));
        String dstName = CommonTranslationUtil.getString(edgeT.getSubterm(2));
        Direction direction = SpoofaxAstToGraphQuery.getDirection(edgeT.getSubterm(3));
        IStrategoTerm originOffset = edgeT.getSubterm(4);
        QueryVertex src = SpoofaxAstToGraphQuery.getQueryVertex(vertexMap, srcName);
        QueryVertex dst = SpoofaxAstToGraphQuery.getQueryVertex(vertexMap, dstName);
        QueryEdge edge = name.contains(GENERATED_VAR_SUBSTR) ? new QueryEdge(src, dst, name, true, direction) : new QueryEdge(src, dst, name, false, direction);
        ctx.addVar((QueryVariable)edge, name, originOffset);
        return edge;
    }

    private static Direction getDirection(IStrategoTerm directionT) {
        String constructorName;
        switch (constructorName = CommonTranslationUtil.getConstructorName(directionT)) {
            case "Outgoing": {
                return Direction.OUTGOING;
            }
            case "Incoming": {
                return Direction.INCOMING;
            }
            case "Undirected": {
                return Direction.ANY;
            }
        }
        throw new IllegalArgumentException(constructorName);
    }

    private static QueryVertex getQueryVertex(Map<String, QueryVertex> vertexMap, String vertexName) {
        QueryVariable queryVariable = (QueryVariable)vertexMap.get(vertexName);
        if (queryVariable.getVariableType() == QueryVariable.VariableType.VERTEX) {
            return (QueryVertex)queryVariable;
        }
        QueryVertex dummyVertex = new QueryVertex(vertexName, false);
        return dummyVertex;
    }

    private static QueryPath getPath(IStrategoTerm pathT, TranslationContext ctx, Map<String, QueryVertex> vertexMap) throws PgqlException {
        String pathFindingGoal = ((IStrategoAppl)pathT.getSubterm(6)).getConstructor().getName();
        IStrategoAppl pathExpressionT = (IStrategoAppl)pathT.getSubterm(2);
        CommonPathExpression commonPathExpression = pathExpressionT.getConstructor().getName().equals("CommonPathExpression") ? SpoofaxAstToGraphQuery.getPathExpression((IStrategoTerm)pathExpressionT, ctx) : SpoofaxAstToGraphQuery.getCommonPathExpressionFromReaches(pathT, ctx);
        switch (pathFindingGoal) {
            case "Reaches": {
                return SpoofaxAstToGraphQuery.getQueryPath(pathT, ctx, vertexMap, PathFindingGoal.REACHES, commonPathExpression);
            }
            case "Shortest": {
                return SpoofaxAstToGraphQuery.getQueryPath(pathT, ctx, vertexMap, PathFindingGoal.SHORTEST, commonPathExpression);
            }
            case "Cheapest": {
                return SpoofaxAstToGraphQuery.getQueryPath(pathT, ctx, vertexMap, PathFindingGoal.CHEAPEST, commonPathExpression);
            }
            case "All": {
                return SpoofaxAstToGraphQuery.getQueryPath(pathT, ctx, vertexMap, PathFindingGoal.ALL, commonPathExpression);
            }
        }
        throw new UnsupportedOperationException(pathFindingGoal);
    }

    private static CommonPathExpression getCommonPathExpressionFromReaches(IStrategoTerm pathT, TranslationContext ctx) {
        String label = CommonTranslationUtil.getString(pathT.getSubterm(2).getSubterm(1));
        CommonPathExpression commonPathExpression = ctx.getCommonPathExpressions().get(label);
        if (commonPathExpression == null) {
            QueryVertex src = new QueryVertex("n", true);
            QueryVertex dst = new QueryVertex("m", true);
            QueryEdge edge = new QueryEdge(src, dst, "e", true, Direction.OUTGOING);
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(new QueryExpression.VarRef((QueryVariable)edge));
            args.add(new QueryExpression.Constant.ConstString(label));
            QueryExpression.FunctionCall labelExp = new QueryExpression.FunctionCall("has_label", args);
            ArrayList<QueryVertex> vertices = new ArrayList<QueryVertex>();
            vertices.add(src);
            vertices.add(dst);
            ArrayList<QueryEdge> connections = new ArrayList<QueryEdge>();
            connections.add(edge);
            HashSet<QueryExpression.FunctionCall> constraints = new HashSet<QueryExpression.FunctionCall>();
            constraints.add(labelExp);
            commonPathExpression = new CommonPathExpression(label, vertices, connections, constraints);
        }
        return commonPathExpression;
    }

    private static QueryPath getQueryPath(IStrategoTerm pathT, TranslationContext ctx, Map<String, QueryVertex> vertexMap, PathFindingGoal goal, CommonPathExpression commonPathExpression) throws PgqlException {
        String srcName = CommonTranslationUtil.getString(pathT.getSubterm(0));
        String dstName = CommonTranslationUtil.getString(pathT.getSubterm(1));
        long minHops = SpoofaxAstToGraphQuery.getMinHops(pathT);
        long maxHops = SpoofaxAstToGraphQuery.getMaxHops(pathT);
        String name = CommonTranslationUtil.getString(pathT.getSubterm(4));
        Direction direction = SpoofaxAstToGraphQuery.getDirection(pathT.getSubterm(5));
        QueryVertex src = SpoofaxAstToGraphQuery.getQueryVertex(vertexMap, srcName);
        QueryVertex dst = SpoofaxAstToGraphQuery.getQueryVertex(vertexMap, dstName);
        int kValue = -1;
        boolean withTies = false;
        block0 : switch (goal) {
            case ALL: {
                break;
            }
            case REACHES: {
                kValue = 1;
                break;
            }
            case SHORTEST: 
            case CHEAPEST: {
                IStrategoTerm topKAnyAllT = pathT.getSubterm(7);
                if (!CommonTranslationUtil.isSome(topKAnyAllT)) break;
                IStrategoAppl topKAnyAllContent = (IStrategoAppl)CommonTranslationUtil.getSomeValue(topKAnyAllT);
                switch (topKAnyAllContent.getName()) {
                    case "TopK": {
                        kValue = CommonTranslationUtil.parseInt(topKAnyAllContent.getSubterm(0));
                        break block0;
                    }
                    case "Any": {
                        kValue = 1;
                        break block0;
                    }
                    case "All": {
                        kValue = 1;
                        withTies = true;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(topKAnyAllContent.getName());
            }
            default: {
                throw new UnsupportedOperationException(goal.name());
            }
        }
        PathMode pathMode = SpoofaxAstToGraphQuery.getPathMode(pathT.getSubterm(8));
        RowsPerMatch rowsPerMatch = SpoofaxAstToGraphQuery.getRowsPerMatch(pathT.getSubterm(9), ctx);
        QueryPath path = new QueryPath(src, dst, name, commonPathExpression, true, minHops, maxHops, goal, kValue, withTies, pathMode, direction, rowsPerMatch);
        return path;
    }

    private static PathMode getPathMode(IStrategoTerm pathModeT) {
        String constructorName;
        switch (constructorName = ((IStrategoAppl)pathModeT).getConstructor().getName()) {
            case "Walk": {
                return PathMode.WALK;
            }
            case "Trail": {
                return PathMode.TRAIL;
            }
            case "Acyclic": {
                return PathMode.ACYCLIC;
            }
            case "Simple": {
                return PathMode.SIMPLE;
            }
        }
        throw new IllegalArgumentException(constructorName);
    }

    private static RowsPerMatch getRowsPerMatch(IStrategoTerm optionalRowsPerMatchT, TranslationContext ctx) {
        String constructorName;
        if (CommonTranslationUtil.isNone(optionalRowsPerMatchT)) {
            return new OneRowPerMatch();
        }
        IStrategoAppl rowsPerMatchT = (IStrategoAppl)CommonTranslationUtil.getSomeValue(optionalRowsPerMatchT);
        switch (constructorName = rowsPerMatchT.getConstructor().getName()) {
            case "OneRowPerMatch": {
                return new OneRowPerMatch();
            }
            case "OneRowPerVertex": {
                QueryVertex vertex = SpoofaxAstToGraphQuery.getRowsPerMatchVertex(rowsPerMatchT, 0, ctx);
                return new OneRowPerVertex(vertex);
            }
            case "OneRowPerEdge": {
                QueryEdge edge = SpoofaxAstToGraphQuery.getRowsPerMatchEdge(rowsPerMatchT, 0, ctx);
                return new OneRowPerEdge(edge);
            }
            case "OneRowPerStep": {
                QueryVertex vertex1 = SpoofaxAstToGraphQuery.getRowsPerMatchVertex(rowsPerMatchT, 0, ctx);
                QueryEdge edge = SpoofaxAstToGraphQuery.getRowsPerMatchEdge(rowsPerMatchT, 1, ctx);
                QueryVertex vertex2 = SpoofaxAstToGraphQuery.getRowsPerMatchVertex(rowsPerMatchT, 2, ctx);
                return new OneRowPerStep(vertex1, edge, vertex2);
            }
        }
        throw new IllegalArgumentException(constructorName);
    }

    private static QueryVertex getRowsPerMatchVertex(IStrategoAppl rowsPerMatchT, int variablePosition, TranslationContext ctx) {
        IStrategoTerm vertexVariableT = rowsPerMatchT.getSubterm(variablePosition);
        String vertexName = CommonTranslationUtil.getString(vertexVariableT.getSubterm(0));
        QueryVertex vertex = new QueryVertex(vertexName, false);
        IStrategoTerm originOffset = vertexVariableT.getSubterm(1);
        ctx.addVar((QueryVariable)vertex, vertexName, originOffset);
        return vertex;
    }

    private static QueryEdge getRowsPerMatchEdge(IStrategoAppl rowsPerMatchT, int variablePosition, TranslationContext ctx) {
        IStrategoTerm edgeVariableT = rowsPerMatchT.getSubterm(variablePosition);
        String edgeName = CommonTranslationUtil.getString(edgeVariableT.getSubterm(0));
        QueryEdge edge = new QueryEdge(null, null, edgeName, false, null);
        IStrategoTerm originOffset = edgeVariableT.getSubterm(1);
        ctx.addVar((QueryVariable)edge, edgeName, originOffset);
        return edge;
    }

    private static long getMinHops(IStrategoTerm pathT) throws PgqlException {
        return SpoofaxAstToGraphQuery.getMinMaxHops(pathT, true);
    }

    private static long getMaxHops(IStrategoTerm pathT) throws PgqlException {
        return SpoofaxAstToGraphQuery.getMinMaxHops(pathT, false);
    }

    private static long getMinMaxHops(IStrategoTerm pathT, boolean min) throws PgqlException {
        IStrategoTerm pathQuantifiersT = pathT.getSubterm(3);
        if (CommonTranslationUtil.isSome(pathQuantifiersT)) {
            pathQuantifiersT = CommonTranslationUtil.getSomeValue(pathQuantifiersT);
            int position = min ? 0 : 1;
            return CommonTranslationUtil.parseLong(pathQuantifiersT.getSubterm(position));
        }
        return 1L;
    }

    private static void giveAnonymousVariablesUniqueHiddenName(Collection<? extends QueryVariable> variables, TranslationContext ctx) {
        for (QueryVariable queryVariable : variables) {
            if (queryVariable.isAnonymous()) {
                String name = queryVariable.getName().replace(GENERATED_VAR_SUBSTR, "anonymous");
                while (ctx.isVariableNameInUse(name)) {
                    name = name + "_2";
                }
                queryVariable.setName(name);
            }
            if (queryVariable.getVariableType() != QueryVariable.VariableType.PATH) continue;
            QueryPath path = (QueryPath)queryVariable;
            SpoofaxAstToGraphQuery.giveAnonymousVariablesUniqueHiddenName(path.getConnections(), ctx);
            SpoofaxAstToGraphQuery.giveAnonymousVariablesUniqueHiddenName(path.getVertices(), ctx);
        }
    }

    private static GroupBy getGroupBy(TranslationContext ctx, IStrategoTerm groupByT) throws PgqlException {
        String consName;
        switch (consName = ((IStrategoAppl)groupByT).getConstructor().getName()) {
            case "Some": {
                IStrategoTerm groupByElemsT = CommonTranslationUtil.getList(groupByT);
                return new GroupBy(SpoofaxAstToGraphQuery.getExpAsVars(ctx, groupByElemsT));
            }
            case "CreateOneGroup": {
                return new GroupBy(Collections.emptyList());
            }
            case "None": {
                return null;
            }
        }
        throw new IllegalArgumentException(consName);
    }

    private static List<ExpAsVar> getExpAsVars(TranslationContext ctx, IStrategoTerm expAsVarsT) throws PgqlException {
        ArrayList<ExpAsVar> expAsVars = new ArrayList<ExpAsVar>(expAsVarsT.getSubtermCount());
        for (IStrategoTerm expAsVarT : expAsVarsT) {
            if (((IStrategoAppl)expAsVarT).getConstructor().getName().equals(ALL_PROPERTIES_CONSTRUCTOR)) {
                QueryExpression.VarRef varRef = (QueryExpression.VarRef)CommonTranslationUtil.translateExp(expAsVarT.getSubterm(0), ctx);
                String expAsVarName = "<<anonymous>>_" + varRef + ".*";
                IStrategoTerm prefixT = expAsVarT.getSubterm(1);
                String prefix = CommonTranslationUtil.isSome(prefixT) ? CommonTranslationUtil.getString(prefixT) : null;
                ExpAsVar expAsVar = new ExpAsVar((QueryExpression)new QueryExpression.AllProperties(varRef, prefix), expAsVarName, true, expAsVarName);
                expAsVars.add(expAsVar);
                continue;
            }
            QueryExpression exp = CommonTranslationUtil.translateExp(expAsVarT.getSubterm(0), ctx);
            IStrategoTerm columnName = expAsVarT.getSubterm(1);
            String varName = CommonTranslationUtil.getString(columnName.getSubterm(0));
            IStrategoTerm originNameT = columnName.getSubterm(1);
            String originName = CommonTranslationUtil.isNone(originNameT) ? null : CommonTranslationUtil.getString(originNameT);
            boolean anonymous = ((IStrategoAppl)expAsVarT.getSubterm(2)).getConstructor().getName().equals("Anonymous");
            IStrategoTerm originOffset = expAsVarT.getSubterm(3);
            ExpAsVar expAsVar = new ExpAsVar(exp, varName, anonymous, originName);
            expAsVars.add(expAsVar);
            ctx.addVar((QueryVariable)expAsVar, varName, originOffset);
        }
        return expAsVars;
    }

    private static List<OrderByElem> getOrderByElems(TranslationContext ctx, IStrategoTerm orderByT) throws PgqlException {
        ArrayList<OrderByElem> orderByElems = new ArrayList<OrderByElem>();
        if (!CommonTranslationUtil.isNone(orderByT)) {
            IStrategoTerm orderByElemsT = CommonTranslationUtil.getList(orderByT);
            for (IStrategoTerm orderByElemT : orderByElemsT) {
                QueryExpression exp = CommonTranslationUtil.translateExp(orderByElemT.getSubterm(0), ctx);
                boolean ascending = ((IStrategoAppl)orderByElemT.getSubterm(1)).getConstructor().getName().equals("Asc");
                orderByElems.add(new OrderByElem(exp, ascending));
            }
        }
        return orderByElems;
    }
}

