/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.synchronizer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import oracle.pgx.api.EdgeBuilder;
import oracle.pgx.api.GraphChangeSet;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.VertexBuilder;
import oracle.pgx.api.VertexModifier;
import oracle.pgx.api.internal.synchronizer.KeyValue;
import oracle.pgx.api.internal.synchronizer.ResultSetConverter;
import oracle.pgx.common.PartitionedId;
import oracle.pgx.common.types.ChangeType;
import oracle.pgx.common.types.IdStrategy;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.RdbmsEntityProviderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetToChangeSetHandler {
    private GraphChangeSet changeSet;
    private PgxGraph graph;
    private Set<Long> edgesToBeRemoved = new HashSet<Long>();
    private Set<String> partitionedEdgesToBeRemoved = new HashSet<String>();
    private static final Logger LOG = LoggerFactory.getLogger(ResultSetToChangeSetHandler.class);

    public ResultSetToChangeSetHandler(GraphChangeSet changeSet, PgxGraph graph) {
        this.changeSet = changeSet;
        this.graph = graph;
    }

    public Set<Long> getEdgesToBeRemoved() {
        return this.edgesToBeRemoved;
    }

    public Set<String> getPartitionedEdgesToBeRemoved() {
        return this.partitionedEdgesToBeRemoved;
    }

    private boolean addEdgeChanges(ResultSet rs, RdbmsEntityProviderConfig rdbmsProvider, boolean isUpdate) throws SQLException {
        Object edgeId = ResultSetConverter.getKeyColumnValue(rs, rdbmsProvider);
        KeyValue destId = ResultSetConverter.getKeyColumnValueAndCheckIfNull(rs, rdbmsProvider.getDestinationVertexKeyType(), rdbmsProvider.getDestinationColumn());
        KeyValue sourceId = ResultSetConverter.getKeyColumnValueAndCheckIfNull(rs, rdbmsProvider.getSourceVertexKeyType(), rdbmsProvider.getSourceColumn());
        String partitionedEdgeId = PartitionedId.createPartitionedId((String)rdbmsProvider.getName(), (Object[])new Object[]{edgeId});
        if (this.graph.getEdgeIdStrategy() == IdStrategy.PARTITIONED_IDS) {
            this.partitionedEdgesToBeRemoved.add(partitionedEdgeId);
        } else {
            this.edgesToBeRemoved.add((Long)edgeId);
        }
        if (isUpdate) {
            if (this.graph.getEdgeIdStrategy() == IdStrategy.PARTITIONED_IDS) {
                this.changeSet.resetEdge(partitionedEdgeId);
            } else {
                this.changeSet.resetEdge((Long)edgeId);
            }
        }
        if (sourceId.isNull() || destId.isNull()) {
            return false;
        }
        EdgeBuilder<Object> edgeBuilder = null;
        edgeBuilder = this.graph.getEdgeIdStrategy() == IdStrategy.PARTITIONED_IDS ? this.changeSet.addEdge(partitionedEdgeId, PartitionedId.createPartitionedId((String)rdbmsProvider.getSourceVertexProvider(), (Object[])new Object[]{sourceId.getKeyValue()}), PartitionedId.createPartitionedId((String)rdbmsProvider.getDestinationVertexProvider(), (Object[])new Object[]{destId.getKeyValue()})) : this.changeSet.addEdge((long)((Long)edgeId), sourceId.getKeyValue(), destId.getKeyValue()).setLabel(rdbmsProvider.getName());
        this.addPropertiesToGraphBuilder(edgeBuilder, rs, rdbmsProvider);
        return true;
    }

    public long addEdgesToChangeSet(ResultSet rs, RdbmsEntityProviderConfig rdbmsProvider) throws SQLException {
        LOG.debug("Adding edges resultSet to changeset for: {}", (Object)rdbmsProvider.getName());
        long addedEdges = 0L;
        while (rs.next()) {
            if (!this.addEdgeChanges(rs, rdbmsProvider, false)) continue;
            ++addedEdges;
        }
        return addedEdges;
    }

    public long addVerticesToChangeSet(ResultSet rs, RdbmsEntityProviderConfig rdbmsProvider) throws SQLException {
        LOG.debug("Adding vertices resultSet to changeset for: {}", (Object)rdbmsProvider.getName());
        long addedVertices = 0L;
        while (rs.next()) {
            Object vertexId = ResultSetConverter.getKeyColumnValue(rs, rdbmsProvider);
            VertexBuilder<Object> vertexBuilder = null;
            if (this.graph.getVertexIdStrategy() == IdStrategy.PARTITIONED_IDS) {
                String partitionedVertexId = PartitionedId.createPartitionedId((String)rdbmsProvider.getName(), (Object[])new Object[]{vertexId});
                vertexBuilder = this.changeSet.addVertex(partitionedVertexId);
            } else {
                vertexBuilder = this.changeSet.addVertex(vertexId).addLabel(rdbmsProvider.getName());
            }
            this.addPropertiesToGraphBuilder(vertexBuilder, rs, rdbmsProvider);
            ++addedVertices;
        }
        return addedVertices;
    }

    public long removeEdgesFromChangeSet(ResultSet rs, RdbmsEntityProviderConfig rdbmsProvider) throws SQLException {
        LOG.debug("Removing edges resultSet to changeset for: {}", (Object)rdbmsProvider.getName());
        long removedEdges = 0L;
        while (rs.next()) {
            Object edgeId = ResultSetConverter.getKeyColumnValue(rs, rdbmsProvider);
            KeyValue destId = ResultSetConverter.getKeyColumnValueAndCheckIfNull(rs, rdbmsProvider.getDestinationVertexKeyType(), "v_dst");
            KeyValue sourceId = ResultSetConverter.getKeyColumnValueAndCheckIfNull(rs, rdbmsProvider.getSourceVertexKeyType(), "v_src");
            if (destId.isNull() || sourceId.isNull()) continue;
            if (this.graph.getEdgeIdStrategy() == IdStrategy.PARTITIONED_IDS) {
                String partitionedEdgeId = PartitionedId.createPartitionedId((String)rdbmsProvider.getName(), (Object[])new Object[]{edgeId});
                ChangeType changeType = this.changeSet.getEdgeChangeType(partitionedEdgeId);
                this.removeEntityWithId(changeType, partitionedEdgeId, this.changeSet::resetEdge, this.changeSet::removeEdge);
            } else {
                ChangeType changeType = this.changeSet.getEdgeChangeType(edgeId);
                this.removeEntityWithId(changeType, (Long)edgeId, this.changeSet::resetEdge, this.changeSet::removeEdge);
            }
            ++removedEdges;
        }
        return removedEdges;
    }

    public long removeVerticesFromChangeSet(ResultSet rs, RdbmsEntityProviderConfig rdbmsProvider) throws SQLException {
        LOG.debug("Removing vertices resultSet to changeset for: {}", (Object)rdbmsProvider.getName());
        long removedVertices = 0L;
        while (rs.next()) {
            Object vertexId = ResultSetConverter.getKeyColumnValue(rs, rdbmsProvider);
            if (this.graph.getVertexIdStrategy() == IdStrategy.PARTITIONED_IDS) {
                vertexId = PartitionedId.createPartitionedId((String)rdbmsProvider.getName(), (Object[])new Object[]{vertexId});
            }
            ChangeType changeType = this.changeSet.getVertexChangeType(vertexId);
            this.removeEntityWithId(changeType, vertexId, this.changeSet::resetVertex, this.changeSet::removeVertex);
            ++removedVertices;
        }
        return removedVertices;
    }

    private <T> void removeEntityWithId(ChangeType changeType, T entityId, Consumer<T> resetEntity, Consumer<T> removeEntity) {
        if (changeType == null) {
            removeEntity.accept(entityId);
            return;
        }
        switch (changeType) {
            case ADD: {
                resetEntity.accept(entityId);
                break;
            }
            case MODIFY: {
                resetEntity.accept(entityId);
                removeEntity.accept(entityId);
            }
        }
    }

    public long updateEdgesToChangeSet(ResultSet rs, RdbmsEntityProviderConfig rdbmsProvider) throws SQLException {
        LOG.debug("Updating edges resultSet to changeset for: {}", (Object)rdbmsProvider.getName());
        long updatedEdges = 0L;
        while (rs.next()) {
            if (!this.addEdgeChanges(rs, rdbmsProvider, true)) continue;
            ++updatedEdges;
        }
        return updatedEdges;
    }

    public long updateVerticesToChangeSet(ResultSet rs, RdbmsEntityProviderConfig rdbmsProvider) throws SQLException {
        LOG.debug("Updating vertices resultSet to changeset for: {}", (Object)rdbmsProvider.getName());
        long updatedVertices = 0L;
        while (rs.next()) {
            Object vertexId = ResultSetConverter.getKeyColumnValue(rs, rdbmsProvider);
            VertexModifier<String> vertexBuilder = null;
            if (this.graph.getVertexIdStrategy() == IdStrategy.PARTITIONED_IDS) {
                String partitionedVertexId = PartitionedId.createPartitionedId((String)rdbmsProvider.getName(), (Object[])new Object[]{vertexId});
                vertexBuilder = this.changeSet.updateVertex(partitionedVertexId);
            } else {
                vertexBuilder = this.changeSet.updateVertex(vertexId).addLabel(rdbmsProvider.getName());
            }
            this.addPropertiesToGraphBuilder(vertexBuilder, rs, rdbmsProvider);
            ++updatedVertices;
        }
        return updatedVertices;
    }

    void addPropertiesToGraphBuilder(VertexBuilder builder, ResultSet rs, RdbmsEntityProviderConfig provider) throws SQLException {
        for (GraphPropertyConfig propConfig : provider.getProps()) {
            if (propConfig.getName().equals(provider.getKeyColumn())) continue;
            builder.setProperty(propConfig.getName(), ResultSetConverter.getParsedObject(rs, propConfig.getName(), propConfig.getType()));
        }
    }

    void addPropertiesToGraphBuilder(EdgeBuilder builder, ResultSet rs, RdbmsEntityProviderConfig provider) throws SQLException {
        for (GraphPropertyConfig propConfig : provider.getProps()) {
            if (propConfig.getName().equals(provider.getKeyColumn())) continue;
            builder.setProperty(propConfig.getName(), ResultSetConverter.getParsedObject(rs, propConfig.getName(), propConfig.getType()));
        }
    }

    public static long fetchAndAddToChangeSet(Statement statement, String query, ResultSetToChangeSet action, RdbmsEntityProviderConfig provider) throws SQLException {
        try (ResultSet rs = statement.executeQuery(query);){
            long l = action.addToChangeSet(rs, provider);
            return l;
        }
    }

    public static interface ResultSetToChangeSet {
        public long addToChangeSet(ResultSet var1, RdbmsEntityProviderConfig var2) throws SQLException;
    }
}

