/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.synchronizer;

import java.util.List;
import oracle.pgx.api.internal.synchronizer.FlashbackConfig;
import oracle.pgx.api.internal.synchronizer.FlashbackPropertyConfig;

public final class FlashbackConfigBuilder {
    private long startScn;
    private long endScn;
    private String graphName;
    private String username;
    private String tableName;
    private String keyColumn;
    private String sourceColumn;
    private String destinationColumn;
    private String schema;
    private List<FlashbackPropertyConfig> properties;
    private int dop = 1;

    public FlashbackConfigBuilder setStartScn(long startScn) {
        this.startScn = startScn;
        return this;
    }

    public FlashbackConfigBuilder setEndScn(long endScn) {
        this.endScn = endScn;
        return this;
    }

    public FlashbackConfigBuilder setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public FlashbackConfigBuilder setGraphName(String graphName) {
        this.graphName = graphName;
        return this;
    }

    public FlashbackConfigBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public FlashbackConfigBuilder setDop(int dop) {
        this.dop = dop;
        return this;
    }

    public FlashbackConfigBuilder setProperties(List<FlashbackPropertyConfig> properties) {
        this.properties = properties;
        return this;
    }

    public FlashbackConfigBuilder setSourceColumn(String sourceColumn) {
        this.sourceColumn = sourceColumn;
        return this;
    }

    public FlashbackConfigBuilder setDestinationColumn(String destinationColumn) {
        this.destinationColumn = destinationColumn;
        return this;
    }

    public FlashbackConfigBuilder setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
        return this;
    }

    public FlashbackConfigBuilder setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public FlashbackConfig build() {
        return new FlashbackConfig(this.startScn, this.endScn, this.graphName, this.username, this.dop, this.tableName, this.properties, this.keyColumn, this.sourceColumn, this.destinationColumn, this.schema);
    }
}

