/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;
import oracle.pgx.api.PgqlResultSet;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.frames.PgxFrameColumn;
import oracle.pgx.api.frames.PgxGenericFrameStorer;
import oracle.pgx.api.frames.functions.ColumnRenaming;
import oracle.pgx.api.frames.schema.ColumnDescriptor;
import oracle.pgx.api.frames.schema.datatypes.collection.VectorType;

public abstract class PgxFrame
implements AutoCloseable {
    private static final long PRINT_LIMIT = 1000L;
    private static final long DEFAULT_LIMIT = 10L;

    public ColumnDescriptor[] getColumnDescriptors() {
        return (ColumnDescriptor[])Arrays.stream(this.getColumns()).map(PgxFrameColumn::getDescriptor).toArray(ColumnDescriptor[]::new);
    }

    protected abstract PgxFrameColumn[] getColumns();

    public abstract PgxFrameColumn getColumn(String var1);

    protected abstract PgxFuture<PgxFrame> selectAsync(boolean var1, LinkedHashMap<String, String> var2);

    private PgxFuture<PgxFrame> selectAsync(boolean inPlace, String ... columns) {
        LinkedHashMap<String, String> columnMappings = new LinkedHashMap<String, String>();
        for (String column : columns) {
            columnMappings.put(column, column);
        }
        return this.selectAsync(inPlace, columnMappings);
    }

    public PgxFuture<PgxFrame> selectAsync(String ... columns) {
        return this.selectAsync(false, columns);
    }

    public PgxFuture<PgxFrame> selectInPlaceAsync(String ... columns) {
        return this.selectAsync(true, columns);
    }

    public PgxFrame select(String ... columns) throws InterruptedException, ExecutionException {
        return this.selectAsync(columns).get();
    }

    public PgxFrame selectInPlace(String ... columns) throws InterruptedException, ExecutionException {
        return this.selectInPlaceAsync(columns).get();
    }

    protected abstract PgxFuture<PgxFrame> renameColumnsAsync(boolean var1, ColumnRenaming ... var2);

    public PgxFuture<PgxFrame> renameColumnsAsync(ColumnRenaming ... columnsWithRenamings) {
        return this.renameColumnsAsync(false, columnsWithRenamings);
    }

    public PgxFuture<PgxFrame> renameColumnsInPlaceAsync(ColumnRenaming ... columnsWithRenamings) {
        return this.renameColumnsAsync(true, columnsWithRenamings);
    }

    public PgxFrame renameColumns(ColumnRenaming ... columnsWithRenamings) throws InterruptedException, ExecutionException {
        return this.renameColumnsAsync(columnsWithRenamings).get();
    }

    public PgxFrame renameColumnsInPlace(ColumnRenaming ... columnsWithRenamings) throws InterruptedException, ExecutionException {
        return this.renameColumnsInPlaceAsync(columnsWithRenamings).get();
    }

    public PgxFuture<PgxFrame> renameColumnAsync(String oldColumnName, String newColumnName) {
        return this.renameColumnsAsync(ColumnRenaming.renaming(oldColumnName, newColumnName));
    }

    public PgxFuture<PgxFrame> renameColumnInPlaceAsync(String oldColumnName, String newColumnName) {
        return this.renameColumnsInPlaceAsync(ColumnRenaming.renaming(oldColumnName, newColumnName));
    }

    public PgxFrame renameColumn(String oldColumnName, String newColumnName) throws InterruptedException, ExecutionException {
        return this.renameColumnAsync(oldColumnName, newColumnName).get();
    }

    public PgxFrame renameColumnInPlace(String oldColumnName, String newColumnName) throws InterruptedException, ExecutionException {
        return this.renameColumnInPlaceAsync(oldColumnName, newColumnName).get();
    }

    protected abstract PgxFuture<PgxFrame> flattenAsync(boolean var1, String[] var2);

    private PgxFuture<PgxFrame> flattenAllAsync(boolean inPlace) {
        String[] columns = (String[])Arrays.stream(this.getColumns()).map(PgxFrameColumn::getDescriptor).filter(d -> d.getColumnType() instanceof VectorType).map(ColumnDescriptor::getColumnName).toArray(String[]::new);
        return this.flattenAsync(inPlace, columns);
    }

    public PgxFuture<PgxFrame> flattenAsync(String ... columns) {
        return this.flattenAsync(false, columns);
    }

    public PgxFuture<PgxFrame> flattenInPlaceAsync(String ... columns) {
        return this.flattenAsync(true, columns);
    }

    public PgxFrame flatten(String ... columns) throws InterruptedException, ExecutionException {
        return this.flattenAsync(columns).get();
    }

    public PgxFrame flattenInPlace(String ... columns) throws InterruptedException, ExecutionException {
        return this.flattenInPlaceAsync(columns).get();
    }

    public PgxFuture<PgxFrame> flattenAllAsync() {
        return this.flattenAllAsync(false);
    }

    public PgxFuture<PgxFrame> flattenAllInPlaceAsync() {
        return this.flattenAllAsync(true);
    }

    public PgxFrame flattenAll() throws InterruptedException, ExecutionException {
        return this.flattenAllAsync().get();
    }

    public PgxFrame flattenAllInPlace() throws InterruptedException, ExecutionException {
        return this.flattenAllInPlaceAsync().get();
    }

    protected abstract PgxFuture<PgxFrame> headAsync(boolean var1, long var2);

    public PgxFuture<PgxFrame> headAsync(long numRows) {
        return this.headAsync(false, numRows);
    }

    public PgxFuture<PgxFrame> headAsync() {
        return this.headAsync(10L);
    }

    public PgxFuture<PgxFrame> headInPlaceAsync(long numRows) {
        return this.headAsync(true, numRows);
    }

    public PgxFuture<PgxFrame> headInPlaceAsync() {
        return this.headInPlaceAsync(10L);
    }

    public PgxFrame head(long numRows) throws InterruptedException, ExecutionException {
        return this.headAsync(numRows).get();
    }

    public PgxFrame head() throws InterruptedException, ExecutionException {
        return this.headAsync().get();
    }

    public PgxFrame headInPlace(long numRows) throws InterruptedException, ExecutionException {
        return this.headInPlaceAsync(numRows).get();
    }

    public PgxFrame headInPlace() throws InterruptedException, ExecutionException {
        return this.headInPlaceAsync().get();
    }

    protected abstract PgxFuture<PgxFrame> tailAsync(boolean var1, long var2);

    public PgxFuture<PgxFrame> tailAsync(long numRows) {
        return this.tailAsync(false, numRows);
    }

    public PgxFuture<PgxFrame> tailAsync() {
        return this.tailAsync(10L);
    }

    public PgxFuture<PgxFrame> tailInPlaceAsync(long numRows) {
        return this.tailAsync(true, numRows);
    }

    public PgxFuture<PgxFrame> tailInPlaceAsync() {
        return this.tailInPlaceAsync(10L);
    }

    public PgxFrame tail(long numRows) throws InterruptedException, ExecutionException {
        return this.tailAsync(numRows).get();
    }

    public PgxFrame tail() throws InterruptedException, ExecutionException {
        return this.tail(10L);
    }

    public PgxFrame tailInPlace(long numRows) throws InterruptedException, ExecutionException {
        return this.tailInPlaceAsync(numRows).get();
    }

    public PgxFrame tailInPlace() throws InterruptedException, ExecutionException {
        return this.tailInPlace(10L);
    }

    public abstract PgxFuture<Long> countAsync();

    public long count() throws InterruptedException, ExecutionException {
        return this.countAsync().get();
    }

    public PgxFuture<Long> lengthAsync() {
        return this.countAsync();
    }

    public long length() throws InterruptedException, ExecutionException {
        return this.lengthAsync().get();
    }

    public abstract PgxGenericFrameStorer write();

    public PgxFuture<PgxFrame> printAsync() {
        return this.printAsync(System.out, 1000L, 0L, true);
    }

    public PgxFrame print() throws InterruptedException, ExecutionException {
        return this.printAsync().get();
    }

    public PgxFuture<PgxFrame> printAsync(long numRows) {
        return this.printAsync(numRows, 0L);
    }

    public PgxFrame print(long numRows) throws InterruptedException, ExecutionException {
        return this.printAsync(numRows).get();
    }

    public PgxFuture<PgxFrame> printAsync(long numResults, long from) {
        return this.printAsync(System.out, numResults, from);
    }

    public PgxFrame print(long numResults, long from) throws InterruptedException, ExecutionException {
        return this.printAsync(numResults, from).get();
    }

    public PgxFuture<PgxFrame> printAsync(PrintStream printStream, long numResults, long from) {
        return this.printAsync(printStream, numResults, from, false);
    }

    public PgxFrame print(PrintStream printStream, long numResults, long from) throws InterruptedException, ExecutionException {
        return this.printAsync(printStream, numResults, from).get();
    }

    protected abstract PgxFuture<PgxFrame> printAsync(PrintStream var1, long var2, long var4, boolean var6);

    public PgxFrame join(PgxFrame right, String joinKeyColumn) throws InterruptedException, ExecutionException {
        return this.joinAsync(right, joinKeyColumn).get();
    }

    public PgxFrame join(PgxFrame right, String leftJoinKeyColumn, String rightJoinKeyColumn) throws InterruptedException, ExecutionException {
        return this.join(right, leftJoinKeyColumn, rightJoinKeyColumn, null, null);
    }

    public PgxFrame join(PgxFrame right, String joinKeyColumn, String leftPrefix, String rightPrefix) throws InterruptedException, ExecutionException {
        return this.joinAsync(right, joinKeyColumn, leftPrefix, rightPrefix).get();
    }

    public PgxFrame join(PgxFrame right, String leftJoinKeyColumn, String rightJoinKeyColumn, String leftPrefix, String rightPrefix) throws InterruptedException, ExecutionException {
        return this.joinAsync(right, leftJoinKeyColumn, rightJoinKeyColumn, leftPrefix, rightPrefix).get();
    }

    public PgxFuture<PgxFrame> joinAsync(PgxFrame right, String joinKeyColumn) {
        return this.joinAsync(right, joinKeyColumn, joinKeyColumn);
    }

    public PgxFuture<PgxFrame> joinAsync(PgxFrame right, String leftJoinKeyColumn, String rightJoinKeyColumn) {
        return this.joinAsync(right, leftJoinKeyColumn, rightJoinKeyColumn, null, null);
    }

    public PgxFuture<PgxFrame> joinAsync(PgxFrame right, String joinKeyColumn, String leftPrefix, String rightPrefix) {
        return this.joinAsync(right, joinKeyColumn, joinKeyColumn, leftPrefix, rightPrefix);
    }

    public abstract PgxFuture<PgxFrame> joinAsync(PgxFrame var1, String var2, String var3, String var4, String var5);

    public abstract PgxFuture<PgxFrame> unionAsync(PgxFrame var1, PgxFrame ... var2);

    public PgxFrame union(PgxFrame b, PgxFrame ... others) throws InterruptedException, ExecutionException {
        return this.unionAsync(b, others).get();
    }

    public abstract PgxFuture<PgqlResultSet> toPgqlResultSetAsync();

    public PgqlResultSet toPgqlResultSet() throws InterruptedException, ExecutionException {
        return this.toPgqlResultSetAsync().get();
    }

    public abstract PgxFuture<Void> destroyAsync();

    @Override
    public void close() {
        this.destroyAsync().join();
    }

    public void destroy() throws InterruptedException, ExecutionException {
        this.destroyAsync().get();
    }
}

