/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import oracle.pgx.api.EdgeProviderMetaData;
import oracle.pgx.api.VertexProviderMetaData;
import oracle.pgx.common.Self;
import oracle.pgx.common.pojo.ObfuscatedGraphConfigDeserializer;
import oracle.pgx.common.pojo.ObfuscatedGraphConfigSerializer;
import oracle.pgx.common.types.IdStrategy;
import oracle.pgx.common.types.IdType;
import oracle.pgx.config.GraphConfig;

public class GraphMetaData
extends Self {
    private long numVertices;
    private long numEdges;
    private long memoryMb;
    private String dataSourceVersion;
    private GraphConfig config;
    private long creationRequestTimestamp;
    private long creationTimestamp;
    private IdStrategy vertexIdStrategy = IdStrategy.KEYS_AS_IDS;
    private final IdType vertexIdType;
    private IdStrategy edgeIdStrategy = IdStrategy.KEYS_AS_IDS;
    private final IdType edgeIdType;
    private boolean directed = true;
    private boolean isGraphPinned;
    private boolean isSnapshotPinned;
    private Map<String, VertexProviderMetaData> vertexProvidersMetaData = GraphMetaData.getMainVertexProviderMetaDataMap();
    private Map<String, EdgeProviderMetaData> edgeProvidersMetaData = GraphMetaData.getMainEdgeProviderMetaDataMap();

    @JsonCreator
    public GraphMetaData(@JsonProperty(value="vertexIdType") IdType vertexIdType, @JsonProperty(value="edgeIdType") IdType edgeIdType) {
        this.vertexIdType = vertexIdType;
        this.edgeIdType = edgeIdType;
        if (this.isNonPartitioned()) {
            this.vertexProvidersMetaData.get("V").setIdType(vertexIdType);
            this.edgeProvidersMetaData.get("E").setIdType(edgeIdType);
        }
    }

    public GraphMetaData(GraphMetaData other) {
        super((Object)other.getCreationTimestamp());
        this.config = other.getConfig();
        this.numVertices = other.getNumVertices();
        this.numEdges = other.getNumEdges();
        this.memoryMb = other.getMemoryMb();
        this.dataSourceVersion = other.getDataSourceVersion();
        this.creationRequestTimestamp = other.creationRequestTimestamp;
        this.creationTimestamp = other.getCreationTimestamp();
        this.isGraphPinned = other.isGraphPinned;
        this.isSnapshotPinned = other.isSnapshotPinned;
        this.vertexProvidersMetaData = new HashMap<String, VertexProviderMetaData>();
        other.getVertexProvidersMetaData().forEach((tableName, tableMetaData) -> this.vertexProvidersMetaData.put((String)tableName, new VertexProviderMetaData((VertexProviderMetaData)((Object)tableMetaData))));
        this.edgeProvidersMetaData = new HashMap<String, EdgeProviderMetaData>();
        other.getEdgeProvidersMetaData().forEach((tableName, tableMetaData) -> this.edgeProvidersMetaData.put((String)tableName, new EdgeProviderMetaData((EdgeProviderMetaData)((Object)tableMetaData))));
        this.vertexIdStrategy = other.vertexIdStrategy;
        this.edgeIdStrategy = other.edgeIdStrategy;
        this.directed = other.directed;
        this.vertexIdType = other.getVertexIdType();
        this.edgeIdType = other.getEdgeIdType();
        if (this.isNonPartitioned()) {
            this.vertexProvidersMetaData.get("V").setIdType(this.vertexIdType);
            this.edgeProvidersMetaData.get("E").setIdType(this.edgeIdType);
        }
    }

    private static Map<String, VertexProviderMetaData> getMainVertexProviderMetaDataMap() {
        Set<String> edgeProviders = Collections.singleton("E");
        return Collections.singletonMap("V", new VertexProviderMetaData("V", IdType.INTEGER, Collections.emptySet(), Collections.emptyList(), edgeProviders, edgeProviders));
    }

    private static Map<String, EdgeProviderMetaData> getMainEdgeProviderMetaDataMap() {
        EdgeProviderMetaData metaData = new EdgeProviderMetaData("E", IdType.LONG, true, Collections.emptySet(), Collections.emptyList(), "V", "V");
        return Collections.singletonMap("E", metaData);
    }

    public VertexProviderMetaData getMainVertexProviderMetaData() {
        return this.vertexProvidersMetaData.get("V");
    }

    public EdgeProviderMetaData getMainEdgeProviderMetaData() {
        return this.edgeProvidersMetaData.get("E");
    }

    final boolean isNonPartitioned() {
        if (this.vertexProvidersMetaData.size() != 1 || this.edgeProvidersMetaData.size() != 1) {
            return false;
        }
        return this.vertexProvidersMetaData.containsKey("V") && this.edgeProvidersMetaData.containsKey("E");
    }

    public boolean isPartitioned() {
        return !this.isNonPartitioned();
    }

    public Map<String, VertexProviderMetaData> getVertexProvidersMetaData() {
        return this.vertexProvidersMetaData;
    }

    public void setVertexProvidersMetaData(Map<String, VertexProviderMetaData> vertexProviderMetaDataMap) {
        this.vertexProvidersMetaData = new HashMap<String, VertexProviderMetaData>(vertexProviderMetaDataMap);
    }

    public Map<String, EdgeProviderMetaData> getEdgeProvidersMetaData() {
        return this.edgeProvidersMetaData;
    }

    public void setEdgeProvidersMetaData(Map<String, EdgeProviderMetaData> edgeProviderMetaDataMap) {
        this.edgeProvidersMetaData = new HashMap<String, EdgeProviderMetaData>(edgeProviderMetaDataMap);
    }

    public long getNumVertices() {
        return this.numVertices;
    }

    public void setNumVertices(long numVertices) {
        this.numVertices = numVertices;
    }

    public long getNumEdges() {
        return this.numEdges;
    }

    public void setNumEdges(long numEdges) {
        this.numEdges = numEdges;
    }

    public long getMemoryMb() {
        return this.memoryMb;
    }

    public void setMemoryMb(long memoryMb) {
        this.memoryMb = memoryMb;
    }

    public String getDataSourceVersion() {
        return this.dataSourceVersion;
    }

    public void setDataSourceVersion(String dataSourceVersion) {
        this.dataSourceVersion = dataSourceVersion;
    }

    public GraphConfig getConfig() {
        return this.config;
    }

    @JsonDeserialize(using=ObfuscatedGraphConfigDeserializer.class)
    @JsonSerialize(using=ObfuscatedGraphConfigSerializer.class)
    public void setConfig(GraphConfig config) {
        this.config = config;
    }

    public long getCreationRequestTimestamp() {
        return this.creationRequestTimestamp;
    }

    public void setCreationRequestTimestamp(long creationRequestTimestamp) {
        this.creationRequestTimestamp = creationRequestTimestamp;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setCreationTimestamp(long creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public IdStrategy getVertexIdStrategy() {
        return this.vertexIdStrategy;
    }

    public void setVertexIdStrategy(IdStrategy idStrategy) {
        this.vertexIdStrategy = idStrategy;
    }

    public IdType getVertexIdType() {
        return this.vertexIdType;
    }

    public IdStrategy getEdgeIdStrategy() {
        return this.edgeIdStrategy;
    }

    public void setEdgeIdStrategy(IdStrategy idStrategy) {
        this.edgeIdStrategy = idStrategy;
    }

    public IdType getEdgeIdType() {
        return this.edgeIdType;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public void setDirected(boolean directed) {
        this.directed = directed;
        if (this.isNonPartitioned()) {
            this.getMainEdgeProviderMetaData().setDirected(directed);
        }
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return "GraphMetaData [numVertices=" + this.numVertices + ", numEdges=" + this.numEdges + ", memoryMb=" + this.memoryMb + ", dataSourceVersion=" + this.dataSourceVersion + ", creationRequestTimestamp=" + this.creationRequestTimestamp + " (" + sdf.format(new Date(this.creationRequestTimestamp)) + "), creationTimestamp=" + this.creationTimestamp + " (" + sdf.format(new Date(this.creationTimestamp)) + "), vertexIdType=" + this.vertexIdType + ", edgeIdType=" + this.edgeIdType + ", directed=" + this.directed + "]";
    }

    public int hashCode() {
        return Objects.hash(this.config, this.creationRequestTimestamp, this.creationTimestamp, this.dataSourceVersion, this.edgeIdType, this.memoryMb, this.numEdges, this.numVertices, this.vertexIdType, this.edgeIdType, this.directed);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GraphMetaData other = (GraphMetaData)((Object)obj);
        if (this.config == null ? other.config != null : !this.config.equals((Object)other.config)) {
            return false;
        }
        if (this.dataSourceVersion == null ? other.dataSourceVersion != null : !this.dataSourceVersion.equals(other.dataSourceVersion)) {
            return false;
        }
        return this.edgeIdType == other.edgeIdType && this.memoryMb == other.memoryMb && this.numEdges == other.numEdges && this.numVertices == other.numVertices && this.vertexIdType == other.vertexIdType && this.creationTimestamp == other.creationTimestamp && this.creationRequestTimestamp == other.creationRequestTimestamp && this.directed == other.directed;
    }

    public boolean isGraphPinned() {
        return this.isGraphPinned;
    }

    public void setGraphPinned(boolean pinned) {
        this.isGraphPinned = pinned;
    }

    public boolean isSnapshotPinned() {
        return this.isSnapshotPinned;
    }

    public void setSnapshotPinned(boolean snapshotPinned) {
        this.isSnapshotPinned = snapshotPinned;
    }
}

