/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.text;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OracleElementBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.SimpleLog;
import oracle.pg.text.OracleAutoIndex;
import oracle.pg.text.OracleIndex;
import oracle.pg.text.OracleIndexIteratorImpl;
import oracle.pg.text.OracleIndexParameters;
import oracle.pg.text.Parameter;

public abstract class OracleIndexManager {
    private static SimpleLog ms_log = SimpleLog.getLog(OracleIndexManager.class);
    private static boolean ms_bDebug = ms_log.isDebugEnabled();
    protected Map<String, OracleIndex<OracleVertexBase>> m_vertexIndices;
    protected Map<String, OracleIndex<OracleEdgeBase>> m_edgeIndices;
    protected OraclePropertyGraphBase m_opg;
    protected boolean m_bEdgeAutoIndexerEnabled = false;
    protected boolean m_bVertexAutoIndexerEnabled = false;
    private final String m_szVertexAutoIndexName = "VERTEX_AUTO_INDEX";
    private final String m_szEdgeAutoIndexName = "EDGE_AUTO_INDEX";
    protected OracleAutoIndex<OracleVertexBase> m_vertexAutoIndex;
    protected OracleAutoIndex<OracleEdgeBase> m_edgeAutoIndex;
    public static final int VERTEX_CLASS_ID = 1;
    public static final int EDGE_CLASS_ID = 2;
    private boolean m_bClosed;
    protected ReentrantReadWriteLock.WriteLock m_vertexIndexCacheLock;
    protected ReentrantReadWriteLock.WriteLock m_edgeIndexCacheLock;

    public OracleIndexManager(OraclePropertyGraphBase opg) {
        this.m_opg = opg;
        this.m_vertexAutoIndex = null;
        this.m_edgeAutoIndex = null;
        this.m_bEdgeAutoIndexerEnabled = false;
        this.m_bVertexAutoIndexerEnabled = false;
        this.m_vertexIndices = new HashMap<String, OracleIndex<OracleVertexBase>>();
        this.m_edgeIndices = new HashMap<String, OracleIndex<OracleEdgeBase>>();
        this.m_vertexIndexCacheLock = new ReentrantReadWriteLock().writeLock();
        this.m_edgeIndexCacheLock = new ReentrantReadWriteLock().writeLock();
        this.createIndexTable();
        if (ms_bDebug) {
            ms_log.debug("constructor: done");
        }
    }

    public void refreshIndicesCache() {
        this.refreshAllIndicesCache();
    }

    public void refreshVertexAutoIndexCache() {
        ms_log.debug("refreshVertexAutoIndexCache: started, update vertex auto index");
        this.m_bVertexAutoIndexerEnabled = this.existsAutoIndexInDB(OracleVertexBase.class);
        if (this.m_bVertexAutoIndexerEnabled) {
            ms_log.debug("refreshVertexAutoIndexCache: vertex auto index enabled");
            this.m_vertexAutoIndex = this.getVertexAutoIndexer(null);
        } else {
            ms_log.debug("refreshVertexAutoIndexCache: vertex auto index disabled");
            this.disableVertexAutoIndexer();
        }
    }

    protected abstract List<OracleIndex> getAllIndicesFromDB();

    public <T extends OracleElementBase> void refreshAllIndicesCache() {
        OracleIndex indexTmp;
        OracleIndex index;
        ms_log.debug("refreshAllIndicesCache: get current list of manual and auto indices for edges and vertices");
        List<OracleIndex> indices = this.getAllIndicesFromDB();
        HashMap<String, OracleIndex> indicesFromDB = new HashMap<String, OracleIndex>();
        if (indices != null) {
            for (int idx = 0; idx < indices.size(); ++idx) {
                indicesFromDB.put(indices.get(idx).getIndexName(), indices.get(idx));
            }
        }
        if (!indicesFromDB.containsKey(this.getVertexAutoIndexName())) {
            ms_log.debug("refreshAllIndicesCache: vertex auto index no longer exists");
            this.disableVertexAutoIndexer();
        } else if (this.getVertexAutoIndexer(null) != null) {
            if (ms_bDebug) {
                ms_log.debug((Object)("refreshAllIndicesCache: vertex auto index " + this.getVertexAutoIndexName()), " already in cache ");
            }
            OracleIndex indexTmp2 = (OracleIndex)indicesFromDB.remove(this.getVertexAutoIndexName());
            indices.remove(indexTmp2);
            indexTmp2.close();
        } else {
            OracleAutoIndex index2;
            if (ms_bDebug) {
                ms_log.debug((Object)("refreshAllIndicesCache: add vertex auto index " + this.getVertexAutoIndexName()), " to cache ");
            }
            this.m_vertexAutoIndex = index2 = (OracleAutoIndex)indicesFromDB.get(this.getVertexAutoIndexName());
        }
        if (!indicesFromDB.containsKey(this.getEdgeAutoIndexName())) {
            ms_log.debug("refreshAllIndicesCache: edge auto index no longer exists");
            this.disableEdgeAutoIndexer();
        } else if (this.getEdgeAutoIndexer(null) != null) {
            if (ms_bDebug) {
                ms_log.debug((Object)("refreshAllIndicesCache: edge auto index " + this.getEdgeAutoIndexName()), " already in cache ");
            }
            OracleIndex indexTmp3 = (OracleIndex)indicesFromDB.remove(this.getEdgeAutoIndexName());
            indices.remove(indexTmp3);
            indexTmp3.close();
        } else {
            OracleAutoIndex index3;
            if (ms_bDebug) {
                ms_log.debug((Object)("refreshAllIndicesCache: add edge auto index " + this.getEdgeAutoIndexName()), " to cache ");
            }
            this.m_edgeAutoIndex = index3 = (OracleAutoIndex)indicesFromDB.get(this.getEdgeAutoIndexName());
        }
        Object[] cachedIndices = null;
        if (ms_bDebug) {
            ms_log.debug("refreshAllIndicesCache: get lock for manual vertex indices cache");
        }
        this.m_vertexIndexCacheLock.lock();
        if (ms_bDebug) {
            ms_log.debug("refreshAllIndicesCache: get lock for manual edge indices cache");
        }
        this.m_edgeIndexCacheLock.lock();
        if (this.m_vertexIndices != null && !this.m_vertexIndices.isEmpty()) {
            cachedIndices = this.m_vertexIndices.values().toArray();
            for (Object obj : cachedIndices) {
                index = (OracleIndex)obj;
                if (indicesFromDB == null || !indicesFromDB.containsKey(index.getIndexName())) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)("refreshAllIndicesCache: index " + index.getIndexName()), " no longer exists, remove from vertex cache ");
                    }
                    this.m_vertexIndices.remove(index.getIndexName());
                    index.close();
                    continue;
                }
                if (ms_bDebug) {
                    ms_log.debug((Object)("refreshAllIndicesCache: index " + index.getIndexName()), " already in vertex cache ");
                }
                indexTmp = (OracleIndex)indicesFromDB.remove(index.getIndexName());
                indices.remove(indexTmp);
                indexTmp.close();
            }
        }
        if (this.m_edgeIndices != null && !this.m_edgeIndices.isEmpty()) {
            cachedIndices = this.m_edgeIndices.values().toArray();
            for (Object obj : cachedIndices) {
                index = (OracleIndex)obj;
                if (indicesFromDB == null || !indicesFromDB.containsKey(index.getIndexName())) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)("refreshAllIndicesCache: index " + index.getIndexName()), " no longer exists, remove from edge cache ");
                    }
                    this.m_edgeIndices.remove(index.getIndexName());
                    index.close();
                    continue;
                }
                if (ms_bDebug) {
                    ms_log.debug((Object)("refreshAllIndicesCache: index " + index.getIndexName()), " already in cache ");
                }
                indexTmp = (OracleIndex)indicesFromDB.remove(index.getIndexName());
                indices.remove(indexTmp);
                indexTmp.close();
            }
        }
        ms_log.debug("refreshAllIndicesCache: add remaining indices found in db");
        if (indices != null) {
            for (OracleIndex index4 : indices) {
                if (ms_bDebug) {
                    ms_log.debug((Object)("refreshAllIndicesCache: add index " + index4.getIndexName()), " obtained from db ");
                }
                if (OracleVertexBase.class.isAssignableFrom(index4.getIndexClass())) {
                    this.m_vertexIndices.put(index4.getIndexName(), index4);
                    continue;
                }
                this.m_edgeIndices.put(index4.getIndexName(), index4);
            }
        }
        if (ms_bDebug) {
            ms_log.debug("refreshAlllIndicesCache: release lock  for manual vertex indices cache");
        }
        this.m_vertexIndexCacheLock.unlock();
        if (ms_bDebug) {
            ms_log.debug("refreshAllIndicesCache: release lock  for manual edge indices cache");
        }
        this.m_edgeIndexCacheLock.unlock();
        ms_log.debug("refreshAllIndicesCache: done");
    }

    public void refreshVertexIndicesCache() {
        ms_log.debug("refreshVertexIndicesCache: get current list of manual indices for vertices");
        List<OracleIndex<OracleVertexBase>> indices = this.getIndicesFromDB(OracleVertexBase.class);
        HashMap<String, OracleIndex<OracleVertexBase>> indicesFromDB = new HashMap<String, OracleIndex<OracleVertexBase>>();
        if (indices != null) {
            for (int idx = 0; idx < indices.size(); ++idx) {
                indicesFromDB.put(indices.get(idx).getIndexName(), indices.get(idx));
            }
        }
        Object[] cachedIndices = null;
        if (ms_bDebug) {
            ms_log.debug("refreshVertexIndicesCache: get lock for manual vertex indices cache");
        }
        this.m_vertexIndexCacheLock.lock();
        if (this.m_vertexIndices != null && !this.m_vertexIndices.isEmpty()) {
            cachedIndices = this.m_vertexIndices.values().toArray();
            for (Object obj : cachedIndices) {
                OracleIndex index = (OracleIndex)obj;
                if (indicesFromDB == null || !indicesFromDB.containsKey(index.getIndexName())) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)("refreshVertexIndicesCache: index " + index.getIndexName()), " no longer exists, remove from cache ");
                    }
                    this.m_vertexIndices.remove(index.getIndexName());
                    index.close();
                    continue;
                }
                if (ms_bDebug) {
                    ms_log.debug((Object)("refreshVertexIndicesCache: index " + index.getIndexName()), " already in cache ");
                }
                OracleIndex indexTmp = (OracleIndex)indicesFromDB.remove(index.getIndexName());
                indices.remove(indexTmp);
                indexTmp.close();
            }
            ms_log.debug("refreshVertexIndicesCache: add remaining indices found in db");
            if (indices != null) {
                for (OracleIndex oracleIndex : indices) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)("refreshVertexIndicesCache: add index " + oracleIndex.getIndexName()), " obtained from db ");
                    }
                    this.m_vertexIndices.put(oracleIndex.getIndexName(), oracleIndex);
                }
            }
        } else if (indices != null && !indices.isEmpty()) {
            ms_log.debug("refreshVertexIndicesCache: cache empty, add indices found in db");
            Iterator<OracleIndex<OracleVertexBase>> iterator = indices.iterator();
            while (iterator.hasNext()) {
                OracleIndex<OracleVertexBase> oracleIndex;
                OracleIndex<OracleVertexBase> index = oracleIndex = iterator.next();
                this.m_vertexIndices.put(index.getIndexName(), index);
            }
        }
        if (ms_bDebug) {
            ms_log.debug("refreshVertexIndicesCache: release lock  for manual vertex indices cache");
        }
        this.m_vertexIndexCacheLock.unlock();
        ms_log.debug("refreshVertexIndicesCache: done");
    }

    public void refreshEdgeAutoIndexCache() {
        ms_log.debug("refreshEdgeAutoIndexCache: started, update edge auto index");
        this.m_bEdgeAutoIndexerEnabled = this.existsAutoIndexInDB(OracleEdgeBase.class);
        if (this.m_bEdgeAutoIndexerEnabled) {
            ms_log.debug("refreshEdgeAutoIndexCache: edge auto index enabled");
            this.m_edgeAutoIndex = this.getEdgeAutoIndexer(null);
        } else {
            ms_log.debug("refreshEdgeAutoIndexCache: edge auto index disabled");
            this.disableEdgeAutoIndexer();
        }
    }

    public void refreshEdgeIndicesCache() {
        ms_log.debug("refreshEdgeIndicesCache: get current list of manual indices for edges");
        List<OracleIndex<OracleEdgeBase>> indices = this.getIndicesFromDB(OracleEdgeBase.class);
        HashMap<String, OracleIndex<OracleEdgeBase>> indicesFromDB = new HashMap<String, OracleIndex<OracleEdgeBase>>();
        if (indices != null) {
            for (int idx = 0; idx < indices.size(); ++idx) {
                indicesFromDB.put(indices.get(idx).getIndexName(), indices.get(idx));
            }
        }
        Object[] cachedIndices = null;
        if (ms_bDebug) {
            ms_log.debug("refreshEdgeIndicesCache: get lock for manual edge indices cache");
        }
        this.m_edgeIndexCacheLock.lock();
        if (this.m_edgeIndices != null && !this.m_edgeIndices.isEmpty()) {
            cachedIndices = this.m_edgeIndices.values().toArray();
            for (Object obj : cachedIndices) {
                OracleIndex index = (OracleIndex)obj;
                if (indicesFromDB == null || !indicesFromDB.containsKey(index.getIndexName())) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)("refreshEdgeIndicesCache: index " + index.getIndexName()), " no longer exists, remove from cache ");
                    }
                    this.m_edgeIndices.remove(index.getIndexName());
                    index.close();
                    continue;
                }
                if (ms_bDebug) {
                    ms_log.debug((Object)("refreshEdgeIndicesCache: index " + index.getIndexName()), " already in cache ");
                }
                OracleIndex indexTmp = (OracleIndex)indicesFromDB.remove(index.getIndexName());
                indices.remove(indexTmp);
                indexTmp.close();
            }
            ms_log.debug("refreshEdgeIndicesCache: add remaining indices found in db");
            if (indices != null) {
                for (OracleIndex oracleIndex : indices) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)("refreshEdgeIndicesCache: add index " + oracleIndex.getIndexName()), " obtained from db ");
                    }
                    this.m_edgeIndices.put(oracleIndex.getIndexName(), oracleIndex);
                }
            }
        } else if (indices != null && !indices.isEmpty()) {
            ms_log.debug("refreshEdgeIndicesCache: cache empty, add indices found in db");
            Iterator<OracleIndex<OracleEdgeBase>> iterator = indices.iterator();
            while (iterator.hasNext()) {
                OracleIndex<OracleEdgeBase> oracleIndex;
                OracleIndex<OracleEdgeBase> index = oracleIndex = iterator.next();
                this.m_edgeIndices.put(index.getIndexName(), index);
            }
        }
        if (ms_bDebug) {
            ms_log.debug("refreshEdgeIndicesCache: release lock  for manual edge indices cache");
        }
        this.m_edgeIndexCacheLock.unlock();
        ms_log.debug("refreshEdgeIndicesCache: done");
    }

    protected abstract <T extends OracleElementBase> void addIndexMetadata(OracleIndex<T> var1, String var2);

    public final void clearIndices() {
        ms_log.debug("clearIndices: refresh indices cache before executing operation");
        this.refreshIndicesCache();
        if (ms_bDebug) {
            ms_log.debug("clearIndices: clear opened indexes");
        }
        if (this.m_vertexIndices != null) {
            if (ms_bDebug) {
                ms_log.debug("clearIndices: vertex indices opened, get and clear them");
            }
            for (OracleIndex<OracleElementBase> oracleIndex : this.m_vertexIndices.values()) {
                if (ms_bDebug) {
                    ms_log.debug((Object)"clearIndices: clear index ", oracleIndex.getIndexName());
                }
                oracleIndex.clearIndex();
            }
        }
        if (this.m_edgeIndices != null) {
            if (ms_bDebug) {
                ms_log.debug("clearIndices: edge indices opened, get and clear them");
            }
            for (OracleIndex<OracleElementBase> oracleIndex : this.m_edgeIndices.values()) {
                if (ms_bDebug) {
                    ms_log.debug((Object)"clearIndices: clear index ", oracleIndex.getIndexName());
                }
                oracleIndex.clearIndex();
            }
        }
        if (ms_bDebug) {
            ms_log.debug("clearIndices: clear and disable vertex auto index ");
        }
        this.m_vertexAutoIndex.clearIndex();
        if (ms_bDebug) {
            ms_log.debug("clearIndices: clear and disable edge auto index ");
        }
        this.m_edgeAutoIndex.clearIndex();
        if (ms_bDebug) {
            ms_log.debug("clearIndices: done... ");
        }
    }

    public final <T extends OracleElementBase> void dropIndices() {
        ms_log.debug("dropAllManualIndices: refresh manual indices cache");
        this.refreshIndicesCache();
        if (ms_bDebug) {
            ms_log.debug("dropIndices: drop existing manual indices");
        }
        this.dropAllManualIndices(false);
        if (ms_bDebug) {
            ms_log.debug("dropIndices: drop auto indices ");
        }
        this.dropAllAutoIndices(false);
        if (ms_bDebug) {
            ms_log.debug("dropIndices: done... ");
        }
    }

    public final void dropAllManualIndices() {
        this.dropAllManualIndices(true);
    }

    public final void dropAllManualIndices(boolean refresh) {
        OracleIndex index;
        if (refresh) {
            ms_log.debug("dropAllManualIndices: refresh indices cache before dropping indexes");
            this.refreshIndicesCache();
        }
        if (ms_bDebug) {
            ms_log.debug("dropAllManualIndices: clear opened indexes");
        }
        Object[] cachedIndices = null;
        if (ms_bDebug) {
            ms_log.debug("dropAllManualIndices: get lock for manual vertex indices cache");
        }
        this.m_vertexIndexCacheLock.lock();
        if (this.m_vertexIndices != null && !this.m_vertexIndices.isEmpty()) {
            for (Object obj : cachedIndices = this.m_vertexIndices.values().toArray()) {
                index = (OracleIndex)obj;
                if (ms_bDebug) {
                    ms_log.debug((Object)("dropAllManualIndices: drop index " + index.getIndexName()), " and remove from cache ");
                }
                this.m_vertexIndices.remove(index.getIndexName());
                index.dropIndex();
            }
            if (ms_bDebug) {
                ms_log.debug("dropAllManualIndices: release lock  for manual vertex indices cache");
            }
        }
        this.m_vertexIndexCacheLock.unlock();
        if (ms_bDebug) {
            ms_log.debug("dropAllManualIndices: get lock for manual edge indices cache");
        }
        this.m_edgeIndexCacheLock.lock();
        if (this.m_edgeIndices != null && !this.m_edgeIndices.isEmpty()) {
            for (Object obj : cachedIndices = this.m_edgeIndices.values().toArray()) {
                index = (OracleIndex)obj;
                if (ms_bDebug) {
                    ms_log.debug((Object)("dropAllManualIndices: drop index " + index.getIndexName()), " and remove from cache ");
                }
                this.m_edgeIndices.remove(index.getIndexName());
                index.dropIndex();
            }
            if (ms_bDebug) {
                ms_log.debug("dropAllManualIndices: release lock  for manual edge indices cache");
            }
        }
        this.m_edgeIndexCacheLock.unlock();
        if (ms_bDebug) {
            ms_log.debug("dropAllManualIndices: done... ");
        }
    }

    public <T extends OracleElementBase> void refreshManualIndicesCache() {
        OracleIndex indexTmp;
        OracleIndex index;
        ms_log.debug("refreshManualIndicesCache: get current list of manual indices for edges and vertices");
        List<OracleIndex<T>> indices = this.getIndicesFromDB(null);
        HashMap<String, OracleIndex<T>> indicesFromDB = new HashMap<String, OracleIndex<T>>();
        if (indices != null) {
            for (int idx = 0; idx < indices.size(); ++idx) {
                indicesFromDB.put(indices.get(idx).getIndexName(), indices.get(idx));
            }
        }
        Object[] cachedIndices = null;
        if (ms_bDebug) {
            ms_log.debug("refreshManualIndicesCache: get lock for manual vertex indices cache");
        }
        this.m_vertexIndexCacheLock.lock();
        if (ms_bDebug) {
            ms_log.debug("refreshManualIndicesCache: get lock for manual edge indices cache");
        }
        this.m_edgeIndexCacheLock.lock();
        if (this.m_vertexIndices != null && !this.m_vertexIndices.isEmpty()) {
            cachedIndices = this.m_vertexIndices.values().toArray();
            for (Object obj : cachedIndices) {
                index = (OracleIndex)obj;
                if (indicesFromDB == null || !indicesFromDB.containsKey(index.getIndexName())) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)("refreshManualIndicesCache: index " + index.getIndexName()), " no longer exists, remove from vertex cache ");
                    }
                    this.m_vertexIndices.remove(index.getIndexName());
                    index.close();
                    continue;
                }
                if (ms_bDebug) {
                    ms_log.debug((Object)("refreshManualIndicesCache: index " + index.getIndexName()), " already in vertex cache ");
                }
                indexTmp = (OracleIndex)indicesFromDB.remove(index.getIndexName());
                indices.remove(indexTmp);
                indexTmp.close();
            }
        }
        if (this.m_edgeIndices != null && !this.m_edgeIndices.isEmpty()) {
            cachedIndices = this.m_edgeIndices.values().toArray();
            for (Object obj : cachedIndices) {
                index = (OracleIndex)obj;
                if (indicesFromDB == null || !indicesFromDB.containsKey(index.getIndexName())) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)("refreshManualIndicesCache: index " + index.getIndexName()), " no longer exists, remove from edge cache ");
                    }
                    this.m_edgeIndices.remove(index.getIndexName());
                    index.close();
                    continue;
                }
                if (ms_bDebug) {
                    ms_log.debug((Object)("refreshManualIndicesCache: index " + index.getIndexName()), " already in cache ");
                }
                indexTmp = (OracleIndex)indicesFromDB.remove(index.getIndexName());
                indices.remove(indexTmp);
                indexTmp.close();
            }
        }
        ms_log.debug("refreshManualIndicesCache: add remaining indices found in db");
        if (indices != null) {
            for (OracleIndex oracleIndex : indices) {
                if (ms_bDebug) {
                    ms_log.debug((Object)("refreshManualIndicesCache: add index " + oracleIndex.getIndexName()), " obtained from db ");
                }
                if (OracleVertexBase.class.isAssignableFrom(oracleIndex.getClass())) {
                    this.m_vertexIndices.put(oracleIndex.getIndexName(), oracleIndex);
                    continue;
                }
                this.m_edgeIndices.put(oracleIndex.getIndexName(), oracleIndex);
            }
        }
        if (ms_bDebug) {
            ms_log.debug("refreshManualIndicesCache: release lock  for manual vertex indices cache");
        }
        this.m_vertexIndexCacheLock.unlock();
        if (ms_bDebug) {
            ms_log.debug("refreshManualIndicesCache: release lock  for manual edge indices cache");
        }
        this.m_edgeIndexCacheLock.unlock();
        ms_log.debug("refreshManualIndicesCache: done");
    }

    public final void dropAllAutoIndices() {
        this.dropAllAutoIndices(true);
    }

    public final void dropAllAutoIndices(boolean refresh) {
        if (refresh) {
            ms_log.debug("dropAllAutoIndices: refresh indices cache");
            this.refreshAllIndicesCache();
        }
        if (ms_bDebug) {
            ms_log.debug("dropAllAutoIndices: clear and disable vertex auto index ");
        }
        this.disableVertexAutoIndexer();
        if (ms_bDebug) {
            ms_log.debug("dropAllAutoIndices: clear and disable edge auto index ");
        }
        this.disableEdgeAutoIndexer();
        if (ms_bDebug) {
            ms_log.debug("dropAllAutoIndices: done... ");
        }
    }

    public final void clearAndCloseIndices() {
        OracleIndex index;
        if (ms_bDebug) {
            ms_log.debug("clearAndCloseIndices: clear opened indexes and close them");
        }
        Object[] cachedIndices = null;
        ms_log.debug("clearAndCloseIndices: refresh indices cache");
        this.refreshIndicesCache();
        if (ms_bDebug) {
            ms_log.debug("clearAndCloseIndices: get lock for manual vertex indices cache");
        }
        this.m_vertexIndexCacheLock.lock();
        if (this.m_vertexIndices != null && !this.m_vertexIndices.isEmpty()) {
            for (Object obj : cachedIndices = this.m_vertexIndices.values().toArray()) {
                index = (OracleIndex)obj;
                if (ms_bDebug) {
                    ms_log.debug((Object)("clearAndCloseIndices: clear, close index " + index.getIndexName()), " and remove from cache ");
                }
                this.m_vertexIndices.remove(index.getIndexName());
                index.clearIndex();
                index.close();
            }
            if (ms_bDebug) {
                ms_log.debug("clearAndCloseIndices: release lock  for manual vertex indices cache");
            }
        }
        this.m_vertexIndexCacheLock.unlock();
        if (ms_bDebug) {
            ms_log.debug("clearAndCloseIndices: get lock for manual edge indices cache");
        }
        this.m_edgeIndexCacheLock.lock();
        if (this.m_edgeIndices != null && !this.m_edgeIndices.isEmpty()) {
            for (Object obj : cachedIndices = this.m_edgeIndices.values().toArray()) {
                index = (OracleIndex)obj;
                if (ms_bDebug) {
                    ms_log.debug((Object)("clearAndCloseIndices: clear, close index " + index.getIndexName()), " and remove from cache ");
                }
                this.m_edgeIndices.remove(index.getIndexName());
                index.clearIndex();
                index.close();
            }
            if (ms_bDebug) {
                ms_log.debug("clearAndCloseIndices: release lock  for manual edge indices cache");
            }
        }
        this.m_edgeIndexCacheLock.unlock();
        if (this.m_vertexAutoIndex != null) {
            if (ms_bDebug) {
                ms_log.debug((Object)"clearAndCloseIndices: clear and close vertex auto index ", this.m_vertexAutoIndex.getIndexName());
            }
            this.m_vertexAutoIndex.clearIndex();
            this.m_vertexAutoIndex.close();
        }
        if (this.m_edgeAutoIndex != null) {
            if (ms_bDebug) {
                ms_log.debug((Object)"clearAndCloseIndices: clear and close edge auto index ", this.m_edgeAutoIndex.getIndexName());
            }
            this.m_edgeAutoIndex.clearIndex();
            this.m_edgeAutoIndex.close();
        }
        if (ms_bDebug) {
            ms_log.debug("clearAndCloseIndices: done... ");
        }
    }

    public void close() {
        if (this.m_bClosed) {
            ms_log.warn("close: index manager already closed, do nothing");
            return;
        }
        if (ms_bDebug) {
            ms_log.debug("close: close opened indices");
        }
        this.closeIndices();
    }

    public final void closeIndices() {
        OracleIndex index;
        if (ms_bDebug) {
            ms_log.debug("closeIndices: commit opened indexes and close them");
        }
        Object[] cachedIndices = null;
        ms_log.debug("closeIndices: refresh indices cache");
        this.refreshIndicesCache();
        if (ms_bDebug) {
            ms_log.debug("closeIndices: get lock for manual vertex indices cache");
        }
        this.m_vertexIndexCacheLock.lock();
        if (this.m_vertexIndices != null && !this.m_vertexIndices.isEmpty()) {
            for (Object obj : cachedIndices = this.m_vertexIndices.values().toArray()) {
                index = (OracleIndex)obj;
                if (ms_bDebug) {
                    ms_log.debug((Object)("closeIndices: close index " + index.getIndexName()), " and remove from cache ");
                }
                this.m_vertexIndices.remove(index.getIndexName());
                index.close();
            }
            if (ms_bDebug) {
                ms_log.debug("closeIndices: release lock  for manual vertex indices cache");
            }
        }
        this.m_vertexIndexCacheLock.unlock();
        if (ms_bDebug) {
            ms_log.debug("closeIndices: get lock for manual edge indices cache");
        }
        this.m_edgeIndexCacheLock.lock();
        if (this.m_edgeIndices != null && !this.m_edgeIndices.isEmpty()) {
            for (Object obj : cachedIndices = this.m_edgeIndices.values().toArray()) {
                index = (OracleIndex)obj;
                if (ms_bDebug) {
                    ms_log.debug((Object)("closeIndices: close index " + index.getIndexName()), " and remove from cache ");
                }
                this.m_edgeIndices.remove(index.getIndexName());
                index.close();
            }
            if (ms_bDebug) {
                ms_log.debug("closeIndices: release lock  for manual edge indices cache");
            }
        }
        this.m_edgeIndexCacheLock.unlock();
        if (this.m_vertexAutoIndex != null) {
            if (ms_bDebug) {
                ms_log.debug((Object)"closeIndices: close vertex auto index ", this.m_vertexAutoIndex.getIndexName());
            }
            this.m_vertexAutoIndex.close();
            this.m_vertexAutoIndex = null;
        }
        if (this.m_edgeAutoIndex != null) {
            if (ms_bDebug) {
                ms_log.debug((Object)"closeIndices: close edge auto index ", this.m_edgeAutoIndex.getIndexName());
            }
            this.m_edgeAutoIndex.close();
            this.m_edgeAutoIndex = null;
        }
        if (ms_bDebug) {
            ms_log.debug("closeIndices: done... ");
        }
    }

    public void commitIndices() {
        OracleIndex index;
        if (ms_bDebug) {
            ms_log.debug("commitIndices: commit opened indexes");
        }
        ms_log.debug("commitIndices: refresh  indices cache");
        this.refreshIndicesCache();
        Object[] cachedIndices = null;
        if (ms_bDebug) {
            ms_log.debug("commitIndices: get lock for manual vertex indices cache");
        }
        this.m_vertexIndexCacheLock.lock();
        if (this.m_vertexIndices != null && !this.m_vertexIndices.isEmpty()) {
            for (Object obj : cachedIndices = this.m_vertexIndices.values().toArray()) {
                index = (OracleIndex)obj;
                if (ms_bDebug) {
                    ms_log.debug("commitIndices: commit index " + index.getIndexName());
                }
                index.commit();
            }
            if (ms_bDebug) {
                ms_log.debug("commitIndices: release lock  for manual vertex indices cache");
            }
        }
        this.m_vertexIndexCacheLock.unlock();
        if (ms_bDebug) {
            ms_log.debug("commitIndices: get lock for manual edge indices cache");
        }
        this.m_edgeIndexCacheLock.lock();
        if (this.m_edgeIndices != null && !this.m_edgeIndices.isEmpty()) {
            for (Object obj : cachedIndices = this.m_edgeIndices.values().toArray()) {
                index = (OracleIndex)obj;
                if (ms_bDebug) {
                    ms_log.debug("commitIndices: commit index " + index.getIndexName());
                }
                index.commit();
            }
            if (ms_bDebug) {
                ms_log.debug("commitIndices: release lock  for manual edge indices cache");
            }
        }
        this.m_edgeIndexCacheLock.unlock();
        if (this.getVertexAutoIndexer(new Parameter[0]) != null) {
            if (ms_bDebug) {
                ms_log.debug((Object)"commitIndices: commit vertex auto index ", this.m_vertexAutoIndex.getIndexName());
            }
            this.m_vertexAutoIndex.commit();
        }
        if (this.getEdgeAutoIndexer(new Parameter[0]) != null) {
            if (ms_bDebug) {
                ms_log.debug((Object)"commitIndices: commit edge auto index ", this.m_edgeAutoIndex.getIndexName());
            }
            this.m_edgeAutoIndex.commit();
        }
        if (ms_bDebug) {
            ms_log.debug("commitIndices: done... ");
        }
    }

    public final <T extends OracleElementBase> boolean containsIndexedKey(String key, Class<T> indexClass) {
        if (OracleVertexBase.class.isAssignableFrom(indexClass)) {
            if (ms_bDebug) {
                ms_log.debug((Object)"containsIndexedKey: index class is a vertex, check ", "vertex auto index metadata in db ");
            }
            if (this.containsIndexedKeyFromDB("*", this.getVertexAutoIndexName(), OracleVertexBase.class)) {
                if (ms_bDebug) {
                    ms_log.debug("containsIndexedKey: all property names enabled return true");
                }
                return true;
            }
            return this.containsIndexedKeyFromDB(key, this.getVertexAutoIndexName(), OracleVertexBase.class);
        }
        if (OracleEdgeBase.class.isAssignableFrom(indexClass)) {
            if (ms_bDebug) {
                ms_log.debug((Object)"containsIndexedKey: index class is an edge, check ", "edge auto index metadata in db ");
            }
            if (this.containsIndexedKeyFromDB("*", this.getEdgeAutoIndexName(), OracleEdgeBase.class)) {
                if (ms_bDebug) {
                    ms_log.debug("containsIndexedKey: all property names enabled return true");
                }
                return true;
            }
            return this.containsIndexedKeyFromDB(key, this.getEdgeAutoIndexName(), OracleEdgeBase.class);
        }
        return false;
    }

    protected abstract <T extends OracleElementBase> boolean containsIndexedKeyFromDB(String var1, String var2, Class<T> var3);

    public final synchronized <T extends OracleElementBase> OracleIndex<T> createIndex(String indexName, Class<T> indexClass, OraclePropertyGraphBase pg, Parameter ... indexParameters) {
        return this.createInternalIndex(indexName, indexClass, pg, true, indexParameters);
    }

    private final synchronized <T extends OracleElementBase> OracleIndex<T> createInternalIndex(String indexName, Class<T> indexClass, OraclePropertyGraphBase pg, boolean erase, Parameter ... indexParameters) {
        if (OracleVertexBase.class.isAssignableFrom(indexClass)) {
            if (ms_bDebug) {
                ms_log.debug((Object)("createInternalIndex: create index " + indexName), " as vertex index");
            }
            if (this.m_vertexIndices != null && this.m_vertexIndices.containsKey(indexName)) {
                if (ms_bDebug) {
                    ms_log.debug("createInternalIndex: get index from cache");
                }
                return this.m_vertexIndices.get(indexName);
            }
            OracleIndex<OracleVertexBase> index = this.getVertexIndexFromPG(indexName, indexParameters, erase);
            if (index != null) {
                if (erase) {
                    if (ms_bDebug) {
                        ms_log.debug("createInternalIndex: persist index into index metadata table");
                    }
                    this.addIndexMetadata(index, null);
                }
                this.m_vertexIndexCacheLock.lock();
                if (this.m_vertexIndices == null) {
                    if (ms_bDebug) {
                        ms_log.debug("createInternalIndex: initialize vertex index cache");
                    }
                    this.m_vertexIndices = new HashMap<String, OracleIndex<OracleVertexBase>>();
                }
                if (ms_bDebug) {
                    ms_log.debug("createInternalIndex: add index to vertex index cache");
                }
                this.m_vertexIndices.put(indexName, index);
                this.m_vertexIndexCacheLock.unlock();
            }
            return index;
        }
        if (OracleEdgeBase.class.isAssignableFrom(indexClass)) {
            if (ms_bDebug) {
                ms_log.debug((Object)("createInternalIndex: create index " + indexName), " as edge index");
            }
            if (this.m_edgeIndices != null && this.m_edgeIndices.containsKey(indexName)) {
                return this.m_edgeIndices.get(indexName);
            }
            OracleIndex<OracleEdgeBase> index = this.getEdgeIndexFromPG(indexName, indexParameters, erase);
            if (index != null) {
                if (erase) {
                    if (ms_bDebug) {
                        ms_log.debug("createInternalIndex: persist index into index metadata table");
                    }
                    this.addIndexMetadata(index, null);
                }
                this.m_edgeIndexCacheLock.lock();
                if (this.m_edgeIndices == null) {
                    if (ms_bDebug) {
                        ms_log.debug("createInternalIndex: initialize edge index cache");
                    }
                    this.m_edgeIndices = new HashMap<String, OracleIndex<OracleEdgeBase>>();
                }
                if (ms_bDebug) {
                    ms_log.debug("createInternalIndex: add index to edge index cache");
                }
                this.m_edgeIndices.put(indexName, index);
                this.m_edgeIndexCacheLock.unlock();
            }
            return index;
        }
        throw new IllegalArgumentException("Class is not indexable: " + indexClass);
    }

    protected abstract <T extends OracleElementBase> void deleteIndexMetadata(String var1, String var2, Class<T> var3);

    public void disableEdgeAutoIndexer() {
        if (!this.m_bEdgeAutoIndexerEnabled) {
            ms_log.debug("disableEdgeAutoIndexer: index already disabled");
            return;
        }
        this.m_bEdgeAutoIndexerEnabled = false;
        if (this.m_edgeAutoIndex != null) {
            if (ms_bDebug) {
                ms_log.debug("disableEdgeAutoIndexer: remove all and close index");
            }
            this.m_edgeAutoIndex.dropIndex();
            String indexName = this.m_edgeAutoIndex.getIndexName();
            Class<OracleEdgeBase> indexClass = OracleEdgeBase.class;
            List<String> propertyNames = this.getIndexedKeys(indexName, indexClass);
            if (propertyNames != null) {
                for (String propertyName : propertyNames) {
                    this.deleteIndexMetadata(indexName, propertyName, indexClass);
                }
            }
            this.m_edgeAutoIndex = null;
        }
        this.m_edgeAutoIndex = null;
    }

    public void disableVertexAutoIndexer() {
        if (!this.m_bVertexAutoIndexerEnabled) {
            ms_log.debug("disableVertexAutoIndexer: index already disabled");
            return;
        }
        this.m_bVertexAutoIndexerEnabled = false;
        if (this.m_vertexAutoIndex != null) {
            if (ms_bDebug) {
                ms_log.debug("disableVertexAutoIndexer: remove all and close index");
            }
            this.m_vertexAutoIndex.dropIndex();
            String indexName = this.m_vertexAutoIndex.getIndexName();
            Class<OracleVertexBase> indexClass = OracleVertexBase.class;
            List<String> propertyNames = this.getIndexedKeys(indexName, indexClass);
            if (propertyNames != null) {
                for (String propertyName : propertyNames) {
                    this.deleteIndexMetadata(indexName, propertyName, indexClass);
                }
            }
            this.m_vertexAutoIndex = null;
        }
        this.m_vertexAutoIndex = null;
    }

    public final void dropIndex(String indexName) {
        this.dropIndex(indexName, true);
    }

    public final void dropIndex(String indexName, boolean refresh) {
        if (ms_bDebug) {
            ms_log.debug((Object)"dropIndex: started with index ", indexName);
        }
        if (refresh) {
            ms_log.debug("dropIndex: refresh indices cache");
            this.refreshIndicesCache();
        }
        if (this.existVertexIndex(indexName)) {
            OracleIndex index;
            if (ms_bDebug) {
                ms_log.debug("dropIndex: index is a vertex index");
            }
            if ((index = this.getVertexIndex(indexName, false)) == null) {
                ms_log.debug("dropIndex: index not defined");
                return;
            }
            if (ms_bDebug) {
                ms_log.debug("dropIndex: drop index data");
            }
            index.dropIndex();
            this.m_vertexIndexCacheLock.lock();
            if (this.m_vertexIndices != null && this.m_vertexIndices.containsKey(indexName)) {
                if (ms_bDebug) {
                    ms_log.debug("dropIndex: remove index from vertex cache");
                }
                this.m_vertexIndices.remove(indexName);
            }
            this.m_vertexIndexCacheLock.unlock();
            if (ms_bDebug) {
                ms_log.debug("dropIndex: delete index meta data from index table");
            }
            this.deleteIndexMetadata(indexName, null, OracleVertexBase.class);
        } else if (this.existEdgeIndex(indexName)) {
            OracleIndex index;
            if (ms_bDebug) {
                ms_log.debug("dropIndex: index is a vertex index");
            }
            if ((index = this.getEdgeIndex(indexName, false)) == null) {
                ms_log.debug("dropIndex: index not defined");
                return;
            }
            if (ms_bDebug) {
                ms_log.debug("dropIndex: drop index data");
            }
            index.dropIndex();
            this.m_edgeIndexCacheLock.lock();
            if (this.m_edgeIndices != null && this.m_edgeIndices.containsKey(indexName)) {
                if (ms_bDebug) {
                    ms_log.debug("dropIndex: remove index from edges cache");
                }
                this.m_edgeIndices.remove(indexName);
            }
            this.m_edgeIndexCacheLock.unlock();
            if (ms_bDebug) {
                ms_log.debug("dropIndex: delete index meta data from index table");
            }
            this.deleteIndexMetadata(indexName, null, OracleEdgeBase.class);
        }
    }

    public final void dropAllIndices() {
        if (ms_bDebug) {
            ms_log.debug("dropAllIndices: started, drop all indices");
        }
        this.dropIndices();
        if (ms_bDebug) {
            ms_log.debug("dropAllIndices: delete indices from table");
        }
        this.dropIndexMetadata();
    }

    protected abstract void dropIndexMetadata();

    public final void enableEdgeAutoIndexer() {
        if (!this.m_bEdgeAutoIndexerEnabled) {
            this.m_bEdgeAutoIndexerEnabled = true;
        }
    }

    public final void enableVertexAutoIndexer() {
        if (!this.m_bVertexAutoIndexerEnabled) {
            this.m_bVertexAutoIndexerEnabled = true;
        }
    }

    public final boolean existEdgeIndex(String indexName) {
        return this.m_edgeIndices != null && this.m_edgeIndices.containsKey(indexName) || this.existsIndexInDB(indexName, OracleEdgeBase.class);
    }

    protected abstract <T extends OracleElementBase> boolean existsIndexInDB(String var1, Class<T> var2);

    protected final <T extends OracleElementBase> boolean existsManualIndexesInDB(Class<T> indexClass) {
        return this.existsIndexesInDB(indexClass, false);
    }

    protected final <T extends OracleElementBase> boolean existsAutoIndexInDB(Class<T> indexClass) {
        return this.existsIndexesInDB(indexClass, true);
    }

    protected abstract <T extends OracleElementBase> boolean existsIndexesInDB(Class<T> var1, boolean var2);

    public final boolean existVertexIndex(String indexName) {
        return this.m_vertexIndices != null && this.m_vertexIndices.containsKey(indexName) || this.existsIndexInDB(indexName, OracleVertexBase.class);
    }

    protected abstract <T extends OracleElementBase> OracleAutoIndex<T> getAutoIndexFromDB(String var1, Class<T> var2);

    public OracleAutoIndex<OracleEdgeBase> getEdgeAutoIndexer(Parameter ... indexParameters) {
        if (this.isEdgeAutoIndexerEnabled() && this.m_edgeAutoIndex == null) {
            if (!this.existsAutoIndexInDB(OracleEdgeBase.class)) {
                if (ms_bDebug) {
                    ms_log.debug("getEdgeAutoIndexer: create new edge auto indexer");
                }
                if (indexParameters != null && indexParameters.length > 0) {
                    ms_log.debug("getEdgeAutoIndexer: use indexParameters passed in");
                } else {
                    indexParameters = this.m_opg.getDefaultIndexParameters() != null ? this.m_opg.getDefaultIndexParameters().getParameters() : new OracleIndexParameters().getParameters();
                }
                this.m_edgeAutoIndex = this.getEdgeAutoIndexFromPG(indexParameters, true);
            } else {
                if (ms_bDebug) {
                    ms_log.debug("getEdgeAutoIndexer: get edge auto indexer from DB");
                }
                this.m_edgeAutoIndex = this.getAutoIndexFromDB(this.getEdgeAutoIndexName(), OracleEdgeBase.class);
            }
        } else if (!this.isEdgeAutoIndexerEnabled()) {
            this.m_edgeAutoIndex = null;
            if (ms_bDebug) {
                ms_log.debug("getEdgeAutoIndexer: disabled, return null");
            }
        }
        if (ms_bDebug) {
            ms_log.debug("getEdgeAutoIndexer: return edge auto index");
        }
        return this.m_edgeAutoIndex;
    }

    public final <T extends OracleElementBase> OracleIndex<T> getEdgeIndex(String indexName) {
        return this.getEdgeIndex(indexName, true);
    }

    public final <T extends OracleElementBase> OracleIndex<T> getEdgeIndex(String indexName, boolean refresh) {
        if (ms_bDebug) {
            ms_log.debug((Object)"getEdgeIndex: search index ", indexName);
        }
        if (refresh) {
            ms_log.debug("getEdgeIndex: refresh indices cache");
            this.refreshIndicesCache();
        }
        if (this.getEdgeAutoIndexName().equals(indexName)) {
            return this.getEdgeAutoIndexer(new Parameter[0]);
        }
        if (this.m_edgeIndices != null && this.m_edgeIndices.containsKey(indexName)) {
            if (ms_bDebug) {
                ms_log.debug("getEdgeIndex: index is in cache, return from cache");
            }
            return this.m_edgeIndices.get(indexName);
        }
        if (ms_bDebug) {
            ms_log.debug("getEdgeIndex: get index from database");
        }
        OracleIndex index = this.getIndexFromDB(indexName);
        this.m_edgeIndices.put(indexName, index);
        return index;
    }

    private final Iterator<OracleIndex<OracleEdgeBase>> getEdgeIndices() {
        ms_log.debug("getEdgeIndices: refresh edge indices cache");
        this.refreshEdgeIndicesCache();
        if (this.m_edgeIndices != null) {
            if (ms_bDebug) {
                ms_log.debug("getEdgeIndices: indices found in database");
            }
            return this.m_edgeIndices.values().iterator();
        }
        if (ms_bDebug) {
            ms_log.debug("getEdgeIndices: no indices found in database, return null");
        }
        return null;
    }

    protected final <T extends OracleElementBase> Class<T> getEntityTypeAsClass(int type) {
        if (type == 1) {
            return OracleVertexBase.class;
        }
        if (type == 2) {
            return OracleEdgeBase.class;
        }
        throw new OraclePropertyGraphException("Type " + type + " is not Vertex or Edge class ID");
    }

    public static final <T extends OracleElementBase> int getEntityTypeAsInt(Class<T> indexClass) {
        if (indexClass != null && OracleVertexBase.class.isAssignableFrom(indexClass)) {
            return 1;
        }
        if (indexClass != null && OracleEdgeBase.class.isAssignableFrom(indexClass)) {
            return 2;
        }
        throw new OraclePropertyGraphException("Class " + indexClass + " is not Vertex or Edge");
    }

    public abstract <T extends OracleElementBase> List<String> getIndexedKeys(String var1, Class<T> var2);

    protected abstract OracleIndex getIndexFromDB(String var1);

    public final Iterator<OracleIndex<? extends OracleElementBase>> getIndices() {
        if (ms_bDebug) {
            ms_log.debug("getIndices: get indices from database index meta data");
        }
        return new OracleIndexIteratorImpl(this.getIndicesFromDB());
    }

    protected final <T extends OracleElementBase> List<OracleIndex<T>> getIndicesFromDB() {
        return this.getIndicesFromDB(null);
    }

    protected abstract <T extends OracleElementBase> List<OracleIndex<T>> getIndicesFromDB(Class<T> var1);

    public final OracleAutoIndex<OracleVertexBase> getVertexAutoIndexer(Parameter ... indexParameters) {
        if (this.isVertexAutoIndexerEnabled() && this.m_vertexAutoIndex == null) {
            if (!this.existsAutoIndexInDB(OracleVertexBase.class)) {
                if (ms_bDebug) {
                    ms_log.debug("getVertexAutoIndexer: create new vertex auto indexer");
                }
                if (indexParameters != null && indexParameters.length > 0) {
                    ms_log.debug("getVertexAutoIndexer: use indexParameters passed in");
                    this.m_vertexAutoIndex = this.getVertexAutoIndexFromPG(indexParameters, true);
                } else {
                    if (ms_bDebug) {
                        ms_log.debug("getVertexAutoIndexer: use parameters from graph");
                    }
                    indexParameters = this.m_opg.getDefaultIndexParameters() != null ? this.m_opg.getDefaultIndexParameters().getParameters() : new OracleIndexParameters().getParameters();
                    this.m_vertexAutoIndex = this.getVertexAutoIndexFromPG(indexParameters, true);
                }
            } else {
                if (ms_bDebug) {
                    ms_log.debug("getVertexAutoIndexer: get vertex auto indexer from DB");
                }
                this.m_vertexAutoIndex = this.getAutoIndexFromDB(this.getVertexAutoIndexName(), OracleVertexBase.class);
            }
        } else if (!this.isVertexAutoIndexerEnabled()) {
            this.m_vertexAutoIndex = null;
            if (ms_bDebug) {
                ms_log.debug("getVertexAutoIndexer: disabled, return null");
            }
        }
        if (ms_bDebug) {
            ms_log.debug("getVertexAutoIndexer: return vertex auto index");
        }
        return this.m_vertexAutoIndex;
    }

    public final <T extends OracleElementBase> OracleIndex<T> getVertexIndex(String indexName) {
        return this.getVertexIndex(indexName, true);
    }

    public final <T extends OracleElementBase> OracleIndex<T> getVertexIndex(String indexName, boolean refresh) {
        if (ms_bDebug) {
            ms_log.debug((Object)"getVertexIndex: search index ", indexName);
        }
        if (refresh) {
            ms_log.debug("getVertexIndex: refresh indices cache");
            this.refreshIndicesCache();
        }
        if (this.getVertexAutoIndexName().equals(indexName)) {
            return this.getVertexAutoIndexer(new Parameter[0]);
        }
        if (this.m_vertexIndices != null && this.m_vertexIndices.containsKey(indexName)) {
            if (ms_bDebug) {
                ms_log.debug("getVertexIndex: index is in cache, return from cache");
            }
            return this.m_vertexIndices.get(indexName);
        }
        if (ms_bDebug) {
            ms_log.debug("getVertexIndex: get index from database");
        }
        OracleIndex index = this.getIndexFromDB(indexName);
        this.m_vertexIndices.put(indexName, index);
        return index;
    }

    private final Iterator<OracleIndex<OracleVertexBase>> getVertexIndices() {
        ms_log.debug("getVertexIndices: refresh vertex indices cache");
        this.refreshVertexIndicesCache();
        if (this.m_vertexIndices != null) {
            if (ms_bDebug) {
                ms_log.debug("getVertexIndices: indices found in database");
            }
            return this.m_vertexIndices.values().iterator();
        }
        if (ms_bDebug) {
            ms_log.debug("getVertexIndices: no indices found in database, return null");
        }
        return null;
    }

    public final <T extends OracleElementBase> boolean indexAlreadyExists(String indexName, Class<T> indexClass) {
        return this.existsIndexInDB(indexName, indexClass);
    }

    protected static final boolean inTrace() {
        String str = System.getProperty("opg.inTrace");
        return str != null && str.equals("true");
    }

    public final boolean isEdgeAutoIndexerEnabled() {
        return this.m_bEdgeAutoIndexerEnabled;
    }

    public final boolean isVertexAutoIndexerEnabled() {
        return this.m_bVertexAutoIndexerEnabled;
    }

    public final void remove(Object element) {
        this.remove(element, true);
    }

    public final void remove(Object element, boolean forceRefresh) {
        if (forceRefresh) {
            ms_log.debug("remove: refresh indices caches before starting");
            this.refreshIndicesCache();
        }
        if (element instanceof OracleVertexBase) {
            Iterator<OracleIndex<OracleVertexBase>> vIndices;
            if (ms_bDebug) {
                ms_log.debug((Object)"remove: element is a vertex, get vertex indices for vertex", ((OracleVertexBase)element).id());
            }
            if ((vIndices = this.m_vertexIndices.values().iterator()) != null) {
                while (vIndices.hasNext()) {
                    if (ms_bDebug) {
                        ms_log.debug("remove: get next vertex index");
                    }
                    OracleIndex<OracleVertexBase> index = vIndices.next();
                    if (ms_bDebug) {
                        ms_log.debug((Object)"remove: remove vertex from index ", index.getIndexName());
                    }
                    index.remove((OracleVertexBase)element);
                }
            }
            if (this.getVertexAutoIndexer(new Parameter[0]) != null) {
                if (ms_bDebug) {
                    ms_log.debug("remove: remove vertex from auto index");
                }
                this.getVertexAutoIndexer(new Parameter[0]).remove((OracleVertexBase)element);
            }
        } else if (element instanceof OracleEdgeBase) {
            Iterator<OracleIndex<OracleEdgeBase>> eIndices;
            if (ms_bDebug) {
                ms_log.debug((Object)"remove: element is a edge, get edge indices for edge ", ((OracleEdgeBase)element).id());
            }
            if ((eIndices = this.m_edgeIndices.values().iterator()) != null) {
                while (eIndices.hasNext()) {
                    if (ms_bDebug) {
                        ms_log.debug("remove: get next edge index");
                    }
                    OracleIndex<OracleEdgeBase> index = eIndices.next();
                    if (ms_bDebug) {
                        ms_log.debug((Object)"remove: remove edge from index ", index.getIndexName());
                    }
                    index.remove((OracleEdgeBase)element);
                }
            }
            if (this.getEdgeAutoIndexer(new Parameter[0]) != null) {
                ms_log.debug("remove: remove edge from auto index");
                this.getEdgeAutoIndexer(new Parameter[0]).remove((OracleEdgeBase)element);
            }
        }
    }

    public final void removePropertyFromIndices(String key, Object element) {
        if (ms_bDebug) {
            ms_log.debug("removePropertyFromIndices: started ");
        }
        if (element instanceof OracleVertexBase) {
            if (ms_bDebug) {
                ms_log.debug((Object)"removePropertyFromIndices: element is vertex, ", "remove from vertex auto index");
            }
            if (this.isVertexAutoIndexerEnabled() && this.getVertexAutoIndexer(new Parameter[0]) != null) {
                ms_log.debug("removePropertyFromIndices: auto index enabled, remove key");
                this.getVertexAutoIndexer(new Parameter[0]).remove(key, null, (OracleVertexBase)element);
            } else {
                ms_log.debug("removePropertyFromIndices: auto index not enabled, do no op");
            }
        } else if (element instanceof OracleEdgeBase) {
            if (ms_bDebug) {
                ms_log.debug((Object)"removePropertyFromIndices: element is edge, ", "remove from edge auto index");
            }
            if (this.isEdgeAutoIndexerEnabled() && this.getEdgeAutoIndexer(new Parameter[0]) != null) {
                ms_log.debug("removePropertyFromIndices: auto index enabled, remove key");
                this.getEdgeAutoIndexer(new Parameter[0]).remove(key, null, (OracleEdgeBase)element);
            } else {
                ms_log.debug("removePropertyFromIndices: auto index not enabled, do no op");
            }
        }
    }

    public final <T extends OracleElementBase> void startAutoIndexingProperty(String key, Class<T> elementClass) {
        if (OracleVertexBase.class.isAssignableFrom(elementClass)) {
            if (ms_bDebug) {
                ms_log.debug("startAutoIndexingProperty: add key ----- to indexed property names of auto index " + this.getVertexAutoIndexName());
            }
            if (!this.isVertexAutoIndexerEnabled()) {
                if (ms_bDebug) {
                    ms_log.debug((Object)"startAutoIndexingProperty: vertex auto index is not ", "enabled, enable it");
                }
                this.enableVertexAutoIndexer();
            }
            if (!this.containsIndexedKeyFromDB(key, this.getVertexAutoIndexName(), OracleVertexBase.class)) {
                if (ms_bDebug) {
                    ms_log.debug((Object)"startAutoIndexingProperty: reindex data with respect to ", "key -----");
                }
                this.addIndexMetadata(this.getVertexAutoIndexer(new Parameter[0]), key);
                this.getVertexAutoIndexer(new Parameter[0]).reindexElements(key);
            }
        } else if (OracleEdgeBase.class.isAssignableFrom(elementClass)) {
            if (ms_bDebug) {
                ms_log.debug("startAutoIndexingProperty: add key -----  to indexed property names of auto index " + this.getEdgeAutoIndexName());
            }
            if (!this.isEdgeAutoIndexerEnabled()) {
                if (ms_bDebug) {
                    ms_log.debug((Object)"startAutoIndexingProperty: edge auto index is not ", "enabled, enable it");
                }
                this.enableEdgeAutoIndexer();
            }
            if (!this.containsIndexedKeyFromDB(key, this.getEdgeAutoIndexName(), OracleEdgeBase.class)) {
                if (ms_bDebug) {
                    ms_log.debug((Object)"startAutoIndexingProperty: reindex data with respect to ", "key -----");
                }
                this.addIndexMetadata(this.getEdgeAutoIndexer(new Parameter[0]), key);
                this.getEdgeAutoIndexer(new Parameter[0]).reindexElements(key);
            }
        } else {
            throw new IllegalArgumentException("Class is not indexable: " + elementClass);
        }
    }

    public final <T extends OracleElementBase> void startAutoIndexingProperties(String[] propertyNames, Class<T> elementClass) {
        if (OracleVertexBase.class.isAssignableFrom(elementClass)) {
            if (ms_bDebug) {
                StringBuilder propertyNamesSb = new StringBuilder();
                for (int idx = 0; idx < propertyNames.length; ++idx) {
                    propertyNamesSb.append(propertyNames[idx]);
                    if (idx >= propertyNames.length - 1) continue;
                    propertyNamesSb.append(", ");
                }
                ms_log.debug("startAutoIndexingProperties: add propertyNames [] to indexed propertyNames of auto index " + this.getVertexAutoIndexName());
            }
            if (!this.isVertexAutoIndexerEnabled()) {
                if (ms_bDebug) {
                    ms_log.debug((Object)"startAutoIndexingProperties: vertex auto index is not ", "enabled, enable it");
                }
                this.enableVertexAutoIndexer();
            }
            for (int i = 0; i < propertyNames.length; ++i) {
                String key = propertyNames[i];
                if (this.containsIndexedKeyFromDB(key, this.getVertexAutoIndexName(), OracleVertexBase.class)) continue;
                if (ms_bDebug) {
                    ms_log.debug("startAutoIndexingProperties: add indexed key ----- to metadata");
                }
                this.addIndexMetadata(this.getVertexAutoIndexer(new Parameter[0]), key);
            }
            if (ms_bDebug) {
                ms_log.debug("startAutoIndexingProperties: reindex data with respect to key");
            }
            this.getVertexAutoIndexer(new Parameter[0]).reindexElements();
        } else if (OracleEdgeBase.class.isAssignableFrom(elementClass)) {
            if (ms_bDebug) {
                StringBuilder propertyNamesSb = new StringBuilder();
                for (int idx = 0; idx < propertyNames.length; ++idx) {
                    propertyNamesSb.append(propertyNames[idx]);
                    if (idx >= propertyNames.length - 1) continue;
                    propertyNamesSb.append(", ");
                }
                ms_log.debug("startAutoIndexingProperties: add propertyNames [] to indexed propertyNames of auto index " + this.getEdgeAutoIndexName());
            }
            if (!this.isEdgeAutoIndexerEnabled()) {
                if (ms_bDebug) {
                    ms_log.debug((Object)"startAutoIndexingProperties: edge auto index is not ", "enabled, enable it");
                }
                this.enableEdgeAutoIndexer();
            }
            for (int i = 0; i < propertyNames.length; ++i) {
                String key = propertyNames[i];
                if (this.containsIndexedKeyFromDB(key, this.getEdgeAutoIndexName(), OracleEdgeBase.class)) continue;
                if (ms_bDebug) {
                    ms_log.debug("startAutoIndexingProperties: add indexed key to metadata");
                }
                this.addIndexMetadata(this.getEdgeAutoIndexer(new Parameter[0]), key);
            }
            if (ms_bDebug) {
                ms_log.debug((Object)"startAutoIndexingProperties: reindex data with respect ", "to new propertyNames");
            }
            this.getEdgeAutoIndexer(new Parameter[0]).reindexElements();
        } else {
            throw new IllegalArgumentException("Class is not indexable: " + elementClass);
        }
    }

    public final <T extends OracleElementBase> void stopAutoIndexingProperties(String[] propertyNames, Class<T> elementClass) {
        if (OracleVertexBase.class.isAssignableFrom(elementClass)) {
            boolean bReindex = false;
            for (int idx = 0; idx < propertyNames.length; ++idx) {
                if (!this.containsIndexedKeyFromDB(propertyNames[idx], this.getVertexAutoIndexName(), OracleVertexBase.class)) continue;
                if (ms_bDebug) {
                    ms_log.debug("stopAutoIndexingProperties: remove key  from vertex auto index");
                }
                this.deleteIndexMetadata(this.getVertexAutoIndexName(), propertyNames[idx], OracleVertexBase.class);
                this.getVertexAutoIndexer(new Parameter[0]).removeAll(propertyNames[idx]);
                bReindex = true;
            }
            if (bReindex) {
                if (ms_bDebug) {
                    ms_log.debug("stopAutoIndexingProperties: reindex data with respect to indexed propertyNames");
                }
                this.getVertexAutoIndexer(new Parameter[0]).reindexElements();
            }
        } else if (OracleEdgeBase.class.isAssignableFrom(elementClass)) {
            boolean bReindex = false;
            for (int idx = 0; idx < propertyNames.length; ++idx) {
                if (!this.containsIndexedKeyFromDB(propertyNames[idx], this.getEdgeAutoIndexName(), OracleEdgeBase.class)) continue;
                if (ms_bDebug) {
                    ms_log.debug("stopAutoIndexingProperties: remove key  from edge auto index");
                }
                this.deleteIndexMetadata(this.getEdgeAutoIndexName(), propertyNames[idx], OracleEdgeBase.class);
                this.getEdgeAutoIndexer(new Parameter[0]).removeAll(propertyNames[idx]);
                bReindex = true;
            }
            if (bReindex) {
                if (ms_bDebug) {
                    ms_log.debug("stopAutoIndexingProperties: reindex data with respect to indexed propertyNames");
                }
                this.getEdgeAutoIndexer(new Parameter[0]).reindexElements();
            }
        }
    }

    public <T extends OracleElementBase> void stopAutoIndexingProperty(String key, Class<T> elementClass) {
        if (OracleVertexBase.class.isAssignableFrom(elementClass) && this.containsIndexedKeyFromDB(key, this.getVertexAutoIndexName(), OracleVertexBase.class)) {
            List<String> indexedKeys;
            if (ms_bDebug) {
                ms_log.debug("stopAutoIndexingProperty: remove key  from vertex auto index");
            }
            this.deleteIndexMetadata(this.getVertexAutoIndexName(), key, OracleVertexBase.class);
            if (ms_bDebug) {
                ms_log.debug("stopAutoIndexingProperty: reindex data with respect to key");
            }
            if ((indexedKeys = this.getIndexedKeys(this.getVertexAutoIndexName(), OracleVertexBase.class)) != null && indexedKeys.size() > 0) {
                this.getVertexAutoIndexer(new Parameter[0]).removeAll(key);
            } else {
                this.disableVertexAutoIndexer();
            }
        } else if (OracleEdgeBase.class.isAssignableFrom(elementClass) && this.containsIndexedKeyFromDB(key, this.getEdgeAutoIndexName(), OracleEdgeBase.class)) {
            List<String> indexedKeys;
            if (ms_bDebug) {
                ms_log.debug("stopAutoIndexingProperty: remove key  from edge auto index");
            }
            this.deleteIndexMetadata(this.getEdgeAutoIndexName(), key, OracleEdgeBase.class);
            if (ms_bDebug) {
                ms_log.debug("stopAutoIndexingProperty: reindex data with respect to key");
            }
            if ((indexedKeys = this.getIndexedKeys(this.getEdgeAutoIndexName(), OracleEdgeBase.class)) != null && indexedKeys.size() > 0) {
                this.getEdgeAutoIndexer(new Parameter[0]).removeAll(key);
            } else {
                this.disableEdgeAutoIndexer();
            }
        }
    }

    public final String getVertexAutoIndexName() {
        return "VERTEX_AUTO_INDEX";
    }

    public final String getEdgeAutoIndexName() {
        return "EDGE_AUTO_INDEX";
    }

    protected abstract void createIndexTable();

    protected abstract OracleAutoIndex<OracleVertexBase> getVertexAutoIndexFromPG(Parameter[] var1, boolean var2);

    protected abstract OracleIndex<OracleVertexBase> getVertexIndexFromPG(String var1, Parameter[] var2, boolean var3);

    protected abstract OracleIndex<OracleEdgeBase> getEdgeIndexFromPG(String var1, Parameter[] var2, boolean var3);

    protected abstract OracleAutoIndex<OracleEdgeBase> getEdgeAutoIndexFromPG(Parameter[] var1, boolean var2);

    public void refreshAutoIndices() {
        if (this.isVertexAutoIndexerEnabled() && this.getVertexAutoIndexer(new Parameter[0]) != null) {
            ms_log.debug("refreshAutoIndices: vertex auto index enabled, reindex ");
            this.getVertexAutoIndexer(new Parameter[0]).reindexElements();
        } else {
            ms_log.debug("refreshAutoIndices: vertex auto index not enabled, do no op");
        }
        if (this.isEdgeAutoIndexerEnabled() && this.getEdgeAutoIndexer(new Parameter[0]) != null) {
            ms_log.debug("refreshAutoIndices: edge auto index enabled, reindex");
            this.getEdgeAutoIndexer(new Parameter[0]).reindexElements();
        } else {
            ms_log.debug("refreshAutoIndices: edge auto index not enabled, do no op");
        }
    }
}

