/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.loader.exceptions;

public class InvalidPropertyTypeException
extends RuntimeException {
    public InvalidPropertyTypeException(String id, long lLineIdx, String szLine, CauseType type) {
        super("Invalid Property Type '" + id + "' in line #" + lLineIdx + " with content '" + szLine + "',  property type column " + InvalidPropertyTypeException.getCause(type));
    }

    public InvalidPropertyTypeException(int id, CauseType type) {
        super("Invalid Property Type '" + id + "' property type column " + InvalidPropertyTypeException.getCause(type));
    }

    public static String getCause(CauseType type) {
        if (type == null) {
            return null;
        }
        if (CauseType.INVALID_NUMERIC_VALUE.equals((Object)type)) {
            return " must be a numeric value";
        }
        if (CauseType.INVALID_PROPERTY_TYPE.equals((Object)type)) {
            return " is an invalid property type value, value must be a numeric value from 1 to 10 or 20,25,30, 101";
        }
        return null;
    }

    public static enum CauseType {
        INVALID_NUMERIC_VALUE,
        INVALID_PROPERTY_TYPE;

    }
}

