/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.loader.exceptions;

public class InvalidIdArgumentException
extends RuntimeException {
    public InvalidIdArgumentException(String id, long lLineIdx, String szLine, Column column, CauseType type) {
        super("Invalid " + InvalidIdArgumentException.getColumn(column) + " ID '" + id + "' in line #" + lLineIdx + " with content '" + szLine + "',  " + InvalidIdArgumentException.getCause(type, column));
    }

    public InvalidIdArgumentException(String idA, String idB, long lLineIdx, String szLine, Column columnA, Column columnB, CauseType type) {
        super("Invalid " + InvalidIdArgumentException.getColumn(columnA) + " ID '" + idA + "' in line #" + lLineIdx + " with content '" + szLine + "',  " + InvalidIdArgumentException.getCause(type, columnA) + " and " + InvalidIdArgumentException.getColumn(columnB) + " ID '" + idB + "' in line #" + lLineIdx + " with content '" + szLine + "',  " + InvalidIdArgumentException.getCause(type, columnB));
    }

    public static String getColumn(Column column) {
        if (column == null) {
            return null;
        }
        if (Column.VID.equals((Object)column)) {
            return "VERTEX";
        }
        if (Column.SVID.equals((Object)column)) {
            return "SOURCE VERTEX";
        }
        if (Column.DVID.equals((Object)column)) {
            return "DESTINATION VERTEX";
        }
        if (Column.EID.equals((Object)column)) {
            return "EDGE";
        }
        return null;
    }

    public static String getCause(CauseType type, Column column) {
        if (type == null) {
            return null;
        }
        if (CauseType.INVALID_NUMERIC_VALUE.equals((Object)type)) {
            return (Object)((Object)column) + " must be a Long numeric value";
        }
        if (CauseType.GHOST_VERTEX.equals((Object)type)) {
            return (Object)((Object)column) + " is a ghost vertex as it is not defined in the graph";
        }
        return null;
    }

    public static enum Column {
        VID,
        SVID,
        DVID,
        EID;

    }

    public static enum CauseType {
        INVALID_NUMERIC_VALUE,
        GHOST_VERTEX;

    }
}

