/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.csvconverter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.UUID;
import oracle.pg.common.ColumnToAttrMapping;
import oracle.pg.common.DataConverterListener;
import oracle.pg.common.HelperUtilities;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.OraclePropertyGraphUtilsBase;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.SimpleJsonDataWrapper;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.SimpleRdfDataWrapper;
import oracle.pg.common.SimpleSpatialDataWrapper;
import oracle.pg.common.csvconverter.CSV2OPEConfig;
import oracle.pg.common.csvconverter.CSV2OPGConfig;
import oracle.pg.common.csvconverter.CSV2OPVConfig;
import oracle.pg.common.exporter.ExporterUtils;
import org.apache.commons.io.FilenameUtils;

public abstract class OraclePropertyGraphCSVConverter {
    static SimpleLog ms_log = SimpleLog.getLog(OraclePropertyGraphCSVConverter.class);
    protected static final boolean ms_bDebug = ms_log.isDebugEnabled();
    protected static final boolean ms_bShowProgress = ParametersBase.getInstance().showProgress();
    private static final String CHARSET = ParametersBase.getCharset();
    private static final String SPACE_DELIMITER = " ";
    private static final String FIELD_DELIMITER = ",";
    private static final String RECORD_DELIMITER = "\n";
    private static final String FALLBACK_STRING = String.valueOf("");
    private static final Float FALLBACK_FLOAT = Float.valueOf(0.0f);
    private static final Integer FALLBACK_INTEGER = 0;
    private static final Double FALLBACK_DOUBLE = 0.0;
    private static final Long FALLBACK_LONG = 0L;
    private static final Short FALLBACK_SHORT = 0;
    private static final Byte FALLBACK_BYTE = 0;
    private static final Character FALLBACK_CHAR = Character.valueOf('\u0000');
    private static final Boolean FALLBACK_BOOLEAN = false;
    private static final Date FALLBACK_DATE = new Date();
    private static final SimpleSpatialDataWrapper FALLBACK_SPATIAL_WRAPPER = SimpleSpatialDataWrapper.getInstance("");
    private static final SimpleJsonDataWrapper FALLBACK_JSON_WRAPPER = SimpleJsonDataWrapper.getInstance("");
    private static final SimpleRdfDataWrapper FALLBACK_RDF_WRAPPER = SimpleRdfDataWrapper.getInstance("");
    private static StringBuilder sbCsvRecord = new StringBuilder();
    private static long lErrors;

    public static void convertCSV2OPV(InputStream inCSV, String vidColName, long lOffsetVID, ColumnToAttrMapping[] ctams, int dop, long lOffsetLines, DateFormat dateFormat, OutputStream opvOS, DataConverterListener dcl) {
        OraclePropertyGraphCSVConverter.convertCSV2OPV(inCSV, vidColName, lOffsetVID, ctams, dop, ',', '\"', lOffsetLines, dateFormat, false, opvOS, dcl);
    }

    public static void convertCSV2OPV(InputStream inCSV, String vidColName, long lOffsetVID, ColumnToAttrMapping[] ctams, int dop, long lOffsetLines, OutputStream opvOS, DataConverterListener dcl) {
        OraclePropertyGraphCSVConverter.convertCSV2OPV(inCSV, vidColName, lOffsetVID, ctams, dop, ',', '\"', lOffsetLines, null, false, opvOS, dcl);
    }

    public static void convertCSV2OPV(InputStream inCSV, String vidColName, long lOffsetVID, ColumnToAttrMapping[] ctams, int dop, char delimiterChar, char quotationChar, long lOffsetLines, DateFormat dateFormat, OutputStream opvOS, DataConverterListener dcl) {
        OraclePropertyGraphCSVConverter.convertCSV2OPV(inCSV, vidColName, lOffsetVID, ctams, dop, delimiterChar, quotationChar, lOffsetLines, dateFormat, false, opvOS, dcl);
    }

    public static void convertCSV2OPV(InputStream inCSV, String vidColName, long lOffsetVID, ColumnToAttrMapping[] ctams, int dop, char delimiterChar, char quotationChar, long lOffsetLines, DateFormat dateFormat, boolean allowMultiline, OutputStream opvOS, DataConverterListener dcl) {
        OraclePropertyGraphCSVConverter.convertCSV2OPV(inCSV, vidColName, false, null, lOffsetVID, ctams, dop, delimiterChar, quotationChar, lOffsetLines, dateFormat, allowMultiline, opvOS, dcl);
    }

    public static void convertCSV2OPV(InputStream inCSV, String vidColName, boolean hasVertexLabelCol, String vlColName, long lOffsetVID, ColumnToAttrMapping[] ctams, int dop, char delimiterChar, char quotationChar, long lOffsetLines, DateFormat dateFormat, boolean allowMultiline, OutputStream opvOS, DataConverterListener dcl) {
        CSV2OPVConfig config = (CSV2OPVConfig)new CSV2OPVConfig().setVidColumnName(vidColName).setHasVertexLabelColumn(hasVertexLabelCol).setVlColumnName(vlColName).setOffsetVID(lOffsetVID).setCtams(ctams).setDop(dop).setDelimiterChar(delimiterChar).setQuotationChar(quotationChar).setOffsetLines(lOffsetLines).setDateFormat(dateFormat).setAllowMultiLine(allowMultiline).setDcl(dcl);
        OraclePropertyGraphCSVConverter.convertCSV2OPV(inCSV, config, opvOS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void convertCSV2OPV(InputStream inCSV, CSV2OPVConfig config, OutputStream opvOS) {
        vidColName = config.getVidColumnName();
        lOffsetVID = config.getOffsetVID();
        ctams = config.getCtams();
        hasVertexLabelCol = config.hasVertexLabelColumn();
        vlColName = config.getVlColumnName();
        delimiterChar = config.getDelimiterChar();
        quotationChar = config.getQuotationChar();
        lOffsetLines = config.getOffsetLines();
        dateFormat = config.getDateFormat();
        allowMultiline = config.allowsMultiLine();
        dcl = config.getDcl();
        allowExtraFields = config.allowsExtraFields();
        try {
            baFieldDelimiter = ",".getBytes(OraclePropertyGraphCSVConverter.CHARSET);
            baRecordDelimiter = "\n".getBytes(OraclePropertyGraphCSVConverter.CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new OraclePropertyGraphException(e);
        }
        baEscapedSpaceDelimiter = HelperUtilities.escape(" ");
        dateFormats = new DateFormat[OraclePropertyGraphBase.CSV_DATE_TIME_FORMATS.length + 1];
        dateFormats[0] = dateFormat;
        for (idx = 0; idx < OraclePropertyGraphBase.CSV_DATE_TIME_FORMATS.length; ++idx) {
            dateFormats[idx + 1] = new SimpleDateFormat(OraclePropertyGraphBase.CSV_DATE_TIME_FORMATS[idx]);
        }
        opgDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        try {
            brIn = new BufferedReader(new InputStreamReader(inCSV, OraclePropertyGraphCSVConverter.CHARSET), 0x100000);
        }
        catch (UnsupportedEncodingException e) {
            throw new OraclePropertyGraphException(e);
        }
        OraclePropertyGraphCSVConverter.lErrors = 0L;
        szCsvRecord = "";
        szPropertyKey = null;
        value = null;
        if (config.getCtams() == null) {
            try {
                szCsvRecord = OraclePropertyGraphCSVConverter.readCsvRecord(brIn, allowMultiline, quotationChar);
            }
            catch (IOException ioe) {
                throw new OraclePropertyGraphException(ioe);
            }
            ctams = OraclePropertyGraphCSVConverter.parseHeaderToColumnToAttrMappings(szCsvRecord, delimiterChar);
        }
        idColumnPosition = -1;
        if (vidColName != null) {
            for (i = 0; i < ctams.length; ++i) {
                if (!ctams[i].getAttrName().equals(vidColName)) continue;
                if (ctams[i].getColumnPosition() != -1) {
                    idColumnPosition = ctams[i].getColumnPosition();
                    break;
                }
                idColumnPosition = i;
                break;
            }
        }
        labelPosition = -1;
        if (hasVertexLabelCol) {
            for (i = 0; i < ctams.length; ++i) {
                if (!ctams[i].getAttrName().equals(vlColName)) continue;
                if (ctams[i].getColumnPosition() != -1) {
                    labelPosition = ctams[i].getColumnPosition();
                    break;
                }
                labelPosition = i;
                break;
            }
        }
        try {
            for (lLineIdx = 0L; lLineIdx < lOffsetLines && (szCsvRecord = OraclePropertyGraphCSVConverter.readCsvRecord(brIn, allowMultiline, quotationChar)) != null; ++lLineIdx) {
            }
        }
        catch (IOException e) {
            OraclePropertyGraphCSVConverter.handleError(dcl, lLineIdx, szCsvRecord, "convertCSV2OPV: hit IOException.");
        }
        lSrcMaxlines = -1L;
        baos = new ByteArrayOutputStream(0x1000000);
        while (true) {
            block49: {
                block48: {
                    block47: {
                        try lbl-1000:
                        // 4 sources

                        {
                            while (true) {
                                if ((lSrcMaxlines == -1L || lLineIdx < lSrcMaxlines) && (szCsvRecord = OraclePropertyGraphCSVConverter.readCsvRecord(brIn, allowMultiline, quotationChar)) != null) {
                                    if (dcl != null && ++lLineIdx % dcl.reportProgressFrequency() == 0L) {
                                        dcl.progressTo(lLineIdx, "convertCSV2OPV: done to " + lLineIdx);
                                    }
                                    expectedLength = ctams.length;
                                    for (idx = 0; idx < ctams.length; ++idx) {
                                        if (ctams[idx].getColumnPosition() + 1 <= expectedLength) continue;
                                        expectedLength = ctams[idx].getColumnPosition() + 1;
                                    }
                                    csvVertexTokens = OraclePropertyGraphCSVConverter.splitEscapedStringValues(lLineIdx, szCsvRecord, ctams, delimiterChar, quotationChar, allowExtraFields, expectedLength, dcl);
                                    vertexHasKV = false;
                                    break block47;
                                }
                                baos.flush();
                                expectedLength = opvOS;
                                synchronized (expectedLength) {
                                    baos.writeTo(opvOS);
                                    baos.reset();
                                    opvOS.flush();
                                }
                                break;
                            }
                        }
                        catch (IOException e) {
                            OraclePropertyGraphCSVConverter.handleError(dcl, lLineIdx, szCsvRecord, "convertCSV2OPV: hit IOException.");
                        }
                        try {
                            opvOS.flush();
                            return;
                        }
                        catch (IOException e) {
                            OraclePropertyGraphCSVConverter.ms_log.error("hit IOException when flushing vertices from csv to opv");
                        }
                        return;
                    }
                    for (i = 0; i < ctams.length; ++i) {
                        valueColumnPosition = i;
                        if (ctams[i].getColumnPosition() != -1) {
                            valueColumnPosition = ctams[i].getColumnPosition();
                        }
                        if (valueColumnPosition == idColumnPosition || csvVertexTokens[valueColumnPosition] == null) continue;
                        vertexHasKV = true;
                        break;
                    }
                    vid = null;
                    if (idColumnPosition == -1) break block48;
                    if (csvVertexTokens[idColumnPosition] == null) ** GOTO lbl-1000
                    longID = OraclePropertyGraphCSVConverter.parseTokenToID(csvVertexTokens[idColumnPosition]);
                    vid = longID + lOffsetVID;
                    break block49;
                }
                vid = lLineIdx + lOffsetVID;
            }
            if (vertexHasKV) break;
            try {
                baos.write(vid.toString().getBytes(OraclePropertyGraphCSVConverter.CHARSET));
                baos.write(baFieldDelimiter);
                baos.write(baEscapedSpaceDelimiter);
                baos.write(baFieldDelimiter);
                baos.write(baFieldDelimiter);
                baos.write(baFieldDelimiter);
                baos.write(baFieldDelimiter);
                if (labelPosition != -1) {
                    baos.write(baFieldDelimiter);
                    baos.write(HelperUtilities.escape(csvVertexTokens[labelPosition]));
                } else if (vlColName != null) {
                    baos.write(baFieldDelimiter);
                    baos.write(HelperUtilities.escape(vlColName));
                }
                baos.write(baRecordDelimiter);
            }
            catch (IOException ioe) {
                OraclePropertyGraphCSVConverter.handleError(dcl, lLineIdx, szCsvRecord, "convertCSV2OPV: hit IOException writing empty vertex.");
                ** GOTO lbl-1000
            }
        }
        i = 0;
        while (true) {
            if (i < ctams.length) ** break;
            ** continue;
            valueColumnPosition = i;
            if (ctams[i].getColumnPosition() != -1) {
                valueColumnPosition = ctams[i].getColumnPosition();
            }
            if (valueColumnPosition != idColumnPosition && csvVertexTokens[valueColumnPosition] != null) {
                try {
                    baos.write(vid.toString().getBytes(OraclePropertyGraphCSVConverter.CHARSET));
                    baos.write(baFieldDelimiter);
                    szPropertyKey = ctams[i].getAttrName();
                    if (szPropertyKey == null || szPropertyKey.isEmpty()) {
                        szPropertyKey = " ";
                    }
                    baos.write(HelperUtilities.escape(szPropertyKey));
                    baos.write(baFieldDelimiter);
                    value = OraclePropertyGraphCSVConverter.parseTokenToObject(ctams[i], csvVertexTokens[valueColumnPosition], dateFormats, lLineIdx, dcl);
                    ExporterUtils.writeValue(baos, value, baFieldDelimiter, opgDateFormat);
                    if (labelPosition != -1) {
                        baos.write(baFieldDelimiter);
                        baos.write(HelperUtilities.escape(csvVertexTokens[labelPosition]));
                    } else if (vlColName != null) {
                        baos.write(baFieldDelimiter);
                        baos.write(HelperUtilities.escape(vlColName));
                    }
                    baos.write(baRecordDelimiter);
                }
                catch (IOException ioe) {
                    OraclePropertyGraphCSVConverter.handleError(dcl, lLineIdx, szCsvRecord, "convertCSV2OPV: hit IOException writing property.");
                }
                if (baos.size() > 0xC00000) {
                    baos.flush();
                    var39_49 = opvOS;
                    synchronized (var39_49) {
                        baos.writeTo(opvOS);
                        baos.reset();
                    }
                }
            }
            ++i;
        }
    }

    public static String readCsvRecord(BufferedReader br, boolean allowMultiline, char quotChar) throws IOException {
        if (!allowMultiline) {
            return br.readLine();
        }
        boolean insideQuote = false;
        boolean twoCharactersNewLine = false;
        int nextChar = -1;
        int n = -1;
        int ch = br.read();
        if (ch == -1) {
            return null;
        }
        while (ch != -1) {
            int n2;
            if (ch == quotChar) {
                boolean bl = insideQuote = !insideQuote;
                if (n2 == 92) {
                    insideQuote = !insideQuote;
                }
            } else if (!insideQuote) {
                if (ch == 10) break;
                if (ch == 13) {
                    nextChar = br.read();
                    if (nextChar != 10) break;
                    twoCharactersNewLine = true;
                    break;
                }
            }
            sbCsvRecord.append((char)ch);
            n2 = ch;
            ch = br.read();
        }
        String csvRecord = sbCsvRecord.toString();
        sbCsvRecord = new StringBuilder();
        if (!twoCharactersNewLine && nextChar != -1) {
            sbCsvRecord.append((char)nextChar);
        }
        return csvRecord;
    }

    private static Long parseTokenToID(String str) {
        Long id;
        if (str == null) {
            str = "";
        }
        try {
            id = Long.parseLong(str);
        }
        catch (NumberFormatException ex) {
            id = HelperUtilities.hash64(str, 0, str.length(), 0L);
        }
        return id;
    }

    private static String[] splitEscapedStringValues(long lLineIdx, String szLine, ColumnToAttrMapping[] ctams, char delChar, char quotChar, boolean allowExtraFields, int expectedLength, DataConverterListener dcl) {
        int toReturnLength = ctams.length;
        if (expectedLength != -1) {
            toReturnLength = expectedLength;
        }
        String[] csvTokens = new String[toReturnLength];
        int position = 0;
        for (int expectedToken = 0; expectedToken < toReturnLength; ++expectedToken) {
            boolean quoteOpened;
            boolean stringWasQuoted = false;
            if (expectedToken < toReturnLength - 1 && position >= szLine.length()) {
                OraclePropertyGraphCSVConverter.handleError(dcl, lLineIdx, szLine, "Mising field(s) in row " + lLineIdx + ": " + szLine);
            }
            StringBuilder sb = new StringBuilder();
            stringWasQuoted = quoteOpened = position < szLine.length() && szLine.charAt(position) == quotChar;
            if (quoteOpened) {
                ++position;
                while (position < szLine.length() && quoteOpened) {
                    if (szLine.charAt(position) == quotChar && position + 1 < szLine.length() && szLine.charAt(position + 1) == quotChar) {
                        sb.append(quotChar);
                        position += 2;
                        continue;
                    }
                    if (szLine.charAt(position) == '\\' && position + 1 < szLine.length() && szLine.charAt(position + 1) == quotChar) {
                        sb.append(quotChar);
                        position += 2;
                        continue;
                    }
                    if (szLine.charAt(position) == '\\' && position + 1 < szLine.length() && szLine.charAt(position + 1) == '\\') {
                        sb.append('\\');
                        position += 2;
                        continue;
                    }
                    if (szLine.charAt(position) == quotChar && position + 1 < szLine.length() && szLine.charAt(position + 1) != quotChar || szLine.charAt(position) == quotChar && position + 1 == szLine.length()) {
                        quoteOpened = false;
                        ++position;
                        continue;
                    }
                    sb.append(szLine.charAt(position));
                    ++position;
                }
                if (quoteOpened) {
                    OraclePropertyGraphCSVConverter.handleError(dcl, lLineIdx, szLine, "Quote not closed in row " + lLineIdx + ": " + szLine);
                }
                if (position < szLine.length() && szLine.charAt(position) != delChar) {
                    OraclePropertyGraphCSVConverter.handleError(dcl, lLineIdx, szLine, "Data after quote in row " + lLineIdx + ": " + szLine);
                }
                if (expectedToken < toReturnLength - 1 && position >= szLine.length()) {
                    OraclePropertyGraphCSVConverter.handleError(dcl, lLineIdx, szLine, "Mising field(s) in row " + lLineIdx + ": " + szLine);
                }
            } else {
                while (position < szLine.length() && szLine.charAt(position) != delChar) {
                    sb.append(szLine.charAt(position++));
                }
            }
            csvTokens[expectedToken] = sb.toString();
            if (csvTokens[expectedToken].isEmpty() && !stringWasQuoted) {
                csvTokens[expectedToken] = null;
            }
            if (expectedToken >= toReturnLength - 1) continue;
            ++position;
        }
        if (!allowExtraFields && position < szLine.length()) {
            OraclePropertyGraphCSVConverter.handleError(dcl, lLineIdx, szLine, "Extra field(s) in row " + lLineIdx + ": " + szLine);
        }
        return csvTokens;
    }

    public static ColumnToAttrMapping[] parseHeaderToColumnToAttrMappings(String header, char delimiterChar) {
        String[] tokens = OraclePropertyGraphCSVConverter.splitWithoutRegex(header, delimiterChar);
        LinkedList<ColumnToAttrMapping> ctaml = new LinkedList<ColumnToAttrMapping>();
        for (int idx = 0; idx < tokens.length; ++idx) {
            ColumnToAttrMapping ctam = OraclePropertyGraphCSVConverter.parseTokenToColumnToAttrMapping(tokens[idx]);
            ctaml.add(ctam);
        }
        return ctaml.toArray(new ColumnToAttrMapping[ctaml.size()]);
    }

    private static String[] splitWithoutRegex(String str, char delimiter) {
        LinkedList<String> splited = new LinkedList<String>();
        StringBuilder sb = new StringBuilder();
        if (str == null) {
            return null;
        }
        for (int idx = 0; idx < str.length(); ++idx) {
            if (str.charAt(idx) == delimiter) {
                splited.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            sb.append(str.charAt(idx));
        }
        splited.add(sb.toString());
        return splited.toArray(new String[splited.size()]);
    }

    private static ColumnToAttrMapping parseTokenToColumnToAttrMapping(String str) {
        String[] tokens = OraclePropertyGraphCSVConverter.splitWithoutRegex(str, ':');
        Class dtClass = String.class;
        if (tokens == null || tokens.length == 0) {
            return null;
        }
        if (tokens.length == 2 && tokens[1] != null) {
            if ("START_ID".equals(tokens[1]) || "END_ID".equals(tokens[1]) || "TYPE".equals(tokens[1]) || "ID".equals(tokens[1])) {
                if ("string".equals(tokens[0])) {
                    dtClass = String.class;
                    tokens[0] = tokens[1];
                } else if ("boolean".equals(tokens[0])) {
                    dtClass = Boolean.class;
                    tokens[0] = tokens[1];
                } else if ("byte".equals(tokens[0])) {
                    dtClass = Byte.class;
                    tokens[0] = tokens[1];
                } else if ("short".equals(tokens[0])) {
                    dtClass = Short.class;
                    tokens[0] = tokens[1];
                } else if ("int".equals(tokens[0])) {
                    dtClass = Integer.class;
                    tokens[0] = tokens[1];
                } else if ("long".equals(tokens[0])) {
                    dtClass = Long.class;
                    tokens[0] = tokens[1];
                } else if ("float".equals(tokens[0])) {
                    dtClass = Float.class;
                    tokens[0] = tokens[1];
                } else if ("double".equals(tokens[0])) {
                    dtClass = Double.class;
                    tokens[0] = tokens[1];
                } else if ("char".equals(tokens[0])) {
                    dtClass = Character.class;
                    tokens[0] = tokens[1];
                } else if ("date".equals(tokens[0])) {
                    dtClass = Date.class;
                    tokens[0] = tokens[1];
                } else if ("spatial".equals(tokens[0])) {
                    dtClass = SimpleSpatialDataWrapper.class;
                    tokens[0] = tokens[1];
                } else if ("json".equals(tokens[0])) {
                    dtClass = SimpleJsonDataWrapper.class;
                    tokens[0] = tokens[1];
                } else if ("rdf".equals(tokens[0])) {
                    dtClass = SimpleRdfDataWrapper.class;
                    tokens[0] = tokens[1];
                } else if ("".equals(tokens[0]) || tokens[0] == null) {
                    dtClass = String.class;
                    tokens[0] = tokens[1];
                } else {
                    dtClass = String.class;
                }
            } else {
                dtClass = OraclePropertyGraphCSVConverter.getDatatypeClassFromToken(tokens[1]);
            }
        } else if (tokens.length == 3 && tokens[1] != null) {
            if (tokens[0] == null || tokens[0].isEmpty()) {
                tokens[0] = tokens[2] == null ? "" : tokens[2];
            }
            dtClass = OraclePropertyGraphCSVConverter.getDatatypeClassFromToken(tokens[1]);
        }
        return ColumnToAttrMapping.getInstance(tokens[0], dtClass);
    }

    private static Class<?> getDatatypeClassFromToken(String token) {
        if ("string".equalsIgnoreCase(token)) {
            return String.class;
        }
        if ("boolean".equalsIgnoreCase(token)) {
            return Boolean.class;
        }
        if ("byte".equalsIgnoreCase(token)) {
            return Byte.class;
        }
        if ("short".equalsIgnoreCase(token)) {
            return Short.class;
        }
        if ("int".equalsIgnoreCase(token)) {
            return Integer.class;
        }
        if ("long".equalsIgnoreCase(token)) {
            return Long.class;
        }
        if ("float".equalsIgnoreCase(token)) {
            return Float.class;
        }
        if ("double".equalsIgnoreCase(token)) {
            return Double.class;
        }
        if ("char".equalsIgnoreCase(token)) {
            return Character.class;
        }
        if ("date".equalsIgnoreCase(token)) {
            return Date.class;
        }
        if ("spatial".equalsIgnoreCase(token)) {
            return SimpleSpatialDataWrapper.class;
        }
        if ("json".equalsIgnoreCase(token)) {
            return SimpleJsonDataWrapper.class;
        }
        if ("rdf".equalsIgnoreCase(token)) {
            return SimpleRdfDataWrapper.class;
        }
        return String.class;
    }

    private static Object parseTokenToObject(ColumnToAttrMapping ctam, String csvToken, DateFormat[] dateFormats, long progress, DataConverterListener dcl) {
        Object value;
        block25: {
            value = null;
            if (ms_bDebug) {
                ms_log.debug("parseTokenToObject: started with columnToAttrMapping ");
                ms_log.debug("parseTokenToObject: started with  token ");
            }
            try {
                if (ctam.getDTClass() == String.class) {
                    value = FALLBACK_STRING;
                    if (csvToken != null) {
                        value = csvToken;
                    } else {
                        OraclePropertyGraphCSVConverter.handleError(dcl, progress, csvToken, "parseTokenToObject: null value for attribute ");
                    }
                    break block25;
                }
                if (Float.class.isAssignableFrom(ctam.getDTClass())) {
                    value = FALLBACK_FLOAT;
                    value = Float.valueOf(Float.parseFloat(csvToken));
                    break block25;
                }
                if (Integer.class.isAssignableFrom(ctam.getDTClass())) {
                    value = FALLBACK_INTEGER;
                    value = Integer.parseInt(csvToken);
                    break block25;
                }
                if (Double.class.isAssignableFrom(ctam.getDTClass())) {
                    value = FALLBACK_DOUBLE;
                    value = Double.parseDouble(csvToken);
                    break block25;
                }
                if (Long.class.isAssignableFrom(ctam.getDTClass())) {
                    value = FALLBACK_LONG;
                    value = Long.parseLong(csvToken);
                    break block25;
                }
                if (Short.class.isAssignableFrom(ctam.getDTClass())) {
                    value = FALLBACK_SHORT;
                    value = Short.parseShort(csvToken);
                    break block25;
                }
                if (Byte.class.isAssignableFrom(ctam.getDTClass())) {
                    value = FALLBACK_BYTE;
                    value = Byte.parseByte(csvToken);
                    break block25;
                }
                if (Character.class.isAssignableFrom(ctam.getDTClass())) {
                    value = FALLBACK_CHAR;
                    value = Character.valueOf(csvToken.charAt(0));
                    break block25;
                }
                if (Boolean.class.isAssignableFrom(ctam.getDTClass())) {
                    value = FALLBACK_BOOLEAN;
                    value = Boolean.parseBoolean(csvToken);
                    break block25;
                }
                if (Date.class.isAssignableFrom(ctam.getDTClass())) {
                    value = FALLBACK_DATE;
                    boolean parseSucceded = false;
                    ParseException pex = null;
                    int iStart = 0;
                    if (dateFormats[iStart] == null) {
                        ++iStart;
                    }
                    for (int idx = iStart; idx < dateFormats.length; ++idx) {
                        try {
                            if (dateFormats[idx] == null) continue;
                            value = dateFormats[idx].parse(OraclePropertyGraphUtilsBase.unescape(csvToken));
                            parseSucceded = true;
                            pex = null;
                            break;
                        }
                        catch (ParseException pe) {
                            pex = pe;
                        }
                    }
                    if (!parseSucceded) {
                        throw pex;
                    }
                    break block25;
                }
                if (SimpleSpatialDataWrapper.class.isAssignableFrom(ctam.getDTClass())) {
                    value = FALLBACK_SPATIAL_WRAPPER;
                    value = SimpleSpatialDataWrapper.getInstance(csvToken);
                    break block25;
                }
                if (SimpleJsonDataWrapper.class.isAssignableFrom(ctam.getDTClass())) {
                    value = FALLBACK_JSON_WRAPPER;
                    value = SimpleJsonDataWrapper.getInstance(csvToken);
                    break block25;
                }
                if (SimpleRdfDataWrapper.class.isAssignableFrom(ctam.getDTClass())) {
                    value = FALLBACK_RDF_WRAPPER;
                    value = SimpleRdfDataWrapper.getInstance(csvToken);
                    break block25;
                }
                throw new OraclePropertyGraphException("parseTokenToObject: Unknown value type : " + ctam.getClass().getName());
            }
            catch (ParseException ex) {
                OraclePropertyGraphCSVConverter.handleError(dcl, progress, csvToken, "parseTokenToObject: hit ParseException with value " + csvToken + " for attribute " + ctam.getAttrName() + " to " + ctam.getDTClass());
            }
            catch (NumberFormatException ex) {
                OraclePropertyGraphCSVConverter.handleError(dcl, progress, csvToken, "parseTokenToObject: hit NumberFormatException with value ");
            }
        }
        if (ms_bDebug) {
            ms_log.debug("parseTokenToObject: value object is ");
        }
        return value;
    }

    private static void handleError(DataConverterListener dcl, long progress, Object offender, String message) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug(message);
        }
        if (dcl != null) {
            if (!dcl.continueOnError(++lErrors, progress, offender, message)) {
                throw new OraclePropertyGraphException(message);
            }
        } else {
            throw new OraclePropertyGraphException(message);
        }
    }

    public static void convertCSV2OPE(InputStream inCSV, String eidColName, long lOffsetEID, String svidColName, String dvidColName, boolean hasEdgeLabelCol, String elColName, ColumnToAttrMapping[] ctams, int dop, long lOffsetLines, DateFormat dateFormat, OutputStream opeOS, DataConverterListener dcl) {
        OraclePropertyGraphCSVConverter.convertCSV2OPE(inCSV, eidColName, lOffsetEID, svidColName, dvidColName, hasEdgeLabelCol, elColName, ctams, dop, ',', '\"', lOffsetLines, dateFormat, false, opeOS, dcl);
    }

    public static void convertCSV2OPE(InputStream inCSV, String eidColName, long lOffsetEID, String svidColName, String dvidColName, boolean hasEdgeLabelCol, String elColName, ColumnToAttrMapping[] ctams, int dop, long lOffsetLines, OutputStream opeOS, DataConverterListener dcl) {
        OraclePropertyGraphCSVConverter.convertCSV2OPE(inCSV, eidColName, lOffsetEID, svidColName, dvidColName, hasEdgeLabelCol, elColName, ctams, dop, ',', '\"', lOffsetLines, null, false, opeOS, dcl);
    }

    public static void convertCSV2OPE(InputStream inCSV, String eidColName, long lOffsetEID, String svidColName, String dvidColName, boolean hasEdgeLabelCol, String elColName, ColumnToAttrMapping[] ctams, int dop, char delimiterChar, char quotationChar, long lOffsetLines, DateFormat dateFormat, OutputStream opeOS, DataConverterListener dcl) {
        OraclePropertyGraphCSVConverter.convertCSV2OPE(inCSV, eidColName, lOffsetEID, svidColName, dvidColName, hasEdgeLabelCol, elColName, ctams, dop, delimiterChar, quotationChar, lOffsetLines, dateFormat, false, opeOS, dcl);
    }

    public static void convertCSV2OPE(InputStream inCSV, String eidColName, long lOffsetEID, String svidColName, String dvidColName, boolean hasEdgeLabelCol, String elColName, ColumnToAttrMapping[] ctams, int dop, char delimiterChar, char quotationChar, long lOffsetLines, DateFormat dateFormat, boolean allowMultiline, OutputStream opeOS, DataConverterListener dcl) {
        OraclePropertyGraphCSVConverter.convertCSV2OPE(inCSV, eidColName, lOffsetEID, svidColName, dvidColName, 0L, hasEdgeLabelCol, elColName, ctams, dop, delimiterChar, quotationChar, lOffsetLines, dateFormat, allowMultiline, opeOS, dcl);
    }

    public static void convertCSV2OPE(InputStream inCSV, String eidColName, long lOffsetEID, String svidColName, String dvidColName, long lOffsetVID, boolean hasEdgeLabelCol, String elColName, ColumnToAttrMapping[] ctams, int dop, char delimiterChar, char quotationChar, long lOffsetLines, DateFormat dateFormat, boolean allowMultiline, OutputStream opeOS, DataConverterListener dcl) {
        OraclePropertyGraphCSVConverter.convertCSV2OPE(inCSV, eidColName, lOffsetEID, svidColName, dvidColName, lOffsetVID, lOffsetVID, hasEdgeLabelCol, elColName, ctams, dop, delimiterChar, quotationChar, lOffsetLines, dateFormat, allowMultiline, opeOS, dcl);
    }

    public static void convertCSV2OPE(InputStream inCSV, String eidColName, long lOffsetEID, String svidColName, String dvidColName, long lOffsetSVID, long lOffsetDVID, boolean hasEdgeLabelCol, String elColName, ColumnToAttrMapping[] ctams, int dop, char delimiterChar, char quotationChar, long lOffsetLines, DateFormat dateFormat, boolean allowMultiline, OutputStream opeOS, DataConverterListener dcl) {
        CSV2OPEConfig config = (CSV2OPEConfig)new CSV2OPEConfig().setEidColumnName(eidColName).setOffsetEID(lOffsetEID).setSvidColumnName(svidColName).setDvidColumnName(dvidColName).setOffsetSVID(lOffsetSVID).setOffsetDVID(lOffsetDVID).setHasEdgeLabelColumn(hasEdgeLabelCol).setElColumnName(elColName).setCtams(ctams).setDop(dop).setDelimiterChar(delimiterChar).setQuotationChar(quotationChar).setOffsetLines(lOffsetLines).setDateFormat(dateFormat).setAllowMultiLine(allowMultiline).setDcl(dcl);
        OraclePropertyGraphCSVConverter.convertCSV2OPE(inCSV, config, opeOS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void convertCSV2OPE(InputStream inCSV, CSV2OPEConfig config, OutputStream opeOS) {
        eidColName = config.getEidColumnName();
        lOffsetEID = config.getOffsetEID();
        svidColName = config.getSvidColumnName();
        dvidColName = config.getDvidColumnName();
        lOffsetSVID = config.getOffsetSVID();
        lOffsetDVID = config.getOffsetDVID();
        hasEdgeLabelCol = config.hasEdgeLabelColumn();
        elColName = config.getElColumnName();
        ctams = config.getCtams();
        delimiterChar = config.getDelimiterChar();
        quotationChar = config.getQuotationChar();
        lOffsetLines = config.getOffsetLines();
        dateFormat = config.getDateFormat();
        allowMultiline = config.allowsMultiLine();
        dcl = config.getDcl();
        allowExtraFields = config.allowsExtraFields();
        try {
            baFieldDelimiter = ",".getBytes(OraclePropertyGraphCSVConverter.CHARSET);
            baRecordDelimiter = "\n".getBytes(OraclePropertyGraphCSVConverter.CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new OraclePropertyGraphException(e);
        }
        baEscapedSpaceDelimiter = HelperUtilities.escape(" ");
        dateFormats = new DateFormat[OraclePropertyGraphBase.CSV_DATE_TIME_FORMATS.length + 1];
        dateFormats[0] = dateFormat;
        for (idx = 0; idx < OraclePropertyGraphBase.CSV_DATE_TIME_FORMATS.length; ++idx) {
            dateFormats[idx + 1] = new SimpleDateFormat(OraclePropertyGraphBase.CSV_DATE_TIME_FORMATS[idx]);
        }
        opgDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        try {
            brIn = new BufferedReader(new InputStreamReader(inCSV, OraclePropertyGraphCSVConverter.CHARSET), 0x100000);
        }
        catch (UnsupportedEncodingException e) {
            throw new OraclePropertyGraphException(e);
        }
        OraclePropertyGraphCSVConverter.lErrors = 0L;
        szCsvRecord = "";
        szPropertyKey = null;
        value = null;
        if (ctams == null) {
            try {
                szCsvRecord = OraclePropertyGraphCSVConverter.readCsvRecord(brIn, allowMultiline, quotationChar);
            }
            catch (IOException ioe) {
                throw new OraclePropertyGraphException(ioe);
            }
            ctams = OraclePropertyGraphCSVConverter.parseHeaderToColumnToAttrMappings(szCsvRecord, delimiterChar);
        }
        idColumnPosition = -1;
        if (eidColName != null) {
            for (i = 0; i < ctams.length; ++i) {
                if (!ctams[i].getAttrName().equals(eidColName)) continue;
                if (ctams[i].getColumnPosition() != -1) {
                    idColumnPosition = ctams[i].getColumnPosition();
                    break;
                }
                idColumnPosition = i;
                break;
            }
        }
        vSourcePosition = -1;
        for (i = 0; i < ctams.length; ++i) {
            if (!ctams[i].getAttrName().equals(svidColName)) continue;
            if (ctams[i].getColumnPosition() != -1) {
                vSourcePosition = ctams[i].getColumnPosition();
                break;
            }
            vSourcePosition = i;
            break;
        }
        if (vSourcePosition == -1) {
            throw new IllegalArgumentException("SVID must be defined in the CSV file, column " + svidColName + " not found ");
        }
        vDestinationPosition = -1;
        for (i = 0; i < ctams.length; ++i) {
            if (!ctams[i].getAttrName().equals(dvidColName)) continue;
            if (ctams[i].getColumnPosition() != -1) {
                vDestinationPosition = ctams[i].getColumnPosition();
                break;
            }
            vDestinationPosition = i;
            break;
        }
        if (vDestinationPosition == -1) {
            throw new IllegalArgumentException("DVID must be defined in the CSV file, column " + dvidColName + " not found ");
        }
        labelPosition = -1;
        if (hasEdgeLabelCol) {
            for (i = 0; i < ctams.length; ++i) {
                if (!ctams[i].getAttrName().equals(elColName)) continue;
                if (ctams[i].getColumnPosition() != -1) {
                    labelPosition = ctams[i].getColumnPosition();
                    break;
                }
                labelPosition = i;
                break;
            }
        }
        try {
            for (lLineIdx = 0L; lLineIdx < lOffsetLines && (szCsvRecord = OraclePropertyGraphCSVConverter.readCsvRecord(brIn, allowMultiline, quotationChar)) != null; ++lLineIdx) {
            }
        }
        catch (IOException e) {
            OraclePropertyGraphCSVConverter.handleError(dcl, lLineIdx, szCsvRecord, "convertCSV2OPE: hit IOException.");
        }
        lSrcMaxlines = -1L;
        baos = new ByteArrayOutputStream(0x1000000);
        while (true) {
            block53: {
                block52: {
                    block51: {
                        try lbl-1000:
                        // 6 sources

                        {
                            while (true) {
                                if ((lSrcMaxlines == -1L || lLineIdx < lSrcMaxlines) && (szCsvRecord = OraclePropertyGraphCSVConverter.readCsvRecord(brIn, allowMultiline, quotationChar)) != null) {
                                    if (dcl != null && ++lLineIdx % dcl.reportProgressFrequency() == 0L) {
                                        dcl.progressTo(lLineIdx, "convertCSV2OPE: done to " + lLineIdx);
                                    }
                                    expectedLength = ctams.length;
                                    for (idx = 0; idx < ctams.length; ++idx) {
                                        if (ctams[idx].getColumnPosition() + 1 <= expectedLength) continue;
                                        expectedLength = ctams[idx].getColumnPosition() + 1;
                                    }
                                    csvEdgeTokens = OraclePropertyGraphCSVConverter.splitEscapedStringValues(lLineIdx, szCsvRecord, ctams, delimiterChar, quotationChar, allowExtraFields, expectedLength, dcl);
                                    edgeHasKV = false;
                                    break block51;
                                }
                                baos.flush();
                                expectedLength = opeOS;
                                synchronized (expectedLength) {
                                    baos.writeTo(opeOS);
                                    baos.reset();
                                    opeOS.flush();
                                }
                                break;
                            }
                        }
                        catch (IOException e) {
                            OraclePropertyGraphCSVConverter.handleError(dcl, lLineIdx, szCsvRecord, "convertCSV2OPV: hit IOException.");
                        }
                        try {
                            opeOS.flush();
                            return;
                        }
                        catch (IOException e) {
                            OraclePropertyGraphCSVConverter.ms_log.error("hit IOException when flushing edges from csv to ope");
                        }
                        return;
                    }
                    for (i = 0; i < ctams.length; ++i) {
                        valueColumnPosition = i;
                        if (ctams[i].getColumnPosition() != -1) {
                            valueColumnPosition = ctams[i].getColumnPosition();
                        }
                        if (valueColumnPosition == idColumnPosition || valueColumnPosition == vSourcePosition || valueColumnPosition == vDestinationPosition || valueColumnPosition == labelPosition || csvEdgeTokens[valueColumnPosition] == null) continue;
                        edgeHasKV = true;
                        break;
                    }
                    eid = null;
                    if (idColumnPosition == -1) break block52;
                    if (csvEdgeTokens[idColumnPosition] == null) ** GOTO lbl-1000
                    longID = OraclePropertyGraphCSVConverter.parseTokenToID(csvEdgeTokens[idColumnPosition]);
                    eid = longID + lOffsetEID;
                    break block53;
                }
                eid = lLineIdx + lOffsetEID;
            }
            if (csvEdgeTokens[vSourcePosition] == null) ** GOTO lbl-1000
            vSourceId = OraclePropertyGraphCSVConverter.parseTokenToID(csvEdgeTokens[vSourcePosition]) + lOffsetSVID;
            if (csvEdgeTokens[vDestinationPosition] == null) ** GOTO lbl-1000
            vDestinationId = OraclePropertyGraphCSVConverter.parseTokenToID(csvEdgeTokens[vDestinationPosition]) + lOffsetDVID;
            if (edgeHasKV) break;
            try {
                baos.write(eid.toString().getBytes(OraclePropertyGraphCSVConverter.CHARSET));
                baos.write(baFieldDelimiter);
                baos.write(vSourceId.toString().getBytes(OraclePropertyGraphCSVConverter.CHARSET));
                baos.write(baFieldDelimiter);
                baos.write(vDestinationId.toString().getBytes(OraclePropertyGraphCSVConverter.CHARSET));
                baos.write(baFieldDelimiter);
                if (labelPosition != -1) {
                    baos.write(HelperUtilities.escape(csvEdgeTokens[labelPosition]));
                } else {
                    baos.write(HelperUtilities.escape(elColName));
                }
                baos.write(baFieldDelimiter);
                baos.write(baEscapedSpaceDelimiter);
                baos.write(baFieldDelimiter);
                baos.write(baFieldDelimiter);
                baos.write(baFieldDelimiter);
                baos.write(baFieldDelimiter);
                baos.write(baRecordDelimiter);
            }
            catch (IOException ioe) {
                OraclePropertyGraphCSVConverter.handleError(dcl, lLineIdx, szCsvRecord, "convertCSV2OPE: hit IOException writing empty edge.");
                ** GOTO lbl-1000
            }
        }
        i = 0;
        while (true) {
            if (i < ctams.length) ** break;
            ** continue;
            valueColumnPosition = i;
            if (ctams[i].getColumnPosition() != -1) {
                valueColumnPosition = ctams[i].getColumnPosition();
            }
            if (valueColumnPosition != idColumnPosition && valueColumnPosition != vSourcePosition && valueColumnPosition != vDestinationPosition && valueColumnPosition != labelPosition && csvEdgeTokens[valueColumnPosition] != null && (labelPosition == -1 || csvEdgeTokens[labelPosition] != null)) {
                try {
                    baos.write(eid.toString().getBytes(OraclePropertyGraphCSVConverter.CHARSET));
                    baos.write(baFieldDelimiter);
                    baos.write(vSourceId.toString().getBytes(OraclePropertyGraphCSVConverter.CHARSET));
                    baos.write(baFieldDelimiter);
                    baos.write(vDestinationId.toString().getBytes(OraclePropertyGraphCSVConverter.CHARSET));
                    baos.write(baFieldDelimiter);
                    if (labelPosition != -1) {
                        baos.write(HelperUtilities.escape(csvEdgeTokens[labelPosition]));
                    } else {
                        baos.write(HelperUtilities.escape(elColName));
                    }
                    baos.write(baFieldDelimiter);
                    szPropertyKey = ctams[i].getAttrName();
                    if (szPropertyKey == null || szPropertyKey.isEmpty()) {
                        szPropertyKey = " ";
                    }
                    baos.write(HelperUtilities.escape(szPropertyKey));
                    baos.write(baFieldDelimiter);
                    value = OraclePropertyGraphCSVConverter.parseTokenToObject(ctams[i], csvEdgeTokens[valueColumnPosition], dateFormats, lLineIdx, dcl);
                    ExporterUtils.writeValue(baos, value, baFieldDelimiter, opgDateFormat);
                    baos.write(baRecordDelimiter);
                }
                catch (IOException ioe) {
                    OraclePropertyGraphCSVConverter.handleError(dcl, lLineIdx, szCsvRecord, "convertCSV2OPV: hit IOException writing property.");
                }
                if (baos.size() > 0xC00000) {
                    baos.flush();
                    var49_57 = opeOS;
                    synchronized (var49_57) {
                        baos.writeTo(opeOS);
                        baos.reset();
                    }
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void convertCSV2OPG(InputStream inCSV, CSV2OPGConfig config, OutputStream opVOS, OutputStream opEOS) throws IOException {
        block49: {
            OraclePropertyGraphCSVConverter.ms_log.debug("CSV2OPG: start");
            ctams = config.getCtams();
            delimiterChar = config.getDelimiterChar();
            quotationChar = config.getQuotationChar();
            lOffsetLines = config.getOffsetLines();
            allowMultiline = config.allowsMultiLine();
            dcl = config.getDcl();
            allowExtraFields = config.allowsExtraFields();
            vidColumnNames = config.getVidColumnNames();
            offsetVIDs = config.getOffsetVIDs();
            if (vidColumnNames == null || vidColumnNames.length == 0) {
                throw new IllegalArgumentException("At least one vertices column must be provided");
            }
            try {
                brIn = new BufferedReader(new InputStreamReader(inCSV, OraclePropertyGraphCSVConverter.CHARSET), 0x100000);
            }
            catch (UnsupportedEncodingException e) {
                throw new OraclePropertyGraphException(e);
            }
            OraclePropertyGraphCSVConverter.lErrors = 0L;
            szCsvRecord = "";
            if (ctams == null) {
                try {
                    szCsvRecord = OraclePropertyGraphCSVConverter.readCsvRecord(brIn, allowMultiline, quotationChar);
                }
                catch (IOException ioe) {
                    throw new OraclePropertyGraphException(ioe);
                }
                ctams = OraclePropertyGraphCSVConverter.parseHeaderToColumnToAttrMappings(szCsvRecord, delimiterChar);
            }
            verticesIdsPositions = new int[vidColumnNames.length];
            for (i = 0; i < verticesIdsPositions.length; ++i) {
                verticesIdsPositions[i] = -1;
                for (j = 0; j < ctams.length; ++j) {
                    if (!ctams[j].getAttrName().equals(vidColumnNames[i])) continue;
                    if (ctams[j].getColumnPosition() != -1) {
                        verticesIdsPositions[i] = ctams[j].getColumnPosition();
                        break;
                    }
                    verticesIdsPositions[i] = j;
                    break;
                }
                if (verticesIdsPositions[i] != -1) continue;
                throw new IllegalArgumentException("All vertices ids must be defined in the CSV file, column " + vidColumnNames[i] + " not found ");
            }
            try {
                for (lLineIdx = 0L; lLineIdx < lOffsetLines && (szCsvRecord = OraclePropertyGraphCSVConverter.readCsvRecord(brIn, allowMultiline, quotationChar)) != null; ++lLineIdx) {
                }
            }
            catch (IOException e) {
                OraclePropertyGraphCSVConverter.handleError(dcl, lLineIdx, szCsvRecord, "convertCSV2OPG: hit IOException.");
            }
            prefix = UUID.randomUUID().toString();
            vertexFileName = FilenameUtils.normalize((String)(System.getProperty("java.io.tmpdir") + "/" + prefix + ".v.csv"));
            tmpFileVertices = new File(vertexFileName);
            edgeFileName = FilenameUtils.normalize((String)(System.getProperty("java.io.tmpdir") + "/" + prefix + ".e.csv"));
            tmpFileEdges = new File(edgeFileName);
            osTmpVertices = null;
            osTmpEdges = null;
            fisVertices = null;
            fisEdges = null;
            vids = new HashSet<String>();
            lSrcMaxlines = -1L;
            try {
                fisVertices = new FileOutputStream(vertexFileName);
                osTmpVertices = new BufferedOutputStream(fisVertices);
                fisEdges = new FileOutputStream(edgeFileName);
                osTmpEdges = new BufferedOutputStream(fisEdges);
                while ((lSrcMaxlines == -1L || lLineIdx < lSrcMaxlines) && (szCsvRecord = OraclePropertyGraphCSVConverter.readCsvRecord(brIn, allowMultiline, quotationChar)) != null) {
                    if (dcl != null && ++lLineIdx % dcl.reportProgressFrequency() == 0L) {
                        dcl.progressTo(lLineIdx, "convertCSV2OPG: done to " + lLineIdx);
                    }
                    expectedLength = ctams.length;
                    for (idx = 0; idx < ctams.length; ++idx) {
                        if (ctams[idx].getColumnPosition() + 1 <= expectedLength) continue;
                        expectedLength = ctams[idx].getColumnPosition() + 1;
                    }
                    csvTokens = OraclePropertyGraphCSVConverter.splitEscapedStringValues(lLineIdx, szCsvRecord, ctams, delimiterChar, quotationChar, allowExtraFields, expectedLength, dcl);
                    for (i = 0; i < verticesIdsPositions.length; ++i) {
                        isNewVertexId = vids.add(csvTokens[verticesIdsPositions[i]]);
                        if (!isNewVertexId) continue;
                        id = csvTokens[verticesIdsPositions[i]];
                        if (csvTokens[verticesIdsPositions[i]].contains("" + delimiterChar) || csvTokens[verticesIdsPositions[i]].contains("" + quotationChar) || csvTokens[verticesIdsPositions[i]].contains("\n")) {
                            id = quotationChar + id.replace("" + quotationChar, "" + quotationChar + quotationChar) + quotationChar;
                        }
                        osTmpVertices.write(id.getBytes(OraclePropertyGraphCSVConverter.CHARSET));
                        if (config.keepsOriginalID()) {
                            osTmpVertices.write(("" + delimiterChar).getBytes(OraclePropertyGraphCSVConverter.CHARSET));
                            osTmpVertices.write(id.getBytes(OraclePropertyGraphCSVConverter.CHARSET));
                        }
                        osTmpVertices.write("\n".getBytes(OraclePropertyGraphCSVConverter.CHARSET));
                    }
                    osTmpEdges.write(szCsvRecord.getBytes(OraclePropertyGraphCSVConverter.CHARSET));
                    osTmpEdges.write("\n".getBytes(OraclePropertyGraphCSVConverter.CHARSET));
                }
                osTmpVertices.flush();
                osTmpEdges.flush();
                if (osTmpVertices == null) break block49;
            }
            catch (IOException e) {
                block50: {
                    try {
                        OraclePropertyGraphCSVConverter.handleError(dcl, lLineIdx, szCsvRecord, "convertCSV2OPG: hit IOException.");
                        if (osTmpVertices == null) break block50;
                    }
                    catch (Throwable var37_47) {
                        if (osTmpVertices != null) {
                            OraclePropertyGraphUtilsBase.quietlyClose(osTmpVertices);
                        }
                        if (osTmpEdges != null) {
                            OraclePropertyGraphUtilsBase.quietlyClose(osTmpEdges);
                        }
                        if (fisVertices != null) {
                            OraclePropertyGraphUtilsBase.quietlyClose(fisVertices);
                        }
                        if (fisEdges != null) {
                            OraclePropertyGraphUtilsBase.quietlyClose(fisEdges);
                        }
                        throw var37_47;
                    }
                    OraclePropertyGraphUtilsBase.quietlyClose(osTmpVertices);
                }
                if (osTmpEdges != null) {
                    OraclePropertyGraphUtilsBase.quietlyClose(osTmpEdges);
                }
                if (fisVertices != null) {
                    OraclePropertyGraphUtilsBase.quietlyClose(fisVertices);
                }
                if (fisEdges != null) {
                    OraclePropertyGraphUtilsBase.quietlyClose(fisEdges);
                } else {
                    ** GOTO lbl120
                }
            }
            OraclePropertyGraphUtilsBase.quietlyClose(osTmpVertices);
        }
        if (osTmpEdges != null) {
            OraclePropertyGraphUtilsBase.quietlyClose(osTmpEdges);
        }
        if (fisVertices != null) {
            OraclePropertyGraphUtilsBase.quietlyClose(fisVertices);
        }
        if (fisEdges != null) {
            OraclePropertyGraphUtilsBase.quietlyClose(fisEdges);
        }
        ctamsTmpVertices = new ColumnToAttrMapping[1];
        ctamsTmpVertices = config.keepsOriginalID() != false ? new ColumnToAttrMapping[2] : new ColumnToAttrMapping[1];
        try {
            ctamsTmpVertices[0] = ColumnToAttrMapping.getInstance("vid", Class.forName("java.lang.String"));
            if (config.keepsOriginalID()) {
                ctamsTmpVertices[1] = ColumnToAttrMapping.getInstance(config.getOriginalIDName(), Class.forName("java.lang.String"));
            }
        }
        catch (ClassNotFoundException e) {
            throw new OraclePropertyGraphException(e);
        }
        configVertices = new CSV2OPVConfig();
        configVertices.setCtams(ctamsTmpVertices);
        configVertices.setDop(config.getDop());
        configVertices.setDelimiterChar(delimiterChar);
        configVertices.setQuotationChar(quotationChar);
        configVertices.setOffsetLines(0L);
        configVertices.setDateFormat(config.getDateFormat());
        configVertices.setAllowMultiLine(allowMultiline);
        configVertices.setAllowExtraFields(false);
        configVertices.setDcl(config.getDcl());
        configVertices.setVidColumnName("vid");
        configVertices.setOffsetVID(offsetVIDs);
        isTmpVertices = null;
        isTmpEdges = null;
        try {
            isTmpVertices = new BufferedInputStream(new FileInputStream(tmpFileVertices));
            OraclePropertyGraphCSVConverter.convertCSV2OPV(isTmpVertices, configVertices, opVOS);
            ** if (isTmpVertices == null) goto lbl-1000
        }
        catch (Throwable var38_48) {
            if (isTmpVertices != null) {
                OraclePropertyGraphUtilsBase.quietlyClose(isTmpVertices);
            }
            throw var38_48;
        }
lbl-1000:
        // 1 sources

        {
            OraclePropertyGraphUtilsBase.quietlyClose(isTmpVertices);
        }
lbl-1000:
        // 2 sources

        {
        }
        config.setAllowExtraFields(true);
        config.setOffsetLines(0L);
        try {
            isTmpEdges = new BufferedInputStream(new FileInputStream(tmpFileEdges));
            OraclePropertyGraphCSVConverter.convertCSV2OPE(isTmpEdges, config, opEOS);
            ** if (isTmpEdges == null) goto lbl-1000
        }
        catch (Throwable var39_49) {
            if (isTmpEdges != null) {
                OraclePropertyGraphUtilsBase.quietlyClose(isTmpEdges);
            }
            throw var39_49;
        }
lbl-1000:
        // 1 sources

        {
            OraclePropertyGraphUtilsBase.quietlyClose(isTmpEdges);
        }
lbl-1000:
        // 2 sources

        {
        }
        try {
            if (tmpFileVertices != null) {
                tmpFileVertices.delete();
            }
        }
        catch (Exception e) {
            throw new OraclePropertyGraphException(e);
        }
        try {
            if (tmpFileEdges != null) {
                tmpFileEdges.delete();
            }
        }
        catch (Exception e) {
            throw new OraclePropertyGraphException(e);
        }
    }

    static class CSV2OPV
    implements Runnable {
        InputStream is;
        ColumnToAttrMapping[] ctas;
        OutputStream os;

        public CSV2OPV(InputStream is, ColumnToAttrMapping[] ctas, OutputStream os) {
            this.is = is;
            this.ctas = ctas;
            this.os = os;
        }

        @Override
        public void run() {
            OraclePropertyGraphCSVConverter.convertCSV2OPV(this.is, "vid", 0L, this.ctas, -1, 0L, null, this.os, null);
            try {
                this.is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

