/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.converter.rdbms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.jdbc.OracleCallableStatement;
import oracle.pg.common.BackendConfig;
import oracle.pg.common.ColumnToAttrMapping;
import oracle.pg.common.DataConverterListener;
import oracle.pg.common.HelperUtilities;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.SQLUtils;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.exporter.ExporterUtils;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class RDBMSTableConverter {
    static SimpleLog ms_log = SimpleLog.getLog(RDBMSTableConverter.class);
    protected static final boolean ms_bDebug = ms_log.isDebugEnabled();
    private static final String VALIDATE_RDBMS_VERTICES_PROCEDURE = " CREATE OR REPLACE PROCEDURE validate_rdbms_vertices(vidcolname varchar2, owner varchar2, tablename varchar2, o_cursor out sys_refcursor) as query_str varchar2(1000); vid varchar2(256); vowner varchar2(256); vtable varchar2(256); fulltablename varchar2(500); begin    if (owner is null or trim(owner) is null) then      vowner := sys.dbms_assert.qualified_sql_name(sys_context('userenv', 'current_user'));   else      vowner := trim(sys.dbms_assert.qualified_sql_name(owner));   end if;   vtable := trim(sys.dbms_assert.qualified_sql_name(tablename));   fulltablename := sys.dbms_assert.enquote_name(vowner, false) || '.' || sys.dbms_assert.enquote_name(vtable, false);   if (vidcolname is null) then      vid := '''dummy_column''';   else      vid := sys.dbms_assert.enquote_name(vidcolname, false);    end if;    query_str := ' select ' || vid || ' as vid from ' || fulltablename || ' where 1 < 0 ';    open o_cursor for query_str;  end; ";
    private static final String VALIDATE_RDBMS_VERTICES_QUERY = " begin validate_rdbms_vertices(?, ?, ?, ?);  end; ";
    private static final String VALIDATE_RDBMS_EDGES_PROCEDURE = " CREATE OR REPLACE PROCEDURE validate_rdbms_edges(eidcolname varchar2, svidcolname varchar2, dvidcolname varchar2, owner varchar2, tablename varchar2, o_cursor out sys_refcursor) as query_str varchar2(1000); eid varchar2(256); vowner varchar2(256); vtable varchar2(256); fulltablename varchar2(500); begin    if (owner is null or trim(owner) is null) then      vowner := sys.dbms_assert.qualified_sql_name(sys_context('userenv', 'current_user'));   else      vowner := sys.dbms_assert.qualified_sql_name(owner);    end if;   vtable := sys.dbms_assert.qualified_sql_name(tablename);   fulltablename := sys.dbms_assert.enquote_name(vowner, false) || '.' || sys.dbms_assert.enquote_name(vtable, false);   if (eidcolname is null) then      eid := '''dummy_column''';   else      eid := sys.dbms_assert.enquote_name(eidcolname, false);    end if;    query_str := ' select ' || eid || ' as eid, ' ||                  sys.dbms_assert.enquote_name(svidcolname, false) || ' as svid, ' ||                  sys.dbms_assert.enquote_name(dvidcolname, false) || ' as dvid from ' ||                  fulltablename  || ' where 1 < 0 ';    open o_cursor for query_str;    dbms_output.put_line(query_str);  end; ";
    private static final String VALIDATE_RDBMS_EDGES_QUERY = " begin validate_rdbms_edges(?, ?, ?, ?, ?, ?); end; ";
    private static final String C_ARRAY_PROCEDURE = "  CREATE OR REPLACE TYPE c_varchar2_array AS TABLE OF VARCHAR2(4000);";
    private static final String CONVERT_RDBMS_VERTICES_PROCEDURE = "CREATE OR REPLACE PROCEDURE converter_rdbms_vertices(vidcolname varchar2, owner varchar2,  tablename varchar2, dop number, property_names c_varchar2_array, sql_property_names c_varchar2_array,  o_cursor out sys_refcursor) is query_str varchar2(2000); vid varchar2(256); colstmt varchar2(1000); dopStr varchar2(100);  vowner varchar2(256); vtable varchar2(256); fulltablename varchar2(500); begin    if (owner is null or trim(owner) is null) then      vowner := sys.dbms_assert.qualified_sql_name(sys_context('userenv', 'current_user'));   else      vowner := trim(sys.dbms_assert.qualified_sql_name(owner));   end if;   vtable := trim(sys.dbms_assert.qualified_sql_name(tablename));   fulltablename := sys.dbms_assert.enquote_name(vowner, false) || '.' || sys.dbms_assert.enquote_name(vtable, false);   colstmt := ' ';    if property_names is NULL or property_names is empty then      colstmt := ' ';   else      for i in property_names.FIRST .. property_names.LAST       loop          colstmt := colstmt || ', ' || sys.dbms_assert.enquote_name(property_names(i), false) || ' as ' ||                     sys.dbms_assert.enquote_name(sql_property_names(i), false);      end loop;   end if;    if (vidcolname is null) then      vid := 'ROWNUM';   else      vid := sys.dbms_assert.enquote_name(vidcolname, false);    end if;    if (dop < 0) then      dopStr := ' ';    else      dopStr := '(' || dop || ')';    end if;    query_str := ' select /*+ parallel' || dopStr || ' */ ' || vid || ' as vid ' || colstmt ||               ' from ' || fulltablename;    dbms_output.put_line(query_str);    open o_cursor for query_str;  end; ";
    private static final String CONVERT_RDBMS_VERTICES_QUERY = " begin converter_rdbms_vertices(?, ?, ?, ?, ?, ?, ?); end; ";
    private static final String CONVERT_RDBMS_EDGES_PROCEDURE = "CREATE OR REPLACE PROCEDURE converter_rdbms_edges(eidcolname varchar2, svidcolname varchar2, dvidcolname varchar2, hasel number, elcolname varchar2, owner varchar2, tablename varchar2, dop number,  property_names c_varchar2_array, sql_property_names c_varchar2_array, o_cursor out sys_refcursor) is query_str varchar2(2000); eid varchar2(256); el varchar2(256); colstmt varchar2(1000); dopStr varchar2(100); vowner varchar2(256); vtable varchar2(256); fulltablename varchar2(500); begin    if (owner is null or trim(owner) is null) then      vowner := sys.dbms_assert.qualified_sql_name(sys_context('userenv', 'current_user'));   else      vowner := trim(sys.dbms_assert.qualified_sql_name(owner));   end if;   vtable := trim(sys.dbms_assert.qualified_sql_name(tablename));   fulltablename := sys.dbms_assert.enquote_name(vowner, false) || '.' || sys.dbms_assert.enquote_name(vtable, false);   colstmt := ' ';    if property_names is NULL or property_names is empty then      colstmt := ' ';   else      for i in property_names.FIRST .. property_names.LAST       loop          colstmt := colstmt || ', ' || sys.dbms_assert.enquote_name(property_names(i), false) || ' as ' ||                     sys.dbms_assert.enquote_name(sql_property_names(i), false) ;      end loop;   end if;    if (eidcolname is null) then      eid := 'ROWNUM';   else      eid := sys.dbms_assert.enquote_name(eidcolname, false);    end if;    if (dop < 0) then      dopStr := ' ';    else      dopStr := '(' || dop || ')';    end if;    if (hasel is null) then      el := sys.dbms_assert.enquote_literal(elcolname);    else      el := sys.dbms_assert.enquote_name(elcolname, false);    end if;    query_str := ' select /*+ parallel' || dopStr || ' */ ' || eid || ' as eid, ' ||                 sys.dbms_assert.enquote_name(svidcolname, false) || ' as svid, ' ||                 sys.dbms_assert.enquote_name(dvidcolname, false) || ' as dvid, ' ||                 el || ' as el ' || colstmt || ' from ' || fulltablename;    dbms_output.put_line(query_str);    open o_cursor for query_str;  end; ";
    private static final String CONVERT_RDBMS_EDGES_QUERY = " begin converter_rdbms_edges(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end; ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertRDBMSTable2OPE(Connection conn, String schema, String rdbmsTableName, String eidColName, long lEIDOffset, String svidColName, String dvidColName, long lSVIDOffset, long lDVIDOffset, boolean bHasEdgeLabelCol, String elColName, ColumnToAttrMapping[] ctams, int dop, OutputStream opeOS, DataConverterListener dcl, BackendConfig bc) {
        block93: {
            Serializable dtClass;
            Object columnName;
            if (conn == null) {
                throw new IllegalArgumentException("convertRDBMSTable2OPE: conn can not be null");
            }
            if (rdbmsTableName == null || rdbmsTableName.length() == 0) {
                throw new IllegalArgumentException("convertRDBMSTable2OPE: rdbms table name can not be null or empty");
            }
            if (svidColName == null || svidColName.length() == 0) {
                throw new IllegalArgumentException("convertRDBMSTable2OPE: svid column name can not be null or empty");
            }
            if (dvidColName == null || dvidColName.length() == 0) {
                throw new IllegalArgumentException("convertRDBMSTable2OPE: dvid column name can not be null or empty");
            }
            if (elColName == null || elColName.length() == 0) {
                throw new IllegalArgumentException("convertRDBMSTable2OPE: edge label column name can not be null or empty");
            }
            if (dop < 0) {
                dop = 8;
                ms_log.error("convertRDBMSTable2OPE: dop can not be negative, set it to default value 8");
            }
            if (opeOS == null) {
                throw new IllegalArgumentException("convertRDBMSTable2OPE: ope output stream can not be null");
            }
            ArrayList<String> columnNames = new ArrayList<String>();
            HashMap<String, String> columnName2AttrNameMap = new HashMap<String, String>();
            HashMap columnName2DTMap = new HashMap();
            for (ColumnToAttrMapping e : ctams) {
                columnName = e.getColumnName();
                String attrName = e.getAttrName();
                dtClass = e.getDTClass();
                columnNames.add((String)columnName);
                columnName2AttrNameMap.put((String)columnName, attrName);
                columnName2DTMap.put(columnName, (Class<?>)dtClass);
            }
            boolean bEIDIsIntOrLong = false;
            boolean bSVIDIsIntOrLong = false;
            boolean bDVIDIsIntOrLong = false;
            RDBMSTableConverter.createInitialProcedure(conn, VALIDATE_RDBMS_EDGES_PROCEDURE);
            try {
                CallableStatement stmt = conn.prepareCall(VALIDATE_RDBMS_EDGES_QUERY);
                columnName = null;
                try {
                    stmt.setString(1, eidColName);
                    stmt.setString(2, svidColName);
                    stmt.setString(3, dvidColName);
                    stmt.setString(4, schema);
                    stmt.setString(5, rdbmsTableName);
                    stmt.registerOutParameter(6, -10);
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug("convertRDBMSTable2OPE: query to find out type of column " + eidColName + " is " + VALIDATE_RDBMS_EDGES_QUERY);
                    }
                    stmt.execute();
                    try {
                        ResultSet rs = ((OracleCallableStatement)stmt).getCursor(6);
                        dtClass = null;
                        try {
                            ResultSetMetaData rsmd = rs.getMetaData();
                            int eidType = rsmd.getColumnType(1);
                            bEIDIsIntOrLong = SQLUtils.validateIsNumericColumn(eidType);
                            int svidType = rsmd.getColumnType(2);
                            bSVIDIsIntOrLong = SQLUtils.validateIsNumericColumn(svidType);
                            int dvidType = rsmd.getColumnType(3);
                            bDVIDIsIntOrLong = SQLUtils.validateIsNumericColumn(svidType);
                        }
                        catch (Throwable throwable) {
                            dtClass = throwable;
                            throw throwable;
                        }
                        finally {
                            if (rs != null) {
                                if (dtClass != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)dtClass).addSuppressed(throwable);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e) {
                        throw new OraclePropertyGraphException(e);
                    }
                }
                catch (Throwable e) {
                    columnName = e;
                    throw e;
                }
                finally {
                    if (stmt != null) {
                        if (columnName != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable e) {
                                ((Throwable)columnName).addSuppressed(e);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new OraclePropertyGraphException(e);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(0x1000000);
            long[] lErrors = new long[1];
            Object eid = null;
            long lEdges = 0L;
            long lLines = 0L;
            RDBMSTableConverter.createInitialProcedure(conn, C_ARRAY_PROCEDURE);
            RDBMSTableConverter.createInitialProcedure(conn, CONVERT_RDBMS_EDGES_PROCEDURE);
            try (CallableStatement stmt = conn.prepareCall(CONVERT_RDBMS_EDGES_QUERY);){
                stmt.setString(1, eidColName);
                stmt.setString(2, svidColName);
                stmt.setString(3, dvidColName);
                if (bHasEdgeLabelCol) {
                    stmt.setObject(4, (Object)1);
                } else {
                    stmt.setNull(4, 4);
                }
                stmt.setString(5, elColName);
                stmt.setString(6, schema);
                stmt.setString(7, rdbmsTableName);
                stmt.setInt(8, dop);
                ArrayDescriptor arrDescPropNames = ArrayDescriptor.createDescriptor((String)"C_VARCHAR2_ARRAY", (Connection)conn);
                ArrayDescriptor arrSqlPropNames = ArrayDescriptor.createDescriptor((String)"C_VARCHAR2_ARRAY", (Connection)conn);
                String[] columnNamesAr = new String[columnNames.size()];
                String[] sqlColumnNamesAr = new String[columnNames.size()];
                int idx = 0;
                Iterator iterator = columnNames.iterator();
                while (iterator.hasNext()) {
                    String name;
                    columnNamesAr[idx] = name = (String)iterator.next();
                    sqlColumnNamesAr[idx] = "P" + idx;
                    if (ms_bDebug) {
                        ms_log.debug("convertRDBMSTable2OPE: add column " + name);
                    }
                    ++idx;
                }
                ARRAY propertyNamesArray = new ARRAY(arrDescPropNames, conn, (Object)columnNamesAr);
                stmt.setArray(9, (Array)propertyNamesArray);
                ARRAY sqlPropertyNamesArray = new ARRAY(arrSqlPropNames, conn, (Object)sqlColumnNamesAr);
                stmt.setArray(10, (Array)sqlPropertyNamesArray);
                stmt.registerOutParameter(11, -10);
                stmt.execute();
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("convertRDBMSTable2OPE: stmt is  begin converter_rdbms_edges(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end; ");
                }
                try (ResultSet rs = ((OracleCallableStatement)stmt).getCursor(11);){
                    rs.setFetchSize(10000);
                    while (rs.next()) {
                        eid = rs.getObject("EID");
                        if (eid == null) continue;
                        long leid = RDBMSTableConverter.getIDFromColumn(eidColName, eid, bEIDIsIntOrLong);
                        leid += lEIDOffset;
                        Object svid = rs.getObject("SVID");
                        if (svid == null) continue;
                        long lsvid = RDBMSTableConverter.getIdFromColumnValue(svid, bSVIDIsIntOrLong);
                        lsvid += lSVIDOffset;
                        Object dvid = rs.getObject("DVID");
                        if (dvid == null) continue;
                        long ldvid = RDBMSTableConverter.getIdFromColumnValue(dvid, bDVIDIsIntOrLong);
                        ldvid += lDVIDOffset;
                        String el = bHasEdgeLabelCol ? rs.getString("EL") : elColName;
                        if (el == null) continue;
                        if (bc != null && bc.doesEdgeLabelSizeExceedLimit(HelperUtilities.escape(el))) {
                            lErrors[0] = lErrors[0] + 1L;
                            StringBuilder sb = new StringBuilder();
                            sb.append("hit Exception when converting edge: ");
                            sb.append(leid);
                            sb.append(" ,label exceed the limit: ");
                            sb.append(bc.getEdgeLabelSizeLimit());
                            if (dcl != null && dcl.continueOnError(lErrors[0], lEdges, eid, sb.toString())) continue;
                            OraclePropertyGraphException e = new OraclePropertyGraphException(sb.toString());
                            ms_log.error("convertRDBMSTable2OPE: did not pass BackendConfig check ", e);
                            throw e;
                        }
                        if (el == null) continue;
                        if (columnNames.size() == 0) {
                            if (ms_log.isDebugEnabled()) {
                                ms_log.debug("convertRDBMSTable2OPE: no key/value pairs, write one line to the output stream");
                            }
                            ExporterUtils.writeOneEdgeLineWithoutKV(baos, leid, lsvid, ldvid, el);
                            HelperUtilities.flushIfReachLimit(baos, opeOS, 0xC00000L);
                            ++lLines;
                            if (ms_log.isDebugEnabled()) {
                                ms_log.debug("convertRDBMSTable2OPE: lLines = " + lLines);
                            }
                        } else {
                            boolean hasNonNullValue = false;
                            int idxC = 0;
                            for (String columnName2 : columnNamesAr) {
                                Object obj;
                                String szPropertyKey = (String)columnName2AttrNameMap.get(columnName2);
                                if (bc != null && bc.doesPropertyNameSizeExceedLimit(HelperUtilities.escape(szPropertyKey))) {
                                    lErrors[0] = lErrors[0] + 1L;
                                    StringBuilder sb = new StringBuilder();
                                    sb.append("hit Exception when converting edge: ");
                                    sb.append(leid);
                                    sb.append(" ,property name exceed the limit: ");
                                    sb.append(bc.getPropertyNameSizeLimit());
                                    if (dcl != null && dcl.continueOnError(lErrors[0], lEdges, eid, sb.toString())) continue;
                                    OraclePropertyGraphException e = new OraclePropertyGraphException(sb.toString());
                                    ms_log.error("convertRDBMSTable2OPE: did not pass BackendConfig check ", e);
                                    throw e;
                                }
                                Class dtClass2 = (Class)columnName2DTMap.get(columnName2);
                                if ((obj = rs.getObject(sqlColumnNamesAr[idxC++])) == null) continue;
                                hasNonNullValue = true;
                                Object value = SQLUtils.castRDBMSObject(obj, dtClass2);
                                if (ms_log.isDebugEnabled()) {
                                    ms_log.debug("convertRDBMSTable2OPE: key = -----, value = -----, write one line to the output stream");
                                }
                                ExporterUtils.writeOneEdgeLineWithKV(baos, leid, lsvid, ldvid, el, szPropertyKey, value, bc, dcl, lErrors);
                                HelperUtilities.flushIfReachLimit(baos, opeOS, 0xC00000L);
                                ++lLines;
                                if (!ms_log.isDebugEnabled()) continue;
                                ms_log.debug("convertRDBMSTable2OPE: lLines = " + lLines);
                            }
                            if (!hasNonNullValue) {
                                if (ms_log.isDebugEnabled()) {
                                    ms_log.debug("convertRDBMSTable2OPE: no key/value pairs, write one line to the output stream");
                                }
                                ExporterUtils.writeOneEdgeLineWithoutKV(baos, leid, lsvid, ldvid, el);
                                HelperUtilities.flushIfReachLimit(baos, opeOS, 0xC00000L);
                                ++lLines;
                                if (ms_log.isDebugEnabled()) {
                                    ms_log.debug("convertRDBMSTable2OPE: lLines = " + lLines);
                                }
                            }
                        }
                        ++lEdges;
                    }
                }
                HelperUtilities.flushIfReachLimit(baos, opeOS);
            }
            catch (IOException | SQLException e) {
                String msg = "convertRDBMSTable2OPE: hit Exception when converting edge " + (eid != null ? eid : "NULL");
                ms_log.error(msg);
                if (dcl != null) {
                    lErrors[0] = lErrors[0] + 1L;
                    if (!dcl.continueOnError(lErrors[0], lEdges, eid, msg)) {
                        throw new OraclePropertyGraphException(msg, e);
                    }
                    break block93;
                }
                throw new OraclePropertyGraphException(msg, e);
            }
            finally {
                try {
                    opeOS.flush();
                }
                catch (IOException e1) {
                    ms_log.error("hit IOException when flushing edges from csv to ope");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void convertRDBMSTable2OPV(Connection conn, String schema, String rdbmsTableName, String vidColName, long lVIDOffset, ColumnToAttrMapping[] ctams, int dop, OutputStream opvOS, DataConverterListener dcl, BackendConfig bc) {
        block90: {
            Object columnName;
            if (conn == null) {
                throw new IllegalArgumentException("convertRDBMSTable2OPV: conn can not be null");
            }
            if (rdbmsTableName == null || rdbmsTableName.length() == 0) {
                throw new IllegalArgumentException("convertRDBMSTable2OPV: rdbms table name can not be null or empty");
            }
            if (dop < 0) {
                dop = 8;
                ms_log.error("convertRDBMSTable2OPV: dop can not be negative, set it to default value 8");
            }
            if (opvOS == null) {
                throw new IllegalArgumentException("convertRDBMSTable2OPV: opv output stream can not be null");
            }
            ArrayList<String> columnNames = new ArrayList<String>();
            HashMap<String, String> columnName2AttrNameMap = new HashMap<String, String>();
            HashMap columnName2DTMap = new HashMap();
            for (ColumnToAttrMapping e : ctams) {
                columnName = e.getColumnName();
                String attrName = e.getAttrName();
                Class<?> dtClass = e.getDTClass();
                columnNames.add((String)columnName);
                columnName2AttrNameMap.put((String)columnName, attrName);
                columnName2DTMap.put((String)columnName, dtClass);
            }
            RDBMSTableConverter.createInitialProcedure(conn, VALIDATE_RDBMS_VERTICES_PROCEDURE);
            boolean bVIDIsIntOrLong = false;
            if (vidColName != null) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("convertRDBMSTable2OPV: vidColName = " + vidColName);
                }
                try (CallableStatement stmt = conn.prepareCall(VALIDATE_RDBMS_VERTICES_QUERY);){
                    stmt.setString(1, vidColName);
                    stmt.setString(2, schema);
                    stmt.setString(3, rdbmsTableName);
                    stmt.registerOutParameter(4, -10);
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug("convertRDBMSTable2OPV: query to find out type of column " + vidColName + " is " + VALIDATE_RDBMS_VERTICES_QUERY);
                    }
                    stmt.execute();
                    try {
                        ResultSet rs = ((OracleCallableStatement)stmt).getCursor(4);
                        columnName = null;
                        try {
                            ResultSetMetaData rsmd = rs.getMetaData();
                            int vidType = rsmd.getColumnType(1);
                            if (ms_log.isDebugEnabled()) {
                                ms_log.debug("convertRDBMSTable2OPV: type of column " + vidColName + " is " + vidType);
                            }
                            bVIDIsIntOrLong = SQLUtils.validateIsNumericColumn(vidType);
                        }
                        catch (Throwable throwable) {
                            columnName = throwable;
                            throw throwable;
                        }
                        finally {
                            if (rs != null) {
                                if (columnName != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)columnName).addSuppressed(throwable);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e) {
                        throw new OraclePropertyGraphException(e);
                    }
                }
                catch (SQLException e) {
                    throw new OraclePropertyGraphException(e);
                }
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("convertRDBMSTable2OPV: bVIDIsIntOrLong = " + bVIDIsIntOrLong);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(0x1000000);
            long[] lErrors = new long[1];
            Object vid = null;
            long lVertices = 0L;
            long lLines = 0L;
            RDBMSTableConverter.createInitialProcedure(conn, C_ARRAY_PROCEDURE);
            RDBMSTableConverter.createInitialProcedure(conn, CONVERT_RDBMS_VERTICES_PROCEDURE);
            try (CallableStatement stmt = conn.prepareCall(CONVERT_RDBMS_VERTICES_QUERY);){
                stmt.setString(1, vidColName);
                stmt.setString(2, schema);
                stmt.setString(3, rdbmsTableName);
                stmt.setInt(4, dop);
                ArrayDescriptor arrDescPropNames = ArrayDescriptor.createDescriptor((String)"C_VARCHAR2_ARRAY", (Connection)conn);
                ArrayDescriptor arrSqlPropNames = ArrayDescriptor.createDescriptor((String)"C_VARCHAR2_ARRAY", (Connection)conn);
                String[] columnNamesAr = new String[columnNames.size()];
                String[] sqlColumnNamesAr = new String[columnNames.size()];
                int idx = 0;
                Iterator iterator = columnNames.iterator();
                while (iterator.hasNext()) {
                    String name;
                    columnNamesAr[idx] = name = (String)iterator.next();
                    sqlColumnNamesAr[idx] = "P" + idx;
                    if (ms_bDebug) {
                        ms_log.debug("convertRDBMSTable2OPE: add column " + name);
                    }
                    ++idx;
                }
                ARRAY propertyNamesArray = new ARRAY(arrDescPropNames, conn, (Object)columnNamesAr);
                stmt.setArray(5, (Array)propertyNamesArray);
                ARRAY sqlPropertyNamesArray = new ARRAY(arrSqlPropNames, conn, (Object)sqlColumnNamesAr);
                stmt.setArray(6, (Array)sqlPropertyNamesArray);
                stmt.registerOutParameter(7, -10);
                stmt.execute();
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("convertRDBMSTable2OPV: stmt is  begin converter_rdbms_vertices(?, ?, ?, ?, ?, ?, ?); end; ");
                }
                try (ResultSet rs = ((OracleCallableStatement)stmt).getCursor(7);){
                    ms_log.debug("convertRDBMSTable2OPV: result set found");
                    rs.setFetchSize(10000);
                    while (rs.next()) {
                        ms_log.debug("convertRDBMSTable2OPV: item found");
                        vid = rs.getObject("VID");
                        if (vid == null) continue;
                        long lvid = RDBMSTableConverter.getIDFromColumn(vidColName, vid, bVIDIsIntOrLong);
                        lvid += lVIDOffset;
                        String vertexLabel = null;
                        if (ms_log.isDebugEnabled()) {
                            ms_log.debug("convertRDBMSTable2OPV: lvid = " + lvid);
                        }
                        if (columnNames.size() == 0) {
                            if (ms_log.isDebugEnabled()) {
                                ms_log.debug("convertRDBMSTable2OPV: no key/value pairs, write one line to the output stream");
                            }
                            ExporterUtils.writeOneVertexLineWithLabelWithoutKV(baos, lvid, vertexLabel);
                            HelperUtilities.flushIfReachLimit(baos, opvOS, 0xC00000L);
                            ++lLines;
                            if (ms_log.isDebugEnabled()) {
                                ms_log.debug("convertRDBMSTable2OPV: lLines = " + lLines);
                            }
                        } else {
                            boolean hasNonNullValue = false;
                            int idxC = 0;
                            for (String columnName2 : columnNamesAr) {
                                Object obj;
                                String szPropertyKey = (String)columnName2AttrNameMap.get(columnName2);
                                if (bc != null && bc.doesPropertyNameSizeExceedLimit(HelperUtilities.escape(szPropertyKey))) {
                                    lErrors[0] = lErrors[0] + 1L;
                                    StringBuilder sb = new StringBuilder();
                                    sb.append("hit Exception when converting vertex: ");
                                    sb.append(lvid);
                                    sb.append(" ,property name exceed the limit: ");
                                    sb.append(bc.getEdgeLabelSizeLimit());
                                    if (dcl != null && dcl.continueOnError(lErrors[0], lVertices, vid, sb.toString())) continue;
                                    OraclePropertyGraphException e = new OraclePropertyGraphException(sb.toString());
                                    ms_log.error("convertRDBMSTable2OPV: did not pass BackendConfig check ", e);
                                    throw e;
                                }
                                Class dtClass = (Class)columnName2DTMap.get(columnName2);
                                if ((obj = rs.getObject(sqlColumnNamesAr[idxC++])) == null) continue;
                                hasNonNullValue = true;
                                Object value = SQLUtils.castRDBMSObject(obj, dtClass);
                                ExporterUtils.writeOneVertexLineWithKV(baos, lvid, szPropertyKey, value, vertexLabel, bc, dcl, lErrors);
                                HelperUtilities.flushIfReachLimit(baos, opvOS, 0xC00000L);
                                ++lLines;
                                if (!ms_log.isDebugEnabled()) continue;
                                ms_log.debug("convertRDBMSTable2OPV: lLines = " + lLines);
                            }
                            if (!hasNonNullValue) {
                                if (ms_log.isDebugEnabled()) {
                                    ms_log.debug("convertRDBMSTable2OPV: no key/value pairs, write one line to the output stream");
                                }
                                ExporterUtils.writeOneVertexLineWithLabelWithoutKV(baos, lvid, vertexLabel);
                                HelperUtilities.flushIfReachLimit(baos, opvOS, 0xC00000L);
                                ++lLines;
                                if (ms_log.isDebugEnabled()) {
                                    ms_log.debug("convertRDBMSTable2OPV: lLines = " + lLines);
                                }
                            }
                        }
                        ++lVertices;
                    }
                    HelperUtilities.flushIfReachLimit(baos, opvOS);
                }
            }
            catch (IOException | SQLException e) {
                String msg = "convertRDBMSTable2OPV: hit Exception (" + e.getClass().getName() + ") when converting vertex " + (vid != null ? vid : "NULL");
                ms_log.error(msg);
                if (dcl != null) {
                    lErrors[0] = lErrors[0] + 1L;
                    if (!dcl.continueOnError(lErrors[0], lVertices, vid, msg)) {
                        throw new OraclePropertyGraphException(msg, e);
                    }
                    break block90;
                }
                throw new OraclePropertyGraphException(msg, e);
            }
            finally {
                try {
                    opvOS.flush();
                }
                catch (IOException e1) {
                    ms_log.error("hit IOException when flushing edges from csv to opv");
                }
            }
        }
    }

    private static void createInitialProcedure(Connection conn, String procedureStr) {
        try (CallableStatement stmt = conn.prepareCall(procedureStr);){
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("createInitialProcedure: create procedure " + procedureStr);
            }
            stmt.execute();
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException("Failed to create procedure " + e);
        }
    }

    private static long getIdFromColumnValue(Object id, boolean isIntOrLong) {
        if (isIntOrLong) {
            return (Long)SQLUtils.castRDBMSObject(id, Long.class);
        }
        String idstr = (String)id;
        return HelperUtilities.hash64(idstr, 0, idstr.length(), 0L);
    }

    private static long getIDFromColumn(String colName, Object id, boolean isIntOrLong) {
        if (colName != null) {
            return RDBMSTableConverter.getIdFromColumnValue(id, isIntOrLong);
        }
        return (Long)SQLUtils.castRDBMSObject(id, Long.class);
    }
}

