/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.pg.common.CommonCache;
import oracle.pg.common.OracleLinkedHashMap;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.SimpleLog;

public class VertexCache
extends CommonCache {
    static SimpleLog ms_log = SimpleLog.getLog(VertexCache.class);
    private Map<Long, OracleVertexBase> m_hmCache = null;
    private Map<Long, OracleVertexBase>[] m_hmPtnCaches = null;
    private static ConcurrentHashMap<OraclePropertyGraphBase, VertexCache> ms_chm = new ConcurrentHashMap();
    protected static final boolean ms_bShowProgress = ParametersBase.getInstance().showProgress();
    private long m_lHits = 0L;
    private long m_lMiss = 0L;
    private long m_lPuts = 0L;
    private long m_lRems = 0L;

    Map getInternalMap() {
        return this.m_hmCache;
    }

    private VertexCache(OraclePropertyGraphBase opg) {
        super(opg);
        ms_log.debug((Object)"VertexCache: Constructor, graphName ", opg.getGraphName());
        long lCacheSize = ParametersBase.getInstance().getVertexCacheSize();
        this.m_hmPtnCaches = new Map[ms_iCachePtnNum];
        for (int idx = 0; idx < this.m_hmPtnCaches.length; ++idx) {
            if (ParametersBase.getInstance().syncCache()) {
                ms_log.debug("VertexCache: syncCache");
                this.m_hmPtnCaches[idx] = Collections.synchronizedMap(new OracleLinkedHashMap((int)lCacheSize, 0.75f, true));
                continue;
            }
            ms_log.debug("VertexCache: not syncCache");
            this.m_hmPtnCaches[idx] = new OracleLinkedHashMap<Long, OracleVertexBase>((int)lCacheSize, 0.75f, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VertexCache getInstance(OraclePropertyGraphBase opg) {
        VertexCache vc = null;
        ConcurrentHashMap<OraclePropertyGraphBase, VertexCache> concurrentHashMap = ms_chm;
        synchronized (concurrentHashMap) {
            vc = ms_chm.get(opg);
            if (vc == null) {
                ms_log.debug((Object)"getInstance: start a new VertexCache for ", opg.getGraphName());
                vc = new VertexCache(opg);
                ms_chm.put(opg, vc);
            }
        }
        return vc;
    }

    public void clearCache() {
        for (int idx = 0; idx < this.m_hmPtnCaches.length; ++idx) {
            this.m_hmPtnCaches[idx].clear();
        }
    }

    public void put(OracleVertexBase v) {
        this.put((Long)v.id(), v);
    }

    public void put(Long lID, OracleVertexBase v) {
        this.m_hmPtnCaches[this.getPtnID(lID)].put(lID, v);
        ++this.m_lPuts;
    }

    public OracleVertexBase remove(OracleVertexBase v) {
        return this.remove((Long)v.id());
    }

    public OracleVertexBase remove(Long lID) {
        OracleVertexBase e = null;
        e = this.m_hmPtnCaches[this.getPtnID(lID)].remove(lID);
        ++this.m_lRems;
        return e;
    }

    public void dumpStatistics(PrintStream ps) {
        ps.println("EdgeCache: m_lHits " + this.m_lHits);
        ps.println("EdgeCache: m_lMiss " + this.m_lMiss);
        ps.println("EdgeCache: m_lPuts " + this.m_lPuts);
        ps.println("EdgeCache: m_lRems " + this.m_lRems);
    }

    public OracleVertexBase get(Long lID) {
        if (ms_log.isDebugEnabled() && ParametersBase.getInstance().isSuperVerboseOn()) {
            ms_log.debug((Object)"get: trace ", new Throwable());
        }
        if (this.m_opg.isBuiltinElementsCacheDisabled()) {
            ms_log.debug("get: skip cache read due to cache setting");
            return null;
        }
        OracleVertexBase v = null;
        v = this.m_hmPtnCaches[this.getPtnID(lID)].get(lID);
        if (v != null) {
            ++this.m_lHits;
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"get: found a hit in cache using lID ", lID.toString());
            }
            return v;
        }
        ++this.m_lMiss;
        return null;
    }
}

