/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Date;
import oracle.jdbc.OracleStatement;
import oracle.pg.common.HelperUtilities;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.SimpleJsonDataWrapper;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.SimpleRdfDataWrapper;
import oracle.pg.common.SimpleSpatialDataWrapper;
import oracle.spatial.util.Util;

public class SQLUtils {
    static SimpleLog ms_log = SimpleLog.getLog(SQLUtils.class);
    static boolean ms_bDebug = ms_log.isDebugEnabled();
    static boolean ms_bShowProgress = ParametersBase.getInstance().showProgress();
    private static final int TABLE_MAX_LENGTH = 117;
    private static final int TABLE_MAX_LENGTH_PREVIOUS = 30;
    public static final int DB_MINOR_VERSION_DEFAULT = 2;
    public static final int DB_12C = 12;
    public static final int DB_18C = 18;
    public static final int DB_19C = 19;
    public static final int DB_20C = 20;
    public static final int DB_21C = 21;
    public static final String OPG_PATCH_NOT_INSTALLED = "OPG_PATCH_NOT_INSTALLED";
    public static final int ORA_INVALID_ID = 904;
    public static final int ORA_LITERAL_TOO_LONG = 1704;
    static final String STRIP_SCHEMA_STMT = " { ? = call strip_schema_name(?) }";
    static final String STRIP_SCHEMA_FUNCTION_STMT = "    create or replace function strip_schema_name(vcSchemaAndTabName varchar2) return varchar2 IS \n    first_token_name varchar2(32767) := substr(vcSchemaAndTabName, 1, 32767); \n    schema_tab_name_checked varchar2(32767) := NULL; \n    second_token_name varchar2(32767) := NULL; \n    third_token_name varchar2(32767) := NULL; \n    dblink varchar2(32767); \n    nextpos number; \n  begin \n    schema_tab_name_checked := sys.dbms_assert.qualified_sql_name(vcSchemaAndTabName); \n    dbms_utility.name_tokenize(schema_tab_name_checked, first_token_name, \n                              second_token_name, third_token_name, dblink, nextpos); \n    if (dblink is not NULL) then \n      raise_application_error(-20000, 'objects over database links are not supported'); \n    end if; \n    if (third_token_name is not NULL) then \n      raise_application_error(-20000, 'invalid schema and table name, 3-part schema names not supported'); \n    else \n      if (second_token_name is not NULL) then \n        return second_token_name; \n      else \n        return first_token_name; \n      end if; \n    end if; \n end;";

    public static String checkSQLName(String string, int maxStringLength) throws SQLException {
        if (string == null) {
            return null;
        }
        if (string.contains(".")) {
            throw new SQLException("The input string cannot contain '.'");
        }
        return Util.checkSQLName((String)string, (int)maxStringLength);
    }

    public static String myCheckName(String string) throws SQLException {
        if (string == null || string.length() == 0) {
            return null;
        }
        String tmpString = string.trim();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tmpString.length(); ++i) {
            char ch = tmpString.charAt(i);
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String qualifiedSQLName(Connection conn, String name) throws SQLException {
        return Util.qualifiedSQLName((Connection)conn, (String)name);
    }

    public static int getMaxLengthAllowed(Connection conn) {
        if (DbFeature.TABLE_MAX_LENGTH_117.isSupported(conn)) {
            return 117;
        }
        return 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String enquoteLiteral(Connection conn, String name) throws SQLException {
        String sqlName = null;
        try (Statement stmt = null;){
            if (name != null) {
                stmt = conn.createStatement();
                sqlName = ((OracleStatement)stmt).enquoteLiteral(name);
            }
        }
        return sqlName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String simpleSqlNameCheck(Connection conn, String name) throws SQLException {
        String sqlName = null;
        try (Statement stmt = null;){
            if (name != null) {
                stmt = conn.createStatement();
                sqlName = ((OracleStatement)stmt).enquoteIdentifier(name, false);
            }
        }
        return sqlName;
    }

    public static String enquoteLiteral(Connection conn, String literal, int maxLengthAllowed) throws SQLException {
        String newLiteral = null;
        try {
            newLiteral = SQLUtils.checkSQLName(literal, maxLengthAllowed);
            newLiteral = '\'' + newLiteral + '\'';
        }
        catch (SQLException sqle) {
            ms_log.debug("enquoteLiteral: make a DB roundtrip");
            newLiteral = SQLUtils.enquoteLiteral(conn, literal);
        }
        return newLiteral;
    }

    public static String getValidatedGraphName(Connection conn, String graphName, int maxLengthAllowed) throws SQLException {
        String newLiteral = null;
        try {
            newLiteral = SQLUtils.checkSQLName(graphName, maxLengthAllowed);
        }
        catch (SQLException sqle) {
            ms_log.debug("getValidatedGraphName: make a DB roundtrip");
            newLiteral = SQLUtils.simpleSqlNameCheck(conn, graphName);
        }
        return newLiteral;
    }

    public static String getValidatedGraphName(Connection conn, String graphName) throws SQLException {
        return SQLUtils.getValidatedGraphName(conn, graphName, SQLUtils.getMaxLengthAllowed(conn));
    }

    public static String enquoteNameSQLName(Connection conn, String name) throws SQLException {
        String newName = null;
        if (name == null) {
            return null;
        }
        try {
            newName = SQLUtils.checkSQLName(name, SQLUtils.getMaxLengthAllowed(conn));
            if (newName != null) {
                newName = '\"' + newName.toUpperCase() + '\"';
            }
        }
        catch (SQLException sqle) {
            ms_log.debug("enquoteNameSQLName: make a DB roundtrip");
            newName = Util.enquoteNameSQLName((Connection)conn, (String)name);
        }
        return newName;
    }

    public static String enquoteTableName(Connection conn, String tableName) throws SQLException {
        return Util.enquoteTableName((Connection)conn, (String)tableName);
    }

    public static String enquoteColumnName(Connection conn, String columnName) throws SQLException {
        return Util.enquoteTableName((Connection)conn, (String)columnName);
    }

    public static String enquoteColumnNameCaseSensitive(Connection conn, String name) throws SQLException {
        return Util.enquoteNameSQLName((Connection)conn, (String)name, (boolean)false);
    }

    public static boolean validateIsNumericColumn(int sqlType) {
        return sqlType == -6 || sqlType == 5 || sqlType == 4 || sqlType == -5 || sqlType == 3 || sqlType == 2;
    }

    public static final Object castRDBMSObject(Object obj, Class dtClass) {
        if (obj == null) {
            return null;
        }
        String szDestName = dtClass.getName();
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"castRDBMSObject: szDestName ", szDestName);
            ms_log.debug((Object)"castRDBMSObject: class of obj ", obj.getClass().getName());
            ms_log.debug((Object)"castRDBMSObject: obj ", obj);
        }
        Object value = null;
        if (obj instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)obj;
            if (Integer.class.isAssignableFrom(dtClass)) {
                value = bd.intValue();
            } else if (Long.class.isAssignableFrom(dtClass)) {
                value = bd.longValue();
            } else if (Float.class.isAssignableFrom(dtClass)) {
                value = Float.valueOf(bd.floatValue());
            } else if (Double.class.isAssignableFrom(dtClass)) {
                value = bd.doubleValue();
            }
        } else {
            value = SimpleSpatialDataWrapper.class.isAssignableFrom(dtClass) ? SimpleSpatialDataWrapper.getInstance(obj.toString()) : (SimpleJsonDataWrapper.class.isAssignableFrom(dtClass) ? SimpleJsonDataWrapper.getInstance(obj.toString()) : (SimpleRdfDataWrapper.class.isAssignableFrom(dtClass) ? SimpleRdfDataWrapper.getInstance(obj.toString()) : (Character.class.isAssignableFrom(dtClass) ? Character.valueOf(obj.toString().charAt(0)) : dtClass.cast(obj))));
        }
        return value;
    }

    public static void setStmtArgumentForDml(int idx, PreparedStatement ps, String szKey, Object objVa1) throws SQLException, IOException {
        ps.setString(idx, szKey);
        if (szKey == null || objVa1 == null) {
            ps.setNull(idx + 1, 4);
            ps.setString(idx + 2, null);
            ps.setNull(idx + 3, 8);
            ps.setTimestamp(idx + 4, null);
            return;
        }
        if (objVa1 instanceof String) {
            ps.setInt(idx + 1, 1);
            ps.setString(idx + 2, (String)objVa1);
            ps.setNull(idx + 3, 8);
            ps.setTimestamp(idx + 4, null);
        } else if (objVa1 instanceof Float) {
            ps.setInt(idx + 1, 3);
            ps.setString(idx + 2, null);
            ps.setFloat(idx + 3, ((Float)objVa1).floatValue());
            ps.setTimestamp(idx + 4, null);
        } else if (objVa1 instanceof Integer) {
            ps.setInt(idx + 1, 2);
            ps.setString(idx + 2, null);
            ps.setInt(idx + 3, (Integer)objVa1);
            ps.setTimestamp(idx + 4, null);
        } else if (objVa1 instanceof Double) {
            ps.setInt(idx + 1, 4);
            ps.setString(idx + 2, null);
            ps.setDouble(idx + 3, (Double)objVa1);
            ps.setTimestamp(idx + 4, null);
        } else if (objVa1 instanceof Long) {
            ps.setInt(idx + 1, 7);
            ps.setString(idx + 2, null);
            ps.setLong(idx + 3, (Long)objVa1);
            ps.setTimestamp(idx + 4, null);
        } else if (objVa1 instanceof Short) {
            ps.setInt(idx + 1, 8);
            ps.setString(idx + 2, null);
            ps.setShort(idx + 3, (Short)objVa1);
            ps.setTimestamp(idx + 4, null);
        } else if (objVa1 instanceof Byte) {
            ps.setInt(idx + 1, 9);
            ps.setString(idx + 2, null);
            ps.setByte(idx + 3, (Byte)objVa1);
            ps.setTimestamp(idx + 4, null);
        } else if (objVa1 instanceof Character) {
            ps.setInt(idx + 1, 10);
            ps.setString(idx + 2, String.valueOf((Character)objVa1));
            ps.setNull(idx + 3, 8);
            ps.setTimestamp(idx + 4, null);
        } else if (objVa1 instanceof Date) {
            Timestamp dateV = new Timestamp(((Date)objVa1).getTime());
            ps.setInt(idx + 1, 5);
            ps.setString(idx + 2, null);
            ps.setNull(idx + 3, 8);
            ps.setObject(idx + 4, dateV);
        } else if (objVa1 instanceof OffsetDateTime) {
            ms_log.debug("extractPropertyValueFromLine: setValue jdbc statement, value offsetdatetime object");
            ps.setInt(idx + 1, 5);
            ps.setString(idx + 2, null);
            ps.setNull(idx + 3, 8);
            ps.setObject(idx + 4, objVa1);
        } else if (objVa1 instanceof OffsetDateTime) {
            ms_log.debug("extractPropertyValueFromLine: setValue jdbc statement, value offsetdatetime object");
            ps.setInt(idx + 1, 5);
            ps.setString(idx + 2, null);
            ps.setNull(idx + 3, 8);
            ps.setObject(idx + 4, objVa1);
        } else if (objVa1 instanceof LocalDate) {
            ms_log.debug("extractPropertyValueFromLine: setValue jdbc statement, value localdate object");
            ps.setInt(idx + 1, 5);
            ps.setString(idx + 2, null);
            ps.setNull(idx + 3, 8);
            ps.setObject(idx + 4, objVa1);
        } else if (objVa1 instanceof LocalTime) {
            ms_log.debug("extractPropertyValueFromLine: setValue jdbc statement, value offsetdatetime object");
            ps.setInt(idx + 1, 5);
            ps.setString(idx + 2, null);
            ps.setNull(idx + 3, 8);
            ps.setObject(idx + 4, objVa1);
        } else if (objVa1 instanceof OffsetTime) {
            ms_log.debug("extractPropertyValueFromLine: setValue jdbc statement, value offsetdatetime object");
            ps.setInt(idx + 1, 5);
            ps.setString(idx + 2, null);
            ps.setNull(idx + 3, 8);
            ps.setObject(idx + 4, objVa1);
        } else if (objVa1 instanceof Instant) {
            ms_log.debug("extractPropertyValueFromLine: setValue jdbc statement, value offsetdatetime object");
            ps.setInt(idx + 1, 5);
            ps.setString(idx + 2, null);
            ps.setNull(idx + 3, 8);
            ps.setObject(idx + 4, objVa1);
        } else if (objVa1 instanceof Boolean) {
            ps.setInt(idx + 1, 6);
            ps.setString(idx + 2, (Boolean)objVa1 != false ? "Y" : "N");
            ps.setNull(idx + 3, 8);
            ps.setTimestamp(idx + 4, null);
        } else if (objVa1 instanceof SimpleSpatialDataWrapper) {
            ps.setInt(idx + 1, 20);
            ps.setString(idx + 2, ((SimpleSpatialDataWrapper)objVa1).serialize());
            ps.setNull(idx + 3, 8);
            ps.setTimestamp(idx + 4, null);
        } else if (objVa1 instanceof SimpleRdfDataWrapper) {
            ps.setInt(idx + 1, 30);
            ps.setString(idx + 2, ((SimpleRdfDataWrapper)objVa1).serialize());
            ps.setNull(idx + 3, 8);
            ps.setTimestamp(idx + 4, null);
        } else if (objVa1 instanceof SimpleJsonDataWrapper) {
            ps.setInt(idx + 1, 25);
            ps.setString(idx + 2, ((SimpleJsonDataWrapper)objVa1).serialize());
            ps.setNull(idx + 3, 8);
            ps.setTimestamp(idx + 4, null);
        } else if (objVa1 instanceof Serializable) {
            ps.setInt(idx + 1, 101);
            ps.setString(idx + 2, HelperUtilities.serializableToStr((Serializable)objVa1));
            ps.setNull(idx + 3, 8);
            ps.setTimestamp(idx + 4, null);
        } else {
            throw new OraclePropertyGraphException("setStmtArgumentForDml: TODO  unsupported type. " + objVa1.getClass().getName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String stripSchema(Connection connection, String tabName) throws SQLException {
        try (CallableStatement stmt = connection.prepareCall(STRIP_SCHEMA_FUNCTION_STMT);){
            stmt.execute();
        }
        try {
            stmt = connection.prepareCall(STRIP_SCHEMA_STMT);
            var3_4 = null;
            try {
                if (ms_bDebug || ms_bShowProgress) {
                    ms_log.debug((Object)"stripSchema: strip schema stmt:", STRIP_SCHEMA_STMT);
                    ms_log.debug((Object)"stripSchema: original string: ", tabName);
                }
                stmt.registerOutParameter(1, 12);
                stmt.setString(2, tabName);
                boolean hadResults = stmt.execute();
                ms_log.debug((Object)"stripSchema: had results? ", hadResults);
                String token1 = stmt.getString(1);
                if (ms_bDebug || ms_bShowProgress) {
                    ms_log.debug((Object)"strip schema: retrieved token (1): ", token1);
                }
                String string = token1;
                return string;
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (var3_4 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Exception e) {
            ms_log.error(e);
            throw e;
        }
    }

    public static int getDatabaseMajorVersion(Connection conn) {
        int dbVersion;
        try {
            dbVersion = conn.getMetaData().getDatabaseMajorVersion();
        }
        catch (SQLException ex) {
            throw new OraclePropertyGraphException(ex);
        }
        return dbVersion;
    }

    public static String getOpgVersion(Connection conn) {
        String opgVersion;
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT opg_apis.get_opg_version() from sys.dual");){
            rs.next();
            opgVersion = rs.getString(1);
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 904) {
                opgVersion = OPG_PATCH_NOT_INSTALLED;
            }
            throw new OraclePropertyGraphException(ex);
        }
        return opgVersion;
    }

    public static boolean isOpgPatchInstalled(String opgVersion) {
        return opgVersion != null && !OPG_PATCH_NOT_INSTALLED.equals(opgVersion);
    }

    public static boolean isMaxStringSizeExtended(Connection conn) {
        boolean isExtended = true;
        try (Statement stmt = conn.createStatement();){
            String createStmt = "DECLARE\n  str_column varchar2(4001) := '';\nBEGIN\n  for i in 1 .. 4001 loop\n    str_column := str_column || 'x';\n  end loop;\n  execute immediate  'select ''' || str_column || ''' as x from sys.dual';\nEND;";
            stmt.execute(createStmt);
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 1704) {
                isExtended = false;
            }
            throw new OraclePropertyGraphException(ex);
        }
        return isExtended;
    }

    public static void createInitialProcedure(Connection conn, String procedureStr) {
        try (CallableStatement stmt = conn.prepareCall(procedureStr);){
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("createInitialProcedure: create procedure " + procedureStr);
            }
            stmt.execute();
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException("Failed to create procedure " + e);
        }
    }

    public static boolean isEnterpriseEditionDB(Connection conn) {
        boolean isEE = false;
        try {
            String dbVersion = conn.getMetaData().getDatabaseProductVersion();
            if (dbVersion.toUpperCase().contains("ENTERPRISE EDITION") || dbVersion.contains("EE")) {
                isEE = true;
            }
        }
        catch (Exception ex) {
            isEE = false;
        }
        return isEE;
    }

    public static void setEventForPartitioning(Connection connection, int level) throws SQLException {
        String strStmt = "alter session set events  '14524 trace name context forever, level " + level + "'";
        ms_log.debug((Object)"setEventForPartitioning: stmt = ", strStmt);
        try (PreparedStatement stmt = connection.prepareStatement(strStmt);){
            stmt.executeUpdate();
        }
    }

    public static enum DbFeature {
        CUSTOM_ID_PROPERTY(18, true),
        SHARDING(18, false),
        CREATE_PG_WITH_TBS_SET(18, true),
        VERTEX_LABELS(19, true),
        REVOKE_ACCESS(19, true),
        DISTINCT_PG_TABLES(20, true),
        TABLE_MAX_LENGTH_117(21, true);

        int requiredVersion;
        boolean isSupportedWithPatch;

        private DbFeature(int requiredVersion, boolean isSupportedWithPatch) {
            this.requiredVersion = requiredVersion;
            this.isSupportedWithPatch = isSupportedWithPatch;
        }

        public boolean isSupported(Connection conn) {
            return this.isSupported(SQLUtils.getDatabaseMajorVersion(conn), SQLUtils.getOpgVersion(conn));
        }

        public boolean isSupported(int dbVersion, String opgVersion) {
            return dbVersion >= this.requiredVersion || this.isSupportedWithPatch && SQLUtils.isOpgPatchInstalled(opgVersion);
        }
    }
}

