/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import oracle.pg.common.Direction;
import oracle.pg.common.OracleCommonUtils;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OracleElement;
import oracle.pg.common.OracleElementBase;
import oracle.pg.common.OracleElementHelper;
import oracle.pg.common.OraclePropertyBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.OracleVertexPropertyBase;
import oracle.pg.common.SimpleLog;

public abstract class OracleVertexBase
extends OracleElementBase
implements Comparable<Object> {
    public static final String DEFAULT_LABEL = "vertex";
    private String m_szLabel = "vertex";
    static SimpleLog ms_log = SimpleLog.getLog(OracleVertexBase.class);
    static boolean ms_bDebug = ms_log.isDebugEnabled();

    protected OracleVertexBase(OraclePropertyGraphBase opg, Long vid, String label) {
        super(opg, vid);
        this.m_szLabel = label;
    }

    protected OracleVertexBase() {
    }

    public abstract long degree(Direction var1, String ... var2);

    public final OracleVertexPropertyBase<Object> property(String key, Object value, Object ... keyValues) {
        OracleElementHelper.validateProperty(key, value);
        OraclePropertyBase vertexProperty = null;
        if (this.property(key) != null) {
            vertexProperty = this.property(key, value);
            OracleElementHelper.attachProperties((OracleElement)((Object)vertexProperty), keyValues);
        } else {
            vertexProperty = this.property(key, value);
        }
        return vertexProperty;
    }

    @Override
    public final int compareTo(Object o) {
        long lthat;
        if (o == null) {
            throw new NullPointerException("Input argument must not be null");
        }
        OracleVertexBase v = (OracleVertexBase)o;
        long lthis = this.m_lID;
        if (lthis < (lthat = ((Long)v.id()).longValue())) {
            return -1;
        }
        if (lthis == lthat) {
            return 0;
        }
        return 1;
    }

    @Override
    public String label() {
        if (this.m_szLabel == null) {
            ms_log.debug("label: label cannot be null, use default");
            this.m_szLabel = DEFAULT_LABEL;
        }
        return this.m_szLabel;
    }

    public final void setLabel(String szLbl) {
        this.setLabel(szLbl, false, false);
    }

    public final void setLabel(String szLbl, boolean skipQueue, boolean skipLucene) {
        if (szLbl == null && this.m_szLabel == null) {
            ms_log.debug("setLabel: both labels are equal to NULL, do nothing");
            return;
        }
        if (szLbl != null && this.m_szLabel != null && szLbl.equals(this.m_szLabel)) {
            ms_log.debug("setLabel: both labels are not null, but the same, do nothing");
            return;
        }
        ms_log.debug("setLabel: label changed, check update and add to queue");
        this.m_szLabel = szLbl;
        if (skipQueue) {
            if (ms_bDebug) {
                ms_log.debug("setLabel: skipQueue set to true, do nothing");
            }
            return;
        }
        if (this.m_opg.isTransientPropertyGraphInstance()) {
            throw new OraclePropertyGraphException("Property Graph is a transient graph, no update operations allowed");
        }
        if (skipLucene) {
            if (ms_bDebug) {
                ms_log.debug("setLabel: skipLucene set to true, call addUpdatedElement");
            }
            this.m_opg.addUpdatedElement(this);
        } else {
            if (ms_bDebug) {
                ms_log.debug("setLabel: skipLucene set to false, call addUpdatedElementWithIndices");
            }
            this.m_opg.addUpdatedElementWithIndices(this);
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("Vertex ID ").append(this.m_lID).append(" [").append(this.m_szLabel == null ? "NULL" : this.m_szLabel).append("] ").append(this.getAttributes());
        return sb.toString();
    }

    public final OracleEdgeBase addEdge(String label, OracleVertexBase inVertex, Object ... keyValues) {
        ms_log.debug("addEdge: start");
        if (this.m_opg.isTransientPropertyGraphInstance()) {
            throw new OraclePropertyGraphException("Property Graph is a transient graph, no update operations allowed");
        }
        if (null == inVertex) {
            throw new IllegalArgumentException("The provided argument can not be null: vertex");
        }
        if (!(inVertex instanceof OracleVertexBase)) {
            throw new OraclePropertyGraphException("Cannot add vertex as it is not an instance of OracleVertex");
        }
        OracleElementHelper.validateLabel(label);
        OracleElementHelper.legalPropertyKeyValueArray(keyValues);
        Object idValue = OracleElementHelper.getIdValue(keyValues).orElse(null);
        OracleVertexBase oInVertex = inVertex;
        OracleEdgeBase e = this.m_opg.addEdge(idValue, this, oInVertex, label);
        ms_log.debug("addEdge: append properties");
        OracleElementHelper.attachProperties(e, keyValues);
        ms_log.debug("addEdge: done");
        return e;
    }

    public final Iterator<OracleVertexPropertyBase<Object>> properties(String ... propertyKeys) {
        ArrayList<OraclePropertyBase> properties = new ArrayList<OraclePropertyBase>();
        if (propertyKeys == null || propertyKeys.length <= 0) {
            Set<String> keys = this.keys();
            propertyKeys = new String[keys.size()];
            propertyKeys = keys.toArray(propertyKeys);
        }
        for (String key : propertyKeys) {
            properties.add(this.property(key));
        }
        return properties.iterator();
    }

    public final int hashCode() {
        ms_log.debug("hashCode: start");
        int hc = this.id().hashCode();
        Set<String> setKeys = this.keys();
        hc = OracleCommonUtils.revolve(hc, setKeys.size());
        for (String szKey : setKeys) {
            hc = OracleCommonUtils.revolve(hc, szKey.hashCode());
            Object obj = this.propertyValue(szKey);
            hc = OracleCommonUtils.revolve(hc, obj.hashCode());
        }
        return hc;
    }

    public final OracleVertexPropertyBase<Object> property(String key) {
        return new OracleVertexPropertyBase<Object>(this, key, this.propertyValue(key));
    }

    public final OracleVertexPropertyBase<Object> property(String key, Object value) {
        this.property(key, value, false);
        return new OracleVertexPropertyBase<Object>(this, key, value);
    }

    public boolean equals(Object o) {
        ms_log.debug("equals: starts");
        if (o == null) {
            ms_log.debug("equals: object to compare is null, return false");
            return false;
        }
        if (this == o) {
            ms_log.debug("equals: object is the same, return true");
            return true;
        }
        if (this.getClass() != o.getClass()) {
            if (ms_bDebug) {
                ms_log.debug((Object)"equals: object class are different, o class is ", o.getClass().getName());
            }
            return false;
        }
        if (ms_bDebug) {
            ms_log.debug("equals: refresh this object, to get most updated state");
        }
        this.refresh();
        if (ms_bDebug) {
            ms_log.debug("equals: refresh object to compare, to get most updated state");
        }
        OracleVertexBase ov = (OracleVertexBase)o;
        ov.refresh();
        if (!this.id().equals(ov.id())) {
            if (ms_bDebug) {
                ms_log.debug("equals: ids are different, return false");
            }
            return false;
        }
        Set<String> setKeys = this.keys();
        Set<String> setKeys2 = ov.keys();
        if (setKeys.size() != setKeys2.size()) {
            if (ms_bDebug) {
                ms_log.debug("equals: different key sets, return false");
            }
            return false;
        }
        for (String szKey : setKeys) {
            Object obj = this.propertyValue(szKey);
            Object obj1 = ov.propertyValue(szKey);
            if (obj == null && obj1 != null) {
                if (ms_bDebug) {
                    ms_log.debug("equals: value exists for key in the object to compare but not in this one ");
                }
                return false;
            }
            if (obj1 == null) {
                if (!ms_bDebug) continue;
                ms_log.debug("equals: value exists for key ----- in this object but not in object to compare ");
                continue;
            }
            if (obj.equals(obj1)) continue;
            if (ms_bDebug) {
                ms_log.debug("equals: different values for key ----, this object: , other vertex:---");
            }
            if (obj instanceof String || obj instanceof Integer || obj instanceof Long || obj instanceof Double || obj instanceof Float || obj instanceof Date || obj instanceof Boolean || obj instanceof Byte || obj instanceof Short || obj instanceof Character) {
                if (ms_bDebug) {
                    ms_log.debug("equals: primitive types return false");
                }
                return false;
            }
            if (obj instanceof Serializable && obj1 instanceof Serializable) {
                ms_log.debug("equals: parse serializable objects and compare");
                try {
                    String str1 = OraclePropertyGraphBase.serializableToStr((Serializable)obj);
                    String str2 = OraclePropertyGraphBase.serializableToStr((Serializable)obj);
                    if (ms_bDebug) {
                        ms_log.debug("equals: str1: ----, str2: ----");
                    }
                    if (str1 == null || str2 == null || !str1.equals(str2)) continue;
                    continue;
                }
                catch (Exception e) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)"equals: exception found when trying to parse serializable ", e);
                    }
                    return false;
                }
            }
            if (ms_bDebug) {
                ms_log.debug("equals: different values even in serializable");
            }
            return false;
        }
        ms_log.debug("equals: true");
        return true;
    }

    public final Iterator<OracleEdgeBase> edges(Direction direction, String ... labels) {
        return this.edges(direction, (OraclePropertyGraphBase.OptimizationFlag)null, labels);
    }

    public abstract Iterator<OracleEdgeBase> edges(Direction var1, OraclePropertyGraphBase.OptimizationFlag var2, String ... var3);

    public final Iterator<OracleVertexBase> vertices(Direction direction, String ... labels) {
        return this.vertices(direction, (OraclePropertyGraphBase.OptimizationFlag)null, labels);
    }

    public abstract Iterator<OracleVertexBase> vertices(Direction var1, OraclePropertyGraphBase.OptimizationFlag var2, String ... var3);

    public final OracleEdgeBase addEdge(String label, OracleVertexBase inVertex) {
        ms_log.debug("addEdge: start");
        if (this.m_opg.isTransientPropertyGraphInstance()) {
            throw new OraclePropertyGraphException("Property Graph is a transient graph, no update operations allowed");
        }
        OracleEdgeBase e = this.m_opg.addEdge(null, this, inVertex, label);
        ms_log.debug("addEdge: done");
        return e;
    }

    @Override
    public final void remove() {
        ms_log.debug("remove: start");
        if (this.m_opg.isTransientPropertyGraphInstance()) {
            throw new OraclePropertyGraphException("Property Graph is a transient graph, no update operations allowed");
        }
        this.m_opg.removeVertex(this);
        this.cleanup();
    }

    @Override
    public final void forceRefresh() throws Exception {
        this.m_opg.readVertexFromDB(this.m_lID, this, true);
    }
}

