/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.zip.GZIPInputStream;
import oracle.jdbc.OracleConnection;
import oracle.pg.common.DataLoaderListener;
import oracle.pg.common.HelperUtilities;
import oracle.pg.common.OracleConvertersUtilsBase;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.PropertyReader;
import oracle.pg.common.SimpleJsonDataWrapper;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.SimpleRdfDataWrapper;
import oracle.pg.common.SimpleSpatialDataWrapper;
import oracle.pg.common.exporter.ExporterUtils;
import oracle.pg.common.exporter.ffiles.OraclePropertyGraphFlatFileExporter;
import oracle.pg.common.loader.OracleFlatFileSplitter;
import oracle.pg.common.loader.OracleFlatFileSplitterConfig;
import oracle.pg.common.messages.MesgConsts;
import oracle.pg.common.messages.Message;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.config.AbstractPgGraphConfigBuilder;
import org.apache.commons.io.FilenameUtils;

public abstract class OraclePropertyGraphUtilsBase
extends OracleConvertersUtilsBase
implements MesgConsts {
    static SimpleLog ms_log = SimpleLog.getLog(OraclePropertyGraphUtilsBase.class);
    protected static final boolean ms_bDebug = ms_log.isDebugEnabled();
    protected static final boolean ms_bShowProgress = ParametersBase.getInstance().showProgress();
    static final byte[] magic = new byte[]{31, -117};
    static int PIPE_SIZE = 0x200000;

    public static OracleConnection castAsOracleConnection(Connection connection) throws SQLException {
        return (OracleConnection)connection.unwrap(Connection.class);
    }

    public static int getPropertyType(Object objVa1) {
        if (objVa1 == null) {
            return -1;
        }
        if (objVa1 instanceof String) {
            return 1;
        }
        if (objVa1 instanceof Float) {
            return 3;
        }
        if (objVa1 instanceof Integer) {
            return 2;
        }
        if (objVa1 instanceof Double) {
            return 4;
        }
        if (objVa1 instanceof Long) {
            return 7;
        }
        if (objVa1 instanceof Short) {
            return 8;
        }
        if (objVa1 instanceof Byte) {
            return 9;
        }
        if (objVa1 instanceof Character) {
            return 10;
        }
        if (objVa1 instanceof Date) {
            return 5;
        }
        if (objVa1 instanceof Boolean) {
            return 6;
        }
        if (objVa1 instanceof SimpleSpatialDataWrapper) {
            return 20;
        }
        if (objVa1 instanceof SimpleRdfDataWrapper) {
            return 30;
        }
        if (objVa1 instanceof SimpleJsonDataWrapper) {
            return 25;
        }
        if (objVa1 instanceof Serializable) {
            return 101;
        }
        throw new OraclePropertyGraphException("getPropertyType: unsupported type. " + objVa1.getClass().getName());
    }

    public static boolean isNumericValue(int propertyType) {
        return propertyType == 3 || propertyType == 2 || propertyType == 7 || propertyType == 4 || propertyType == 8 || propertyType == 9;
    }

    public static boolean isDateValue(int propertyType) {
        return propertyType == 5;
    }

    public static String getPropertyValueAsStr(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return ((Float)value).toString();
        }
        if (value instanceof Integer) {
            return ((Integer)value).toString();
        }
        if (value instanceof Double) {
            return ((Double)value).toString();
        }
        if (value instanceof Long) {
            return ((Long)value).toString();
        }
        if (value instanceof Short) {
            return ((Short)value).toString();
        }
        if (value instanceof Byte) {
            return ((Byte)value).toString();
        }
        if (value instanceof Character) {
            return ((Character)value).toString();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "Y" : "N";
        }
        if (value instanceof SimpleRdfDataWrapper) {
            return ((SimpleRdfDataWrapper)value).serialize();
        }
        if (value instanceof SimpleJsonDataWrapper) {
            return ((SimpleJsonDataWrapper)value).serialize();
        }
        if (value instanceof SimpleSpatialDataWrapper) {
            return ((SimpleSpatialDataWrapper)value).serialize();
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Serializable) {
            return HelperUtilities.serializableToStr((Serializable)value);
        }
        throw new OraclePropertyGraphException("getPropertyValueAsStr: unsupported type. " + value.getClass().getName());
    }

    public static void outputVertexRecord(OutputStream os, Long vid, String szPropertyKey, Object value) throws IOException {
        OraclePropertyGraphUtilsBase.outputVertexRecord(os, vid, null, szPropertyKey, value);
    }

    public static void outputVertexRecord(OutputStream os, Long vid, String szLabel, String szPropertyKey, Object value) throws IOException {
        ExporterUtils.outputVertexRecord(os, vid, szLabel, szPropertyKey, value);
    }

    public static void outputEdgeRecord(OutputStream os, Long eid, Long svid, Long dvid, String label, String szPropertyKey, Object value) throws IOException {
        ExporterUtils.outputEdgeRecord(os, eid, svid, dvid, label, szPropertyKey, value);
    }

    public static boolean compareValueObjects(Object obj, Object obj1) {
        if (obj == null && obj1 != null) {
            if (ms_bDebug) {
                ms_log.debug((Object)"equals: value exists in the object", " to compare but not in this one ");
            }
            return false;
        }
        if (obj1 == null) {
            if (ms_bDebug) {
                ms_log.debug((Object)"equals: value exists in this object", " but not in object to compare ");
            }
            return false;
        }
        if (!obj.equals(obj1)) {
            if (ms_bDebug) {
                ms_log.debug("compareValueObjects: different values for  this object: other vertex: ");
            }
            if (obj instanceof String || obj instanceof Integer || obj instanceof Long || obj instanceof Double || obj instanceof Float || obj instanceof Date || obj instanceof Boolean || obj instanceof Byte || obj instanceof Short || obj instanceof Character) {
                if (ms_bDebug) {
                    ms_log.debug("equals: primitive types return false");
                }
                return false;
            }
            if (obj instanceof Serializable && obj1 instanceof Serializable) {
                ms_log.debug("equals: parse serializable objects and compare");
                try {
                    String str1 = OraclePropertyGraphBase.serializableToStr((Serializable)obj);
                    String str2 = OraclePropertyGraphBase.serializableToStr((Serializable)obj1);
                    return str1 != null && str2 != null && str1.equals(str2);
                }
                catch (Exception e) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)"equals: exception found when trying to parse serializable ", e);
                    }
                    return false;
                }
            }
            if (ms_bDebug) {
                ms_log.debug("equals: different values even in serializable");
            }
            return false;
        }
        return true;
    }

    public static final String unescape(String s) {
        String szResult;
        if (s == null) {
            return null;
        }
        try {
            szResult = s.replace("%2C", ",");
            szResult = szResult.replace("%0A", "\n");
            szResult = szResult.replace("%0D", "\r");
            szResult = szResult.replace("%20", " ");
            szResult = szResult.replace("%09", "\t");
            szResult = szResult.replace("%25", "%");
        }
        catch (Exception e) {
            throw new OraclePropertyGraphException(e);
        }
        return szResult;
    }

    public static final boolean compareFiles(String szSrcFile, String szDstFile) throws IOException {
        boolean bSame = false;
        Object[] saSrc = OraclePropertyGraphUtilsBase.readFileIntoArray(szSrcFile);
        Object[] saDst = OraclePropertyGraphUtilsBase.readFileIntoArray(szDstFile);
        Arrays.sort(saSrc);
        Arrays.sort(saDst);
        bSame = Arrays.equals(saSrc, saDst);
        return bSame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] readFileIntoArray(String filename) throws IOException, FileNotFoundException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(filename));
        LinkedList<String> list = new LinkedList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line = null;
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
        }
        String[] array = list.toArray(new String[list.size()]);
        return array;
    }

    public static final InputStream handleGZipInputStream(InputStream in) throws IOException {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in, 1024);
        }
        in.mark(magic.length);
        byte[] baHeader = new byte[magic.length];
        int bytesRead = in.read(baHeader);
        if (bytesRead == -1) {
            ms_log.debug("handleGZipInputStream: hit end of file");
        }
        in.reset();
        boolean bSame = true;
        for (int idx = 0; idx < magic.length; ++idx) {
            if (magic[idx] == baHeader[idx]) continue;
            bSame = false;
            break;
        }
        if (bSame) {
            ms_log.debug("handleGZipInputStream: gzipped stream");
            in = new GZIPInputStream(in);
        }
        return in;
    }

    public static final void quietlyClose(OutputStream[] osa) {
        if (osa != null) {
            for (OutputStream os : osa) {
                OraclePropertyGraphUtilsBase.quietlyClose(os);
            }
        }
    }

    public static final void quietlyClose(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException ioe) {
                ms_log.debug((Object)"quietlyClose: os exception", ioe);
            }
        }
    }

    public static final void quietlyClose(InputStream[] isa) {
        if (isa != null) {
            for (InputStream is : isa) {
                OraclePropertyGraphUtilsBase.quietlyClose(is);
            }
        }
    }

    public static final void quietlyClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException ioe) {
                ms_log.debug((Object)"quietlyClose: is exception", ioe);
            }
        }
    }

    public static void quietlyClose(BufferedReader br) {
        try {
            if (br != null) {
                br.close();
            }
        }
        catch (IOException ioe) {
            ms_log.debug((Object)"quietlyClose: br exception", ioe);
        }
    }

    public static final void quietlyShutdown(OraclePropertyGraphBase opg) {
        if (opg != null) {
            try {
                opg.close();
            }
            catch (Exception e) {
                ms_log.debug((Object)"quietlyShutdown: exception", e);
            }
        }
    }

    public static final <E> List<E> listify(Iterable<E> it) {
        if (it == null) {
            return new ArrayList();
        }
        ArrayList<E> al = new ArrayList<E>();
        for (E e : it) {
            al.add(e);
        }
        return al;
    }

    public static final <E> long size(Iterable<E> it) {
        if (it == null) {
            return 0L;
        }
        long lSize = 0L;
        for (E e : it) {
            if (ms_bDebug) {
                ms_log.debug((Object)"size: found ", e);
            }
            ++lSize;
        }
        return lSize;
    }

    public static final <E> long size(Iterator<E> it) {
        if (it == null) {
            return 0L;
        }
        long lSize = 0L;
        while (it.hasNext()) {
            E e = it.next();
            if (ms_bDebug) {
                ms_log.debug((Object)"size: found ", e);
            }
            ++lSize;
        }
        return lSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void saveFileIntoOutputStream(OutputStream os, String fileName) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(FilenameUtils.normalize((String)fileName));
            byte[] buf = new byte[8192];
            int c = 0;
            while ((c = ((InputStream)is).read(buf, 0, buf.length)) > 0) {
                os.write(buf, 0, c);
                os.flush();
            }
        }
        catch (Throwable throwable) {
            OraclePropertyGraphUtilsBase.quietlyClose(is);
            throw throwable;
        }
        OraclePropertyGraphUtilsBase.quietlyClose(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveInputStreamIntoFile(InputStream is, String fileName) throws IOException {
        byte[] buffer = new byte[is.available()];
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(FilenameUtils.normalize((String)fileName));
            ((OutputStream)outStream).write(buffer);
            outStream.flush();
        }
        catch (Throwable throwable) {
            OraclePropertyGraphUtilsBase.quietlyClose(outStream);
            throw throwable;
        }
        OraclePropertyGraphUtilsBase.quietlyClose(outStream);
    }

    public static final void exportFlatFiles(OraclePropertyGraphBase pg, String vertexFileName, String edgeFileName, boolean append) throws IOException, FileNotFoundException {
        OraclePropertyGraphUtilsBase.exportFlatFiles(pg, vertexFileName, edgeFileName, 0, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void exportFlatFiles(OraclePropertyGraphBase pg, String vertexFileName, String edgeFileName, int dop, boolean append) throws IOException, FileNotFoundException {
        ms_log.debug("exportFlatFiles: start");
        BufferedOutputStream m_osVertex = null;
        BufferedOutputStream m_osEdge = null;
        try {
            m_osVertex = new BufferedOutputStream(new FileOutputStream(vertexFileName, append), 0x1000000);
            m_osEdge = new BufferedOutputStream(new FileOutputStream(edgeFileName, append), 0x1000000);
            OraclePropertyGraphUtilsBase.exportFlatFiles(pg, m_osVertex, m_osEdge, dop, append);
        }
        catch (Throwable throwable) {
            OraclePropertyGraphUtilsBase.quietlyClose(m_osVertex);
            OraclePropertyGraphUtilsBase.quietlyClose(m_osEdge);
            throw throwable;
        }
        OraclePropertyGraphUtilsBase.quietlyClose(m_osVertex);
        OraclePropertyGraphUtilsBase.quietlyClose(m_osEdge);
    }

    public static void exportVertices(Iterator<OracleVertexBase>[] itVertexArray, OutputStream osVertex) throws IOException, FileNotFoundException {
        OraclePropertyGraphFlatFileExporter.exportVertices(itVertexArray, osVertex);
    }

    public static void validateSources(Object[] oaSources, String element) {
        if (oaSources == null || oaSources.length == 0) {
            throw new IllegalArgumentException("loadData: need at least one String/InputStream source");
        }
        for (int i = 0; i < oaSources.length; ++i) {
            if (oaSources[i] instanceof String) {
                File f = new File((String)oaSources[i]);
                if (f.exists()) continue;
                throw new IllegalArgumentException("loadData: " + f.getName() + " flat file does not exist");
            }
            if (oaSources[i] instanceof InputStream) continue;
            throw new IllegalArgumentException("loadData: input " + element + " source must be either file name or inputstream");
        }
    }

    public static void prepareConfigVertexPropertiesFromOPVFile(Object[] oaVertexSources, AbstractPgGraphConfigBuilder config, int dop, OracleFlatFileSplitterConfig ofsconfig) {
        try {
            OraclePropertyGraphUtilsBase.validateSources(oaVertexSources, "vertex");
            Map<String, Class> propertyMap = OraclePropertyGraphUtilsBase.getPropertiesFromFile(dop, ofsconfig, oaVertexSources, true);
            Set<Map.Entry<String, Class>> properties = propertyMap.entrySet();
            for (Map.Entry<String, Class> property : properties) {
                config.addVertexProperty(property.getKey(), OraclePropertyGraphUtilsBase.getDatatypeAsPropertyType(property.getValue()));
            }
        }
        catch (OraclePropertyGraphException ex) {
            throw ex;
        }
        catch (IOException ex) {
            Message msg = new Message("ERR_HIT_IO", "addVertexPropertiesFromOPVFile");
            throw new OraclePropertyGraphException(msg.toString(), ex);
        }
        catch (Exception ex) {
            Message msg = new Message("ERR_HIT_EXCEPTION", "addVertexPropertiesFromOPVFile");
            throw new OraclePropertyGraphException(msg.toString(), ex);
        }
    }

    public static Map<String, Class> getPropertiesFromFile(int dop, OracleFlatFileSplitterConfig config, Object[] sources, boolean bVertex) throws ExecutionException, IOException, InterruptedException {
        int i;
        OutputStream[] osa = null;
        InputStream[] isa = null;
        osa = new OutputStream[dop];
        for (i = 0; i < dop; ++i) {
            osa[i] = new PipedOutputStream();
        }
        isa = new InputStream[dop];
        for (i = 0; i < dop; ++i) {
            isa[i] = new PipedInputStream((PipedOutputStream)osa[i], PIPE_SIZE);
        }
        DataLoaderListener dll = null;
        if (config != null && config.getDataLoaderListener() != null) {
            dll = config.getDataLoaderListener();
        }
        OracleFlatFileSplitter vertexSplitter = new OracleFlatFileSplitter(bVertex, sources, osa, config);
        PropertyReader propertyReader = new PropertyReader(bVertex, isa, dop, dll);
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(2);
        ExecutorCompletionService<Object> completionService = new ExecutorCompletionService<Object>(executor);
        ArrayList<Future<Object>> tasks = new ArrayList<Future<Object>>();
        Future<Long> futureFileSplitter = completionService.submit(vertexSplitter);
        tasks.add(futureFileSplitter);
        Future<Map<String, Class>> futurePropertyReader = completionService.submit(propertyReader);
        tasks.add(futurePropertyReader);
        for (Future future : tasks) {
            try {
                Object v = future.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                for (Future future2 : tasks) {
                    future2.cancel(true);
                }
                tasks.clear();
                executor.shutdownNow();
                throw e;
            }
        }
        executor.shutdown();
        return futurePropertyReader.get();
    }

    public static void prepareConfigEdgePropertiesFromOPVFile(Object[] oaEdgeSources, AbstractPgGraphConfigBuilder config, int dop, OracleFlatFileSplitterConfig ofsconfig) {
        try {
            OraclePropertyGraphUtilsBase.validateSources(oaEdgeSources, "edge");
            Map<String, Class> propertyMap = OraclePropertyGraphUtilsBase.getPropertiesFromFile(dop, ofsconfig, oaEdgeSources, false);
            Set<Map.Entry<String, Class>> properties = propertyMap.entrySet();
            for (Map.Entry<String, Class> property : properties) {
                config.addVertexProperty(property.getKey(), OraclePropertyGraphUtilsBase.getDatatypeAsPropertyType(property.getValue()));
            }
        }
        catch (OraclePropertyGraphException ex) {
            throw ex;
        }
        catch (IOException ex) {
            Message msg = new Message("ERR_HIT_IO", "addVertexPropertiesFromOPVFile");
            throw new OraclePropertyGraphException(msg.toString(), ex);
        }
        catch (Exception ex) {
            Message msg = new Message("ERR_HIT_EXCEPTION", "addVertexPropertiesFromOPVFile");
            throw new OraclePropertyGraphException(msg.toString(), ex);
        }
    }

    public static PropertyType getDatatypeAsPropertyType(Class dtClass) {
        if (Integer.class.equals((Object)dtClass) || Short.class.equals((Object)dtClass) || Byte.class.equals((Object)dtClass)) {
            return PropertyType.INTEGER;
        }
        if (Long.class.equals((Object)dtClass)) {
            return PropertyType.LONG;
        }
        if (Boolean.class.equals((Object)dtClass)) {
            return PropertyType.BOOLEAN;
        }
        if (LocalDate.class.equals((Object)dtClass)) {
            return PropertyType.LOCAL_DATE;
        }
        if (Float.class.equals((Object)dtClass)) {
            return PropertyType.FLOAT;
        }
        if (Double.class.equals((Object)dtClass)) {
            return PropertyType.DOUBLE;
        }
        return PropertyType.STRING;
    }

    public static void exportEdges(Iterator<OracleEdgeBase>[] itEdgeArray, OutputStream osEdge) throws IOException, FileNotFoundException {
        OraclePropertyGraphFlatFileExporter.exportEdges(itEdgeArray, osEdge);
    }

    public static final void exportFlatFiles(OraclePropertyGraphBase pg, OutputStream osVertex, OutputStream osEdge, int dop, boolean append) throws IOException, FileNotFoundException {
        OraclePropertyGraphUtilsBase.exportFlatFiles(pg, osVertex, osEdge, dop, append, true);
    }

    public static void exportFlatFiles(OraclePropertyGraphBase pg, OutputStream osVertex, OutputStream osEdge, int dop, boolean append, boolean closeStreams) throws IOException, FileNotFoundException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("exportFlatFiles: start");
        }
        OraclePropertyGraphUtilsBase.exportVertexFlatFile(pg, osVertex, dop, append, closeStreams);
        OraclePropertyGraphUtilsBase.exportEdgeFlatFile(pg, osEdge, dop, append, closeStreams);
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("exportFlatFiles: end");
        }
    }

    public static void exportVertexFlatFile(OraclePropertyGraphBase pg, OutputStream osVertex, int dop, boolean append, boolean closeStream) throws IOException, FileNotFoundException {
        OraclePropertyGraphFlatFileExporter.exportVertexFlatFile(pg, osVertex, dop, append, closeStream);
    }

    public static void exportEdgeFlatFile(OraclePropertyGraphBase pg, OutputStream osEdge, int dop, boolean append, boolean closeStream) throws IOException, FileNotFoundException {
        OraclePropertyGraphFlatFileExporter.exportEdgeFlatFile(pg, osEdge, dop, append, closeStream);
    }

    public static void quietlyCloseResultSet(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void quietlyCloseResultSetAndStmt(ResultSet rs, Statement stmt) {
        try {
            if (rs != null) {
                rs.close();
            }
            ms_log.debug("quietlyCloseResultSetAndStmt: close result set");
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    ms_log.debug("quietlyCloseResultSetAndStmt: done closing statement in final block");
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static void quietlyCloseResultSetAndStmt(ResultSet rs) {
        if (rs == null) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = rs.getStatement();
            rs.close();
            ms_log.debug("quietlyCloseResultSetAndStmt: close result set");
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    ms_log.debug("quietlyCloseResultSetAndStmt: done closing statement in final block");
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static void quietlyCloseStmt(Statement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            stmt.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

