/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import oracle.pg.common.Direction;
import oracle.pg.common.EdgeCache;
import oracle.pg.common.EdgeFilterCallback;
import oracle.pg.common.EdgeOpCallback;
import oracle.pg.common.HelperUtilities;
import oracle.pg.common.OpCallback;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OracleElement;
import oracle.pg.common.OracleElementBase;
import oracle.pg.common.OracleElementHelper;
import oracle.pg.common.OracleGraphAttributeUpdater;
import oracle.pg.common.OracleGraphUpdateWorker;
import oracle.pg.common.OracleIndexableGraph;
import oracle.pg.common.OracleMessageConstants;
import oracle.pg.common.OracleMetadataGraph;
import oracle.pg.common.OraclePropertyGraphConstants;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.ProgressListener;
import oracle.pg.common.SimpleJsonDataWrapper;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.SimpleRdfDataWrapper;
import oracle.pg.common.SimpleSpatialDataWrapper;
import oracle.pg.common.VertexCache;
import oracle.pg.common.VertexFilterCallback;
import oracle.pg.common.VertexOpCallback;
import oracle.pg.common.loader.exceptions.InvalidPropertyTypeException;
import oracle.pg.common.messages.MesgConsts;
import oracle.pg.common.messages.Message;
import oracle.pg.text.OracleIndex;
import oracle.pg.text.OracleIndexManager;
import oracle.pg.text.OracleIndexParameters;
import oracle.pg.text.OracleIndexUtils;
import oracle.pg.text.Parameter;
import oracle.pgx.api.Analyst;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxPath;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.config.AbstractPgGraphConfig;

public abstract class OraclePropertyGraphBase
implements OracleIndexableGraph,
OracleMetadataGraph,
OracleGraphAttributeUpdater,
OraclePropertyGraphConstants,
MesgConsts,
OracleMessageConstants,
Closeable {
    protected static final NumberFormatException ms_nfe = new NumberFormatException("null value");
    protected static final int ms_defaultDOP = ParametersBase.getInstance().getDOP();
    protected String m_szGraphName;
    static SimpleLog ms_log = SimpleLog.getLog(OraclePropertyGraphBase.class);
    static boolean ms_bDebug = ms_log.isDebugEnabled();
    protected boolean m_bShutdownCalled = false;
    protected boolean m_bDisposed = false;
    protected VertexCache m_vertexCache = null;
    protected EdgeCache m_edgeCache = null;
    protected List<OracleElementBase> m_vecElements = new ArrayList<OracleElementBase>();
    boolean m_bSkipRefreshIndices = false;
    protected CacheStatus m_cs = CacheStatus.NOT_SET;
    private AbstractPgGraphConfig config;
    ProgressListener m_pl = null;
    private static final Map<Class<?>, Integer> numericTypeOrder = new HashMap();
    protected OracleIndexParameters m_indexParams;
    private VertexFilterCallback m_vfc = null;
    private EdgeFilterCallback m_efc = null;
    private OptimizationFlag m_vof = null;
    private OptimizationFlag m_eof = null;
    private final SimpleDateFormat m_sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private static final DateTimeFormatter m_dtf;
    private int m_iBatchSize = 30;
    private int m_iVecQueueSize = 100;
    protected long m_lTimeSpentInRefreshIndices = 0L;
    protected long m_lCountRefreshIndicesCall = 0L;
    private boolean m_bSolrJavaBinFormat;
    protected boolean m_bTransientGraph = false;
    private long maxValueLengthAllowed = 15000L;
    private long maxLabelLengthAllowed = 3100L;
    private long maxPropertyNameLengthAllowed = 15000L;
    private boolean ms_bShowProgress = ParametersBase.getInstance().showProgress();

    protected void maintainQueue(OracleElementBase oe, OraclePropertyGraphConstants.QueueAction qa) {
        if (qa == OraclePropertyGraphConstants.QueueAction.ADD) {
            oe.setFlag(OracleElement.FLAG.TO_BE_ADDED);
        } else if (qa == OraclePropertyGraphConstants.QueueAction.ADD_UPDATE_INDICES) {
            oe.setFlag(OracleElement.FLAG.TO_BE_ADDED_UPDATE_INDICES);
        } else {
            oe.setFlag(OracleElement.FLAG.TO_BE_REMOVED);
        }
        for (int idx = 0; idx < this.m_vecElements.size(); ++idx) {
            if ((!(oe instanceof OracleVertexBase) || !(this.m_vecElements.get(idx) instanceof OracleVertexBase) || !oe.id().equals(this.m_vecElements.get(idx).id())) && (!(oe instanceof OracleEdgeBase) || !(this.m_vecElements.get(idx) instanceof OracleEdgeBase) || !oe.id().equals(this.m_vecElements.get(idx).id()))) continue;
            ms_log.debug("maintainQueue: in the queue already. take it out for an re-entry");
            this.m_vecElements.remove(idx);
            break;
        }
        this.m_vecElements.add(oe);
        if (this.m_vecElements.size() > this.getQueueSize()) {
            this.flushUpdates();
        }
    }

    public void clearUpdateQueue() {
        this.m_vecElements.clear();
    }

    public final void setSkipRefreshIndices(boolean skip) {
        this.m_bSkipRefreshIndices = skip;
    }

    public final boolean isSkipRefreshIndicesEnabled() {
        return this.m_bSkipRefreshIndices;
    }

    public synchronized void flushUpdates() {
        ms_log.debug("flushUpdates: start");
        if (this.m_vecElements.size() == 0) {
            ms_log.debug("flushUpdates: no op");
            return;
        }
        long lStartTime = 0L;
        long duration = 0L;
        if (!this.isSkipRefreshIndicesEnabled()) {
            if (this.ms_bShowProgress) {
                lStartTime = System.currentTimeMillis();
            }
            ms_log.debug("commit: refresh indices caches");
            this.getOracleIndexManager().refreshIndicesCache();
            if (this.ms_bShowProgress) {
                duration = System.currentTimeMillis() - lStartTime;
                ++this.m_lCountRefreshIndicesCall;
                this.m_lTimeSpentInRefreshIndices += duration;
            }
        }
        try {
            for (int idx = 0; idx < this.m_vecElements.size(); ++idx) {
                OracleElementBase oe = this.m_vecElements.get(idx);
                if (oe instanceof OracleVertexBase) {
                    if (oe.getFlag() == OracleElement.FLAG.TO_BE_ADDED) {
                        ms_log.debug("flushUpdates: physically add vertex");
                        this.addVertexInternal((OracleVertexBase)oe, false);
                        continue;
                    }
                    if (oe.getFlag() == OracleElement.FLAG.TO_BE_ADDED_UPDATE_INDICES) {
                        ms_log.debug("flushUpdates: physically add vertex and update indices");
                        this.addVertexInternal((OracleVertexBase)oe, true);
                        continue;
                    }
                    ms_log.debug("flushUpdates: physically remove vertex");
                    this.removeVertexInternal((OracleVertexBase)oe);
                    continue;
                }
                if (oe.getFlag() == OracleElement.FLAG.TO_BE_ADDED) {
                    ms_log.debug("flushUpdates: physically add edge");
                    this.addEdgeInternal((OracleEdgeBase)oe, false);
                    continue;
                }
                if (oe.getFlag() == OracleElement.FLAG.TO_BE_ADDED_UPDATE_INDICES) {
                    ms_log.debug("flushUpdates: physically add edge and update indices");
                    this.addEdgeInternal((OracleEdgeBase)oe, true);
                    continue;
                }
                ms_log.debug("flushUpdates: physically remove edge");
                this.removeEdgeInternal((OracleEdgeBase)oe);
            }
            this.m_vecElements.clear();
        }
        catch (Exception e) {
            ms_log.error("flushUpdates: ioe ", e);
            throw new OraclePropertyGraphException(e);
        }
        ms_log.debug("flushUpdates: done");
    }

    protected abstract void removeVertexInternal(OracleVertexBase var1) throws Exception;

    protected abstract void removeEdgeInternal(OracleEdgeBase var1) throws Exception;

    protected abstract void addVertexInternal(OracleVertexBase var1, boolean var2) throws Exception;

    protected abstract void addEdgeInternal(OracleEdgeBase var1, boolean var2) throws Exception;

    public long getOperationQueueSize() {
        if (this.m_vecElements != null) {
            return this.m_vecElements.size();
        }
        return 0L;
    }

    public VertexCache getVertexCache() {
        return this.m_vertexCache;
    }

    public EdgeCache getEdgeCache() {
        return this.m_edgeCache;
    }

    public final void clearCache() {
        ms_log.debug("clearCache: start");
        if (this.m_edgeCache != null) {
            this.m_edgeCache.clearCache();
        }
        if (this.m_vertexCache != null) {
            this.m_vertexCache.clearCache();
        }
        ms_log.debug("clearCache: done");
    }

    public CacheStatus getCacheStatus() {
        return this.m_cs;
    }

    public void setCacheStatus(CacheStatus cs) {
        this.m_cs = cs;
    }

    public boolean isBuiltinElementsCacheDisabled() {
        if (this.getCacheStatus() == CacheStatus.DISABLED) {
            return true;
        }
        if (this.getCacheStatus() == CacheStatus.ENABLED) {
            return false;
        }
        return ParametersBase.getInstance().isGraphElementsCacheDisabled();
    }

    public static final OptimizationFlag getJustVertexIdOptFlag() {
        return OptimizationFlag.JUST_VERTEX_ID;
    }

    public static final OptimizationFlag getJustEdgeIdOptFlag() {
        return OptimizationFlag.JUST_EDGE_ID;
    }

    protected OraclePropertyGraphBase() {
    }

    protected OraclePropertyGraphBase(AbstractPgGraphConfig config) {
        this.config = config;
    }

    public AbstractPgGraphConfig getConfig() {
        return this.config;
    }

    protected final void setConfig(AbstractPgGraphConfig config) {
        this.config = config;
    }

    public final String getGraphName() {
        return this.m_szGraphName;
    }

    public String getTextIndexDirectoryPrefix() {
        return "OSG_PG_";
    }

    public static final String getStringForObj(Object objVa1) {
        if (objVa1 == null) {
            return "[null]";
        }
        if (objVa1 instanceof String) {
            return "str:" + (String)objVa1;
        }
        if (objVa1 instanceof Float) {
            return "flo:" + ((Float)objVa1).toString();
        }
        if (objVa1 instanceof Integer) {
            return "int:" + ((Integer)objVa1).toString();
        }
        if (objVa1 instanceof Double) {
            return "dbl:" + ((Double)objVa1).toString();
        }
        if (objVa1 instanceof Date) {
            return "dat:" + ((Date)objVa1).toString();
        }
        if (objVa1 instanceof Instant) {
            return "dat:" + ((Instant)objVa1).atOffset(ZoneOffset.UTC).format(OraclePropertyGraphBase.getDateTimeFormatter());
        }
        if (objVa1 instanceof LocalDate) {
            return "dat:" + ((LocalDate)objVa1).format(OraclePropertyGraphBase.getDateTimeFormatter());
        }
        if (objVa1 instanceof LocalTime) {
            return "dat:" + ((LocalTime)objVa1).format(OraclePropertyGraphBase.getDateTimeFormatter());
        }
        if (objVa1 instanceof LocalDateTime) {
            return "dat:" + ((LocalDateTime)objVa1).format(OraclePropertyGraphBase.getDateTimeFormatter());
        }
        if (objVa1 instanceof OffsetTime) {
            return "dat:" + ((OffsetTime)objVa1).format(OraclePropertyGraphBase.getDateTimeFormatter());
        }
        if (objVa1 instanceof OffsetDateTime) {
            return "dat:" + ((OffsetDateTime)objVa1).format(OraclePropertyGraphBase.getDateTimeFormatter());
        }
        if (objVa1 instanceof Long) {
            return "lng:" + ((Long)objVa1).toString();
        }
        if (objVa1 instanceof Short) {
            return "shr:" + ((Short)objVa1).toString();
        }
        if (objVa1 instanceof Byte) {
            return "byt:" + ((Byte)objVa1).toString();
        }
        if (objVa1 instanceof Character) {
            return "cha:" + ((Character)objVa1).toString();
        }
        if (objVa1 instanceof Boolean) {
            return "bol:" + ((Boolean)objVa1).toString();
        }
        if (objVa1 instanceof Serializable) {
            try {
                return "ser:" + OraclePropertyGraphBase.serializableToStr((Serializable)objVa1);
            }
            catch (IOException ioe) {
                throw new OraclePropertyGraphException(ioe);
            }
        }
        return objVa1.getClass().getName() + ":stringVal=" + objVa1.toString();
    }

    public abstract void clearRepository() throws Exception;

    public abstract OracleVertexBase getVertexInstance(Long var1, boolean var2, boolean var3);

    public abstract OracleEdgeBase getEdgeInstance(Long var1, boolean var2, boolean var3);

    public static final String serializableToStr(Serializable seri) throws IOException {
        return HelperUtilities.serializableToStr(seri);
    }

    public static final Object strToSerializable(String s) throws IOException {
        return HelperUtilities.strToSerializable(s);
    }

    @Override
    public abstract OracleIndexManager getOracleIndexManager();

    public Iterator<OracleEdgeBase> edges() {
        return this.edgesByPropertyKey(null, this.getEdgeFilterCallback());
    }

    public final Iterator<OracleEdgeBase> edgesByPropertyKey(String key) {
        return this.edgesByPropertyKey(new String[]{key}, this.getEdgeFilterCallback());
    }

    public final Iterator<OracleEdgeBase> edgesByPropertyKey(String[] keys) {
        return this.edgesByPropertyKey(keys, this.getEdgeFilterCallback());
    }

    public final Iterator<OracleEdgeBase> edgesByPropertyKey(String[] keys, EdgeFilterCallback efc) {
        return this.edgesByPropertyKey(keys, efc, this.getDefaultEdgeOptFlag());
    }

    public abstract Iterator<OracleEdgeBase> edgesByPropertyKey(String[] var1, EdgeFilterCallback var2, OptimizationFlag var3);

    public Iterator<OracleEdgeBase> edgesByIds(Object[] ids) {
        return this.edgesByIds(ids, ms_defaultDOP);
    }

    public Iterator<OracleEdgeBase> edgesByIds(Object[] ids, int dop) {
        return this.elements(ids, dop, OracleEdgeBase.class);
    }

    public Iterator<OracleVertexBase> vertices() {
        return this.verticesByPropertyKey(null, this.getVertexFilterCallback());
    }

    public final Iterator<OracleVertexBase> verticesByPropertyKey(String keys) {
        return this.verticesByPropertyKey(new String[]{keys}, this.getVertexFilterCallback());
    }

    public final Iterator<OracleVertexBase> verticesByPropertyKey(String[] keys) {
        return this.verticesByPropertyKey(keys, this.getVertexFilterCallback());
    }

    public final Iterator<OracleVertexBase> verticesByPropertyKey(String[] keys, VertexFilterCallback vfc) {
        return this.verticesByPropertyKey(keys, vfc, this.getDefaultVertexOptFlag());
    }

    public abstract Iterator<OracleVertexBase> verticesByPropertyKey(String[] var1, VertexFilterCallback var2, OptimizationFlag var3);

    public Iterator<OracleVertexBase> verticesByIds(Object[] ids) {
        return this.verticesByIds(ids, ms_defaultDOP);
    }

    public Iterator<OracleVertexBase> verticesByIds(Object[] ids, int dop) {
        return this.elements(ids, dop, OracleVertexBase.class);
    }

    @Override
    public final Iterator<Map.Entry<Object, Object>> getElementsProperties(Object[] ids, String propertyName, int dop, Class<? extends OracleElementBase> elementClass) {
        int idx;
        LinkedList<Map.Entry<Object, Object>> elements = new LinkedList<Map.Entry<Object, Object>>();
        if (ids == null) {
            return null;
        }
        if (dop <= 0) {
            dop = ms_defaultDOP;
        }
        Thread[] threads = new Thread[dop];
        OracleGetElementsPropertiesWorker[] opgIdWorkers = new OracleGetElementsPropertiesWorker[dop];
        for (idx = 0; idx < dop; ++idx) {
            opgIdWorkers[idx] = new OracleGetElementsPropertiesWorker(ids, propertyName, elementClass, this, idx, dop);
            threads[idx] = new Thread(opgIdWorkers[idx]);
            threads[idx].start();
        }
        for (idx = 0; idx < dop; ++idx) {
            try {
                threads[idx].join();
                continue;
            }
            catch (InterruptedException ex) {
                Message msg = new Message("ERR_HIT_INTERRUPT", "getElementsProperties(final long[] ids, String propertyName, int dop, Class<? extends OracleElementBase> elementClass)");
                throw new OraclePropertyGraphException(msg.toString(), ex);
            }
        }
        for (idx = 0; idx < dop; ++idx) {
            elements.addAll(opgIdWorkers[idx].getElements());
        }
        return elements.iterator();
    }

    protected final Iterator<? extends OracleElementBase> elements(Object[] ids, int dop, Class<? extends OracleElementBase> elementClass) {
        int idx;
        LinkedList<OracleElementBase> elements = new LinkedList<OracleElementBase>();
        if (ids == null) {
            return null;
        }
        if (dop <= 0) {
            dop = ms_defaultDOP;
        }
        Thread[] threads = null;
        threads = new Thread[dop];
        OracleGetElementsByIdsWorker[] opgIdWorkers = new OracleGetElementsByIdsWorker[dop];
        for (idx = 0; idx < dop; ++idx) {
            opgIdWorkers[idx] = new OracleGetElementsByIdsWorker(ids, elementClass, this, idx, dop);
            threads[idx] = new Thread(opgIdWorkers[idx]);
            threads[idx].start();
        }
        for (idx = 0; idx < dop; ++idx) {
            try {
                threads[idx].join();
                continue;
            }
            catch (InterruptedException ex) {
                Message msg = new Message("ERR_HIT_INTERRUPT", "elements(final long[] ids, int dop, Class<? extends OracleElementBase> elementClass)");
                throw new OraclePropertyGraphException(msg.toString(), ex);
            }
        }
        for (idx = 0; idx < dop; ++idx) {
            for (OracleElementBase v : opgIdWorkers[idx].getElements()) {
                if (v == null) continue;
                if (OracleVertexBase.class.equals(elementClass)) {
                    elements.add((OracleVertexBase)v);
                    continue;
                }
                elements.add((OracleEdgeBase)v);
            }
        }
        return elements.iterator();
    }

    public Iterator<OracleEdgeBase> adjacentEdgesFromVertices(Object[] ids, String[] labels, Direction direction) {
        return this.adjacentEdgesFromVertices(ids, direction, labels, ParametersBase.getInstance().getDOP());
    }

    public final Iterator<OracleEdgeBase> adjacentEdgesFromVertices(Object[] ids, Direction direction, String[] labels, int dop) {
        int idx;
        LinkedList<OracleEdgeBase> elements = new LinkedList<OracleEdgeBase>();
        if (ids == null) {
            return null;
        }
        if (dop <= 0) {
            dop = ms_defaultDOP;
        }
        Thread[] threads = new Thread[dop];
        OracleGetAdjacentEdgesWorker[] opgIdWorkers = new OracleGetAdjacentEdgesWorker[dop];
        for (idx = 0; idx < dop; ++idx) {
            opgIdWorkers[idx] = new OracleGetAdjacentEdgesWorker(ids, this, idx, direction, labels, dop);
            threads[idx] = new Thread(opgIdWorkers[idx]);
            threads[idx].start();
        }
        for (idx = 0; idx < dop; ++idx) {
            try {
                threads[idx].join();
                continue;
            }
            catch (InterruptedException ex) {
                Message msg = new Message("ERR_HIT_INTERRUPT", "getElements(final long[] ids, int dop, Class<? extends OracleElementBase> elementClass)");
                throw new OraclePropertyGraphException(msg.toString(), ex);
            }
        }
        for (idx = 0; idx < dop; ++idx) {
            for (OracleEdgeBase e : opgIdWorkers[idx].getElements()) {
                elements.add(e);
            }
        }
        return elements.iterator();
    }

    public abstract OracleEdgeBase getEdgeInstance(OracleVertexBase var1, OracleVertexBase var2, String var3, Long var4, boolean var5, boolean var6);

    public List<OracleVertexBase> getShortestPath(PgxGraph g, OracleVertexBase start, OracleVertexBase end, String weightPropertyName, List<Double> weights) throws InterruptedException, ExecutionException {
        return this.getShortestPath(g, (Long)start.id(), (Long)end.id(), weightPropertyName, weights);
    }

    public double sum(List<Double> val) {
        if (val == null) {
            Message msg = new Message("ERR_INPUT_LIST_NOT_NULL", "val");
            throw new IllegalArgumentException(msg.toString());
        }
        double dSum = 0.0;
        for (int idx = 0; idx < val.size(); ++idx) {
            dSum += val.get(idx).doubleValue();
        }
        return dSum;
    }

    protected <T extends OracleElementBase> Long getIDFromInternalLabel(Object id, Class<T> class1) {
        String idInternal = null;
        idInternal = OracleVertexBase.class.isAssignableFrom(class1) ? OraclePropertyGraphBase.getVertexInternalLabel(id) : OraclePropertyGraphBase.getEdgeInternalLabel(id);
        if (ms_bDebug) {
            ms_log.debug("addVertex: getVertexInternalLabel " + idInternal);
        }
        return HelperUtilities.hash64(idInternal, 0, idInternal.length(), 0L);
    }

    public List<OracleVertexBase> getShortestPath(PgxGraph g, Long startVertexID, Long endVertexID, String weightPropertyName, List<Double> weights) throws InterruptedException, ExecutionException {
        Analyst analyst = g.getSession().createAnalyst();
        PgxPath path = analyst.shortestPathDijkstra(g, g.getVertex((Object)startVertexID), g.getVertex((Object)endVertexID), g.getEdgeProperty(weightPropertyName));
        if (!path.exists()) {
            return null;
        }
        ArrayList<OracleVertexBase> al = new ArrayList<OracleVertexBase>();
        int idx = 0;
        for (PgxVertex pv : path.getVertices()) {
            OracleVertexBase v = this.getVertex(pv.getId());
            al.add(v);
            if (weights != null && idx > 0) {
                OracleVertexBase vPre = al.get(idx - 1);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("getShortestPath: check from one vertex to another");
                }
                Iterator<OracleEdgeBase> iterator = vPre.edges(Direction.OUT, new String[0]);
                double dMin = Double.POSITIVE_INFINITY;
                while (iterator.hasNext()) {
                    OracleEdgeBase e = iterator.next();
                    OracleVertexBase vDst = e.inVertex();
                    if (!vDst.id().equals(v.id())) continue;
                    double d = Double.POSITIVE_INFINITY;
                    Object val = e.property(weightPropertyName).value();
                    if (val == null) continue;
                    if (val instanceof Integer) {
                        d = ((Integer)val).intValue();
                    } else if (val instanceof Float) {
                        d = ((Float)val).floatValue();
                    } else if (val instanceof Double) {
                        d = (Double)val;
                    } else {
                        ms_log.debug("getShortestPath: find an edge with a non-numeric type property value");
                        continue;
                    }
                    if (!(d < dMin)) continue;
                    dMin = d;
                }
                weights.add(dMin);
            }
            ++idx;
        }
        return al;
    }

    @Override
    public final ProgressListener getProgressListener() {
        return this.m_pl;
    }

    @Override
    public final void setProgressListener(ProgressListener pl) {
        this.m_pl = pl;
    }

    @Override
    public final <T extends OracleElementBase> OracleIndex<T> createIndex(String indexName, Class<T> indexClass, Parameter ... indexParameters) {
        if (this.getOracleIndexManager().indexAlreadyExists(indexName, indexClass)) {
            if (ms_bDebug) {
                ms_log.debug((Object)("createIndex: the index with name " + indexName), "already exists");
            }
            throw new IllegalArgumentException("Index already exists: " + indexName);
        }
        ms_log.debug("createIndex: create index from index manager");
        return this.getOracleIndexManager().createIndex(indexName, indexClass, this, indexParameters);
    }

    @Override
    public OracleIndexParameters getDefaultIndexParameters() {
        if (this.m_indexParams == null) {
            ms_log.debug("getDefaultIndexParameters: initialize index parameters");
            this.m_indexParams = new OracleIndexParameters();
        }
        return this.m_indexParams;
    }

    protected static final Class<?> getClassFromType(int type) {
        switch (type) {
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Float.class;
            }
            case 4: {
                return Double.class;
            }
            case 5: {
                return Date.class;
            }
            case 6: {
                return Boolean.class;
            }
            case 7: {
                return Long.class;
            }
            case 8: {
                return Short.class;
            }
            case 9: {
                return Byte.class;
            }
            case 10: {
                return Character.class;
            }
            case 20: {
                return SimpleSpatialDataWrapper.class;
            }
            case 25: {
                return SimpleJsonDataWrapper.class;
            }
            case 30: {
                return SimpleRdfDataWrapper.class;
            }
            case 101: {
                return Serializable.class;
            }
        }
        return null;
    }

    protected static Class<?> getCombinedType(Class<?> type1, Class<?> type2) {
        Class<Object> type = null;
        type = type1.equals(type2) ? type1 : (numericTypeOrder.containsKey(type1) && numericTypeOrder.containsKey(type2) ? (numericTypeOrder.get(type1) > numericTypeOrder.get(type2) ? type1 : type2) : String.class);
        return type;
    }

    @Override
    public final void setDefaultIndexParameters(OracleIndexParameters indexParams) {
        ms_log.debug("setDefaultIndexParameters: set index parameters");
        this.m_indexParams = indexParams;
    }

    public final VertexFilterCallback getVertexFilterCallback() {
        return this.m_vfc;
    }

    public final EdgeFilterCallback getEdgeFilterCallback() {
        return this.m_efc;
    }

    public final void setVertexFilterCallback(VertexFilterCallback vfc) {
        this.m_vfc = vfc;
    }

    public final void setEdgeFilterCallback(EdgeFilterCallback efc) {
        this.m_efc = efc;
    }

    public final OptimizationFlag getDefaultVertexOptFlag() {
        return this.m_vof;
    }

    public final OptimizationFlag getDefaultEdgeOptFlag() {
        return this.m_eof;
    }

    public final void setDefaultVertexOptFlag(OptimizationFlag vof) {
        if (OptimizationFlag.JUST_EDGE_ID.equals((Object)vof) || OptimizationFlag.JUST_LABEL_EDGE_ID.equals((Object)vof) || OptimizationFlag.JUST_LABEL_VERTEX_EDGE_ID.equals((Object)vof) || OptimizationFlag.JUST_VERTEX_EDGE_ID.equals((Object)vof)) {
            Message msg = new Message("ERR_OPT_FLAG_VERT_INVALID", (Object)vof);
            throw new OraclePropertyGraphException(msg.toString());
        }
        this.m_vof = vof;
    }

    public final void setDefaultEdgeOptFlag(OptimizationFlag eof) {
        if (OptimizationFlag.JUST_VERTEX_ID.equals((Object)eof)) {
            Message msg = new Message("ERR_OPT_FLAG_EDGE_INVALID", (Object)eof);
            throw new OraclePropertyGraphException(msg.toString());
        }
        this.m_eof = eof;
    }

    @Override
    public final boolean isEmpty() throws IOException {
        return this.countVertices() > 0L || this.countEdges() > 0L;
    }

    public final Object decodeObject(int iType, String szVal) throws NumberFormatException, DateTimeParseException, IOException, ParseException {
        return this.decodeObject(iType, szVal, this.m_sdf);
    }

    public final Object decodeObject(int iType, String szVal, SimpleDateFormat sdf) throws NumberFormatException, DateTimeParseException, IOException, ParseException {
        if (iType == 2) {
            return Integer.parseInt(szVal);
        }
        if (iType == 1) {
            return szVal;
        }
        if (iType == 3) {
            return Float.valueOf(Float.parseFloat(szVal));
        }
        if (iType == 4) {
            return Double.parseDouble(szVal);
        }
        if (iType == 7) {
            return Long.parseLong(szVal);
        }
        if (iType == 8) {
            return Short.parseShort(szVal);
        }
        if (iType == 10) {
            return Character.valueOf(szVal.charAt(0));
        }
        if (iType == 9) {
            return Byte.parseByte(szVal);
        }
        if (iType == 6) {
            return "Y".equals(szVal) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (iType == 5) {
            return sdf.parse(szVal);
        }
        if (iType == 20) {
            return SimpleSpatialDataWrapper.getInstance(szVal);
        }
        if (iType == 25) {
            return SimpleJsonDataWrapper.getInstance(szVal);
        }
        if (iType == 30) {
            return SimpleRdfDataWrapper.getInstance(szVal);
        }
        if (iType == 101) {
            return OraclePropertyGraphBase.strToSerializable(szVal);
        }
        throw new InvalidPropertyTypeException(iType, InvalidPropertyTypeException.CauseType.INVALID_PROPERTY_TYPE);
    }

    public static final Class getDatatypeFromDatatypeCode(int iType) throws InvalidPropertyTypeException {
        if (iType == 2) {
            return Integer.class;
        }
        if (iType == 1) {
            return String.class;
        }
        if (iType == 3) {
            return Float.class;
        }
        if (iType == 4) {
            return Double.class;
        }
        if (iType == 7) {
            return Long.class;
        }
        if (iType == 8) {
            return Short.class;
        }
        if (iType == 10) {
            return Character.class;
        }
        if (iType == 9) {
            return Byte.class;
        }
        if (iType == 6) {
            return Boolean.class;
        }
        if (iType == 5) {
            return Date.class;
        }
        if (iType == 20) {
            return SimpleSpatialDataWrapper.class;
        }
        if (iType == 25) {
            return SimpleJsonDataWrapper.class;
        }
        if (iType == 30) {
            return SimpleRdfDataWrapper.class;
        }
        if (iType == 101) {
            return Serializable.class;
        }
        throw new InvalidPropertyTypeException(iType, InvalidPropertyTypeException.CauseType.INVALID_PROPERTY_TYPE);
    }

    public final SimpleDateFormat getSimpleDateFormat() {
        return this.m_sdf;
    }

    public static final DateTimeFormatter getDateTimeFormatter() {
        return m_dtf;
    }

    public final Iterator<OracleVertexBase> verticesByProperty(String key, Object value) {
        return this.verticesByProperty(key, value, ParametersBase.getInstance().getUseWildcards());
    }

    public final Iterator<OracleVertexBase> verticesByProperty(String key, Object value, boolean useWildCards) {
        return this.verticesByProperty(key, value, useWildCards, this.isVertexAutoIndexEnabled(key));
    }

    public final Iterator<OracleVertexBase> verticesByProperty(String key, Object value, Class<?> dtClass, boolean acceptWildcard) {
        return this.verticesByProperty(key, value, dtClass, acceptWildcard, this.isVertexAutoIndexEnabled(key));
    }

    public Class getDatatypeClassFromValueObjForTextIndex(Object value) {
        return OracleIndexUtils.getDatatypeClass(value);
    }

    public final Iterator<OracleVertexBase> verticesByProperty(String key, Object value, boolean acceptWildcard, boolean useLuceneSyntax) {
        if (value != null) {
            Class dtClass = this.getDatatypeClassFromValueObjForTextIndex(value);
            if (ms_bDebug) {
                ms_log.debug((Object)"vertices: dtClass<?>", dtClass);
            }
            if (dtClass != null && String.class.isAssignableFrom(dtClass) && acceptWildcard) {
                ms_log.debug("vertices: using a string value with no data type specified and wildcards, try all data types");
                dtClass = null;
            }
            return this.verticesByProperty(key, value, dtClass, acceptWildcard, useLuceneSyntax);
        }
        return this.verticesByProperty(key, null, null, acceptWildcard, useLuceneSyntax);
    }

    public abstract Iterator<OracleVertexBase> verticesByProperty(String var1, Object var2, Class<?> var3, boolean var4, boolean var5);

    public final Iterator<OracleVertexBase> vertices(Object ... ids) {
        return this.elementsIterator(OracleVertexBase.class, ids);
    }

    protected <T extends OracleElementBase> Iterator<T> elementsIterator(Class<T> elementClass, Object ... ids) {
        if (ids == null || ids.length <= 0) {
            if (OracleVertexBase.class.isAssignableFrom(elementClass)) {
                return this.vertices();
            }
            return this.edges();
        }
        if (ids != null && ids.length > 0) {
            OracleElementHelper.validateMixedElementIds(elementClass, ids);
            Object[] validatedIds = null;
            Object id = ids[0];
            if (id instanceof Number || id instanceof String) {
                ms_log.debug("vertices: input objects are either String or Long object");
                validatedIds = ids;
            } else {
                ms_log.debug("edges: input objects are OracleElementBase objects");
                validatedIds = new Object[ids.length];
                for (int idx = 0; idx < ids.length; ++idx) {
                    validatedIds[idx] = ((OracleElementBase)ids[idx]).id();
                }
            }
            return this.elements(validatedIds, ms_defaultDOP, elementClass);
        }
        return Collections.emptyIterator();
    }

    public final Iterator<OracleEdgeBase> edges(Object ... ids) {
        return this.elementsIterator(OracleEdgeBase.class, ids);
    }

    public final Iterator<OracleEdgeBase> edgesByProperty(String key, Object value) {
        return this.edgesByProperty(key, value, ParametersBase.getInstance().getUseWildcards());
    }

    public final Iterator<OracleEdgeBase> edgesByProperty(String key, Object value, boolean useWildCard) {
        return this.edgesByProperty(key, value, useWildCard, this.isEdgeAutoIndexEnabled(key));
    }

    public final Iterator<OracleEdgeBase> edgesByProperty(String key, Object value, Class<?> dtClass, boolean acceptWildcard) {
        return this.edgesByProperty(key, value, dtClass, acceptWildcard, this.isEdgeAutoIndexEnabled(key));
    }

    public final Iterator<OracleEdgeBase> edgesByProperty(String key, Object value, boolean acceptWildcard, boolean useLuceneSyntax) {
        if (value != null) {
            Class dtClass = this.getDatatypeClassFromValueObjForTextIndex(value);
            if (ms_bDebug) {
                ms_log.debug((Object)"edges: dtClass<?>", dtClass);
                ms_log.debug((Object)"edges: val ", value);
                ms_log.debug((Object)"edges: val class ", value.getClass());
            }
            if (dtClass != null && String.class.isAssignableFrom(dtClass) && acceptWildcard) {
                ms_log.debug("edges: using a string value with no data type specified and wildcards, try all data types");
                dtClass = null;
            }
            return this.edgesByProperty(key, value, dtClass, acceptWildcard, useLuceneSyntax);
        }
        return this.edgesByProperty(key, null, null, acceptWildcard, useLuceneSyntax);
    }

    public abstract Iterator<OracleEdgeBase> edgesByProperty(String var1, Object var2, Class<?> var3, boolean var4, boolean var5);

    public int getBatchSize() {
        return this.m_iBatchSize;
    }

    public void setBatchSize(int batchsize) {
        if (batchsize > 0) {
            this.m_iBatchSize = batchsize;
        } else {
            ms_log.error("setBatchSize: batch size can not be smaller than 0");
        }
    }

    public abstract OracleEdgeBase addEdge(Object var1, OracleVertexBase var2, OracleVertexBase var3, String var4);

    public abstract OracleVertexBase addVertexById(Object var1);

    protected static final String getEdgeInternalLabel(Object id) {
        StringBuilder sb = new StringBuilder();
        if (id == null) {
            sb.append("E").append(UUID.randomUUID());
        } else {
            sb.append("T").append(id.toString());
        }
        return sb.toString();
    }

    protected static final String getVertexInternalLabel(Object id) {
        StringBuilder sb = new StringBuilder();
        if (id == null) {
            sb.append("V").append(UUID.randomUUID());
        } else {
            sb.append("S").append(id.toString());
        }
        ms_log.debug("getVertexInternal: produced string id " + id);
        return sb.toString();
    }

    public abstract OracleEdgeBase getEdge(Object var1);

    protected static final Long getObjectIdIfLongType(Object id) throws NumberFormatException {
        if (id == null) {
            throw ms_nfe;
        }
        if (id instanceof Long) {
            return (Long)id;
        }
        return Long.valueOf(id.toString());
    }

    public abstract OracleVertexBase getVertex(Object var1);

    public abstract void removeEdge(OracleEdgeBase var1);

    public final void startTransaction() {
        ms_log.debug("startTransaction: start");
    }

    public void rollback() {
        ms_log.debug("rollback: start. no op ");
    }

    public final void commitIndices() {
        ms_log.debug("commitIndices: commit indices");
        this.getOracleIndexManager().commitIndices();
    }

    public final void setQueueSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("setQueueSize: size cannot be zero or negative");
        }
        this.m_iVecQueueSize = size;
    }

    public final int getQueueSize() {
        return this.m_iVecQueueSize;
    }

    public long getTimeSpentOnRefreshIndices() {
        return this.m_lTimeSpentInRefreshIndices;
    }

    public long getNumRefreshIndicesCall() {
        return this.m_lCountRefreshIndicesCall;
    }

    public void resetTimeSpentOnRefreshIndices() {
        this.m_lTimeSpentInRefreshIndices = 0L;
    }

    public final void resetNumRefreshIndicesCall() {
        this.m_lCountRefreshIndicesCall = 0L;
    }

    public final boolean useSolrJavaBinFormat() {
        return this.m_bSolrJavaBinFormat;
    }

    public final void setSolrJavaBinFormat(boolean bSolrJavaBinFormat) {
        this.m_bSolrJavaBinFormat = bSolrJavaBinFormat;
    }

    public final boolean isTransientPropertyGraphInstance() {
        return this.m_bTransientGraph;
    }

    public final void setTransientPropertyGraphInstance(boolean flag) {
        this.m_bTransientGraph = flag;
    }

    public final boolean isShutdown() {
        return this.m_bShutdownCalled;
    }

    public final boolean isDisposed() {
        return this.m_bDisposed;
    }

    public final OracleVertexBase addVertex(Object id) {
        if (id != null) {
            return this.addVertex("id", id);
        }
        return this.addVertex((Object[])null);
    }

    public final OracleVertexBase addVertex(Object ... keyValues) {
        if (keyValues == null) {
            return this.addVertexById(null);
        }
        OracleElementHelper.legalPropertyKeyValueArray(keyValues);
        Object idValue = OracleElementHelper.getIdValue(keyValues).orElse(null);
        if (ms_bDebug) {
            ms_log.debug((Object)"addVertex(Object...): started with id, ", (Object)idValue);
        }
        String label = OracleElementHelper.getLabelValue(keyValues).orElse("vertex");
        if (ms_bDebug) {
            ms_log.debug("addVertex(Object...): using label, " + label);
        }
        OracleVertexBase vertex = this.addVertexById(idValue);
        vertex.setLabel(label);
        OracleElementHelper.attachProperties(vertex, keyValues);
        return vertex;
    }

    public abstract void commit();

    protected final void addUpdatedElement(OracleElementBase e) {
        if (e instanceof OracleEdgeBase) {
            this.addUpdatedEdge((OracleEdgeBase)e);
        } else {
            this.addUpdatedVertex((OracleVertexBase)e);
        }
    }

    public final void addUpdatedEdge(OracleEdgeBase e) {
        if (ms_bDebug) {
            ms_log.debug((Object)"addUpdatedEdge: adding e ", e);
        }
        this.maintainQueue(e, OraclePropertyGraphConstants.QueueAction.ADD);
    }

    public final void addUpdatedVertex(OracleVertexBase v) {
        if (ms_bDebug) {
            ms_log.debug((Object)"addUpdatedVertex: adding v ", v.id());
        }
        this.maintainQueue(v, OraclePropertyGraphConstants.QueueAction.ADD);
    }

    protected final void addUpdatedElementWithIndices(OracleElementBase e) {
        if (e instanceof OracleEdgeBase) {
            this.addUpdatedEdgeWithIndices((OracleEdgeBase)e);
        } else {
            this.addUpdatedVertexWithIndices((OracleVertexBase)e);
        }
    }

    protected final void addUpdatedEdgeWithIndices(OracleEdgeBase e) {
        if (ms_bDebug) {
            ms_log.debug((Object)"addUpdatedEdgeWithIndices: adding e ", e);
        }
        this.maintainQueue(e, OraclePropertyGraphConstants.QueueAction.ADD_UPDATE_INDICES);
    }

    final void addUpdatedVertexWithIndices(OracleVertexBase v) {
        if (ms_bDebug) {
            ms_log.debug((Object)"addUpdatedVertexWithIndices: adding v ", v.id());
        }
        this.maintainQueue(v, OraclePropertyGraphConstants.QueueAction.ADD_UPDATE_INDICES);
    }

    public abstract void removeVertex(OracleVertexBase var1);

    public OracleVertexBase readVertexFromDB(Long lVID) throws IOException, ParseException {
        return this.readVertexFromDB(lVID, null, true);
    }

    protected abstract OracleVertexBase readVertexFromDB(Long var1, OracleVertexBase var2, boolean var3) throws IOException, ParseException;

    public OracleEdgeBase readEdgeFromDB(Long lEID) throws IOException, ParseException {
        return this.readEdgeFromDB(lEID, null, true);
    }

    protected abstract OracleEdgeBase readEdgeFromDB(Long var1, OracleEdgeBase var2, boolean var3) throws IOException, ParseException;

    public final String toString() {
        ms_log.debug("toString: starts");
        return this.getClass().getSimpleName().toLowerCase() + " with name " + this.getGraphName();
    }

    public boolean supportVertexLabels() {
        return true;
    }

    public long getMaxValueLengthAllowedInBytes() {
        return this.maxValueLengthAllowed;
    }

    public long getMaxLabelLengthAllowedInBytes() {
        return this.maxLabelLengthAllowed;
    }

    public long getMaxPropertyNameLengthAllowedInBytes() {
        return this.maxPropertyNameLengthAllowed;
    }

    public void removeEdges(Long[] ids) {
        this.removeEdges(ids, ParametersBase.getInstance().getDOP());
    }

    public void removeEdges(Long[] ids, int dop) {
        if (ids == null) {
            ms_log.debug("removeEdges: edge ids array is null. Do nothing.");
            return;
        }
        if (this.isTransientPropertyGraphInstance()) {
            throw new OraclePropertyGraphException("Property Graph is a transient graph, no update operations allowed");
        }
        Iterator<OracleEdgeBase> edges = this.edgesByIds(ids);
        if (edges == null) {
            return;
        }
        while (edges.hasNext()) {
            this.removeEdge(edges.next());
        }
        this.commit();
    }

    public void removeEdges(EdgeOpCallback eoc) {
        this.removeEdges(eoc, ParametersBase.getInstance().getDOP());
    }

    public void removeEdges(EdgeOpCallback eoc, int dop) {
        if (eoc == null) {
            ms_log.debug("removeEdges: opcallback is null. Do nothing.");
            return;
        }
        if (this.isTransientPropertyGraphInstance()) {
            throw new OraclePropertyGraphException("Property Graph is a transient graph, no update operations allowed");
        }
        this.updateGraph(eoc, true, dop, this.getProgressListener(), OpCallback.UpdateType.REMOVE_ENTITY);
    }

    public void removeVertices(VertexOpCallback voc) {
        this.removeVertices(voc, ParametersBase.getInstance().getDOP());
    }

    public void removeVertices(VertexOpCallback voc, int dop) {
        if (voc == null) {
            ms_log.debug("removeVertices: opcallback is null. Do nothing.");
            return;
        }
        if (this.isTransientPropertyGraphInstance()) {
            throw new OraclePropertyGraphException("Property Graph is a transient graph, no update operations allowed");
        }
        this.updateGraph(voc, true, dop, this.getProgressListener(), OpCallback.UpdateType.REMOVE_ENTITY);
    }

    public void removeVertices(Long[] ids) {
        this.removeVertices(ids, ParametersBase.getInstance().getDOP());
    }

    public void removeVertices(Long[] ids, int dop) {
        if (ids == null) {
            ms_log.debug("removeVertices: vertex ids array is null. Do nothing.");
            return;
        }
        if (this.isTransientPropertyGraphInstance()) {
            throw new OraclePropertyGraphException("Property Graph is a transient graph, no update operations allowed");
        }
        Iterator<OracleVertexBase> vertices = this.verticesByIds(ids);
        if (vertices == null) {
            return;
        }
        while (vertices.hasNext()) {
            this.removeVertex(vertices.next());
        }
        this.commit();
    }

    protected abstract <T extends OracleElementBase> OraclePropertyGraphBase getPropertyGraphFromIterator(boolean var1, Iterator<T> var2);

    protected final <T extends OracleElementBase> void consumeAndUpdateDataFromIterators(Iterator<T>[] itElemsArray, boolean isVertex, OpCallback<T> oc, OpCallback.UpdateType updateType, ProgressListener pl) throws InterruptedException, IOException {
        int idx;
        Thread[] threads = new Thread[itElemsArray.length];
        OraclePropertyGraphBase[] opgs = new OraclePropertyGraphBase[itElemsArray.length];
        for (idx = 0; idx < itElemsArray.length; ++idx) {
            Iterator<T> itElems = itElemsArray[idx];
            opgs[idx] = this.getPropertyGraphFromIterator(isVertex, itElems);
            opgs[idx].setTransientPropertyGraphInstance(false);
            OracleGraphUpdateWorker<T> elementWorker = new OracleGraphUpdateWorker<T>(itElems, idx, oc, updateType, pl);
            threads[idx] = new Thread(elementWorker, elementWorker.getName());
            threads[idx].start();
            if (!this.ms_bShowProgress) continue;
            ms_log.debug("updateGraph: start worker thread " + idx);
        }
        for (idx = 0; idx < threads.length; ++idx) {
            if (threads[idx] == null) continue;
            threads[idx].join();
        }
        for (idx = 0; idx < opgs.length; ++idx) {
            if (opgs[idx] == null) continue;
            opgs[idx].commit();
            opgs[idx].close();
        }
    }

    static {
        int idx = 1;
        numericTypeOrder.put(Byte.class, idx++);
        numericTypeOrder.put(Short.class, idx++);
        numericTypeOrder.put(Integer.class, idx++);
        numericTypeOrder.put(Long.class, idx++);
        numericTypeOrder.put(Float.class, idx++);
        numericTypeOrder.put(Double.class, idx++);
        m_dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    }

    protected class OracleGetAdjacentEdgesWorker
    implements Runnable {
        private Object[] requestedIds;
        private OraclePropertyGraphBase opg;
        private int offset;
        private int dop;
        private Direction direction;
        private String[] labels;
        private List<OracleEdgeBase> elements;

        public OracleGetAdjacentEdgesWorker(Object[] ids, OraclePropertyGraphBase opg, int offset, Direction direction, String[] labels, int dop) {
            this.requestedIds = ids;
            this.opg = opg;
            this.offset = offset;
            this.dop = dop;
            this.direction = direction;
            this.elements = new LinkedList<OracleEdgeBase>();
            this.labels = labels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (int idx = this.offset; idx < this.requestedIds.length; idx += this.dop) {
                OracleVertexBase v = this.opg.getVertex(this.requestedIds[idx]);
                try (Iterator<OracleEdgeBase> edges = v.edges(this.direction, this.labels);){
                    while (edges != null && edges.hasNext()) {
                        OracleEdgeBase e = edges.next();
                        if (e == null) continue;
                        this.elements.add(e);
                    }
                    continue;
                }
            }
        }

        public List<OracleEdgeBase> getElements() {
            return this.elements;
        }
    }

    protected class OracleGetElementsPropertiesWorker
    implements Runnable {
        private Object[] requestedIds;
        private String propertyName;
        private Class<? extends OracleElementBase> elementClass;
        private OraclePropertyGraphBase opg;
        private int offset;
        private int dop;
        private List<Map.Entry<Object, Object>> elements;

        public OracleGetElementsPropertiesWorker(Object[] ids, String propertyName, Class<? extends OracleElementBase> elementClass, OraclePropertyGraphBase opg, int offset, int dop) {
            this.requestedIds = ids;
            this.propertyName = propertyName;
            this.elementClass = elementClass;
            this.opg = opg;
            this.offset = offset;
            this.dop = dop;
            this.elements = new LinkedList<Map.Entry<Object, Object>>();
        }

        @Override
        public void run() {
            for (int idx = this.offset; idx < this.requestedIds.length; idx += this.dop) {
                OracleElementBase e;
                OracleElementBase oracleElementBase = e = OracleVertexBase.class.equals(this.elementClass) ? this.opg.getVertex(this.requestedIds[idx]) : this.opg.getEdge(this.requestedIds[idx]);
                if (e != null) {
                    this.elements.add(new AbstractMap.SimpleEntry(this.requestedIds[idx], e.property(this.propertyName).value()));
                    continue;
                }
                this.elements.add(null);
            }
        }

        public List<Map.Entry<Object, Object>> getElements() {
            return this.elements;
        }
    }

    protected class OracleGetElementsByIdsWorker
    implements Runnable {
        private Object[] requestedIds;
        private Class<? extends OracleElementBase> elementClass;
        private OraclePropertyGraphBase opg;
        private int offset;
        private int dop;
        private List<OracleElementBase> elements;

        public OracleGetElementsByIdsWorker(Object[] ids, Class<? extends OracleElementBase> elementClass, OraclePropertyGraphBase opg, int offset, int dop) {
            this.requestedIds = ids;
            this.elementClass = elementClass;
            this.opg = opg;
            this.offset = offset;
            this.dop = dop;
            this.elements = new LinkedList<OracleElementBase>();
        }

        @Override
        public void run() {
            for (int idx = this.offset; idx < this.requestedIds.length; idx += this.dop) {
                OracleElementBase element = null;
                element = OracleVertexBase.class.equals(this.elementClass) ? this.opg.getVertex(this.requestedIds[idx]) : this.opg.getEdge(this.requestedIds[idx]);
                if (element == null) continue;
                this.elements.add(element);
            }
        }

        public List<OracleElementBase> getElements() {
            return this.elements;
        }
    }

    public static enum OptimizationFlag {
        DO_NOT_CREATE_OBJECT,
        JUST_VERTEX_ID,
        JUST_EDGE_ID,
        JUST_VERTEX_EDGE_ID,
        JUST_LABEL_EDGE_ID,
        JUST_LABEL_VERTEX_EDGE_ID;

    }

    public static enum CacheStatus {
        NOT_SET,
        ENABLED,
        DISABLED;

    }

    protected static enum ConstraintType {
        MAX,
        MIN;

    }
}

