/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.pg.common.OracleElementBase;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.ProgressListener;

public interface OracleMetadataGraph {
    default public long countEdges() {
        return this.countEdges(ParametersBase.getInstance().getDOP(), this.getProgressListener());
    }

    default public long countEdges(int dop) {
        return this.countEdges(dop, this.getProgressListener());
    }

    public long countEdges(int var1, ProgressListener var2);

    default public long countVertices() {
        return this.countVertices(ParametersBase.getInstance().getDOP(), this.getProgressListener());
    }

    default public long countVertices(int dop) {
        return this.countVertices(dop, this.getProgressListener());
    }

    public long countVertices(int var1, ProgressListener var2);

    public ProgressListener getProgressListener();

    default public long getMinEdgeID() {
        return this.getMinEdgeID(ParametersBase.getInstance().getDOP(), this.getProgressListener());
    }

    default public long getMinEdgeID(int dop) {
        return this.getMinEdgeID(dop, this.getProgressListener());
    }

    public long getMinEdgeID(int var1, ProgressListener var2);

    default public long getMinVertexID() {
        return this.getMinVertexID(ParametersBase.getInstance().getDOP());
    }

    default public long getMinVertexID(int dop) {
        return this.getMinVertexID(dop, this.getProgressListener());
    }

    public long getMinVertexID(int var1, ProgressListener var2);

    default public long getMaxVertexID() {
        return this.getMaxVertexID(ParametersBase.getInstance().getDOP());
    }

    default public long getMaxVertexID(int dop) {
        return this.getMaxVertexID(dop, this.getProgressListener());
    }

    public long getMaxVertexID(int var1, ProgressListener var2);

    default public long getMaxEdgeID() {
        return this.getMaxEdgeID(ParametersBase.getInstance().getDOP());
    }

    default public long getMaxEdgeID(int dop) {
        return this.getMaxEdgeID(dop, this.getProgressListener());
    }

    public long getMaxEdgeID(int var1, ProgressListener var2);

    default public int getVertexPropertyNames(int dop, int timeout, Set<String> propertyNames) {
        return this.getVertexPropertyNames(dop, timeout, propertyNames, this.getProgressListener());
    }

    public int getVertexPropertyNames(int var1, int var2, Set<String> var3, ProgressListener var4);

    default public int getVertexPropertyNames(int dop, int timeout, Map<String, Class> propertyNames) {
        return this.getVertexPropertyNames(dop, timeout, propertyNames, this.getProgressListener());
    }

    public int getVertexPropertyNames(int var1, int var2, Map<String, Class> var3, ProgressListener var4);

    default public int getEdgePropertyNames(int dop, int timeout, Set<String> propertyNames) {
        return this.getEdgePropertyNames(dop, timeout, propertyNames, this.getProgressListener());
    }

    public int getEdgePropertyNames(int var1, int var2, Set<String> var3, ProgressListener var4);

    default public int getEdgePropertyNames(int dop, int timeout, Map<String, Class> propertyNames) {
        return this.getEdgePropertyNames(dop, timeout, propertyNames, this.getProgressListener());
    }

    public int getEdgePropertyNames(int var1, int var2, Map<String, Class> var3, ProgressListener var4);

    default public boolean isEmpty() throws IOException {
        return this.countVertices() > 0L || this.countEdges() > 0L;
    }

    default public Set<Long> getVertexIDSet() {
        return this.getVertexIDSet(ParametersBase.getInstance().getDOP(), this.getProgressListener());
    }

    default public Set<Long> getVertexIDSet(int dop) {
        return this.getVertexIDSet(dop, this.getProgressListener());
    }

    public Set<Long> getVertexIDSet(int var1, ProgressListener var2);

    default public Set<Long> getInvalidEdgeIDSet() {
        return this.getInvalidEdgeIDSet(ParametersBase.getInstance().getDOP(), this.getProgressListener());
    }

    default public Set<Long> getInvalidEdgeIDSet(int dop) {
        return this.getInvalidEdgeIDSet(dop, this.getProgressListener());
    }

    public Set<Long> getInvalidEdgeIDSet(int var1, ProgressListener var2);

    default public Iterator<Map.Entry<Object, Object>> getElementsProperties(Object[] ids, String propertyName, Class<? extends OracleElementBase> elementClass) {
        return this.getElementsProperties(ids, propertyName, ParametersBase.getInstance().getDOP(), elementClass);
    }

    public Iterator<Map.Entry<Object, Object>> getElementsProperties(Object[] var1, String var2, int var3, Class<? extends OracleElementBase> var4);
}

