/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OracleElementBase;
import oracle.pg.common.OracleMessageConstants;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.messages.MesgConsts;
import oracle.pg.text.OracleAutoIndex;
import oracle.pg.text.OracleIndex;
import oracle.pg.text.OracleIndexManager;
import oracle.pg.text.OracleIndexParameters;
import oracle.pg.text.OracleIndexUtils;
import oracle.pg.text.Parameter;

public interface OracleIndexableGraph
extends MesgConsts,
OracleMessageConstants {
    public static final SimpleLog ms_log = SimpleLog.getLog(OracleIndexableGraph.class);
    public static final boolean ms_bDebug = ms_log.isDebugEnabled();

    public <T extends OracleElementBase> OracleIndex<T> createIndex(String var1, Class<T> var2, Parameter ... var3);

    default public void refreshAutoIndices() {
        if (this.getOracleIndexManager() == null) {
            return;
        }
        ms_log.debug("refreshAutoIndices: refresh automatic indices cache before starting");
        this.getOracleIndexManager().refreshAllIndicesCache();
        ms_log.debug("refreshAutoIndices: executed");
        this.getOracleIndexManager().refreshAutoIndices();
    }

    default public void dropIndex(String indexName) {
        if (this.getOracleIndexManager() == null) {
            return;
        }
        if (ms_bDebug) {
            ms_log.debug((Object)"dropIndex: executed with index ", indexName);
        }
        this.getOracleIndexManager().dropIndex(indexName);
    }

    public OracleIndexManager getOracleIndexManager();

    default public <T extends OracleElementBase> OracleIndex<T> getAutoIndex(Class<T> indexClass) {
        this.validateIndexManager();
        ms_log.debug("getAutoIndex: refresh indices cache before starting");
        this.getOracleIndexManager().refreshAllIndicesCache();
        if (OracleVertexBase.class.isAssignableFrom(indexClass)) {
            ms_log.debug("getAutoIndex: indexClass<?>is assignable from vertex");
            return this.getOracleIndexManager().getVertexAutoIndexer(new Parameter[0]);
        }
        if (OracleEdgeBase.class.isAssignableFrom(indexClass)) {
            ms_log.debug("getAutoIndex: indexClass<?>is assignable from edge");
            return this.getOracleIndexManager().getEdgeAutoIndexer(new Parameter[0]);
        }
        throw new IllegalArgumentException("Class<?>is not indexable: " + indexClass);
    }

    default public <T extends OracleElementBase> OracleIndex<T> getIndex(String indexName, Class<T> indexClass) {
        this.validateIndexManager();
        ms_log.debug("getIndex: refresh indices cache before starting");
        this.getOracleIndexManager().refreshAllIndicesCache();
        if (OracleVertexBase.class.isAssignableFrom(indexClass)) {
            ms_log.debug("getIndex: indexClass<?>is assignable from vertex");
            if (this.getOracleIndexManager().getVertexAutoIndexName().equals(indexName)) {
                return this.getOracleIndexManager().getVertexAutoIndexer(new Parameter[0]);
            }
            if (this.getOracleIndexManager().existVertexIndex(indexName)) {
                ms_log.debug("getIndex: vertex index exists, get from index manager");
                return this.getOracleIndexManager().getVertexIndex(indexName, false);
            }
            if (this.getOracleIndexManager().existEdgeIndex(indexName)) {
                ms_log.debug("getIndex: index does not support vertex class");
                throw new IllegalStateException(indexName + " does not support class: " + indexClass);
            }
            ms_log.debug("getIndex: vertex index does not exists, return null");
            return null;
        }
        if (OracleEdgeBase.class.isAssignableFrom(indexClass)) {
            ms_log.debug("getIndex: indexClass<?>is assignable from edge");
            if (this.getOracleIndexManager().getEdgeAutoIndexName().equals(indexName)) {
                return this.getOracleIndexManager().getEdgeAutoIndexer(new Parameter[0]);
            }
            if (this.getOracleIndexManager().existEdgeIndex(indexName)) {
                ms_log.debug("getIndex: edge index exists, get from index manager");
                return this.getOracleIndexManager().getEdgeIndex(indexName, false);
            }
            if (this.getOracleIndexManager().existVertexIndex(indexName)) {
                ms_log.debug("getIndex: index does not support edge class");
                throw new IllegalStateException(indexName + " does not support class: " + indexClass);
            }
            ms_log.debug("getIndex: edge index does not exists, return null");
            return null;
        }
        throw new IllegalArgumentException("Class<?>is not indexable: " + indexClass);
    }

    default public Iterator<OracleIndex<? extends OracleElementBase>> getIndices() {
        this.validateIndexManager();
        ms_log.debug("getIndices: executed");
        return this.getOracleIndexManager().getIndices();
    }

    default public void dropAllIndices() {
        this.validateIndexManager();
        ms_log.debug("dropIndices: executed");
        this.getOracleIndexManager().dropAllIndices();
    }

    default public void dropAllManualIndices() {
        this.validateIndexManager();
        ms_log.debug("dropAllManualIndices: executed");
        this.getOracleIndexManager().dropAllManualIndices();
    }

    default public void dropAllAutoIndices() {
        this.validateIndexManager();
        ms_log.debug("dropAllAutoIndices: executed");
        this.getOracleIndexManager().dropAllAutoIndices();
    }

    default public <T extends OracleElementBase> void createKeyIndex(String key, Class<T> elementClass, Parameter ... parameters) {
        if (key == null) {
            throw new OraclePropertyGraphException(MSG_IDX_KEY_NOT_NULL.toString());
        }
        this.validateIndexManager();
        ms_log.debug("createKeyIndex: refresh indices cache before starting");
        this.getOracleIndexManager().refreshAllIndicesCache();
        if (OracleVertexBase.class.isAssignableFrom(elementClass)) {
            ms_log.debug("createKeyIndex: element class is vertex, get vertex auto indexer");
            if (!this.getOracleIndexManager().isVertexAutoIndexerEnabled()) {
                ms_log.debug("createKeyIndex: vertex auto index is not enabled, enable it");
                this.getOracleIndexManager().enableVertexAutoIndexer();
            }
            if (!this.getOracleIndexManager().getVertexAutoIndexer(parameters).containsIndexedKey(key)) {
                if (ms_bDebug) {
                    ms_log.debug("createKeyIndex: add key  to vertex auto index");
                }
                this.getOracleIndexManager().startAutoIndexingProperty(key, elementClass);
            } else if (ms_bDebug) {
                ms_log.debug((Object)"createKeyIndex: key  already indexed in ", "vertex auto index");
            }
        } else if (OracleEdgeBase.class.isAssignableFrom(elementClass)) {
            ms_log.debug("createKeyIndex: element class is edge, get edge auto indexer");
            if (!this.getOracleIndexManager().isEdgeAutoIndexerEnabled()) {
                ms_log.debug("createKeyIndex: edge auto index is not enabled, enable it");
                this.getOracleIndexManager().enableEdgeAutoIndexer();
            }
            if (!this.getOracleIndexManager().getEdgeAutoIndexer(parameters).containsIndexedKey(key)) {
                if (ms_bDebug) {
                    ms_log.debug("createKeyIndex: add key  to edge auto index");
                }
                this.getOracleIndexManager().startAutoIndexingProperty(key, elementClass);
            } else if (ms_bDebug) {
                ms_log.debug("createKeyIndex: key  already indexed in edge auto index");
            }
        } else {
            throw new IllegalArgumentException("Class<?>is not indexable: " + elementClass);
        }
    }

    default public <T extends OracleElementBase> void createKeyIndex(String[] keys, Class<T> elementClass) {
        this.createKeyIndex(keys, elementClass, this.getDefaultIndexParameters().getParameters());
    }

    default public <T extends OracleElementBase> void createKeyIndex(String[] keys, Class<T> elementClass, Parameter ... parameters) {
        if (keys == null || keys.length <= 0) {
            throw new OraclePropertyGraphException(MSG_IDX_KEYS_NOT_NULL.toString());
        }
        if (this.getOracleIndexManager() == null) {
            ms_log.info("No indexmanager for graph was found, index will not be created");
            return;
        }
        OracleIndexParameters tmpParams = this.getDefaultIndexParameters();
        this.setDefaultIndexParameters(new OracleIndexParameters(parameters));
        ms_log.debug("createKeyIndex: refresh indices cache before starting");
        this.getOracleIndexManager().refreshAllIndicesCache();
        if (OracleVertexBase.class.isAssignableFrom(elementClass)) {
            ms_log.debug("createKeyIndex: element class is vertex, get vertex auto indexer");
            if (!this.getOracleIndexManager().isVertexAutoIndexerEnabled()) {
                ms_log.debug("createKeyIndex: vertex auto index is not enabled, enable it");
                this.getOracleIndexManager().enableVertexAutoIndexer();
            }
            boolean bAlreadyIndexed = true;
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (this.getOracleIndexManager().getVertexAutoIndexer(new Parameter[0]).containsIndexedKey(key)) continue;
                if (ms_bDebug) {
                    ms_log.debug("createKeyIndex: key  not indexed, add to vertex auto index");
                }
                bAlreadyIndexed = false;
                break;
            }
            if (!bAlreadyIndexed) {
                if (ms_bDebug) {
                    ms_log.debug("createKeyIndex: reindex keys to vertex auto index");
                }
                this.getOracleIndexManager().startAutoIndexingProperties(keys, elementClass);
            }
        } else if (OracleEdgeBase.class.isAssignableFrom(elementClass)) {
            ms_log.debug("createKeyIndex: element class is edge, get edge auto indexer");
            if (!this.getOracleIndexManager().isEdgeAutoIndexerEnabled()) {
                ms_log.debug("createKeyIndex: edge auto index is not enabled, enable it");
                this.getOracleIndexManager().enableEdgeAutoIndexer();
            }
            boolean bAlreadyIndexed = true;
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (this.getOracleIndexManager().getEdgeAutoIndexer(new Parameter[0]).containsIndexedKey(key)) continue;
                if (ms_bDebug) {
                    ms_log.debug("createKeyIndex: key  not indexed, add to vertex auto index");
                }
                bAlreadyIndexed = false;
                break;
            }
            if (!bAlreadyIndexed) {
                if (ms_bDebug) {
                    ms_log.debug("createKeyIndex: reindex keys to edge auto index");
                }
                this.getOracleIndexManager().startAutoIndexingProperties(keys, elementClass);
            }
        } else {
            throw new IllegalArgumentException("Class<?>is not indexable: " + elementClass);
        }
        this.setDefaultIndexParameters(tmpParams);
    }

    default public <T extends OracleElementBase> void dropKeyIndex(String key, Class<T> elementClass) {
        if (key == null) {
            throw new OraclePropertyGraphException(MSG_IDX_KEY_NOT_NULL.toString());
        }
        if (this.getOracleIndexManager() == null) {
            ms_log.info("No index manager for graph was found, index will not be dropped");
            return;
        }
        ms_log.debug("dropKeyIndex: refresh indices cache before starting");
        this.getOracleIndexManager().refreshAllIndicesCache();
        if (OracleVertexBase.class.isAssignableFrom(elementClass)) {
            ms_log.debug("dropKeyIndex: element class is vertex, get vertex auto indexer");
            if (!this.getOracleIndexManager().isVertexAutoIndexerEnabled()) {
                ms_log.debug("dropKeyIndex: vertex auto index is not enabled, do nothing");
                return;
            }
            ms_log.debug("dropKeyIndex: remove key from vertex auto index");
            this.getOracleIndexManager().stopAutoIndexingProperty(key, elementClass);
        } else if (OracleEdgeBase.class.isAssignableFrom(elementClass)) {
            ms_log.debug("dropKeyIndex: element class is edge, get edge auto indexer");
            if (!this.getOracleIndexManager().isEdgeAutoIndexerEnabled()) {
                ms_log.debug("dropKeyIndex: edge auto index is not enabled, do nothing");
                return;
            }
            ms_log.debug("dropKeyIndex: remove key from edge auto index");
            this.getOracleIndexManager().stopAutoIndexingProperty(key, elementClass);
        } else {
            ms_log.debug("dropKeyIndex: element class is not indexable");
            throw new IllegalArgumentException("Class<?>is not indexable: " + elementClass);
        }
    }

    default public <T extends OracleElementBase> void dropKeyIndex(String[] keys, Class<T> elementClass) {
        this.dropKeyIndex(keys, elementClass, this.getDefaultIndexParameters().getParameters());
    }

    default public <T extends OracleElementBase> void dropKeyIndex(String[] keys, Class<T> elementClass, Parameter ... parameters) {
        if (keys == null || keys.length <= 0) {
            throw new OraclePropertyGraphException(MSG_IDX_KEYS_NOT_NULL.toString());
        }
        if (this.getOracleIndexManager() == null) {
            ms_log.info("No index manager for graph was found, index will not be dropped");
            return;
        }
        OracleIndexParameters tmpParams = this.getDefaultIndexParameters();
        this.setDefaultIndexParameters(new OracleIndexParameters(parameters));
        ms_log.debug("dropKeyIndex: refresh indices cache before starting");
        this.getOracleIndexManager().refreshAllIndicesCache();
        if (OracleVertexBase.class.isAssignableFrom(elementClass)) {
            ms_log.debug("dropKeyIndex: element class is vertex, get vertex auto indexer");
            if (!this.getOracleIndexManager().isVertexAutoIndexerEnabled()) {
                ms_log.debug("dropKeyIndex: vertex auto index is not enabled, do nothing");
                return;
            }
            ms_log.debug("dropKeyIndex: remove keys from vertex auto index");
            this.getOracleIndexManager().stopAutoIndexingProperties(keys, elementClass);
        } else if (OracleEdgeBase.class.isAssignableFrom(elementClass)) {
            ms_log.debug("dropKeyIndex: element class is edge, get edge auto indexer");
            if (!this.getOracleIndexManager().isEdgeAutoIndexerEnabled()) {
                ms_log.debug("dropKeyIndex: edge auto index is not enabled, do nothing");
                return;
            }
            ms_log.debug("dropKeyIndex: remove keys from edge auto index");
            this.getOracleIndexManager().stopAutoIndexingProperties(keys, elementClass);
        } else {
            ms_log.debug("dropKeyIndex: element class is not indexable");
            throw new IllegalArgumentException("Class<?>is not indexable: " + elementClass);
        }
        this.setDefaultIndexParameters(tmpParams);
    }

    public OracleIndexParameters getDefaultIndexParameters();

    default public <T extends OracleElementBase> OracleIndexParameters getIndexParameters(String indexName, Class<T> indexClass) {
        OracleIndex<T> index = this.getIndex(indexName, indexClass);
        if (index == null) {
            ms_log.debug("getIndexParameters: index not found");
            throw new OraclePropertyGraphException(MSG_TXT_IDX_NOT_FOUND.toString());
        }
        return index.getOracleIndexParameters();
    }

    default public <T extends OracleElementBase> Set<String> getIndexedKeys(Class<T> elementClass) {
        if (this.getOracleIndexManager() == null) {
            ms_log.info("No index manager for graph was found");
            return Collections.emptySet();
        }
        ms_log.debug("getIndexedKeys: refresh indices cache before starting");
        this.getOracleIndexManager().refreshAllIndicesCache();
        if (OracleVertexBase.class.isAssignableFrom(elementClass)) {
            ms_log.debug("getIndexedKeys: element class is assignable from OracleVertexBase");
            if (!this.getOracleIndexManager().isVertexAutoIndexerEnabled()) {
                if (ms_bDebug) {
                    ms_log.debug((Object)"getIndexedKeys: vertex auto index is not enabled, ", "return empty set");
                }
                return Collections.emptySet();
            }
            ms_log.debug("getIndexedKeys: get indexed keys from auto index");
            return this.getOracleIndexManager().getVertexAutoIndexer(new Parameter[0]).getIndexedKeys();
        }
        if (OracleEdgeBase.class.isAssignableFrom(elementClass)) {
            ms_log.debug("getIndexedKeys: element class is assignable from edgex");
            if (!this.getOracleIndexManager().isEdgeAutoIndexerEnabled()) {
                if (ms_bDebug) {
                    ms_log.debug("getIndexedKeys: edge auto index is not enabled, return empty set");
                }
                return Collections.emptySet();
            }
            ms_log.debug("getIndexedKeys: get indexed keys from auto index");
            return this.getOracleIndexManager().getEdgeAutoIndexer(new Parameter[0]).getIndexedKeys();
        }
        throw new IllegalArgumentException("Class<?>is not indexable: " + elementClass);
    }

    public void setDefaultIndexParameters(OracleIndexParameters var1);

    default public Class<?> getDatatypeClassFromValueObjForTextIndex(Object value) {
        return OracleIndexUtils.getDatatypeClass(value);
    }

    default public boolean isEdgeAutoIndexEnabled(String key) {
        OracleAutoIndex<OracleEdgeBase> autoIndex;
        return this.getOracleIndexManager() != null && this.getOracleIndexManager().isEdgeAutoIndexerEnabled() && (autoIndex = this.getOracleIndexManager().getEdgeAutoIndexer(new Parameter[0])) != null && autoIndex.containsIndexedKey(key);
    }

    default public boolean isVertexAutoIndexEnabled(String key) {
        OracleAutoIndex<OracleVertexBase> autoIndex;
        return this.getOracleIndexManager() != null && this.getOracleIndexManager().isVertexAutoIndexerEnabled() && (autoIndex = this.getOracleIndexManager().getVertexAutoIndexer(new Parameter[0])) != null && autoIndex.containsIndexedKey(key);
    }

    default public void validateIndexManager() {
        if (this.getOracleIndexManager() == null) {
            throw new OraclePropertyGraphException("Index manager is not instantiated or graph is not indexable ");
        }
    }
}

