/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.pg.common.CommonCache;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OracleLinkedHashMap;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.SimpleLog;

public class EdgeCache
extends CommonCache {
    static SimpleLog ms_log = SimpleLog.getLog(EdgeCache.class);
    static boolean ms_bDebug = ms_log.isDebugEnabled();
    private static ConcurrentHashMap<OraclePropertyGraphBase, EdgeCache> ms_chm = new ConcurrentHashMap();
    private long m_lHits = 0L;
    private long m_lMiss = 0L;
    private long m_lPuts = 0L;
    private long m_lRems = 0L;
    private Map<Long, OracleEdgeBase> m_hmCache = null;
    private Map<Long, OracleEdgeBase>[] m_hmPtnCaches = null;
    protected static final boolean ms_bShowProgress = ParametersBase.getInstance().showProgress();

    Map getInternalMap() {
        return this.m_hmCache;
    }

    private EdgeCache(OraclePropertyGraphBase opg) {
        super(opg);
        ms_log.debug((Object)"EdgeCache: Constructor, graphName ", opg.getGraphName());
        long lCacheSize = ParametersBase.getInstance().getEdgeCacheSize();
        ms_log.debug("EdgeCache: ConcurrentHashMap: ptned cache");
        this.m_hmPtnCaches = new Map[ms_iCachePtnNum];
        for (int idx = 0; idx < this.m_hmPtnCaches.length; ++idx) {
            if (ParametersBase.getInstance().syncCache()) {
                ms_log.debug("EdgeCache: syncCache");
                this.m_hmPtnCaches[idx] = Collections.synchronizedMap(new OracleLinkedHashMap((int)lCacheSize, 0.75f, true));
                continue;
            }
            ms_log.debug("EdgeCache: not syncCache");
            this.m_hmPtnCaches[idx] = new OracleLinkedHashMap<Long, OracleEdgeBase>((int)lCacheSize, 0.75f, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EdgeCache getInstance(OraclePropertyGraphBase opg) {
        EdgeCache ec = null;
        ConcurrentHashMap<OraclePropertyGraphBase, EdgeCache> concurrentHashMap = ms_chm;
        synchronized (concurrentHashMap) {
            ec = ms_chm.get(opg);
            if (ec == null) {
                ms_log.debug((Object)"getInstance: start a new EdgeCache for ", opg.getGraphName());
                ec = new EdgeCache(opg);
                ms_chm.put(opg, ec);
            }
            return ec;
        }
    }

    public void put(OracleEdgeBase e) {
        this.put((Long)e.id(), e);
    }

    public void put(Long lID, OracleEdgeBase e) {
        this.m_hmPtnCaches[this.getPtnID(lID)].put(lID, e);
        ++this.m_lPuts;
    }

    public OracleEdgeBase remove(OracleEdgeBase e) {
        return this.remove((Long)e.id());
    }

    public OracleEdgeBase remove(Long lID) {
        OracleEdgeBase e = this.m_hmPtnCaches[this.getPtnID(lID)].remove(lID);
        ++this.m_lRems;
        return e;
    }

    public void clearCache() {
        for (int idx = 0; idx < this.m_hmPtnCaches.length; ++idx) {
            this.m_hmPtnCaches[idx].clear();
        }
    }

    public void dumpStatistics(PrintStream ps) {
        ps.println("EdgeCache: m_lHits " + this.m_lHits);
        ps.println("EdgeCache: m_lMiss " + this.m_lMiss);
        ps.println("EdgeCache: m_lPuts " + this.m_lPuts);
        ps.println("EdgeCache: m_lRems " + this.m_lRems);
    }

    public OracleEdgeBase get(Long lID) {
        if (ms_bDebug && ParametersBase.getInstance().isSuperVerboseOn()) {
            ms_log.debug((Object)"get: trace ", new Throwable());
        }
        if (this.m_opg.isBuiltinElementsCacheDisabled()) {
            ms_log.debug("get: skip cache read due to cache setting");
            return null;
        }
        OracleEdgeBase e = null;
        e = this.m_hmPtnCaches[this.getPtnID(lID)].get(lID);
        if (e != null) {
            ++this.m_lHits;
            if (ms_bDebug) {
                ms_log.debug((Object)"get: found a hit in cache using lID ", lID.toString());
            }
            return e;
        }
        ++this.m_lMiss;
        return null;
    }
}

