/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import oracle.jdbc.OraclePreparedStatement;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.Util;
import oracle.pg.rdbms.Oracle;
import oracle.pg.rdbms.OracleElementIteratorImpl;
import oracle.pg.rdbms.OraclePropertyGraphAnalytics;
import oracle.pg.rdbms.OraclePropertyGraphAnalyticsException;
import oracle.pg.rdbms.OracleVertex;
import oracle.pgx.config.AbstractPgGraphConfig;
import oracle.pgx.config.PgRdbmsGraphConfig;

public abstract class SQLAnalyticsGraph
extends OraclePropertyGraphBase
implements OraclePropertyGraphAnalytics {
    static SimpleLog ms_log = SimpleLog.getLog(SQLAnalyticsGraph.class);

    public SQLAnalyticsGraph() {
    }

    public SQLAnalyticsGraph(PgRdbmsGraphConfig config) {
        super((AbstractPgGraphConfig)config);
    }

    public void analyze(float estimatePercent, String methodOpt) throws SQLException {
        this.analyze(estimatePercent, methodOpt, this.getSessionQueryDOP());
    }

    public void analyze(int dop) throws SQLException {
        try (OraclePreparedStatement analyzeStmt = null;){
            analyzeStmt = (OraclePreparedStatement)this.getOracle().getConnection().prepareCall("begin mdsys.opg_apis.analyze_pg(?,cascade=>true,no_invalidate=>false, degree=>?); end;");
            analyzeStmt.setString(1, this.getGraphName());
            analyzeStmt.setInt(2, dop);
            analyzeStmt.execute();
        }
        ms_log.debug((Object)"analyze: done");
    }

    public void analyzeAuto(int dop) throws SQLException {
        try (OraclePreparedStatement analyzeStmt = null;){
            analyzeStmt = (OraclePreparedStatement)this.getOracle().getConnection().prepareCall("begin mdsys.opg_apis.analyze_pg(?,cascade=>true,no_invalidate=>false, degree=>?, options=>'GATHER AUTO'); end;");
            analyzeStmt.setString(1, this.getGraphName());
            analyzeStmt.setInt(2, dop);
            analyzeStmt.execute();
        }
        ms_log.debug((Object)"analyze: done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyze(float estimatePercent, String methodOpt, int dop) throws SQLException {
        try (OraclePreparedStatement analyzeStmt = null;){
            analyzeStmt = (OraclePreparedStatement)this.getOracle().getConnection().prepareCall("begin mdsys.opg_apis.analyze_pg(?,?,?,cascade=>true,no_invalidate=>false, degree=>?); end;");
            analyzeStmt.setString(1, this.getGraphName());
            analyzeStmt.setFloat(2, estimatePercent);
            analyzeStmt.setString(3, methodOpt);
            analyzeStmt.setInt(4, dop);
            analyzeStmt.execute();
        }
        ms_log.debug((Object)"analyze: done");
    }

    public void createStatTable(String statTableName) throws SQLException {
        try (OraclePreparedStatement ops = null;){
            ops = (OraclePreparedStatement)this.getOracle().getConnection().prepareCall("begin mdsys.opg_apis.create_stat_table(?); end;");
            ops.setString(1, statTableName);
            ops.execute();
        }
        ms_log.debug((Object)"createStatTable: done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expVertexStat(String statTableName, String statid) throws SQLException {
        try (OraclePreparedStatement ops = null;){
            ops = (OraclePreparedStatement)this.getOracle().getConnection().prepareCall("begin mdsys.opg_apis.exp_vertex_tab_stats(?,?,?); end;");
            ops.setString(1, this.getGraphName());
            ops.setString(2, statTableName);
            ops.setString(3, statid);
            ops.execute();
        }
        ms_log.debug((Object)"expVertexStat: done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expEdgeStat(String statTableName, String statid) throws SQLException {
        try (OraclePreparedStatement ops = null;){
            ops = (OraclePreparedStatement)this.getOracle().getConnection().prepareCall("begin mdsys.opg_apis.exp_edge_tab_stats(?,?,?); end;");
            ops.setString(1, this.getGraphName());
            ops.setString(2, statTableName);
            ops.setString(3, statid);
            ops.execute();
        }
        ms_log.debug((Object)"expEdgeStat: done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void impVertexStat(String statTableName, String statid) throws SQLException {
        try (OraclePreparedStatement ops = null;){
            ops = (OraclePreparedStatement)this.getOracle().getConnection().prepareCall("begin mdsys.opg_apis.imp_vertex_tab_stats(?,?,?); end;");
            ops.setString(1, this.getGraphName());
            ops.setString(2, statTableName);
            ops.setString(3, statid);
            ops.execute();
        }
        ms_log.debug((Object)"impEdgeStat: done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void impEdgeStat(String statTableName, String statid) throws SQLException {
        try (OraclePreparedStatement ops = null;){
            ops = (OraclePreparedStatement)this.getOracle().getConnection().prepareCall("begin mdsys.opg_apis.imp_edge_tab_stats(?,?,?); end;");
            ops.setString(1, this.getGraphName());
            ops.setString(2, statTableName);
            ops.setString(3, statid);
            ops.execute();
        }
        ms_log.debug((Object)"impEdgeStat: done");
    }

    @Override
    public void shortestPathPrep(StringBuilder sbExpTab, String szOptions) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = this.getOracle().getConnection().prepareCall("begin opg_apis.find_sp_prep(:1, :2, :3); end;");
            cs.setString(1, this.getEdgeTabName());
            cs.setString(2, sbExpTab == null ? "" : sbExpTab.toString());
            cs.setString(3, szOptions);
            cs.registerOutParameter(2, 12);
            cs.execute();
            String szExpTab = cs.getString(2);
            ms_log.debug((Object)"shortestPathPrep: szExpTab", (Object)szExpTab);
            sbExpTab.setLength(0);
            sbExpTab.append(szExpTab);
        }
        catch (SQLException sqle) {
            try {
                ms_log.debug((Object)"shortestPathPrep: ", (Throwable)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    public abstract String getEdgeTabName();

    @Override
    public void shortestPathCleanup(StringBuilder sbExpTab, String szOptions) throws SQLException {
        ms_log.debug((Object)"shortestPathCleanup: start");
        if (sbExpTab == null || sbExpTab.toString().trim().length() <= 0) {
            throw new IllegalArgumentException("shortestPathCleanup: sbExpTab must not be null or empty");
        }
        CallableStatement cs = null;
        try {
            cs = this.getOracle().getConnection().prepareCall("begin opg_apis.find_sp_cleanup(:1, :2, :3); end;");
            cs.setString(1, this.getEdgeTabName());
            cs.setString(2, sbExpTab == null ? "" : sbExpTab.toString());
            cs.setString(3, szOptions);
            cs.execute();
        }
        catch (SQLException sqle) {
            try {
                ms_log.debug((Object)"shortestPathCleanup: ", (Throwable)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    @Override
    public String shortestPath(OracleVertex vStart, OracleVertex vEnd, StringBuilder sbExpTab) throws SQLException {
        return this.shortestPath(vStart, vEnd, sbExpTab, new StringBuilder(), (String)null);
    }

    @Override
    public String shortestPath(OracleVertex vStart, OracleVertex vEnd, StringBuilder sbExpTab, StringBuilder sbPathWeights, String szOptions) throws SQLException {
        if (vStart == null) {
            throw new OraclePropertyGraphAnalyticsException("Cannot proceed with a NULL start vertex");
        }
        if (vEnd == null) {
            throw new OraclePropertyGraphAnalyticsException("Cannot proceed with a NULL end vertex");
        }
        return this.shortestPath((Long)vStart.id(), (Long)vEnd.id(), sbExpTab, sbPathWeights, szOptions);
    }

    @Override
    public String shortestPath(Long lStart, Long lEnd, StringBuilder sbExpTab) throws SQLException {
        return this.shortestPath(lStart, lEnd, sbExpTab, new StringBuilder(), (String)null);
    }

    @Override
    public String shortestPath(Long lStart, Long lEnd, StringBuilder sbExpTab, StringBuilder sbPathWeights, String szOptions) throws SQLException {
        return this.shortestPath(lStart, lEnd, sbExpTab, this.getEdgeTabName(), sbPathWeights, szOptions, null);
    }

    @Override
    public String shortestPath(Long lStart, Long lEnd, StringBuilder sbExpTab, String szEdgeTabName, StringBuilder sbPathWeights, String szOptions, Long lSCN) throws SQLException {
        return SQLAnalyticsGraph.shortestPath((Connection)this.getOracle().getConnection(), szEdgeTabName, lStart, lEnd, sbExpTab, sbPathWeights, szOptions, lSCN);
    }

    public static String shortestPath(Connection conn, String szEdgeTabName, Long lStart, Long lEnd, StringBuilder sbExpTab, StringBuilder sbPathWeights, String szOptions, Long lSCN) throws SQLException {
        String szPath = null;
        if (lStart == null) {
            throw new OraclePropertyGraphAnalyticsException("Cannot proceed with a NULL start vertex");
        }
        if (lEnd == null) {
            throw new OraclePropertyGraphAnalyticsException("Cannot proceed with a NULL end vertex");
        }
        if (sbExpTab == null || sbExpTab.toString().trim().length() <= 0) {
            throw new IllegalArgumentException("shortestPath: sbExpTab must not be null or empty");
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)("shortestPath: with lStart " + lStart + " => lEnd " + lEnd + ", sbExpTab " + sbExpTab.toString() + ", szEdgeTabName " + szEdgeTabName + ", szOptions " + szOptions));
        }
        CallableStatement cs = null;
        try {
            cs = conn.prepareCall("begin opg_apis.find_sp(:1, :2, :3, :4, :5, :6, :7,:8, :9, :10); end;");
            int idx = 1;
            cs.setString(idx++, szEdgeTabName);
            cs.setLong(idx++, (long)lStart);
            cs.setLong(idx++, (long)lEnd);
            cs.setString(idx++, Util.myCheckName((String)sbExpTab.toString()));
            cs.setInt(idx++, 1);
            cs.setInt(idx++, 20000);
            ++idx;
            int n = ++idx;
            ++idx;
            cs.setString(n, szOptions);
            if (lSCN != null) {
                cs.setLong(idx++, (long)lSCN);
            } else {
                cs.setNull(idx++, 4);
            }
            cs.registerOutParameter(7, 12);
            cs.registerOutParameter(8, 12);
            cs.execute();
            szPath = cs.getString(7);
            String szWeight = cs.getString(8);
            sbPathWeights.setLength(0);
            sbPathWeights.append(szWeight);
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"shortestPath: path is ", (Object)(szPath + ", weights are " + szWeight));
            }
        }
        catch (SQLException sqle) {
            ms_log.debug((Object)"shortestPath: ", (Throwable)sqle);
            throw sqle;
        }
        finally {
            OracleElementIteratorImpl.quietlyCloseStmt(cs);
        }
        return szPath;
    }

    @Override
    public void countTrianglePrep(StringBuilder sbUndirBMTab, StringBuilder sbMapWorkTab, StringBuilder sbUndirAMTab, String szOptions) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = this.getOracle().getConnection().prepareCall("begin opg_apis.count_triangle_prep(:1, :2, :3, :4, :5); end;");
            cs.setString(1, this.getEdgeTabName());
            cs.setString(2, sbUndirBMTab == null ? "" : sbUndirBMTab.toString());
            cs.setString(3, sbMapWorkTab == null ? "" : sbMapWorkTab.toString());
            cs.setString(4, sbUndirBMTab == null ? "" : sbUndirAMTab.toString());
            cs.setString(5, szOptions);
            cs.registerOutParameter(2, 12);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.execute();
            String szUndirBMTab = cs.getString(2);
            ms_log.debug((Object)"countTrianglePrep: szUndirBMTab ", (Object)szUndirBMTab);
            sbUndirBMTab.setLength(0);
            sbUndirBMTab.append(szUndirBMTab);
            String szMapWorkTab = cs.getString(3);
            ms_log.debug((Object)"countTrianglePrep: szMapWorkTab ", (Object)szMapWorkTab);
            sbMapWorkTab.setLength(0);
            sbMapWorkTab.append(szMapWorkTab);
            String szUndirAMTab = cs.getString(4);
            ms_log.debug((Object)"countTrianglePrep: szUndirAMTab ", (Object)szUndirAMTab);
            sbUndirAMTab.setLength(0);
            sbUndirAMTab.append(szUndirAMTab);
        }
        catch (SQLException sqle) {
            try {
                ms_log.debug((Object)"countTrianglePrep: ", (Throwable)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    @Override
    public void countTriangleCleanup(StringBuilder sbUndirBMTab, StringBuilder sbMapWorkTab, StringBuilder sbUndirAMTab, String szOptions) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = this.getOracle().getConnection().prepareCall("begin opg_apis.count_triangle_cleanup(:1, :2, :3, :4, :5); end;");
            cs.setString(1, this.getEdgeTabName());
            cs.setString(2, sbUndirBMTab == null ? "" : Util.myCheckName((String)sbUndirBMTab.toString()));
            cs.setString(3, sbMapWorkTab == null ? "" : Util.myCheckName((String)sbMapWorkTab.toString()));
            cs.setString(4, sbUndirBMTab == null ? "" : Util.myCheckName((String)sbUndirAMTab.toString()));
            cs.setString(5, szOptions);
            cs.execute();
        }
        catch (SQLException sqle) {
            try {
                ms_log.debug((Object)"countTriangleCleanup: ", (Throwable)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    @Override
    public long countTriangle(StringBuilder sbUndirWorkTab) throws SQLException {
        return this.countTriangle(sbUndirWorkTab, 2, this.getSessionQueryDOP(), null, ",CREATE_UNDIRECTED=T,");
    }

    protected abstract int getSessionQueryDOP();

    @Override
    public long countTriangle(StringBuilder sbUndirWorkTab, int iNumSubPtns, int iDOP, String szTBS, String szOptions) throws SQLException {
        return SQLAnalyticsGraph.countTriangle((Connection)this.getOracle().getConnection(), this.getEdgeTabName(), sbUndirWorkTab, iNumSubPtns, iDOP, szTBS, szOptions);
    }

    public static long countTriangle(Connection conn, String szEdgeTabName, StringBuilder sbUndirWorkTab, int iNumSubPtns, int iDOP, String szTBS, String szOptions) throws SQLException {
        long lTriangles = 0L;
        if (sbUndirWorkTab == null || sbUndirWorkTab.toString().trim().length() <= 0) {
            throw new IllegalArgumentException("countTriangle: sbUndirWorkTab must not be null or empty");
        }
        CallableStatement cs = null;
        try {
            cs = conn.prepareCall("begin :1 := opg_apis.count_triangle(:2, :3, :4, :5, :6, :7); end;");
            cs.registerOutParameter(1, 2);
            cs.setString(2, szEdgeTabName);
            cs.setString(3, Util.myCheckName((String)sbUndirWorkTab.toString()));
            cs.setInt(4, iNumSubPtns);
            cs.setInt(5, iDOP);
            cs.setString(6, szTBS);
            cs.setString(7, szOptions);
            cs.execute();
            lTriangles = cs.getLong(1);
            ms_log.debug((Object)"countTriangle: lTriangles", (Object)lTriangles);
        }
        catch (SQLException sqle) {
            ms_log.debug((Object)"countTriangle: ", (Throwable)sqle);
            throw sqle;
        }
        finally {
            OracleElementIteratorImpl.quietlyCloseStmt(cs);
        }
        return lTriangles;
    }

    @Override
    public long estimateTriangleRenum(StringBuilder sbUndirBMTab, StringBuilder sbMapWorkTab, StringBuilder sbUndirAMTab, int iNumSubPtns, int iChunk, int iDOP, String szTBS, String szOptions) throws SQLException {
        return SQLAnalyticsGraph.estimateTriangleRenum((Connection)this.getOracle().getConnection(), this.getEdgeTabName(), sbUndirBMTab, sbMapWorkTab, sbUndirAMTab, iNumSubPtns, iChunk, iDOP, szTBS, szOptions);
    }

    public static long estimateTriangleRenum(Connection conn, String szEdgeTabName, StringBuilder sbUndirBMTab, StringBuilder sbMapWorkTab, StringBuilder sbUndirAMTab, int iNumSubPtns, int iChunk, int iDOP, String szTBS, String szOptions) throws SQLException {
        long lTriangles = 0L;
        if (sbUndirBMTab == null || sbUndirBMTab.toString().trim().length() <= 0) {
            throw new IllegalArgumentException("countTriangleRenum: sbUndirBMTab must not be null or empty");
        }
        if (sbMapWorkTab == null || sbMapWorkTab.toString().trim().length() <= 0) {
            throw new IllegalArgumentException("countTriangleRenum: sbMapWorkTab must not be null or empty");
        }
        if (sbUndirAMTab == null || sbUndirAMTab.toString().trim().length() <= 0) {
            throw new IllegalArgumentException("countTriangleRenum: sbUndirAMTab must not be null or empty");
        }
        CallableStatement cs = null;
        try {
            cs = conn.prepareCall("begin :1 := opg_apis.estimate_triangle_renum(:2, :3, :4, :5, :6, :7, :8, :9, :10); end;");
            String szUndirBMTab = sbUndirBMTab.toString();
            String szMapWorkTab = sbMapWorkTab.toString();
            String szUndirAMTab = sbUndirAMTab.toString();
            cs.registerOutParameter(1, 2);
            cs.setString(2, szEdgeTabName);
            cs.setString(3, Util.myCheckName((String)szUndirBMTab));
            cs.setString(4, Util.myCheckName((String)szMapWorkTab));
            cs.setString(5, Util.myCheckName((String)szUndirAMTab));
            cs.setInt(6, iNumSubPtns);
            cs.setInt(7, iChunk);
            cs.setInt(8, iDOP);
            cs.setString(9, szTBS);
            cs.setString(10, ",CREATE_UNDIRECTED=T," + szOptions);
            cs.execute();
            lTriangles = cs.getLong(1);
            ms_log.debug((Object)"countTriangleRenum: lTriangles for a chunk ", (Object)(lTriangles / (long)iNumSubPtns / (long)iNumSubPtns));
            ms_log.debug((Object)"countTriangleRenum: estimated lTriangles for whole graph ", (Object)lTriangles);
        }
        catch (SQLException sqle) {
            ms_log.debug((Object)"countTriangleRenum: ", (Throwable)sqle);
            throw sqle;
        }
        finally {
            OracleElementIteratorImpl.quietlyCloseStmt(cs);
        }
        return lTriangles;
    }

    @Override
    public long countTriangleRenum(StringBuilder sbUndirBMTab, StringBuilder sbMapWorkTab, StringBuilder sbUndirAMTab, int iNumSubPtns, int iDOP, String szTBS, String szOptions) throws SQLException {
        return SQLAnalyticsGraph.countTriangleRenum((Connection)this.getOracle().getConnection(), this.getEdgeTabName(), sbUndirBMTab, sbMapWorkTab, sbUndirAMTab, iNumSubPtns, iDOP, szTBS, szOptions);
    }

    public static long countTriangleRenum(Connection conn, String szEdgeTabName, StringBuilder sbUndirBMTab, StringBuilder sbMapWorkTab, StringBuilder sbUndirAMTab, int iNumSubPtns, int iDOP, String szTBS, String szOptions) throws SQLException {
        long lTriangles = 0L;
        if (sbUndirBMTab == null || sbUndirBMTab.toString().trim().length() <= 0) {
            throw new IllegalArgumentException("countTriangleRenum: sbUndirBMTab must not be null or empty");
        }
        if (sbMapWorkTab == null || sbMapWorkTab.toString().trim().length() <= 0) {
            throw new IllegalArgumentException("countTriangleRenum: sbMapWorkTab must not be null or empty");
        }
        if (sbUndirAMTab == null || sbUndirAMTab.toString().trim().length() <= 0) {
            throw new IllegalArgumentException("countTriangleRenum: sbUndirAMTab must not be null or empty");
        }
        CallableStatement cs = null;
        try {
            cs = conn.prepareCall("begin :1 := opg_apis.count_triangle_renum(:2, :3, :4, :5, :6, :7, :8, :9); end;");
            cs.registerOutParameter(1, 2);
            cs.setString(2, szEdgeTabName);
            cs.setString(3, Util.myCheckName((String)sbUndirBMTab.toString()));
            cs.setString(4, Util.myCheckName((String)sbMapWorkTab.toString()));
            cs.setString(5, Util.myCheckName((String)sbUndirAMTab.toString()));
            cs.setInt(6, iNumSubPtns);
            cs.setInt(7, iDOP);
            cs.setString(8, szTBS);
            cs.setString(9, ",CREATE_UNDIRECTED=T," + szOptions);
            cs.execute();
            lTriangles = cs.getLong(1);
            ms_log.debug((Object)"countTriangleRenum: lTriangles", (Object)lTriangles);
        }
        catch (SQLException sqle) {
            ms_log.debug((Object)"countTriangleRenum: ", (Throwable)sqle);
            throw sqle;
        }
        finally {
            OracleElementIteratorImpl.quietlyCloseStmt(cs);
        }
        return lTriangles;
    }

    @Override
    public void pageRankPrep(StringBuilder sbNodePR, StringBuilder sbNodeNextPR, StringBuilder sbEdgeTabDeg, StringBuilder sbDelta, String szOptions) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = this.getOracle().getConnection().prepareCall("begin opg_apis.pr_prep(:1, :2, :3, :4, :5, :6); end;");
            cs.setString(1, this.getEdgeTabName());
            cs.setString(2, sbNodePR == null ? "" : sbNodePR.toString());
            cs.setString(3, sbNodeNextPR == null ? "" : sbNodeNextPR.toString());
            cs.setString(4, sbEdgeTabDeg == null ? "" : sbEdgeTabDeg.toString());
            cs.setString(5, sbDelta == null ? "" : sbDelta.toString());
            cs.setString(6, szOptions);
            cs.registerOutParameter(2, 12);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 12);
            cs.execute();
            String szNodePR = cs.getString(2);
            ms_log.debug((Object)"pageRankPrep: szNodePR ", (Object)szNodePR);
            sbNodePR.setLength(0);
            sbNodePR.append(szNodePR);
            String szNodeNextPR = cs.getString(3);
            ms_log.debug((Object)"pageRankPrep: szNodeNextPR ", (Object)szNodeNextPR);
            sbNodeNextPR.setLength(0);
            sbNodeNextPR.append(szNodeNextPR);
            String szEdgeTabDeg = cs.getString(4);
            ms_log.debug((Object)"pageRankPrep: szEdgeTabDeg ", (Object)szEdgeTabDeg);
            sbEdgeTabDeg.setLength(0);
            sbEdgeTabDeg.append(szEdgeTabDeg);
            String szDelta = cs.getString(5);
            ms_log.debug((Object)"pageRankPrep: szDelta ", (Object)szDelta);
            sbDelta.setLength(0);
            sbDelta.append(szDelta);
        }
        catch (SQLException sqle) {
            try {
                ms_log.debug((Object)"pageRankPrep: ", (Throwable)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    @Override
    public void pageRankCleanup(StringBuilder sbNodePR, StringBuilder sbNodeNextPR, StringBuilder sbEdgeTabDeg, StringBuilder sbDelta, String szOptions) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = this.getOracle().getConnection().prepareCall("begin opg_apis.pr_cleanup(:1, :2, :3, :4, :5, :6); end;");
            cs.setString(1, this.getEdgeTabName());
            cs.setString(2, sbNodePR == null ? "" : Util.myCheckName((String)sbNodePR.toString()));
            cs.setString(3, sbNodeNextPR == null ? "" : Util.myCheckName((String)sbNodeNextPR.toString()));
            cs.setString(4, sbEdgeTabDeg == null ? "" : Util.myCheckName((String)sbEdgeTabDeg.toString()));
            cs.setString(5, sbDelta == null ? "" : Util.myCheckName((String)sbDelta.toString()));
            cs.setString(6, szOptions);
            cs.execute();
        }
        catch (SQLException sqle) {
            try {
                ms_log.debug((Object)"pageRankCleanup: ", (Throwable)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    @Override
    public long pageRank(StringBuilder sbNodePR, StringBuilder sbNodeNextPR, StringBuilder sbEdgeTabDeg, StringBuilder sbDelta, float d, int iNumIterations, float convergence, int iDOP, String szTBS, String szOptions) throws SQLException {
        return SQLAnalyticsGraph.pageRank((Connection)this.getOracle().getConnection(), this.getEdgeTabName(), sbNodePR, sbNodeNextPR, sbEdgeTabDeg, sbDelta, d, iNumIterations, convergence, iDOP, szTBS, szOptions);
    }

    public static long pageRank(Connection conn, String szEdgeTabName, StringBuilder sbNodePR, StringBuilder sbNodeNextPR, StringBuilder sbEdgeTabDeg, StringBuilder sbDelta, float d, int iNumIterations, float convergence, int iDOP, String szTBS, String szOptions) throws SQLException {
        long lVertices = 0L;
        if (sbNodePR == null || sbNodePR.toString().trim().length() <= 0) {
            throw new IllegalArgumentException("pageRank: sbNodePR must not be null or empty");
        }
        if (sbNodeNextPR == null || sbNodeNextPR.toString().trim().length() <= 0) {
            throw new IllegalArgumentException("pageRank: sbNodeNextPR must not be null or empty");
        }
        if (sbEdgeTabDeg == null || sbEdgeTabDeg.toString().trim().length() <= 0) {
            throw new IllegalArgumentException("pageRank: sbEdgeTabDeg must not be null or empty");
        }
        if (sbDelta == null || sbDelta.toString().trim().length() <= 0) {
            throw new IllegalArgumentException("pageRank: sbDelta must not be null or empty");
        }
        CallableStatement cs = null;
        try {
            cs = conn.prepareCall("begin opg_apis.pr(:1, :2, :3, :4, :5, :6, :7, :8, :9, :10, :11, :12); end;");
            cs.registerOutParameter(12, 2);
            cs.setString(1, szEdgeTabName);
            cs.setFloat(2, d);
            cs.setInt(3, iNumIterations);
            cs.setFloat(4, convergence);
            cs.setInt(5, iDOP);
            cs.setString(6, Util.myCheckName((String)sbNodePR.toString()));
            cs.setString(7, Util.myCheckName((String)sbNodeNextPR.toString()));
            cs.setString(8, Util.myCheckName((String)sbEdgeTabDeg.toString()));
            cs.setString(9, Util.myCheckName((String)sbDelta.toString()));
            cs.setString(10, szTBS);
            cs.setString(11, ",REUSE_TAB=T,PDML=T," + szOptions);
            cs.execute();
            lVertices = cs.getLong(12);
            ms_log.debug((Object)"pageRank: lVertices", (Object)lVertices);
        }
        catch (SQLException sqle) {
            ms_log.debug((Object)"pageRank: ", (Throwable)sqle);
            throw sqle;
        }
        finally {
            OracleElementIteratorImpl.quietlyCloseStmt(cs);
        }
        return lVertices;
    }

    public ResultSet getTopK(StringBuilder sbTabName, int iColIdx, Sort sort, int k) throws SQLException {
        return SQLAnalyticsGraph.getTopK((Connection)this.getOracle().getConnection(), sbTabName, iColIdx, sort, k, this.getSessionQueryDOP());
    }

    public ResultSet getTopK(StringBuilder sbTabName, int iColIdx, Sort sort, int k, int iDOP) throws SQLException {
        return SQLAnalyticsGraph.getTopK((Connection)this.getOracle().getConnection(), sbTabName, iColIdx, sort, k, iDOP);
    }

    public static ResultSet getTopK(Connection conn, StringBuilder sbTabName, int iColIdx, Sort sort, int k, int iDOP) throws SQLException {
        PreparedStatement ps = null;
        if (conn == null) {
            throw new IllegalArgumentException("getTopK: conn must not be null");
        }
        if (sbTabName == null) {
            throw new IllegalArgumentException("getTopK: sbTabName must not be null");
        }
        if (iColIdx <= 0) {
            throw new IllegalArgumentException("getTopK: iColIdx must not be zero or negative");
        }
        if (k <= 0) {
            throw new IllegalArgumentException("getTopK: k must not be zero or negative");
        }
        if (iDOP < 0) {
            throw new IllegalArgumentException("getTopK: iDOP must not be negative");
        }
        ResultSet rs = null;
        ms_log.debug((Object)"getTopK: start ");
        StringBuilder sbPQ = new StringBuilder().append(" /*+ parallel");
        if (iDOP != 0) {
            sbPQ.append("(").append(iDOP).append(")");
        }
        sbPQ.append(" */ ");
        ps = sort == Sort.ASC ? conn.prepareStatement("select " + sbPQ.toString() + " * from ( select t.*, rownum as row_count from (select * from " + Util.enquoteTableName((Connection)conn, (String)sbTabName.toString()) + " order by " + iColIdx + " asc) t ) where row_count <=? ") : conn.prepareStatement("select " + sbPQ.toString() + " * from ( select t.*, rownum as row_count from (select * from " + Util.enquoteTableName((Connection)conn, (String)sbTabName.toString()) + " order by " + iColIdx + " desc) t ) where row_count <=? ");
        ps.setInt(1, k);
        rs = ps.executeQuery();
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printResultSet(ResultSet rs, PrintStream ps) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("printResultSet: rs must not be null");
        }
        if (ps == null) {
            throw new IllegalArgumentException("printResultSet: ps must not be null");
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int iColCount = rsmd.getColumnCount();
        try {
            while (rs.next()) {
                ps.println();
                for (int idx = 1; idx <= iColCount; ++idx) {
                    String szColName = rsmd.getColumnName(idx);
                    Object obj = rs.getObject(szColName);
                    if (idx > 1) {
                        ps.print(", ");
                    }
                    if (obj == null) {
                        ps.print(szColName + "=NULL");
                        continue;
                    }
                    ps.print(szColName + "=" + obj.toString());
                }
            }
        }
        finally {
            OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs);
        }
    }

    public void sparsifyGraphPrep(StringBuilder sbOutTab, StringBuilder sbUndTab, StringBuilder sbHshTab, StringBuilder sbMchTab, String szOptions) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = this.getOracle().getConnection().prepareCall("begin opg_apis.sparsify_graph_prep(:1, :2, :3, :4, :5, :6); end;");
            cs.setString(1, this.getEdgeTabName());
            cs.setString(2, sbOutTab == null ? "" : sbOutTab.toString());
            cs.setString(3, sbUndTab == null ? "" : sbUndTab.toString());
            cs.setString(4, sbHshTab == null ? "" : sbHshTab.toString());
            cs.setString(5, sbMchTab == null ? "" : sbMchTab.toString());
            cs.setString(6, szOptions);
            cs.registerOutParameter(2, 12);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 12);
            cs.execute();
            String szOutTab = cs.getString(2);
            ms_log.debug((Object)"sparsifyGraphPrep: szOutTab ", (Object)szOutTab);
            sbOutTab.setLength(0);
            sbOutTab.append(szOutTab);
            String szUndTab = cs.getString(3);
            ms_log.debug((Object)"sparsifyGraphPrep: szUndTab ", (Object)szUndTab);
            sbUndTab.setLength(0);
            sbUndTab.append(szUndTab);
            String szHshTab = cs.getString(4);
            ms_log.debug((Object)"sparsifyGraphPrep: szHshTab ", (Object)szHshTab);
            sbHshTab.setLength(0);
            sbHshTab.append(szHshTab);
            String szMchTab = cs.getString(5);
            ms_log.debug((Object)"sparsifyGraphPrep: szMchTab ", (Object)szMchTab);
            sbMchTab.setLength(0);
            sbMchTab.append(szMchTab);
        }
        catch (SQLException sqle) {
            try {
                ms_log.debug((Object)"sparsifyGraphPrep: ", (Throwable)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    public void sparsifyGraphCleanup(StringBuilder sbOutTab, StringBuilder sbUndTab, StringBuilder sbHshTab, StringBuilder sbMchTab, String szOptions) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = this.getOracle().getConnection().prepareCall("begin opg_apis.sparsify_graph_cleanup(:1, :2, :3, :4, :5, :6); end;");
            cs.setString(1, this.getEdgeTabName());
            cs.setString(2, sbOutTab == null ? "" : sbOutTab.toString());
            cs.setString(3, sbUndTab == null ? "" : sbUndTab.toString());
            cs.setString(4, sbHshTab == null ? "" : sbHshTab.toString());
            cs.setString(5, sbMchTab == null ? "" : sbMchTab.toString());
            cs.setString(6, szOptions);
            cs.execute();
        }
        catch (SQLException sqle) {
            try {
                ms_log.debug((Object)"sparsifyGraphCleanup: ", (Throwable)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    public void sparsifyGraph(float fThreshold, int iMinKeep, int iDOP, StringBuilder sbOutTab, StringBuilder sbUndTab, StringBuilder sbHshTab, StringBuilder sbMchTab, String szTBS, String szOptions) throws SQLException {
        SQLAnalyticsGraph.sparsifyGraph((Connection)this.getOracle().getConnection(), this.getEdgeTabName(), fThreshold, iMinKeep, iDOP, sbOutTab, sbUndTab, sbHshTab, sbMchTab, szTBS, szOptions);
    }

    public static void sparsifyGraph(Connection conn, String szEdgeTabName, float fThreshold, int iMinKeep, int iDOP, StringBuilder sbOutTab, StringBuilder sbUndTab, StringBuilder sbHshTab, StringBuilder sbMchTab, String szTBS, String szOptions) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = conn.prepareCall("begin opg_apis.sparsify_graph(:1, :2, :3, :4, :5, :6, :7, :8, :9, :10); end;");
            cs.setString(1, szEdgeTabName);
            cs.setFloat(2, fThreshold);
            cs.setInt(3, iMinKeep);
            cs.setInt(4, iDOP);
            cs.setString(5, sbOutTab == null ? "" : Util.myCheckName((String)sbOutTab.toString()));
            cs.setString(6, sbUndTab == null ? "" : Util.myCheckName((String)sbUndTab.toString()));
            cs.setString(7, sbHshTab == null ? "" : Util.myCheckName((String)sbHshTab.toString()));
            cs.setString(8, sbMchTab == null ? "" : Util.myCheckName((String)sbMchTab.toString()));
            cs.setString(9, szTBS);
            cs.setString(10, szOptions);
            cs.execute();
        }
        catch (SQLException sqle) {
            ms_log.debug((Object)"sparsifyGraph: ", (Throwable)sqle);
            throw sqle;
        }
        finally {
            OracleElementIteratorImpl.quietlyCloseStmt(cs);
        }
    }

    @Override
    public void findClusterPrep(StringBuilder sbClusters, StringBuilder sbUndir, StringBuilder sbCluas, StringBuilder sbNewas, StringBuilder sbDelta, String szOptions) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = this.getOracle().getConnection().prepareCall("begin opg_apis.find_clusters_prep(:1, :2, :3, :4, :5, :6, :7); end;");
            cs.setString(1, this.getEdgeTabName());
            cs.setString(2, sbClusters == null ? "" : sbClusters.toString());
            cs.setString(3, sbUndir == null ? "" : sbUndir.toString());
            cs.setString(4, sbCluas == null ? "" : sbCluas.toString());
            cs.setString(5, sbNewas == null ? "" : sbNewas.toString());
            cs.setString(6, sbDelta == null ? "" : sbDelta.toString());
            cs.setString(7, szOptions);
            cs.registerOutParameter(2, 12);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 12);
            cs.registerOutParameter(6, 12);
            cs.execute();
            String szClusters = cs.getString(2);
            ms_log.debug((Object)"findClustersPrep: szClusters ", (Object)szClusters);
            sbClusters.setLength(0);
            sbClusters.append(szClusters);
            String szUndir = cs.getString(3);
            ms_log.debug((Object)"findClustersPrep: szUndir ", (Object)szUndir);
            sbUndir.setLength(0);
            sbUndir.append(szUndir);
            String szCluas = cs.getString(4);
            ms_log.debug((Object)"findClustersPrep: szCluas ", (Object)szCluas);
            sbCluas.setLength(0);
            sbCluas.append(szCluas);
            String szNewas = cs.getString(5);
            ms_log.debug((Object)"findClustersPrep: szNewas ", (Object)szNewas);
            sbNewas.setLength(0);
            sbNewas.append(szNewas);
            String szDelta = cs.getString(6);
            ms_log.debug((Object)"findClustersPrep: szDelta ", (Object)szDelta);
            sbDelta.setLength(0);
            sbDelta.append(szDelta);
        }
        catch (SQLException sqle) {
            try {
                ms_log.debug((Object)"findClustersPrep: ", (Throwable)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    @Override
    public void findClusterCleanup(StringBuilder sbClusters, StringBuilder sbUndir, StringBuilder sbCluas, StringBuilder sbNewas, StringBuilder sbDelta, String szOptions) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = this.getOracle().getConnection().prepareCall("begin opg_apis.find_clusters_cleanup(:1, :2, :3, :4, :5, :6, :7); end;");
            cs.setString(1, this.getEdgeTabName());
            cs.setString(2, sbClusters == null ? "" : sbClusters.toString());
            cs.setString(3, sbUndir == null ? "" : sbUndir.toString());
            cs.setString(4, sbCluas == null ? "" : sbCluas.toString());
            cs.setString(5, sbNewas == null ? "" : sbNewas.toString());
            cs.setString(6, sbDelta == null ? "" : sbDelta.toString());
            cs.setString(7, szOptions);
            cs.execute();
        }
        catch (SQLException sqle) {
            try {
                ms_log.debug((Object)"findClustersCleanup: ", (Throwable)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    @Override
    public void findCluster(StringBuilder sbClusters, StringBuilder sbUndir, StringBuilder sbCluas, StringBuilder sbNewas, StringBuilder sbDelta, int iDOP, String szTBS, String szOptions) throws SQLException {
        SQLAnalyticsGraph.findCluster((Connection)this.getOracle().getConnection(), this.getEdgeTabName(), sbClusters, sbUndir, sbCluas, sbNewas, sbDelta, iDOP, szTBS, szOptions);
    }

    public static void findCluster(Connection conn, String szEdgeTabName, StringBuilder sbClusters, StringBuilder sbUndir, StringBuilder sbCluas, StringBuilder sbNewas, StringBuilder sbDelta, int iDOP, String szTBS, String szOptions) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = conn.prepareCall("begin opg_apis.find_cc_mapping_based(:1, :2, :3, :4, :5, :6, :7,:8,:9,:10); end;");
            cs.setString(1, szEdgeTabName);
            cs.setString(2, sbClusters == null ? "" : Util.myCheckName((String)sbClusters.toString()));
            cs.setString(3, sbUndir == null ? "" : Util.myCheckName((String)sbUndir.toString()));
            cs.setString(4, sbCluas == null ? "" : Util.myCheckName((String)sbCluas.toString()));
            cs.setString(5, sbNewas == null ? "" : Util.myCheckName((String)sbNewas.toString()));
            cs.setString(6, sbDelta == null ? "" : Util.myCheckName((String)sbDelta.toString()));
            cs.setInt(7, iDOP);
            cs.setInt(8, 0);
            cs.setString(9, szTBS);
            cs.setString(10, ",PDML=T," + szOptions);
            cs.execute();
        }
        catch (SQLException sqle) {
            ms_log.debug((Object)"findClusters: ", (Throwable)sqle);
            throw sqle;
        }
        finally {
            OracleElementIteratorImpl.quietlyCloseStmt(cs);
        }
    }

    @Override
    public void collaborativeFilteringPrep(String szEdgeTabName, StringBuilder sbLeft, StringBuilder sbRight, StringBuilder sbLeft1, StringBuilder sbRight1, StringBuilder sbMatrixProduct, StringBuilder sbLeftDelta, StringBuilder sbRightDelta, String szOptions) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = this.getOracle().getConnection().prepareCall("begin opg_apis.cf_prep(:1, :2, :3, :4, :5, :6, :7, :8, :9); end;");
            cs.setString(1, szEdgeTabName);
            cs.setString(2, sbLeft == null ? "" : sbLeft.toString());
            cs.setString(3, sbRight == null ? "" : sbRight.toString());
            cs.setString(4, sbLeft1 == null ? "" : sbLeft1.toString());
            cs.setString(5, sbRight1 == null ? "" : sbRight1.toString());
            cs.setString(6, sbMatrixProduct == null ? "" : sbMatrixProduct.toString());
            cs.setString(7, sbLeftDelta == null ? "" : sbLeftDelta.toString());
            cs.setString(8, sbRightDelta == null ? "" : sbRightDelta.toString());
            cs.setString(9, szOptions);
            cs.registerOutParameter(2, 12);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 12);
            cs.registerOutParameter(6, 12);
            cs.registerOutParameter(7, 12);
            cs.registerOutParameter(8, 12);
            cs.execute();
            String szLeft = cs.getString(2);
            ms_log.debug((Object)"collaborativeFilteringPrep: szLeft ", (Object)szLeft);
            sbLeft.setLength(0);
            sbLeft.append(szLeft);
            String szRight = cs.getString(3);
            ms_log.debug((Object)"collaborativeFilteringPrep: szRight ", (Object)szRight);
            sbRight.setLength(0);
            sbRight.append(szRight);
            String szLeft1 = cs.getString(4);
            ms_log.debug((Object)"collaborativeFilteringPrep: szLeft1 ", (Object)szLeft1);
            sbLeft1.setLength(0);
            sbLeft1.append(szLeft1);
            String szRight1 = cs.getString(5);
            ms_log.debug((Object)"collaborativeFilteringPrep: szRight1 ", (Object)szRight1);
            sbRight1.setLength(0);
            sbRight1.append(szRight1);
            String szMatrixProduct = cs.getString(6);
            ms_log.debug((Object)"collaborativeFilteringPrep: szMatrixProduct ", (Object)szMatrixProduct);
            sbMatrixProduct.setLength(0);
            sbMatrixProduct.append(szMatrixProduct);
            String szLeftDelta = cs.getString(7);
            ms_log.debug((Object)"collaborativeFilteringPrep: szLeftDelta ", (Object)szLeftDelta);
            sbLeftDelta.setLength(0);
            sbLeftDelta.append(szLeftDelta);
            String szRightDelta = cs.getString(8);
            ms_log.debug((Object)"collaborativeFilteringPrep: szRightDelta ", (Object)szRightDelta);
            sbRightDelta.setLength(0);
            sbRightDelta.append(szRightDelta);
        }
        catch (SQLException sqle) {
            try {
                ms_log.debug((Object)"collaborativeFilteringPrep: ", (Throwable)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    @Override
    public void collaborativeFiltering(String szEdgeTabName, String szLabel, String szRatingProperty, int iterations, double minError, int features, double learningRate, double decreaseRate, double regularizationParam, int dop, StringBuilder sbLeft, StringBuilder sbRight, StringBuilder sbLeft1, StringBuilder sbRight1, StringBuilder sbMatrixProduct, StringBuilder sbLeftDelta, StringBuilder sbRightDelta, String szTBS, String szOptions) throws SQLException {
        CallableStatement cs = null;
        try {
            ms_log.debug((Object)"collaborativeFiltering: prepare CS ", (Object)"");
            cs = this.getOracle().getConnection().prepareCall("begin opg_apis.cf(:1, :2, :3, :4, :5, :6, :7,:8,:9,:10, :11, :12, :13, :14, :15, :16, :17,:18,:19); end;");
            cs.setString(1, szEdgeTabName);
            cs.setString(2, szLabel == null ? "" : szLabel);
            cs.setString(3, szRatingProperty == null ? "" : szRatingProperty);
            cs.setInt(4, iterations);
            cs.setDouble(5, minError);
            cs.setInt(6, features);
            cs.setDouble(7, learningRate);
            cs.setDouble(8, decreaseRate);
            cs.setDouble(9, regularizationParam);
            cs.setInt(10, dop);
            cs.setString(11, sbLeft == null ? "" : Util.myCheckName((String)sbLeft.toString()));
            cs.setString(12, sbRight == null ? "" : Util.myCheckName((String)sbRight.toString()));
            cs.setString(13, sbLeft1 == null ? "" : Util.myCheckName((String)sbLeft1.toString()));
            cs.setString(14, sbRight1 == null ? "" : Util.myCheckName((String)sbRight1.toString()));
            cs.setString(15, sbMatrixProduct == null ? "" : Util.myCheckName((String)sbMatrixProduct.toString()));
            cs.setString(16, sbLeftDelta == null ? "" : Util.myCheckName((String)sbLeftDelta.toString()));
            cs.setString(17, sbRightDelta == null ? "" : Util.myCheckName((String)sbRightDelta.toString()));
            cs.setString(18, szTBS);
            cs.setString(19, ",PDML=T," + szOptions);
            cs.registerOutParameter(11, 12);
            cs.registerOutParameter(12, 12);
            cs.registerOutParameter(13, 12);
            cs.registerOutParameter(14, 12);
            cs.registerOutParameter(15, 12);
            cs.registerOutParameter(16, 12);
            cs.registerOutParameter(17, 12);
            cs.execute();
            ms_log.debug((Object)"collaborativeFiltering: executed CS ", (Object)cs.toString());
        }
        catch (SQLException sqle) {
            try {
                ms_log.debug((Object)"collaborativeFiltering: ", (Throwable)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    public Double collaborativeFilteringCheckIntermediateError(double regularizationParam, int dop, StringBuilder sbMatrixProduct) throws SQLException {
        Double d;
        PreparedStatement ps;
        block5: {
            ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT  /*+ parallel(");
            query.append(dop);
            query.append(") */ SQRT(SUM((w1-w2)*(w1-w2) + ");
            query.append(regularizationParam);
            query.append(" / 2*(err_reg_L+err_reg_R))) as er FROM ");
            query.append(Util.myCheckName((String)sbMatrixProduct.toString()));
            ms_log.debug((Object)"collaborativeFilteringCheckIntermediateError: query ", (Object)query.toString());
            ps = this.getOracle().getConnection().prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next() || rs.getString("er") == null || rs.getString("er").equalsIgnoreCase("null")) break block5;
            Double d2 = rs.getDouble("er");
            OracleElementIteratorImpl.quietlyCloseStmt(ps);
            return d2;
        }
        try {
            d = null;
        }
        catch (SQLException sqle) {
            try {
                ms_log.debug((Object)"collaborativeFilteringCleanup: ", (Throwable)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(ps);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(ps);
        return d;
    }

    public Double collaborativeFilteringGetRecommendation(String szEdgeTabName, int dop, long srcVertex, long dstVertex, StringBuilder sbLeft, StringBuilder sbRight) throws SQLException {
        Double d;
        PreparedStatement ps;
        block5: {
            ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT  /*+ parallel(");
            query.append(dop);
            query.append(") */ L.C, R.P, MIN(e.VN) as real, sum(L.V * R.V) as prediction ");
            query.append(" FROM ");
            query.append(Util.myCheckName((String)szEdgeTabName));
            query.append(" E, ");
            query.append(Util.myCheckName((String)sbLeft.toString()));
            query.append(" L, ");
            query.append(Util.myCheckName((String)sbRight.toString()));
            query.append(" R ");
            query.append(" where L.K = R.K and L.C = E.svid(+) and R.P = E.dvid(+) and L.C = ");
            query.append(srcVertex);
            query.append(" and R.P = ");
            query.append(dstVertex);
            query.append(" group by L.C, R.P ");
            ms_log.debug((Object)"collaborativeFilteringGetRecommendation: query ", (Object)query.toString());
            ps = this.getOracle().getConnection().prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next() || rs.getString("prediction") == null || rs.getString("prediction").equalsIgnoreCase("null")) break block5;
            Double d2 = rs.getDouble("prediction");
            OracleElementIteratorImpl.quietlyCloseStmt(ps);
            return d2;
        }
        try {
            d = null;
        }
        catch (SQLException sqle) {
            try {
                ms_log.debug((Object)"collaborativeFilteringCleanup: ", (Throwable)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(ps);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(ps);
        return d;
    }

    @Override
    public void collaborativeFilteringCleanup(String szEdgeTabName, StringBuilder sbLeft, StringBuilder sbRight, StringBuilder sbLeft1, StringBuilder sbRight1, StringBuilder sbMatrixProduct, StringBuilder sbLeftDelta, StringBuilder sbRightDelta, String szOptions) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = this.getOracle().getConnection().prepareCall("begin opg_apis.cf_cleanup(:1, :2, :3, :4, :5, :6, :7, :8, :9); end;");
            cs.setString(1, szEdgeTabName);
            cs.setString(2, sbLeft == null ? "" : sbLeft.toString());
            cs.setString(3, sbRight == null ? "" : sbRight.toString());
            cs.setString(4, sbLeft1 == null ? "" : sbLeft1.toString());
            cs.setString(5, sbRight1 == null ? "" : sbRight1.toString());
            cs.setString(6, sbMatrixProduct == null ? "" : sbMatrixProduct.toString());
            cs.setString(7, sbLeftDelta == null ? "" : sbLeftDelta.toString());
            cs.setString(8, sbRightDelta == null ? "" : sbRightDelta.toString());
            cs.setString(9, szOptions);
            cs.registerOutParameter(2, 12);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 12);
            cs.registerOutParameter(6, 12);
            cs.registerOutParameter(7, 12);
            cs.registerOutParameter(8, 12);
            cs.execute();
        }
        catch (SQLException sqle) {
            try {
                ms_log.debug((Object)"collaborativeFilteringCleanup: ", (Throwable)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    public abstract Oracle getOracle();

    public static enum Sort {
        ASC,
        DESC;

    }
}

