/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OracleElementBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.Util;
import oracle.pg.common.messages.MesgConsts;
import oracle.pg.rdbms.OracleElementIteratorImpl;
import oracle.pg.rdbms.OraclePropertyGraph;
import oracle.pg.rdbms.Parameters;
import oracle.pg.text.OracleAutoIndex;
import oracle.pg.text.OracleIndex;
import oracle.pg.text.OracleIndexManager;
import oracle.pg.text.Parameter;

public class RDBMSIndexManager
extends OracleIndexManager
implements MesgConsts {
    private static SimpleLog ms_log = SimpleLog.getLog(RDBMSIndexManager.class);
    private static boolean ms_bDebug = ms_log.isDebugEnabled();
    private OraclePropertyGraph m_opgOracle;
    private boolean ms_bShowProgress = Parameters.getInstance().showProgress();
    private static final int ms_iOracleTextIndex = 2;
    private CallableStatement m_csInsOraText = null;
    private CallableStatement m_csDeleteIdxMetadata = null;
    private CallableStatement m_csDeleteIdxMetadatawPropertyName = null;
    private CallableStatement m_csContainsIdxKey = null;
    private CallableStatement m_csExistIndexByName = null;
    private CallableStatement m_csExistIndexByNameAndET = null;
    private CallableStatement m_csExistIndicesByETAndIT = null;
    private CallableStatement m_csGetIndexByNameETAndIT = null;
    private CallableStatement m_csGetIndicesByETAndIT = null;
    private CallableStatement m_csGetIndicesByIT = null;
    private CallableStatement m_csGetAllIndices = null;
    private CallableStatement m_csGetIndexedKeys = null;
    private CallableStatement m_csGetIndexByName = null;
    private String m_szDeleteIdxMetadata = null;
    private String m_szDeleteIdxMetadatawPropertyName = null;
    private String m_szInsertOraText = null;
    private String m_szExistIndexByName = null;
    private String m_szExistIndexByNameAndET = null;
    private String m_szExistIndicesByETAndIT = null;
    private String m_szGetIndexByNameETAndIT = null;
    private String m_szGetAllIndices = null;
    private String m_szGetIndicesByETAndIT = null;
    private String m_szGetIndicesByIT = null;
    private String m_szGetIndexByName = null;

    public final void close() {
        super.close();
        this.closeStatements();
    }

    private final void closeStatements() {
        OracleElementIteratorImpl.quietlyCloseStmt(this.m_csInsOraText);
        OracleElementIteratorImpl.quietlyCloseStmt(this.m_csDeleteIdxMetadata);
        OracleElementIteratorImpl.quietlyCloseStmt(this.m_csDeleteIdxMetadatawPropertyName);
        OracleElementIteratorImpl.quietlyCloseStmt(this.m_csContainsIdxKey);
        OracleElementIteratorImpl.quietlyCloseStmt(this.m_csExistIndexByName);
        OracleElementIteratorImpl.quietlyCloseStmt(this.m_csExistIndexByNameAndET);
        OracleElementIteratorImpl.quietlyCloseStmt(this.m_csExistIndicesByETAndIT);
        OracleElementIteratorImpl.quietlyCloseStmt(this.m_csGetIndexByNameETAndIT);
        OracleElementIteratorImpl.quietlyCloseStmt(this.m_csGetIndicesByETAndIT);
        OracleElementIteratorImpl.quietlyCloseStmt(this.m_csGetIndicesByIT);
        OracleElementIteratorImpl.quietlyCloseStmt(this.m_csGetIndexedKeys);
        OracleElementIteratorImpl.quietlyCloseStmt(this.m_csGetIndexByName);
        OracleElementIteratorImpl.quietlyCloseStmt(this.m_csGetAllIndices);
    }

    public RDBMSIndexManager(OraclePropertyGraph opg) {
        super((OraclePropertyGraphBase)opg);
        this.m_opgOracle = (OraclePropertyGraph)this.m_opg;
        this.initStatements();
        if (this.existsAutoIndexInDB(OracleVertexBase.class)) {
            ms_log.debug((Object)"constructor: get existing auto vertex index from DB");
            this.m_vertexAutoIndex = null;
        }
        if (this.existsAutoIndexInDB(OracleEdgeBase.class)) {
            ms_log.debug((Object)"constructor: get existing auto edge index from DB");
            this.m_edgeAutoIndex = null;
        }
        ms_log.debug((Object)"constructor: done");
    }

    @Deprecated
    public void commitIndices() {
        OracleIndex index;
        if (ms_bDebug) {
            ms_log.debug((Object)"commitIndices: commit opened indexes");
        }
        ms_log.debug((Object)"commitIndices: skip refresh  indices cache, we must have called in opg.commit");
        Object[] cachedIndices = null;
        if (ms_bDebug) {
            ms_log.debug((Object)"commitIndices: get lock for manual vertex indices cache");
        }
        this.m_vertexIndexCacheLock.lock();
        if (this.m_vertexIndices != null && !this.m_vertexIndices.isEmpty()) {
            for (Object obj : cachedIndices = this.m_vertexIndices.values().toArray()) {
                index = (OracleIndex)obj;
                if (ms_bDebug) {
                    ms_log.debug((Object)("commitIndices: commit index " + index.getIndexName()));
                }
                index.commit();
            }
            if (ms_bDebug) {
                ms_log.debug((Object)"commitIndices: release lock  for manual vertex indices cache");
            }
        }
        this.m_vertexIndexCacheLock.unlock();
        if (ms_bDebug) {
            ms_log.debug((Object)"commitIndices: get lock for manual edge indices cache");
        }
        this.m_edgeIndexCacheLock.lock();
        if (this.m_edgeIndices != null && !this.m_edgeIndices.isEmpty()) {
            for (Object obj : cachedIndices = this.m_edgeIndices.values().toArray()) {
                index = (OracleIndex)obj;
                if (ms_bDebug) {
                    ms_log.debug((Object)("commitIndices: commit index " + index.getIndexName()));
                }
                index.commit();
            }
            if (ms_bDebug) {
                ms_log.debug((Object)"commitIndices: release lock  for manual edge indices cache");
            }
        }
        this.m_edgeIndexCacheLock.unlock();
        if (this.getVertexAutoIndexer(new Parameter[0]) != null) {
            if (ms_bDebug) {
                ms_log.debug((Object)"commitIndices: commit vertex auto index ", (Object)this.m_vertexAutoIndex.getIndexName());
            }
            this.m_vertexAutoIndex.commit();
        }
        if (this.getEdgeAutoIndexer(new Parameter[0]) != null) {
            if (ms_bDebug) {
                ms_log.debug((Object)"commitIndices: commit edge auto index ", (Object)this.m_edgeAutoIndex.getIndexName());
            }
            this.m_edgeAutoIndex.commit();
        }
        if (ms_bDebug) {
            ms_log.debug((Object)"commitIndices: done... ");
        }
    }

    public void initStatements() {
        ms_log.debug((Object)"initStatements: started");
        this.m_szInsertOraText = "\n begin \n opg_apis.add_index_metadata_oratext(:1, :2, :3, :4, :5,  :6, :7, :8, :9, :10, :11, :12, :13, :14, :15);\n end;";
        this.m_szDeleteIdxMetadata = "\n begin \n opg_apis.delete_index_metadata(:1, :2, :3);\n end;";
        this.m_szDeleteIdxMetadatawPropertyName = "\n begin \n opg_apis.delete_index_metadata_key(:1, :2, :3, :4);\n end;";
        String szCheckedOwner = this.getQuotedGraphOwner();
        String szCheckedIdxTab = this.getQuotedIndexTabName();
        this.m_szExistIndexByName = "select EIN from " + szCheckedOwner + "." + szCheckedIdxTab + " where EIN = ? ";
        this.m_szExistIndexByNameAndET = this.m_szExistIndexByName + " and ET = ?";
        this.m_szExistIndicesByETAndIT = " select EIN from " + szCheckedOwner + "." + szCheckedIdxTab + " where  ET = ? and IT = ? ";
        this.m_szGetAllIndices = " select * from " + szCheckedOwner + "." + szCheckedIdxTab + " order by EIN ";
        this.m_szGetIndexByName = " select * from " + szCheckedOwner + "." + szCheckedIdxTab + " where EIN = ? ";
        this.m_szGetIndexByNameETAndIT = this.m_szGetIndexByName + " and  ET = ? and IT = ? order by EIN ";
        this.m_szGetIndicesByETAndIT = " select * from " + szCheckedOwner + "." + szCheckedIdxTab + " where IT = ?  and ET = ?  order by EIN ";
        this.m_szGetIndicesByIT = " select * from " + szCheckedOwner + "." + szCheckedIdxTab + " where IT = ?  order by EIN ";
        if (ms_bDebug) {
            ms_log.debug((Object)"initStatements: done");
        }
    }

    private String getQuotedGraphOwner() {
        try {
            return Util.enquoteNameSQLName((Connection)this.m_opgOracle.getOracle().getConnection(), (String)this.m_opgOracle.getGraphOwner());
        }
        catch (SQLException sqle) {
            ms_log.debug((Object)"getQuotedGraphOwner: ", (Throwable)sqle);
            throw new OraclePropertyGraphException((Throwable)sqle);
        }
    }

    private String getQuotedIndexTabName() {
        try {
            return Util.enquoteNameSQLName((Connection)this.m_opgOracle.getOracle().getConnection(), (String)this.getIndexTabName());
        }
        catch (SQLException sqle) {
            ms_log.debug((Object)"getQuotedIndexTabName: ", (Throwable)sqle);
            throw new OraclePropertyGraphException((Throwable)sqle);
        }
    }

    private String buildContainsIdxKeyQuery() {
        String szCheckedOwner = this.getQuotedGraphOwner();
        String szCheckedIdxTab = this.getQuotedIndexTabName();
        return " select K from " + szCheckedOwner + "." + szCheckedIdxTab + " where EIN = ? and K = ? and ET = ?";
    }

    private String buildGetIndexedKeysQuery() {
        String szCheckedOwner = this.getQuotedGraphOwner();
        String szCheckedIdxTab = this.getQuotedIndexTabName();
        return " select K from " + szCheckedOwner + "." + szCheckedIdxTab + " where EIN = ? ";
    }

    protected <T extends OracleElementBase> void addIndexMetadata(OracleIndex<T> index, String szPropertyName) {
        if (index == null) {
            if (ms_bDebug) {
                ms_log.debug((Object)"addKeyIndexMetadata: index is null, do nothing");
            }
            return;
        }
        if (ms_bDebug) {
            ms_log.debug((Object)"addKeyIndexMetadata: start with index ", (Object)index.getIndexName());
        }
    }

    @Deprecated
    public void refreshIndices(long lStartSCN, long lEndSCN) {
        if (ms_bDebug) {
            ms_log.debug((Object)"autoRefreshIndices: auto refresh opened indexes");
        }
        this.refreshIndicesCache();
        if (ms_bDebug) {
            ms_log.debug((Object)"autoRefreshIndices: vertex indices opened, auto-refresh them");
        }
        for (OracleIndex index : this.m_vertexIndices.values()) {
            if (index == null) continue;
            if (ms_bDebug) {
                ms_log.debug((Object)"autoRefreshIndices: auto-refresh index ", (Object)index.getIndexName());
            }
            index.refreshIndex(lStartSCN, lEndSCN);
        }
        this.m_vertexIndices = null;
        if (this.m_edgeIndices != null) {
            if (ms_bDebug) {
                ms_log.debug((Object)"autoRefreshIndices: edge indices opened, auto-refresh them");
            }
            for (OracleIndex index : this.m_edgeIndices.values()) {
                if (index == null) continue;
                if (ms_bDebug) {
                    ms_log.debug((Object)"autoRefreshIndices: auto-refresh index ", (Object)index.getIndexName());
                }
                index.refreshIndex(lStartSCN, lEndSCN);
            }
            this.m_edgeIndices = null;
        }
        if (this.getVertexAutoIndexer(new Parameter[0]) != null) {
            if (ms_bDebug) {
                ms_log.debug((Object)("autoRefreshIndices: auto-refresh vertex auto index " + this.m_vertexAutoIndex.getIndexName()));
            }
            this.m_vertexAutoIndex.refreshIndex(lStartSCN, lEndSCN);
        }
        if (this.getEdgeAutoIndexer(new Parameter[0]) != null) {
            if (ms_bDebug) {
                ms_log.debug((Object)("autoRefreshIndices: auto-refresh auto index " + this.m_edgeAutoIndex.getIndexName()));
            }
            this.m_edgeAutoIndex.refreshIndex(lStartSCN, lEndSCN);
        }
    }

    private CallableStatement getCSForContainsIdxKey() {
        try {
            if (this.m_csContainsIdxKey == null || this.m_csContainsIdxKey.isClosed()) {
                this.m_csContainsIdxKey = this.m_opgOracle.getOracle().getConnection().prepareCall(this.buildContainsIdxKeyQuery());
            }
            return this.m_csContainsIdxKey;
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException((Throwable)e);
        }
    }

    @Deprecated
    public <T extends OracleElementBase> boolean containsIndexedKeyFromDB(String szPropertyName, String indexName, Class<T> indexClass) {
        boolean bl;
        ResultSet rs;
        block12: {
            CallableStatement stmt;
            block10: {
                boolean bl2;
                block11: {
                    rs = null;
                    stmt = null;
                    if (ms_bDebug) {
                        ms_log.debug((Object)("containsIndexedKey: prepare callable statement for query ----- for auto index " + indexName + " and key -----"));
                    }
                    stmt = this.getCSForContainsIdxKey();
                    stmt.clearParameters();
                    ((OraclePreparedStatement)stmt).setFormOfUse(1, (short)2);
                    stmt.setString(1, indexName);
                    ((OraclePreparedStatement)stmt).setFormOfUse(2, (short)2);
                    stmt.setString(2, szPropertyName);
                    stmt.setInt(3, RDBMSIndexManager.getEntityTypeAsInt(indexClass));
                    rs = stmt.executeQuery();
                    if (rs == null || !rs.next()) break block10;
                    if (ms_bDebug) {
                        ms_log.debug((Object)"containsIndexedKey: key used in this auto index");
                    }
                    bl2 = true;
                    if (!ms_bDebug) break block11;
                    ms_log.debug((Object)"containsIndexedKey: done .................... ");
                }
                OracleElementIteratorImpl.quietlyCloseResultSet(rs);
                return bl2;
            }
            try {
                if (ms_bDebug) {
                    ms_log.debug((Object)"containsIndexedKey: key not used in this auto index");
                }
                bl = false;
                if (!ms_bDebug) break block12;
            }
            catch (SQLException e) {
                try {
                    if (ms_log.isErrorEnabled()) {
                        ms_log.error((Object)"containsIndexedKey: SQL statement cannot be executed. Exception is ", (Throwable)e);
                    }
                    OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
                    throw new OraclePropertyGraphException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)"containsIndexedKey: done .................... ");
                    }
                    OracleElementIteratorImpl.quietlyCloseResultSet(rs);
                    throw throwable;
                }
            }
            ms_log.debug((Object)"containsIndexedKey: done .................... ");
        }
        OracleElementIteratorImpl.quietlyCloseResultSet(rs);
        return bl;
    }

    private CallableStatement getCSForDeleteIdxMetadata() {
        try {
            if (this.m_csDeleteIdxMetadata == null || this.m_csDeleteIdxMetadata.isClosed()) {
                this.m_csDeleteIdxMetadata = this.m_opgOracle.getOracle().getConnection().prepareCall(this.m_szDeleteIdxMetadata);
            }
            return this.m_csDeleteIdxMetadata;
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException((Throwable)e);
        }
    }

    private CallableStatement getCSForDeleteIdxMetadatawPropertyName() {
        try {
            if (this.m_csDeleteIdxMetadatawPropertyName == null || this.m_csDeleteIdxMetadatawPropertyName.isClosed()) {
                this.m_csDeleteIdxMetadatawPropertyName = this.m_opgOracle.getOracle().getConnection().prepareCall(this.m_szDeleteIdxMetadatawPropertyName);
            }
            return this.m_csDeleteIdxMetadatawPropertyName;
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException((Throwable)e);
        }
    }

    protected <T extends OracleElementBase> void deleteIndexMetadata(String indexName, String szPropertyName, Class<T> indexClass) {
        CallableStatement cs = null;
        try {
            String szDDL = null;
            if (szPropertyName != null) {
                if (ms_bDebug) {
                    ms_log.debug((Object)("deleteIndexMetadata: prepare callable statement ----- for index " + indexName + " and key -----"));
                }
                szDDL = this.m_szDeleteIdxMetadatawPropertyName;
                cs = this.getCSForDeleteIdxMetadatawPropertyName();
            } else {
                if (ms_bDebug) {
                    ms_log.debug((Object)("deleteIndexMetadata: prepare callable statement ----- for index " + indexName));
                }
                szDDL = this.m_szDeleteIdxMetadata;
                cs = this.getCSForDeleteIdxMetadata();
            }
            cs.clearParameters();
            ((OracleCallableStatement)cs).setFormOfUse(1, (short)2);
            cs.setString(1, indexName);
            if (szPropertyName != null) {
                ((OracleCallableStatement)cs).setFormOfUse(2, (short)2);
                cs.setString(2, szPropertyName);
                ((OracleCallableStatement)cs).setFormOfUse(3, (short)2);
                cs.setString(3, this.m_opgOracle.getGraphOwner());
                ((OracleCallableStatement)cs).setFormOfUse(4, (short)2);
                cs.setString(4, this.m_opgOracle.getGraphName());
            } else {
                ((OracleCallableStatement)cs).setFormOfUse(2, (short)2);
                cs.setString(2, this.m_opgOracle.getGraphOwner());
                ((OracleCallableStatement)cs).setFormOfUse(3, (short)2);
                cs.setString(3, this.m_opgOracle.getGraphName());
            }
            cs.execute();
        }
        catch (SQLException e) {
            if (ms_log.isErrorEnabled()) {
                ms_log.error((Object)("deleteIndexMetadata: index meta data cannot be removed,  with index " + indexName + " key ------, graph name " + this.m_opgOracle.getGraphName() + ", graph owner " + this.m_opgOracle.getGraphOwner() + ". Exception is "), (Throwable)e);
            }
            OracleElementIteratorImpl.quietlyCloseStmt(cs);
            throw new OraclePropertyGraphException((Throwable)e);
        }
        finally {
            if (ms_bDebug) {
                ms_log.debug((Object)"deleteIndexMetadata: done.........");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dropIndexMetadata() {
        CallableStatement cs;
        block9: {
            if (ms_bDebug) {
                ms_log.debug((Object)"dropIndicesMetadata: executed");
            }
            cs = null;
            if (ms_bDebug) {
                ms_log.debug((Object)"dropIndicesMetadata: delete indices from table");
            }
            try {
                if (ms_bDebug) {
                    ms_log.debug((Object)"dropIndexMetadata: commit operations before truncate ");
                }
                cs = this.m_opgOracle.getOracle().getConnection().prepareCall("begin opg_apis.clear_pg_indices(:1); end;");
                cs.setString(1, this.m_opgOracle.getGraphName());
                cs.execute();
                if (!ms_bDebug) break block9;
            }
            catch (SQLException e) {
                try {
                    if (ms_log.isErrorEnabled()) {
                        ms_log.error((Object)"dropIndicesMetadata: index meta data cannot be removed, Exception is ", (Throwable)e);
                    }
                    OracleElementIteratorImpl.quietlyCloseStmt(cs);
                    throw new OraclePropertyGraphException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)"dropIndicesMetadata: close SQL statement");
                    }
                    OracleElementIteratorImpl.quietlyCloseStmt(cs);
                    throw throwable;
                }
            }
            ms_log.debug((Object)"dropIndicesMetadata: close SQL statement");
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    private CallableStatement getCSForExistIndexByName() {
        try {
            if (this.m_csExistIndexByName == null || this.m_csExistIndexByName.isClosed()) {
                this.m_csExistIndexByName = this.m_opgOracle.getOracle().getConnection().prepareCall(this.m_szExistIndexByName);
            }
            return this.m_csExistIndexByName;
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException((Throwable)e);
        }
    }

    private CallableStatement getCSForExistIndexByNameAndET() {
        try {
            if (this.m_csExistIndexByNameAndET == null || this.m_csExistIndexByNameAndET.isClosed()) {
                this.m_csExistIndexByNameAndET = this.m_opgOracle.getOracle().getConnection().prepareCall(this.m_szExistIndexByNameAndET);
            }
            return this.m_csExistIndexByNameAndET;
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException((Throwable)e);
        }
    }

    protected <T extends OracleElementBase> boolean existsIndexInDB(String indexName, Class<T> indexClass) {
        boolean bl;
        ResultSet rs;
        block16: {
            CallableStatement stmt;
            block14: {
                boolean bl2;
                block15: {
                    rs = null;
                    stmt = null;
                    if (indexClass != null) {
                        if (ms_bDebug) {
                            ms_log.debug((Object)"existsIndexInDB: prepare callable statement ", (Object)(this.m_szExistIndexByNameAndET + " with index " + indexName + " and class " + indexClass));
                        }
                        stmt = this.getCSForExistIndexByNameAndET();
                    } else {
                        if (ms_bDebug) {
                            ms_log.debug((Object)"existsIndexInDB: prepare callable statement ", (Object)(this.m_szExistIndexByName + " with index " + indexName));
                        }
                        stmt = this.getCSForExistIndexByName();
                    }
                    stmt.clearParameters();
                    ((OraclePreparedStatement)stmt).setFormOfUse(1, (short)2);
                    stmt.setString(1, indexName);
                    if (indexClass != null) {
                        stmt.setInt(2, RDBMSIndexManager.getEntityTypeAsInt(indexClass));
                    }
                    if (ms_bDebug) {
                        ms_log.debug((Object)"existsIndexInDB: execute query");
                    }
                    if ((rs = stmt.executeQuery()) == null || !rs.next()) break block14;
                    if (ms_bDebug) {
                        ms_log.debug((Object)"existsIndexInDB: index exists, return true");
                    }
                    bl2 = true;
                    if (!ms_bDebug) break block15;
                    ms_log.debug((Object)"existsIndexInDB: done .................... ");
                }
                OracleElementIteratorImpl.quietlyCloseResultSet(rs);
                return bl2;
            }
            try {
                if (ms_bDebug) {
                    ms_log.debug((Object)"existsIndexInDB: index is not defined in the database, return false");
                }
                bl = false;
                if (!ms_bDebug) break block16;
            }
            catch (SQLException e) {
                try {
                    ms_log.error((Object)"existsIndexInDB: SQL statement cannot be executed. Exception is ", (Throwable)e);
                    OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
                    throw new OraclePropertyGraphException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)"existsIndexInDB: done .................... ");
                    }
                    OracleElementIteratorImpl.quietlyCloseResultSet(rs);
                    throw throwable;
                }
            }
            ms_log.debug((Object)"existsIndexInDB: done .................... ");
        }
        OracleElementIteratorImpl.quietlyCloseResultSet(rs);
        return bl;
    }

    private CallableStatement getCSForExistIndicesByETAndIT() {
        try {
            if (this.m_csExistIndicesByETAndIT == null || this.m_csExistIndicesByETAndIT.isClosed()) {
                this.m_csExistIndicesByETAndIT = this.m_opgOracle.getOracle().getConnection().prepareCall(this.m_szExistIndicesByETAndIT);
            }
            return this.m_csExistIndicesByETAndIT;
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException((Throwable)e);
        }
    }

    protected <T extends OracleElementBase> boolean existsIndexesInDB(Class<T> indexClass, boolean isAutoIndex) {
        boolean bl;
        ResultSet rs;
        block14: {
            CallableStatement stmt;
            block12: {
                boolean bl2;
                block13: {
                    rs = null;
                    stmt = null;
                    if (ms_bDebug) {
                        ms_log.debug((Object)("existsIndexInDB: prepare callable statement " + this.m_szExistIndicesByETAndIT), (Object)(" with class " + indexClass + " and index type " + (isAutoIndex ? "auto" : "manual")));
                    }
                    stmt = this.getCSForExistIndicesByETAndIT();
                    stmt.clearParameters();
                    stmt.setInt(1, RDBMSIndexManager.getEntityTypeAsInt(indexClass));
                    if (isAutoIndex) {
                        stmt.setInt(2, 1);
                    } else {
                        stmt.setInt(2, 0);
                    }
                    if (ms_bDebug) {
                        ms_log.debug((Object)"existsIndexesInDB: execute query");
                    }
                    if ((rs = stmt.executeQuery()) == null || !rs.next()) break block12;
                    if (ms_bDebug) {
                        ms_log.debug((Object)"existsIndexesInDB: index exists, return true");
                    }
                    bl2 = true;
                    if (!ms_bDebug) break block13;
                    ms_log.debug((Object)"existsIndexInDB: done .................... ");
                }
                OracleElementIteratorImpl.quietlyCloseResultSet(rs);
                return bl2;
            }
            try {
                if (ms_bDebug) {
                    ms_log.debug((Object)"existsIndexesInDB: index is not defined in the database, return false");
                }
                bl = false;
                if (!ms_bDebug) break block14;
            }
            catch (SQLException e) {
                try {
                    ms_log.error((Object)"existsIndexesInDB: SQL statement cannot be executed. Exception is ", (Throwable)e);
                    OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
                    throw new OraclePropertyGraphException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)"existsIndexInDB: done .................... ");
                    }
                    OracleElementIteratorImpl.quietlyCloseResultSet(rs);
                    throw throwable;
                }
            }
            ms_log.debug((Object)"existsIndexInDB: done .................... ");
        }
        OracleElementIteratorImpl.quietlyCloseResultSet(rs);
        return bl;
    }

    private boolean existsIndexTable() {
        boolean bl;
        CallableStatement stmt;
        ResultSet rs;
        block13: {
            block11: {
                boolean bl2;
                block12: {
                    rs = null;
                    stmt = null;
                    String szQuery = "select table_name from all_tables where table_name = ? and owner=?";
                    if (ms_bDebug) {
                        ms_log.debug((Object)("existsIndexTable: prepare callable statement " + szQuery), (Object)(" for indexTable " + this.getIndexTabName()));
                    }
                    stmt = this.m_opgOracle.getOracle().getConnection().prepareCall(szQuery);
                    stmt.setString(1, this.getIndexTabName().toUpperCase());
                    stmt.setString(2, this.m_opgOracle.getGraphOwner().toUpperCase());
                    if (ms_bDebug) {
                        ms_log.debug((Object)"existsIndexTable: execute query");
                    }
                    if ((rs = stmt.executeQuery()) == null || !rs.next()) break block11;
                    if (ms_bDebug) {
                        ms_log.debug((Object)"existsIndexTable: index table exists, return true");
                    }
                    bl2 = true;
                    if (!ms_bDebug) break block12;
                    ms_log.debug((Object)"existsIndexTable: done .................... ");
                }
                OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
                return bl2;
            }
            try {
                if (ms_bDebug) {
                    ms_log.debug((Object)"existsIndexTable: index is not defined in the database, return false");
                }
                bl = false;
                if (!ms_bDebug) break block13;
            }
            catch (SQLException e) {
                try {
                    if (ms_bDebug) {
                        ms_log.error((Object)"existsIndexTable: SQL Statement cannot be executed, Exception is ", (Throwable)e);
                    }
                    OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
                    throw new OraclePropertyGraphException();
                }
                catch (Throwable throwable) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)"existsIndexTable: done .................... ");
                    }
                    OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
                    throw throwable;
                }
            }
            ms_log.debug((Object)"existsIndexTable: done .................... ");
        }
        OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
        return bl;
    }

    protected <T extends OracleElementBase> OracleAutoIndex<T> getAutoIndexFromDB(String indexName, Class<T> indexClass) {
        return null;
    }

    private CallableStatement getCSForGetIndexedKeys() {
        try {
            if (this.m_csGetIndexedKeys == null || this.m_csGetIndexedKeys.isClosed()) {
                this.m_csGetIndexedKeys = this.m_opgOracle.getOracle().getConnection().prepareCall(this.buildGetIndexedKeysQuery());
            }
            return this.m_csGetIndexedKeys;
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException((Throwable)e);
        }
    }

    @Deprecated
    public <T extends OracleElementBase> List<String> getIndexedKeys(String indexName, Class<T> indexClass) {
        LinkedList<String> linkedList;
        ResultSet rs;
        block12: {
            CallableStatement stmt;
            block10: {
                List<String> list;
                block11: {
                    rs = null;
                    stmt = null;
                    if (ms_bDebug) {
                        ms_log.debug((Object)("loadIndexedKeys: prepare callable statement for query ----- and auto index " + indexName));
                    }
                    stmt = this.getCSForGetIndexedKeys();
                    stmt.clearParameters();
                    ((OraclePreparedStatement)stmt).setFormOfUse(1, (short)2);
                    stmt.setString(1, indexName);
                    rs = stmt.executeQuery();
                    if (rs != null) break block10;
                    ms_log.debug((Object)"loadIndexedKeys: no property names found for auto index");
                    OracleElementIteratorImpl.quietlyCloseResultSet(rs);
                    list = null;
                    if (!ms_bDebug) break block11;
                    ms_log.debug((Object)"loadIndexedKeys: done .................... ");
                }
                OracleElementIteratorImpl.quietlyCloseResultSet(rs);
                return list;
            }
            try {
                LinkedList<String> propertyNames = new LinkedList<String>();
                while (rs.next()) {
                    String szPropertyName = rs.getString(1);
                    if (ms_bDebug) {
                        ms_log.debug((Object)"loadIndexedKeys: found index -----");
                    }
                    if (szPropertyName == null) continue;
                    propertyNames.add(szPropertyName);
                }
                linkedList = propertyNames;
                if (!ms_bDebug) break block12;
            }
            catch (SQLException e) {
                try {
                    if (ms_log.isErrorEnabled()) {
                        ms_log.error((Object)"loadIndexedKeys: SQL statement cannot be executed. Exception is ", (Throwable)e);
                    }
                    OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
                    throw new OraclePropertyGraphException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)"loadIndexedKeys: done .................... ");
                    }
                    OracleElementIteratorImpl.quietlyCloseResultSet(rs);
                    throw throwable;
                }
            }
            ms_log.debug((Object)"loadIndexedKeys: done .................... ");
        }
        OracleElementIteratorImpl.quietlyCloseResultSet(rs);
        return linkedList;
    }

    protected OracleIndex getIndexFromDB(String index) {
        return null;
    }

    public String getIndexTabName() {
        return OraclePropertyGraph.getTextIndexTabName(this.m_opgOracle.getOracle(), this.m_opgOracle.getGraphName());
    }

    protected List<OracleIndex> getAllIndicesFromDB() {
        return null;
    }

    protected <T extends OracleElementBase> List<OracleIndex<T>> getIndicesFromDB(Class<T> indexClass) {
        return null;
    }

    protected OracleAutoIndex<OracleVertexBase> getVertexAutoIndexFromPG(Parameter[] params, boolean erase) {
        throw new UnsupportedOperationException("No engines are supported for automatic indexes");
    }

    protected OracleIndex<OracleVertexBase> getVertexIndexFromPG(String indexName, Parameter[] params, boolean erase) {
        throw new UnsupportedOperationException("No engines are supported for manual indexes");
    }

    protected OracleIndex<OracleEdgeBase> getEdgeIndexFromPG(String indexName, Parameter[] params, boolean erase) {
        throw new UnsupportedOperationException("No engines are supported for manual indexes");
    }

    protected OracleAutoIndex<OracleEdgeBase> getEdgeAutoIndexFromPG(Parameter[] params, boolean erase) {
        throw new UnsupportedOperationException("No engines are supported for automatic indexes");
    }

    protected void createIndexTable() {
        this.m_opgOracle = (OraclePropertyGraph)this.m_opg;
        if (!this.existsIndexTable()) {
            try {
                this.m_opgOracle.createIndexTable(false);
            }
            catch (SQLException e) {
                throw new OraclePropertyGraphException((Throwable)e);
            }
        }
    }

    @Deprecated
    public <T extends OracleElementBase> void stopAutoIndexingProperty(String szPropertyName, Class<T> elementClass) {
        if (OracleVertexBase.class.isAssignableFrom(elementClass) && this.containsIndexedKeyFromDB(szPropertyName, this.getVertexAutoIndexName(), OracleVertexBase.class)) {
            List<String> indexedKeys;
            if (ms_bDebug) {
                ms_log.debug((Object)"stopAutoIndexingProperty: remove key ----- from vertex auto index");
            }
            if (this.getVertexAutoIndexer(new Parameter[0]) instanceof OracleAutoIndex) {
                if (ms_bDebug) {
                    ms_log.debug((Object)"stopAutoIndexingProperty: Oracle text index, drop index");
                }
                this.deleteIndexMetadata(this.getVertexAutoIndexName(), szPropertyName, OracleVertexBase.class);
                this.getVertexAutoIndexer(new Parameter[0]).dropIndex();
                return;
            }
            this.deleteIndexMetadata(this.getVertexAutoIndexName(), szPropertyName, OracleVertexBase.class);
            if (ms_bDebug) {
                ms_log.debug((Object)"stopAutoIndexingProperty: reindex data with respect to key");
            }
            if ((indexedKeys = this.getIndexedKeys(this.getVertexAutoIndexName(), OracleVertexBase.class)) != null && indexedKeys.size() > 0) {
                this.getVertexAutoIndexer(new Parameter[0]).removeAll(szPropertyName);
            } else {
                this.disableVertexAutoIndexer();
            }
        } else if (OracleEdgeBase.class.isAssignableFrom(elementClass) && this.containsIndexedKeyFromDB(szPropertyName, this.getEdgeAutoIndexName(), OracleEdgeBase.class)) {
            List<String> indexedKeys;
            if (ms_bDebug) {
                ms_log.debug((Object)"stopAutoIndexingProperty: remove key ----- from edge auto index");
            }
            if (this.getVertexAutoIndexer(new Parameter[0]) instanceof OracleAutoIndex) {
                if (ms_bDebug) {
                    ms_log.debug((Object)"stopAutoIndexingProperty: Oracle text index, drop index");
                }
                this.deleteIndexMetadata(this.getEdgeAutoIndexName(), szPropertyName, OracleEdgeBase.class);
                this.getEdgeAutoIndexer(new Parameter[0]).dropIndex();
                return;
            }
            this.deleteIndexMetadata(this.getEdgeAutoIndexName(), szPropertyName, OracleEdgeBase.class);
            if (ms_bDebug) {
                ms_log.debug((Object)"stopAutoIndexingProperty: reindex data with respect to key");
            }
            if ((indexedKeys = this.getIndexedKeys(this.getEdgeAutoIndexName(), OracleEdgeBase.class)) != null && indexedKeys.size() > 0) {
                this.getEdgeAutoIndexer(new Parameter[0]).removeAll(szPropertyName);
            } else {
                this.disableEdgeAutoIndexer();
            }
        }
    }
}

