/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import oracle.pg.common.ParametersBase;
import oracle.pg.common.SimpleLog;

public class Parameters
extends ParametersBase {
    static SimpleLog ms_log = SimpleLog.getLog(Parameters.class);
    private static Parameters ms_parameters = new Parameters();
    static boolean bOptimizerGatherStasOff = "true".equalsIgnoreCase(System.getProperty("oracle.pg.rdbms.optimizerGatherStasOff"));
    static String m_szFormNCharSetting = System.getProperty("oracle.pg.rdbms.skipFormNCharSetting");
    static String ms_szInitialKVArraySize = System.getProperty("oracle.pg.rdbms.initialKVAS");
    static int ms_iInitialKVAS = 1;
    static String ms_szGrowthKVArraySize;
    static int ms_iGrowthKVAS;
    static String ms_szVertexCacheSize;
    static long ms_lVertexCacheSize;
    static String ms_szEdgeCacheSize;
    static long ms_lEdgeCacheSize;
    static String ms_szTmpWorkDir;
    static String ms_szDefaultTmpWorkDir;
    static String ms_iAbsThreshold;
    static int ms_iDefaultAbsThreshold;
    static String ms_dRelThreshold;
    static double ms_dDefaultRelThreshold;
    static String ms_szCachePtnNum;
    static int ms_iCachePtnNum;
    static boolean bShowProgress;
    static boolean bForce11g;
    static boolean bOrderBySDE;
    static boolean bSqlMonitor;
    static String ms_iDefPipeSize;
    static int ms_iDefaultDefPipeSize;
    static String ms_iDOP;
    static int ms_iDefaultDOP;
    static String ms_iDefaultDOPPerPtn;
    static int ms_iDefaultDefaultDOPPerPtn;
    static String ms_iRowPrefetch;
    static int ms_iDefaultRowPrefetch;
    static String ms_iCommitFreq;
    static int ms_iDefaultCommitFreq;

    public static Parameters getInstance() {
        return ms_parameters;
    }

    public boolean isOptimizerGatherStasOff() {
        return bOptimizerGatherStasOff;
    }

    public String getSkipFormNCharSetting() {
        return m_szFormNCharSetting;
    }

    int getInitialKVAS() {
        return ms_iInitialKVAS;
    }

    static String checkInput(String s) {
        if (s == null) {
            return s;
        }
        return s;
    }

    int getGrowthKVAS() {
        return ms_iGrowthKVAS;
    }

    long getVertexCacheSize() {
        return ms_lVertexCacheSize;
    }

    long getEdgeCacheSize() {
        return ms_lEdgeCacheSize;
    }

    public String getTmpWorkDir() {
        return ms_szDefaultTmpWorkDir;
    }

    int getAbsThreshold() {
        return ms_iDefaultAbsThreshold;
    }

    double getRelThreshold() {
        return ms_dDefaultRelThreshold;
    }

    int getCachePtnNum() {
        return ms_iCachePtnNum;
    }

    public boolean showProgress() {
        return bShowProgress;
    }

    public boolean force11g() {
        return bForce11g;
    }

    public boolean orderBySDE() {
        return bOrderBySDE;
    }

    public boolean isSqlMonitor() {
        return bSqlMonitor;
    }

    public String getTomcatDatasourcePrefix() {
        String s = System.getProperty("oracle.pg.rdbms.tomcatDatasourcePrefix");
        if (s == null || s.trim().length() == 0) {
            return "java:comp/env/";
        }
        return s;
    }

    String getTomcatEnvDetectionClassName() {
        String s = System.getProperty("oracle.pg.rdbms.tomcatEnvDetectionClassName");
        if (s == null || s.trim().length() == 0) {
            return "org.apache.catalina.ContainerServlet";
        }
        return s;
    }

    public String getJBossDatasourcePrefix() {
        String s = System.getProperty("oracle.pg.rdbms.jbossDatasourcePrefix");
        if (s == null || s.trim().length() == 0) {
            return "java:jboss/datasources/";
        }
        return s;
    }

    String getJBossEnvDetectionClassName() {
        String s = System.getProperty("oracle.pg.rdbms.jbossEnvDetectionClassName");
        if (s == null || s.trim().length() == 0) {
            return "org.jboss.as.naming.NamingContext";
        }
        return s;
    }

    public boolean getUseLuceneSyntax() {
        return !"false".equals(System.getProperty("oracle.pg.rdbms.useLuceneSyntax"));
    }

    int getDefPipeSize() {
        return ms_iDefaultDefPipeSize;
    }

    int getDOP() {
        return ms_iDefaultDOP;
    }

    int getDefaultDOPPerPtn() {
        return ms_iDefaultDefaultDOPPerPtn;
    }

    int getRowPrefetch() {
        return ms_iDefaultRowPrefetch;
    }

    public boolean getUseIteratorBalancer() {
        return "true".equals(System.getProperty("oracle.pg.rdbms.useIteratorBalancer"));
    }

    public int getDefaultCommitFreq() {
        return ms_iDefaultCommitFreq;
    }

    public boolean getUseDisjunctionInGetDegree() {
        return "true".equals(System.getProperty("oracle.pg.rdbms.useDisjunctionInGetDegree"));
    }

    public boolean getTreatTimestampTzAsStr() {
        return "true".equals(System.getProperty("oracle.pg.rdbms.treatTimestampTzAsStr"));
    }

    static {
        try {
            ms_iInitialKVAS = Integer.parseInt(ms_szInitialKVArraySize);
            if (ms_iInitialKVAS <= 0) {
                ms_iInitialKVAS = 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ms_szGrowthKVArraySize = System.getProperty("oracle.pg.rdbms.growthKVAS");
        ms_iGrowthKVAS = 2;
        try {
            ms_iGrowthKVAS = Integer.parseInt(ms_szGrowthKVArraySize);
            if (ms_iGrowthKVAS <= 0) {
                ms_iGrowthKVAS = 2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ms_szVertexCacheSize = System.getProperty("oracle.pg.rdbms.vertexCacheSize");
        ms_lVertexCacheSize = 4000L;
        try {
            ms_lVertexCacheSize = Long.parseLong(ms_szVertexCacheSize);
            if (ms_lVertexCacheSize <= 0L) {
                ms_lVertexCacheSize = 4000L;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ms_szEdgeCacheSize = System.getProperty("oracle.pg.rdbms.edgeCacheSize");
        ms_lEdgeCacheSize = 4000L;
        try {
            ms_lEdgeCacheSize = Long.parseLong(ms_szEdgeCacheSize);
            if (ms_lEdgeCacheSize <= 0L) {
                ms_lEdgeCacheSize = 4000L;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ms_szTmpWorkDir = System.getProperty("oracle.pg.rdbms.tmpWorkDir");
        ms_szDefaultTmpWorkDir = "/tmp";
        try {
            ms_szDefaultTmpWorkDir = ms_szTmpWorkDir;
            if (ms_szDefaultTmpWorkDir == null) {
                ms_szDefaultTmpWorkDir = "/tmp";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ms_iAbsThreshold = System.getProperty("oracle.pg.rdbms.absThreshold");
        ms_iDefaultAbsThreshold = 100;
        try {
            ms_iDefaultAbsThreshold = Integer.parseInt(ms_iAbsThreshold);
            if (ms_iDefaultAbsThreshold <= 0) {
                ms_iDefaultAbsThreshold = 100;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ms_dRelThreshold = System.getProperty("oracle.pg.rdbms.relThreshold");
        ms_dDefaultRelThreshold = 0.05;
        try {
            ms_dDefaultRelThreshold = Double.parseDouble(Parameters.checkInput(ms_dRelThreshold));
            if (ms_dDefaultRelThreshold <= 0.0) {
                ms_dDefaultRelThreshold = 0.05;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ms_szCachePtnNum = System.getProperty("oracle.pg.rdbms.cachePtnNum");
        ms_iCachePtnNum = 1;
        try {
            ms_iCachePtnNum = Integer.parseInt(ms_szCachePtnNum);
            if (ms_iCachePtnNum <= 0) {
                ms_iCachePtnNum = 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        bShowProgress = "true".equalsIgnoreCase(System.getProperty("oracle.pg.rdbms.showProgress"));
        bForce11g = "true".equalsIgnoreCase(System.getProperty("oracle.pg.rdbms.force11g"));
        bOrderBySDE = !"false".equalsIgnoreCase(System.getProperty("oracle.pg.rdbms.orderBySDE"));
        bSqlMonitor = "true".equalsIgnoreCase(System.getProperty("oracle.pg.rdbms.sqlMonitor"));
        ms_iDefPipeSize = System.getProperty("oracle.pg.rdbms.DefPipeSize");
        ms_iDefaultDefPipeSize = 0x200000;
        try {
            ms_iDefaultDefPipeSize = Integer.parseInt(ms_iDefPipeSize);
            if (ms_iDefaultDefPipeSize <= 0) {
                ms_iDefaultDefPipeSize = 0x200000;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ms_iDOP = System.getProperty("oracle.pg.rdbms.dop");
        ms_iDefaultDOP = 16;
        try {
            ms_iDefaultDOP = Integer.parseInt(ms_iDOP);
            if (ms_iDefaultDOP <= 0 && ms_iDefaultDOP > 256) {
                ms_iDefaultDOP = 16;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bShowProgress) {
            ms_log.info((Object)"getDOP: ", (Object)ms_iDefaultDOP);
        }
        ms_iDefaultDOPPerPtn = System.getProperty("oracle.pg.rdbms.defaultDOPPerPtn");
        ms_iDefaultDefaultDOPPerPtn = 1;
        try {
            ms_iDefaultDefaultDOPPerPtn = Integer.parseInt(ms_iDefaultDOPPerPtn);
            if (ms_iDefaultDefaultDOPPerPtn <= 0 && ms_iDefaultDefaultDOPPerPtn > 64) {
                ms_iDefaultDefaultDOPPerPtn = 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bShowProgress) {
            ms_log.info((Object)"getDefaultDOPPerPtn: ", (Object)ms_iDefaultDefaultDOPPerPtn);
        }
        ms_iRowPrefetch = System.getProperty("oracle.pg.rdbms.rowPrefetch");
        ms_iDefaultRowPrefetch = 1;
        try {
            ms_iDefaultRowPrefetch = Integer.parseInt(ms_iRowPrefetch);
            if (ms_iDefaultRowPrefetch <= 0) {
                ms_iDefaultRowPrefetch = 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bShowProgress) {
            ms_log.info((Object)"getRowPrefetch: ", (Object)ms_iDefaultRowPrefetch);
        }
        ms_iCommitFreq = System.getProperty("oracle.pg.rdbms.commitfreq");
        ms_iDefaultCommitFreq = 40000;
        try {
            ms_iDefaultCommitFreq = Integer.parseInt(ms_iCommitFreq);
            if (ms_iDefaultCommitFreq <= 0) {
                ms_iDefaultCommitFreq = 40000;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bShowProgress) {
            ms_log.info((Object)"getDefaultCommitFreq: ", (Object)ms_iDefaultCommitFreq);
        }
    }
}

